package cn.gtmap.onemap.platform.controller.portal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import cn.gtmap.onemap.core.util.RequestUtils;
import cn.gtmap.onemap.model.Map;
import cn.gtmap.onemap.model.ServiceType;
import cn.gtmap.onemap.platform.controller.CtrlUtil;
import cn.gtmap.onemap.platform.entity.Configuration;
import cn.gtmap.onemap.platform.entity.Service;
import cn.gtmap.onemap.platform.entity.TplType;
import cn.gtmap.onemap.platform.entity.dict.Dict;
import cn.gtmap.onemap.platform.entity.dict.Item;
import cn.gtmap.onemap.platform.service.MapService;
import cn.gtmap.onemap.platform.service.TplTypeService;
import cn.gtmap.onemap.platform.support.spring.BaseController;
import cn.gtmap.onemap.service.MetadataService;

import com.alibaba.fastjson.JSONArray;


/**
 * @author <a href="mailto:rayzy1991@163.com">Ray Zhang</a>
 * @version V1.0, 13-4-26 下午3:14
 */
@Controller
@RequestMapping("/portal")
public class TPLConfigController extends BaseController {

    @Autowired
    private MetadataService metadataService;
    @Autowired
    private MapService mapService;
    @Autowired
    private TplTypeService tplTypeService;

    /**
     * 新建模板
     */
    @RequestMapping(value = "/newtpl", method = RequestMethod.POST)
    public String newTpl(@RequestParam("filename") String filename, @RequestParam("tplname") String tplname
            , @RequestParam("description") String description
            , @RequestParam("typeId") String typeId) {
        mapService.createTplFile(filename, tplname, description);
        Configuration cg = mapService.getConfigByTpl(filename);
        cg.setTypeId(typeId);
        mapService.saveConfig(cg, filename);
        tplTypeService.updateTplAndTypeRelationShip(null, typeId, filename);
        return "redirect:/portal/tpls";
    }
    
    @RequestMapping(value = "/removetpl/{tpl}")
    public String removeTpl(@PathVariable("tpl") String name) {
    	Configuration cg = mapService.getConfigByTpl(name);
    	String typeId = cg.getTypeId();
    	if( !StringUtils.isEmpty(typeId) ){
    		TplType type = tplTypeService.getTplType(typeId);
    		if( type != null ){
    			List tpls = type.getAttribute("tpls", List.class, new ArrayList());
        		tpls.remove(name);
            	tplTypeService.saveTplType(type);
    		}
    	}
        mapService.deleteTpl(name);
        return "redirect:/portal/tpls";
    }

    /**
     * 进入某模板的服务列表页
     */
    @RequestMapping(value = "/{tpl}/services", method = RequestMethod.GET)
    public String serviceList(@PathVariable String tpl, Model model) {
        JSONArray services = mapService.getAllService(tpl);
        Configuration cg = mapService.getConfigByTpl(tpl);
        model.addAttribute("services", services);
        model.addAttribute("tplName", cg.getName());
        model.addAttribute("tpl", tpl);
        model.addAttribute("config", cg);
        return "portal/service/service_config";
    }

    /**
     * 编辑服务
     */
    @RequestMapping("/{tpl}/editservice/{serviceId}")
    public String editService(Model model, @PathVariable String tpl, @PathVariable String serviceId) {
        java.util.Map<ServiceType, cn.gtmap.onemap.model.Service> types = metadataService.getServices(serviceId);
        Set<String> typeSet = new HashSet<String>();
        if (types != null) {
            for (ServiceType temp : types.keySet()) {
                typeSet.add(temp.getValue());
            }
        }
        model.addAttribute("typeSet", typeSet);
        model.addAttribute("service", mapService.getService(serviceId, tpl));
        model.addAttribute("tpl", tpl);
        return "/portal/service/edit";
    }

    /**
     * 保存服务
     */
    @RequestMapping(value = "/{tpl}/saveservice/{serviceId}", method = RequestMethod.POST)
    public String saveService(Model model, @PathVariable String tpl, Service service, RedirectAttributes ra) {
        mapService.updateService(service, tpl);
        CtrlUtil.success(ra);
        return "redirect:/portal/" + tpl + "/services";
    }

    /**
     * 给某一模板添加新服务时的查询
     */
    @RequestMapping("/{tpl}/allmap")
    public String allMap(Model model, Pageable pagin, HttpServletRequest request, @PathVariable String tpl) {
        Page<Map> page = metadataService.getMaps(RequestUtils.getFilters(request, "Q_", model), pagin);
        List<HashMap<String, Object>> mapWithStatus = mapService.getFilterMaps(page, tpl);
        model.addAttribute("maps", mapWithStatus);
        model.addAttribute("page", page);
        model.addAttribute("groups", metadataService.getAllMapGroups());
        model.addAttribute("tpl", tpl);
        return "/portal/service/add-map/map-list";
    }

    /**
     * 为某一模板保存服务顺序
     */
    @RequestMapping(value = "/{tpl}/services/save", method = RequestMethod.POST)
    public String saveServices(@PathVariable(value = "tpl") String tpl, @RequestParam(value = "mapsJson") String mapsJson, RedirectAttributes ra) {
        List<Service> services = (List<Service>) JSONArray.parseArray(mapsJson, Service.class);
        mapService.modifyServices(services, tpl);
        CtrlUtil.success(ra);
        return "redirect:/portal/" + tpl + "/services";
    }

    /**
     * 删除某一模板已经关联的服务
     */
    @RequestMapping(value = "/{tpl}/removemap/{id}")
    public String deleteService(@PathVariable(value = "tpl") String tpl, @PathVariable(value = "id") String id, RedirectAttributes ra) {
        mapService.deleteService(id, tpl);
        CtrlUtil.success(ra);
        return "redirect:/portal/" + tpl + "/services";
    }

    /**
     * 服务图例配置
     */
    @RequestMapping(value = "/{tpl}/legend/{serviceId}")
    public String legend(Model model,@PathVariable String tpl, @PathVariable String serviceId) {
        try{
            boolean visible = false;
            model.addAttribute("tpl", tpl);
            model.addAttribute("serviceId", serviceId);
            Configuration cg = mapService.getConfigByTpl(tpl);
            List<Configuration.Widget> widgets = cg.getWidgetContainer().getWidgets();
            for (Configuration.Widget widget : widgets) {
                if (widget.getLabel().equals("图例")) {
                    if (!widget.getConfig().isEmpty()) {

                        List<java.util.Map<String, Object>> maps = (List<java.util.Map<String, Object>>) widget.getConfig().get("serviceIds");
                        for (java.util.Map<String, Object> map : maps) {
                            if (map.get("serviceId").equals(serviceId)) {
                                visible = true;
                                break;
                            }
                        }
                    }
                }
            }
            model.addAttribute("visible", visible);
        }  catch (Exception e){
             throw new RuntimeException(e.getLocalizedMessage());
        }
        return "portal/service/legend-config";
    }

    /**
     * 服务图例配置
     */
    @RequestMapping(value = "/{tpl}/savelegend/{serviceId}", method = RequestMethod.POST)
    public String saveLegend(@PathVariable(value = "tpl") String tpl,
                             RedirectAttributes ra, HttpServletRequest request) {
        mapService.saveLegendConfig(tpl,  request.getParameter("serviceId"), request.getParameter("legendVisible"));
        CtrlUtil.success(ra);
        return "redirect:/portal/" + tpl + "/services";
    }

    /**
     * 为某一模板添加多个新服务
     */
    @RequestMapping(value = "/{tpl}/bindmap", method = RequestMethod.POST)
    public String bindMap(@PathVariable String tpl, HttpServletRequest request, RedirectAttributes ra) {
        String[] mapIds = request.getParameterValues("mapid");
        List<Service> services = new ArrayList<Service>();
        for (String mapId : mapIds) {
            Service service = mapService.mapToService(metadataService.getMap(mapId));
            services.add(service);
        }
        mapService.insertServices(services, tpl);
        CtrlUtil.success(ra);
        return "redirect:/portal/" + tpl + "/services";
    }

    /**
     * 显示某一模板全局配置页面
     */
    @RequestMapping(value = "/{tpl}/global")
    public String showGl(@PathVariable String tpl, Model model) {
        Configuration cg = mapService.getConfigByTpl(tpl);
        model.addAttribute("config", cg);
        model.addAttribute("tplName", cg.getName());
        model.addAttribute("tpl", tpl);
        model.addAttribute("types", tplTypeService.queryAllTplType());
        return "/portal/global/gl_config";
    }

    /**
     * 为某一模板保存全局配置
     */
    @RequestMapping(value = "/{tpl}/savegl", method = RequestMethod.POST)
    public String saveGl(@PathVariable String tpl
    		, Configuration config
    		, RedirectAttributes ra
    		, @RequestParam("name") String name
    		, @RequestParam("oldTypeId") String oldTypeId
            , @RequestParam("baseLayerType") String baseLayerType
            , @RequestParam("baseLayerUrl") String baseLayerUrl) {

        if (StringUtils.isNotBlank(baseLayerType) && StringUtils.isNotBlank(baseLayerUrl)) {
            List<Service> baseLayers = new ArrayList();
            Service service = new Service();
            service.setUrl(baseLayerUrl);
            service.setType(baseLayerType);
            baseLayers.add(service);
            Configuration.Map map = new Configuration.Map();
            map.setBaseLayers(baseLayers);
            config.setMap(map);
        }
        mapService.modifyGlobal(config, tpl);
        Configuration cfg = mapService.getConfigByTpl(tpl);
        cfg.setName(name);
        mapService.saveConfig(cfg, tpl);
        tplTypeService.updateTplAndTypeRelationShip(oldTypeId, config.getTypeId(), tpl);
        CtrlUtil.success(ra);
        return "redirect:/portal/" + tpl + "/global";
    }

    /**
     * 进入某一个模板的字典项界面
     */
    @RequestMapping(value = "/{tpl}/dicts", method = RequestMethod.GET)
    public String dictList(@PathVariable String tpl, Model model) {
        Configuration cg = mapService.getConfigByTpl(tpl);
//       JSONArray dicts = mapService.getAllDicts(tpl);
        model.addAttribute("tplName", cg.getName());
        model.addAttribute("tpl", tpl);
        model.addAttribute("dicts", cg.getDicts());
        model.addAttribute("config", cg);
        return "portal/dict/list";
    }

    /**
     * 编辑某一字典项
     */
    @RequestMapping(value = "/{tpl}/editdict", method = RequestMethod.GET)
    public String editDict(@PathVariable String tpl
            , @RequestParam(value = "dictId", required = false) String dictId
            , Model model) {
        if (dictId == null)
            model.addAttribute("dict", new Dict());
        else
            model.addAttribute("dict", mapService.getDict(dictId, tpl));
        return "portal/dict/edit";
    }

    /**
     * 保存字典修改
     */
    @RequestMapping(value = "/{tpl}/savedict", method = RequestMethod.POST)
    public String saveDict(@PathVariable(value = "tpl") String tpl, Dict dict, RedirectAttributes ra) {
        mapService.updateDict(dict, tpl);
        CtrlUtil.success(ra);
        return "redirect:/portal/" + tpl + "/dicts";
    }

    /**
     * 删除某一模板的字典项
     */
    @RequestMapping(value = "/{tpl}/removedict/{dictId}")
    public String removeDict(@PathVariable(value = "tpl") String tpl, @PathVariable(value = "dictId") String dictId, RedirectAttributes ra) {
        mapService.deleteDict(dictId, tpl);
        CtrlUtil.success(ra);
        return "redirect:/portal/" + tpl + "/dicts";
    }

    /**
     * 查找某一字典的所有子项
     */
    @RequestMapping(value = "/{tpl}/subdicts/{dictId}")
    public String subDicts(@PathVariable(value = "tpl") String tpl, @PathVariable(value = "dictId") String dictId, Model model) {
        Configuration cg = mapService.getConfigByTpl(tpl);
        model.addAttribute("config", cg);
        model.addAttribute("tplName", cg.getName());
        model.addAttribute("tpl", tpl);
        model.addAttribute("dict", mapService.getDict(dictId, tpl));
        model.addAttribute("subDicts", mapService.getAllDictItems(dictId, tpl));
        return "/portal/dict/sub-list";
    }

    /**
     * 保存字典子项修改
     */
    @RequestMapping(value = "/{tpl}/savesubdict/{dictId}", method = RequestMethod.POST)
    public String saveSubDict(@PathVariable(value = "tpl") String tpl
            , @PathVariable(value = "dictId") String dictId
            , Item item
            , RedirectAttributes ra) {
        mapService.updateDictItem(dictId, item, tpl);
        CtrlUtil.success(ra);
        return "redirect:/portal/" + tpl + "/subdicts/" + dictId;
    }

    /**
     * 编辑某一字典子项
     */
    @RequestMapping(value = "/{tpl}/editsubdict/{dictId}", method = RequestMethod.GET)
    public String editSubDict(@PathVariable String tpl
            , @PathVariable String dictId
            , @RequestParam(value = "itemId", required = false) String itemId
            , Model model) {
        if (itemId != null) {
            model.addAttribute("item", mapService.getDictItem(dictId, itemId, tpl));
        } else {
            model.addAttribute("item", new Item());
        }
        model.addAttribute("tpl", tpl);
        model.addAttribute("dictId", dictId);
        return "portal/dict/sub-edit";
    }

    /**
     * 删除某一字典的子项
     */
    @RequestMapping(value = "/{tpl}/rmsubdict/{dictId}")
    public String removeSubDict(@PathVariable(value = "tpl") String tpl
            , @PathVariable(value = "dictId") String dictId
            , @RequestParam(value = "itemId", required = false) String itemId
            , RedirectAttributes ra) {
        mapService.deleteDictItem(dictId, itemId, tpl);
        CtrlUtil.success(ra);
        return "redirect:/portal/" + tpl + "/subdicts/" + dictId;
    }
    
    @RequestMapping(value = "/tplTypes", method = RequestMethod.GET)
    public String tplTypes(Model model) {
    	model.addAttribute("types", tplTypeService.queryAllTplType());
        return "portal/tplTypes";
    }
    
    @RequestMapping(value = "/tplType/edit")
    public String editTplType(Model model, @RequestParam(value = "typeId", required = false) String typeId){
    	if(StringUtils.isEmpty(typeId)){
    		model.addAttribute("tplType", new TplType());
    	}else{
    		model.addAttribute("tplType", tplTypeService.getTplType(typeId));
    	}
    	return "/portal/tplType/edit";
    }
    
    @RequestMapping(value = "/tplType/save")
    public String saveTplType(Model model, TplType tplType){
    	if( !StringUtils.isEmpty(tplType.getId())){
    		tplType.setThumnail(tplTypeService.getTplType(tplType.getId()).getThumnail());
    	}
    	tplTypeService.saveTplType(tplType);
    	return "redirect:/portal/tplTypes";
    }
    
    @RequestMapping(value = "/tplType/toggle")
    public String toggleTplType(Model model, @RequestParam("typeId") String typeId){
    	TplType type = tplTypeService.getTplType(typeId);
    	type.setEnabled(type.isEnabled() ? false : true);
    	tplTypeService.saveTplType(type);
    	return "redirect:/portal/tplTypes";
    }
    
    @RequestMapping(value = "/tplType/uploadThumnail")
    @ResponseBody
    public String uploadThumnail(Model model
    		, @RequestParam("img") MultipartFile file
    		, @RequestParam("typeId") String typeId){
    	TplType type = null;
    	if (!file.isEmpty()) {
            type = tplTypeService.getTplType(typeId);
            try {
				type.setThumnail(file.getBytes());
			} catch (IOException e) {
				return e.getMessage();
			}
            tplTypeService.saveTplType(type);
        }else{
        	throw new RuntimeException("thumnail can not be empty!");
        }
    	return type.getId();
    }
    
    @RequestMapping(value = "/tplType/thumnail/{typeId}")
    @ResponseBody
    public void tplThumnail(@PathVariable("typeId") String typeId
    		, HttpServletRequest request
    		, HttpServletResponse response) throws IOException, ServletException{
    	TplType type = tplTypeService.getTplType(typeId);
    	byte[] thumnail = type.getThumnail();
    	if(thumnail != null){
    		FileCopyUtils.copy(type.getThumnail(), response.getOutputStream());
    	}else{
			request.getRequestDispatcher("/static/img/zt/default.jpg").forward(request, response);
    	}
    }
}