package cn.gtmap.onemap.platform.controller;

import cn.gtmap.onemap.platform.entity.Document;
import cn.gtmap.onemap.platform.event.JSONMessageException;
import cn.gtmap.onemap.platform.service.DocumentService;
import cn.gtmap.onemap.platform.service.TransitService;
import cn.gtmap.onemap.platform.support.spring.BaseController;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.codehaus.xfire.client.Client;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.net.URL;
import java.util.Map;

/**
 * 该controller用于向其他系统发起请求 并接收/处理返回数据等
 * Author: <a href="mailto:yingxiufeng@gtmap.cn">yingxiufeng</a>
 * Date:  2015/7/14 8:53
 */
@Controller
@RequestMapping("/transitService")
public class TransitController extends BaseController {


    @Autowired
    private DocumentService documentService;
    @Autowired
    private TransitService transitService;


    /***
     * 报表输出(for mas)
     * @param dataSource  sde数据源名称
     * @param layerName   查询图层名称
     * @param rId         报表id(用于进行一些特殊处理)
     * @param response
     */
    @RequestMapping(value = "/report/output",method = {RequestMethod.GET,RequestMethod.POST})
    public void reportOutput(@RequestParam("dataSource") String dataSource,
                             @RequestParam(value = "rId", required = true) int rId,
                             @RequestParam(value = "queryCondition", defaultValue = "1=1") String queryCondition,
                             @RequestParam(value = "layerName", required = true) String layerName,
                             @RequestParam(value = "fileName", required = true) String fileName,
                             HttpServletResponse response) {
        try {
            Map map = transitService.generateReportDataFromSde(rId, layerName, queryCondition, dataSource,true);
            if (rId == 6) {
                sendFile((java.io.File) map.get("file"), response);
            } else
                sendDocument(response, documentService.renderAnalysisExcel(map, fileName, Document.Type.xls));
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("doc.excel.export.error", e.getLocalizedMessage()));
        }
    }

    /***
     * 显示报表页面(for mas)
     * @param dataSource
     * @param rId
     * @param queryCondition
     * @param layerName
     * @param fileName
     * @param model
     * @return
     */
    @RequestMapping(value = "/report/view")
    public String reportView(@RequestParam("dataSource") String dataSource,
                             @RequestParam(value = "rId", required = true) int rId,
                             @RequestParam(value = "queryCondition", defaultValue = "1=1") String queryCondition,
                             @RequestParam(value = "layerName", required = true) String layerName,
                             @RequestParam(value = "fileName", required = true) String fileName,
                             Model model){
        try {
            Map map = transitService.generateReportDataFromSde(rId,layerName,queryCondition,dataSource,false);
            model.addAttribute("rId",rId);
            model.addAttribute("data",map.get("data"));
            model.addAttribute("layerName",layerName);
            model.addAttribute("queryCondition",queryCondition);
            model.addAttribute("dataSource",dataSource);
            model.addAttribute("fileName",fileName);
        } catch (Exception e) {
            throw new RuntimeException("report.view.error: "+e.getLocalizedMessage());
        }
        return "transit/report";
    }

    /***
     * wcf test view
     * @return
     */
    @RequestMapping(value = "/wcf")
    public String wcf() {
        return "wcf";
    }

    /***
     * wcf result view
     * @param dltb
     * @param xzdw
     * @param geometry
     * @param wcfUrl
     * @param wcfMethod
     * @return
     */
    @RequestMapping(value = "/wcf/result")
    @ResponseBody
    public Map wcfResult( @RequestParam(value = "dltb", required = false) String dltb,
                          @RequestParam(value = "xzdw", required = false) String xzdw,
                          @RequestParam(value = "geometry", required = true) String geometry,
                          @RequestParam(value = "wcfUrl", required = true) String wcfUrl,
                          @RequestParam(value = "wcfMethod", required = true) String wcfMethod) {
        try {
            Client client = new Client(new URL(wcfUrl));
            JSONObject params = new JSONObject();
            params.put("AnalyseGeoJSON",geometry);
            params.put("TBLayerName",dltb);
            params.put("XWLayerName",xzdw);
            Object[] objects;
            try {
                objects = client.invoke(wcfMethod, new String[]{JSON.toJSONString(params)});
            } catch (Exception e) {
                logger.error(getMessage("tdlyxz.wcf.error",e.getLocalizedMessage()));
                throw new RuntimeException(getMessage("tdlyxz.wcf.error",e.getLocalizedMessage()));
            }
            Map analysisMap = JSON.parseObject(String.valueOf(objects[0]),Map.class);
            return result(analysisMap);
        } catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }
}
