<@com.html title="" import="jquery">
<style type="text/css">
    .table {
        width: 100%;
        margin-bottom: 20px;
        border-spacing: 0;
    }

    .table-bordered {
        border: 1px solid #dddddd;
        border-collapse: separate;
        border-left: 0;
        -webkit-border-radius: 4px;
        -moz-border-radius: 4px;
        border-radius: 4px;
    }

    .table-bordered th {
        border: 1px solid #dddddd;
    }

    .table th {
        height: 20px;
        font-size: 13px;
        padding: 3px 8px;
        border-bottom: 0;
        text-align: center;
        color: #666666;
        vertical-align: middle;
    }

    .table td {
        text-align: left;
        border-top: 1px solid #dddddd;
        padding-left: 10px;
    }

    .title-wrapper {
        /*margin: 15px 0 10px;*/
        position: relative;


    }
    .title {
        color: #27679e;
        font-size: 17px;
        line-height: normal;
        font-family: 'microsoft yahei';
        font-weight: normal;
        text-shadow:1px 1px 4px #124278;
    }
    #errorMsg {
        font-size: 25px;
        font-family: 'microsoft yahei';
        opacity: 0.6;
        text-shadow:1px 1px 4px #124278;
    }
</style>
    <div id="main" style="margin: auto 20px; min-width:660px; ">
    <#if metaData??>
        <#assign data=metaData!>
        <div id="title" class="title-wrapper" align="center">
            <a class="title">${(data["bkjmc"])!}元数据概览</a>
        </div>
        <div id="tableDiv">
            <table class="table table-bordered">
                <tr>
                    <th>年度</th>
                    <td>${(data["nd"])!}</td>
                </tr>
                <tr>
                    <th>业务类型</th>
                    <td>${(data["ywlx"])!}</td>
                </tr>
                <tr>
                    <th>表空间</th>
                    <td>${(data["bkjmc"])!}</td>
                </tr>
                <tr>
                    <th>状态</th>
                    <td>${(data["zt"])!}</td>
                </tr>
                <tr>
                    <th>总共大小</th>
                    <td id="sumSize">${(data["bkjzdx"])!}</td>
                </tr>
                <tr>
                    <th>已用大小</th>
                    <td id="usedSize">${(data["bkjyydx"])!}</td>
                </tr>
                <tr>
                    <th>剩余大小</th>
                    <td id="restSize">${(data["bkjsydx"])!}</td>
                </tr>
                <tr>
                    <th>文件路径</th>
                    <td>${(data["bkjwjlj"])!}</td>
                </tr>
                <tr>
                    <th>数据总数</th>
                    <td>${sum!}</td>
                </tr>
                <tr>
                    <th>行政区数</th>
                    <td>${xzqNum!}</td>
                </tr>
            </table>
        </div>
        <div id="chartDiv1" style="width: 50%; height: 100%; margin: 0 auto;float: left;">
        </div>
        <div id="chartDiv2" style="width: 50%; height: 100%; margin: 0 auto;float: left;">
        </div>
    </div>
    <script src="<@com.rootPath/>/js/highcharts/highcharts.js"></script>
    <script src="<@com.rootPath/>/js/highcharts/exporting.js"></script>
    <script type="text/javascript">
        var usedPer = $("#usedSize")[0].innerText / $("#sumSize")[0].innerText * 100;
        var unusedPer = 100 - usedPer;
        $(function () {
            $('#chartDiv1').highcharts({
                chart:{
                    plotBackgroundColor:null,
                    plotBorderWidth:null,
                    plotShadow:false
                },
                title:{
                    text:'容量使用情况',
                    style:  {

                        fontFamily:'microsoft yahei',
                        fontSize:'16px'
                    },
                    x:-20
                },
                tooltip:{
                    pointFormat:'{series.name}: <b>{point.percentage}%</b>',
                    percentageDecimals:1
                },
                plotOptions:{
                    pie:{
                        allowPointSelect:true,
                        cursor:'pointer',
                        dataLabels:{
                            enabled:true,
                            color:'#000000',
                            connectorColor:'#000000',
                            formatter:function () {
                                return '<b>' + this.point.name + '</b>: ' + this.percentage + ' %';
                            }
                        }
                    }
                },
                credits:{
                    enabled:false
                },
                exporting:{
                    enabled:false
                },
                series:[
                    {
                        type:'pie',
                        name:'占用空间',
                        data:[
                            ['已用大小', Number(usedPer.toFixed(3))],
                            ['剩余大小', Number(unusedPer.toFixed(3))]
                        ]
                    }
                ]
            });

            $("#chartDiv2").highcharts({
                chart:{
                    type:'line',
                    zoomType:"x"
                },
                title:{
                    text:'行政区数据数',
                    style:  {

                        fontFamily:'microsoft yahei',
                        fontSize:'16px'
                    },
                    x:-20 //center
                },
                xAxis:{
                    title:{
                        text:'行政区代码'
                    },
                    categories: ${xzdm},
                    labels:{
                        step:5
                    }
                },
                yAxis:{
                    title:{
                        text:'数据数'
                    },
                    min:0,
                    plotLines:[
                        {
                            value:0,
                            width:1,
                            color:'#808080'
                        }
                    ]
                },
                credits:{
                    enabled:false
                },
                exporting:{
                    enabled:false
                },
                legend:{

                    enabled:false
                },
                series:[
                    {
                        name:'数据总数',
                        data: ${sjzs!}
                    }
                ]
            });
        });

    </script>
    <#else><div align="center" style="margin-top: 30px;"><span id="errorMsg">无元数据信息!</span></div></#if>
</@com.html>