<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8"/>
    <title>${env.getEnv('local.title')}国土资源“一张图”-信息门户子系统</title>
    <link rel="stylesheet" href="<@com.rootPath/>/static/css/bootstrap/bootstrap.css"/>
    <link rel="stylesheet" href="<@com.rootPath/>/static/css/plugins/font/css/font-awesome.css"/>
    <link rel="stylesheet" href="<@com.rootPath/>/static/css/plugins/gridtree/gridtree.css"/>
    <link rel="stylesheet" href="<@com.rootPath/>/static/css/plugins/loading/loading.css"/>

    <link rel="stylesheet" href="<@com.rootPath/>/static/css/hack.css"/>
    <style>
        table tr td {
            border: 1px solid #ddd;
            padding: 5px 10px;
            /*min-height: 30px;*/

        }

        table tr th {
            border: 1px solid #ddd;
            padding: 10px;
            text-align: center;
            vertical-align: middle;
            min-width: 80px;
        }

        table {
            background-color: transparent;
            border: 1px solid #ddd;
            table-layout: auto;
            border-collapse: collapse;
        }

        .tab-content {
            padding: 20px;
            /*border: 1px solid #ddd;*/
            border-top: none;
            border-radius: 0 0 5px 5px;
        }


        .detailPanel{
            display:none;

            z-index:10000;

            background-color:#fafafa;

            width:675px;
            min-height:200px;
            max-height: 630px;
            /*overflow-y: auto;*/
            border:1px solid #666;

            /* CSS3 styling for latest browsers */
            -moz-box-shadow:0 0 90px 5px #000;
            -webkit-box-shadow: 0 0 90px #000;
        }
        .close {

            background-image: url("/omp/img/overlay_close.png");
            position:absolute;
            right:0px;
            top:-5px;
            cursor:pointer;
            height:32px;
            width:32px;
        }

    </style>
</head>
<body>
<div class="container" style="width: 85%;">
<div>
    <h3 style="font-weight: normal; color:#188074"><span class="icon icon-columns"></span>&nbsp;分析结果展示</h3>
</div>
<div class="row">
<div style="width:220px;float:left;">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a href="#xz" data-toggle="tab">现状分析结果</a></li>
        <li><a href="#gh" data-toggle="tab">规划分析结果</a></li>
        <li><a href="#bp" data-toggle="tab">报批分析结果</a></li>
        <li><a href="#gd" data-toggle="tab">供地分析结果</a></li>
    </ul>
</div>
<div>
<div class="tab-content large">
<div id="xz" class="tab-pane fade in active">
<div>
    <ul class="nav nav-tabs">
        <li class="active"><a href="#xzTab1" data-toggle="tab">一级分类</a></li>
        <li><a href="#xzTab2" data-toggle="tab">二级分类</a></li>
        <li><a href="#xzTab3" data-toggle="tab">三大类</a></li>
    </ul>
</div>
<div class="tab-content large">
<div id="xzTab1" class="tab-pane fade in active">
<#if (tdlyxzResult?size>0)>
    <table>
        <tr>
            <th>权属</th>
            <th>合计</th>
            <#assign info=tdlyxzResult[0].categoryA>
            <#list info as infoItem>
                <th>${infoItem["dlmc"]!}(${infoItem["dlbm"]!})</th>
            </#list>
        </tr>
        <#list tdlyxzResult as xzq>
            <tr>
                <td>${xzq["xzqmc"]!}</td>
                <td>${xzq["area"]!?string("0.##")}</td>
                <#assign areaInfo=xzq.categoryA>
                <#list areaInfo as item>
                    <td>${item["area"]!?string("0.##")}</td>
                </#list>
            </tr>
        </#list>
    </table>
<#else ><h5>该分类下无分析结果</h5>
</#if>
</div>
<div id="xzTab2" class="tab-pane fade in">
<#if (tdlyxzResult?size>0)>
    <table>
        <tr>
            <th rowspan="2">权属</th>
            <th rowspan="2">合计</th>
            <th rowspan="2">耕地(01)</th>
            <th colspan="3">其中</th>
            <th rowspan="2">园地(02)</th>
            <th colspan="3">其中</th>
            <th rowspan="2">林地(03)</th>
            <th colspan="3">其中</th>
            <th rowspan="2">草地(04)</th>
            <th colspan="3">其中</th>
            <th rowspan="2">城镇村及工矿用地(20)</th>
            <th colspan="5">其中</th>
            <th rowspan="2">交通运输用地(10)</th>
            <th colspan="6">其中</th>
            <th rowspan="2">水域及水利设施用地(11)</th>
            <th colspan="9">其中</th>
            <th rowspan="2">其他用地</th>
            <th colspan="6">其中</th>
        </tr>
        <tr>
            <th>水田(011)</th>
            <th>水浇地(012)</th>
            <th>旱地(013)</th>
            <th>果园(021)</th>
            <th>茶园(022)</th>
            <th>其他园地(023)</th>
            <th>有林地(031)</th>
            <th>灌木林地(032)</th>
            <th>其他林地(033)</th>
            <th>天然牧草地(041)</th>
            <th>人工牧草地(042)</th>
            <th>其他草地(043)</th>
            <th>城市(201)</th>
            <th>建制镇(202)</th>
            <th>村庄(203)</th>
            <th>采矿用地(204)</th>
            <th>风景名胜及特殊用地(205)</th>
            <th>铁路用地(101)</th>
            <th>公路用地(102)</th>
            <th>农村道路(104)</th>
            <th>机场用地(105)</th>
            <th>港口码头用地(106)</th>
            <th>管道运输用地(107)</th>
            <th>河流水面(111)</th>
            <th>湖泊水面(112)</th>
            <th>水库水面(113)</th>
            <th>坑塘水面(114)</th>
            <th>沿海滩涂(115)</th>
            <th>内陆滩涂(116)</th>
            <th>水渠(117)</th>
            <th>水工建筑用地(118)</th>
            <th>冰川及永久积雪(119)</th>
            <th>设施农用地(122)</th>
            <th>田坎(123)</th>
            <th>盐碱地(124)</th>
            <th>沼泽地(125)</th>
            <th>沙地(126)</th>
            <th>裸地(127)</th>
        </tr>
        <#list tdlyxzResult as xzq>
            <#assign item=xzq.categoryB>
            <tr>
                <td>${xzq["xzqmc"]!}</td>
                <td>${xzq["area"]!?string("0.##")}</td>
                <td>${item["01"]!?string("0.##")}</td>
                <td><#if item["011"]??> ${item["011"]!?string("0.##")}<#else >0</#if></td>
                <td><#if item["012"]??>${item["012"]!?string("0.##")}<#else >0</#if></td>
                <td><#if item["013"]??>${item["013"]!?string("0.##")}<#else >0</#if></td>
                <td>${item["02"]!?string("0.##")}</td>
                <td><#if item["021"]??>${item["021"]!?string("0.##")}<#else >0</#if></td>
                <td><#if item["022"]??>${item["022"]!?string("0.##")}<#else >0</#if></td>
                <td><#if item["023"]??>${item["023"]!?string("0.##")}<#else >0</#if></td>
                <td>${item["03"]!?string("0.##")}</td>
                <td><#if item["031"]??>${item["031"]!?string("0.##")}<#else >0</#if></td>
                <td><#if item["032"]??>${item["032"]!?string("0.##")}<#else >0</#if></td>
                <td><#if item["033"]??>${item["033"]!?string("0.##")}<#else >0</#if></td>
                <td>${item["04"]!?string("0.##")}</td>
                <td><#if item["041"]??>${item["041"]!?string("0.##")}<#else >0</#if></td>
                <td><#if item["042"]??>${item["042"]!?string("0.##")}<#else >0</#if></td>
                <td><#if item["043"]??>${item["043"]!?string("0.##")}<#else >0</#if></td>
                <td>${item["20"]!?string("0.##")}</td>
                <td><#if item["201"]??>${item["201"]!?string("0.##")}<#else >0</#if></td>
                <td><#if item["202"]??>${item["202"]!?string("0.##")}<#else >0</#if></td>
                <td><#if item["203"]??>${item["203"]!?string("0.##")}<#else >0</#if></td>
                <td><#if item["204"]??>${item["204"]!?string("0.##")}<#else >0</#if></td>
                <td><#if item["205"]??>${item["205"]!?string("0.##")}<#else >0</#if></td>
                <td>${item["10"]!?string("0.##")}</td>
                <td><#if item["101"]??>${item["101"]!?string("0.##")}<#else >0</#if></td>
                <td><#if item["102"]??>${item["102"]!?string("0.##")}<#else >0</#if></td>
                <td><#if item["104"]??>${item["104"]!?string("0.##")}<#else >0</#if></td>
                <td><#if item["105"]??>${item["105"]!?string("0.##")}<#else >0</#if></td>
                <td><#if item["106"]??>${item["106"]!?string("0.##")}<#else >0</#if></td>
                <td><#if item["107"]??>${item["107"]!?string("0.##")}<#else >0</#if></td>
                <td>${item["11"]!?string("0.##")}</td>
                <td><#if item["111"]??>${item["111"]!?string("0.##")}<#else >0</#if></td>
                <td><#if item["112"]??>${item["112"]!?string("0.##")}<#else >0</#if></td>
                <td><#if item["113"]??>${item["113"]!?string("0.##")}<#else >0</#if></td>
                <td><#if item["114"]??>${item["114"]!?string("0.##")}<#else >0</#if></td>
                <td><#if item["115"]??>${item["115"]!?string("0.##")}<#else >0</#if></td>
                <td><#if item["116"]??>${item["116"]!?string("0.##")}<#else >0</#if></td>
                <td><#if item["117"]??>${item["117"]!?string("0.##")}<#else >0</#if></td>
                <td><#if item["118"]??>${item["118"]!?string("0.##")}<#else >0</#if></td>
                <td><#if item["119"]??>${item["119"]!?string("0.##")}<#else >0</#if></td>
                <td>${item["12"]!?string("0.##")}</td>
                <td><#if item["122"]??>${item["122"]!?string("0.##")}<#else >0</#if></td>
                <td><#if item["123"]??>${item["123"]!?string("0.##")}<#else >0</#if></td>
                <td><#if item["124"]??>${item["124"]!?string("0.##")}<#else >0</#if></td>
                <td><#if item["125"]??>${item["125"]!?string("0.##")}<#else >0</#if></td>
                <td><#if item["126"]??>${item["126"]!?string("0.##")}<#else >0</#if></td>
                <td><#if item["127"]??>${item["127"]!?string("0.##")}<#else >0</#if></td>
            </tr>
        </#list>
    </table>
<#else ><h5>该分类下无分析结果</h5></#if>
</div>
<div id="xzTab3" class="tab-pane fade in">
<#if (xzResult?size>0)>
    <table id="table3">
        <tr>
            <th rowspan="3" style="min-width: 100px;">权属</th>
            <th rowspan="3">合计</th>
            <th colspan="18">农用地</th>
            <th colspan="13">建设用地</th>
            <th colspan="12">未利用地</th>
            <th rowspan="3">备注</th>
        </tr>
        <tr>
            <th rowspan="2">总面积</th>
            <th colspan="4">耕地</th>
            <th colspan="3">园地</th>
            <th colspan="3">林地(03)</th>
            <th colspan="2">牧草地</th>
            <th colspan="5">其它农用地</th>
            <th rowspan="2">总面积</th>
            <th colspan="5">居民点及独立工矿用地</th>
            <th colspan="5">交通运输用地</th>
            <th colspan="2">水利设施</th>
            <th rowspan="2">总面积</th>
            <th colspan="6">未利用土地</th>
            <th colspan="5">其他土地</th>
        </tr>
        <tr>
            <th>总面积</th>
            <th>水田(011)</th>
            <th>水浇地(012)</th>
            <th>旱地(013)</th>

            <th>果园(021)</th>
            <th>茶园(022)</th>
            <th>其他园地(023)</th>

            <th>有林地(031)</th>
            <th>灌木林地(032)</th>
            <th>其他林地(033)</th>

            <th>天然牧草地(041)</th>
            <th>人工牧草地(042)</th>

            <th>设施农业用地(122)</th>
            <th>农村道路(104)</th>
            <th>坑塘水面(114)</th>
            <th>沟渠(117)</th>
            <th>田坎(123)</th>

            <th>城市(201)</th>
            <th>建制镇(202)</th>
            <th>村庄(203)</th>
            <th>采矿用地(204)</th>
            <th>风景名胜及特殊用地(205)</th>

            <th>铁路用地(101)</th>
            <th>公路用地(102)</th>
            <th>机场用地(105)</th>
            <th>港口码头用地(106)</th>
            <th>管道运输用地(107)</th>

            <th>水库水面(113)</th>
            <th>水工建筑用地(118)</th>

            <th>其它草地(043)</th>
            <th>盐碱地(124)</th>
            <th>沼泽地(125)</th>
            <th>沙地(126)</th>
            <th>裸地(127)</th>
            <th>空闲地(121)</th>

            <th>河流水面(111)</th>
            <th>湖泊水面(112)</th>
            <th>沿海滩涂(115)</th>
            <th>内陆滩涂(116)</th>
            <th>冰川及永久积雪(119)</th>
        </tr>
        <#list xzResult as detailItem>
            <tr>
                <td>${detailItem.QSMC!}</td>
                <td>${detailItem.TOTAL_AREA!?string("0.##")}</td>
                <td>${detailItem.NYD_AREA!?string("0.##")}</td>
                <td>${detailItem.GD_AREA!?string("0.##")}</td>
                <td>${detailItem["011"]!?string("0.##")}</td>
                <td>${detailItem["012"]!?string("0.##")}</td>
                <td>${detailItem["013"]!?string("0.##")}</td>
                <td>${detailItem["021"]!?string("0.##")}</td>
                <td>${detailItem["022"]!?string("0.##")}</td>
                <td>${detailItem["023"]!?string("0.##")}</td>
                <td>${detailItem["031"]!?string("0.##")}</td>
                <td>${detailItem["032"]!?string("0.##")}</td>
                <td>${detailItem["033"]!?string("0.##")}</td>
                <td>${detailItem["041"]!?string("0.##")}</td>
                <td>${detailItem["042"]!?string("0.##")}</td>
                <td>${detailItem["122"]!?string("0.##")}</td>
                <td>${detailItem["104"]!?string("0.##")}</td>
                <td>${detailItem["114"]!?string("0.##")}</td>
                <td>${detailItem["117"]!?string("0.##")}</td>
                <td>${detailItem["123"]!?string("0.##")}</td>
                <td>${detailItem.JSYD_AREA!?string("0.##")}</td>
                <td>${detailItem["201"]!?string("0.##")}</td>
                <td>${detailItem["202"]!?string("0.##")}</td>
                <td>${detailItem["203"]!?string("0.##")}</td>
                <td>${detailItem["204"]!?string("0.##")}</td>
                <td>${detailItem["205"]!?string("0.##")}</td>
                <td>${detailItem["101"]!?string("0.##")}</td>
                <td>${detailItem["102"]!?string("0.##")}</td>
                <td>${detailItem["105"]!?string("0.##")}</td>
                <td>${detailItem["106"]!?string("0.##")}</td>
                <td>${detailItem["107"]!?string("0.##")}</td>
                <td>${detailItem["113"]!?string("0.##")}</td>
                <td>${detailItem["118"]!?string("0.##")}</td>
                <td>${detailItem.WLYD_AREA!?string("0.##")}</td>
                <td>${detailItem["043"]!?string("0.##")}</td>
                <td>${detailItem["124"]!?string("0.##")}</td>
                <td>${detailItem["125"]!?string("0.##")}</td>
                <td>${detailItem["126"]!?string("0.##")}</td>
                <td>${detailItem["127"]!?string("0.##")}</td>
                <td>${detailItem["121"]!?string("0.##")}</td>
                <td>${detailItem["111"]!?string("0.##")}</td>
                <td>${detailItem["112"]!?string("0.##")}</td>
                <td>${detailItem["115"]!?string("0.##")}</td>
                <td>${detailItem["116"]!?string("0.##")}</td>
                <td>${detailItem["119"]!?string("0.##")}</td>
                <td></td>
            </tr>
        </#list>
    </table>
<#else >无分析结果</#if>
</div>
</div>
</div>
<div id="gh" class="tab-pane fade">
    <div>
        <ul class="nav nav-tabs">
            <li class="active"><a href="#ghyt" data-toggle="tab">规划用途汇总</a></li>
            <li><a href="#tdytq" data-toggle="tab">土地用途分区</a></li>
            <li><a href="#jsydgzq" data-toggle="tab">建设用地管制区</a></li>
            <li><a href="#ghjbnttz" data-toggle="tab">规划基本农田调整</a></li>
            <li><a href="#mzzdjsxm" data-toggle="tab">重点建设项目</a></li>
        </ul>
    </div>
    <div class="tab-content large">
        <div id="ghyt" class="tab-pane fade in active">
        <#if ghResult??>
            <table>
                <tr>
                    <th rowspan="2">规划用途</th>
                    <th colspan="5">农用地</th>
                    <th rowspan="2">允许建设区</th>
                    <th rowspan="2">有条件建设区</th>
                    <th rowspan="2">未利用地</th>
                </tr>
                <tr>
                    <th>基本农田</th>
                    <th>一般农田</th>
                    <th style="width: 125px;">水域（农田水利）</th>
                    <th>林地</th>
                    <th>园地</th>
                </tr>
                <tr>
                    <th>面积(公顷)</th>
                    <td>${ghResult.JBNT_AREA}</td>
                    <td>${ghResult.YBNT_AREA}</td>
                    <td>${ghResult.SY_AREA}</td>
                    <td>${ghResult.LD_AREA}</td>
                    <td>${ghResult.YD_AREA}</td>
                    <td>${ghResult.YXJSQ_AREA}</td>
                    <td>${ghResult.YTJJSQ_AREA}</td>
                    <td>${ghResult.WLYD_AREA}</td>
                </tr>
            </table>
        <#else >无分析结果</#if>
        </div>
        <div id="tdytq" class="tab-pane fade in"><@com.tdghsc1 key="土地用途分区"></@com.tdghsc1></div>
        <div id="jsydgzq" class="tab-pane fade in"><@com.tdghsc1 key="建设用地管制区"></@com.tdghsc1></div>
        <div id="ghjbnttz" class="tab-pane fade in"><@com.tdghsc1 key="规划基本农田调整"></@com.tdghsc1></div>
        <div id="mzzdjsxm" class="tab-pane fade in"><@com.tdghsc1 key="重点建设项目"></@com.tdghsc1></div>
    </div>
</div>
<div id="bp" class="tab-pane fade">
    <div>
        <ul class="nav nav-tabs">
            <li class="active"><a href="#bpInfo" data-toggle="tab">报批汇总</a></li>
            <li><a href="#bpDetail" data-toggle="tab">报批详情</a></li>
        </ul>
    </div>
    <div class="tab-content large">
        <div id="bpInfo" class="tab-pane fade in active">
        <#if bpInfo??>
            <table>
                <tr>
                    <th>类型</th>
                    <th>面积_平方米</th>
                    <th>面积_公顷</th>
                    <th>面积_亩</th>
                </tr>
                <tr>
                    <th>已报</th>
                    <td>${bpInfo.YB_AREA!?string("0.##")}</td>
                    <td>${(bpInfo.YB_AREA!?double*0.0001)?string("0.####")}</td>
                    <td>${(bpInfo.YB_AREA!?double*0.0015)?string("0.##")}</td>
                </tr>
                <tr>
                    <th>未报</th>
                    <td>${bpInfo.WB_AREA!?string("0.##")}</td>
                    <td>${(bpInfo.WB_AREA!?double*0.0001)?string("0.####")}</td>
                    <td>${(bpInfo.WB_AREA!?double*0.0015)?string("0.##")}</td>
                </tr>
                <tr>
                    <th>合计</th>
                    <td>${bpInfo.TOTAL_AREA!?string("0.##")}</td>
                    <td>${(bpInfo.TOTAL_AREA!?double*0.0001)?string("0.####")}</td>
                    <td>${(bpInfo.TOTAL_AREA!?double*0.0015)?string("0.##")}</td>
                </tr>
            </table>
        </#if>
        </div>
        <div id="bpDetail" class="tab-pane fade in">
        <#if bpDetail?size!=0>
            <#assign firstItem=bpDetail[0]/>
            <table>
                    <tr>
                        <th>项目名称</th>
                        <th>报批状态</th>
                        <th>用途</th>
                    </tr>
                <#list bpDetail as detailItem>
                    <tr>
                        <td>${detailItem.XMMC!}</td>
                        <td>${detailItem.BPZT!}</td>
                        <td>${detailItem.YT!}</td>
                    </tr>
                </#list>
            </table>
        <#else >无分析详情
        </#if>
        </div>
    </div>
</div>
<div id="gd" class="tab-pane fade">
    <div>
        <ul class="nav nav-tabs">
            <li class="active"><a href="#gdInfo" data-toggle="tab">供地汇总</a></li>
            <li><a href="#gdDetail" data-toggle="tab">供地详情</a></li>
        </ul>
    </div>
    <div class="tab-content large">
        <div id="gdInfo" class="tab-pane fade in active">
        <#if gdInfo??>
            <table>
                <tr>
                    <th>类型</th>
                    <th>面积_平方米</th>
                    <th>面积_公顷</th>
                    <th>面积_亩</th>
                </tr>
                <tr>
                    <th>已供</th>
                    <td>${gdInfo.YG_AREA!?string("0.##")}</td>
                    <td>${(gdInfo.YG_AREA!?double*0.0001)?string("0.####")}</td>
                    <td>${(gdInfo.YG_AREA!?double*0.0015)?string("0.##")}</td>
                </tr>
                <tr>
                    <th>未供</th>
                    <td>${gdInfo.WG_AREA!?string("0.##")}</td>
                    <td>${(gdInfo.WG_AREA!?double*0.0001)?string("0.####")}</td>
                    <td>${(gdInfo.WG_AREA!?double*0.0015)?string("0.##")}</td>
                </tr>
                <tr>
                    <th>合计</th>
                    <td>${gdInfo.TOTAL_AREA!?string("0.##")}</td>
                    <td>${(gdInfo.TOTAL_AREA!?double*0.0001)?string("0.####")}</td>
                    <td>${(gdInfo.TOTAL_AREA!?double*0.0015)?string("0.##")}</td>
                </tr>
            </table>
        </#if>
        </div>
        <div id="gdDetail" class="tab-pane fade in">
        <#if gdDetail?size!=0>
            <#assign firstItem=gdDetail[0]/>
            <table>
                <tr>
                    <th>项目名称</th>
                    <th>项目编号</th>
                </tr>
                <#list gdDetail as detailItem>
                    <tr>
                        <td>${detailItem.XMMC!}</td>
                        <td>${detailItem.XMBH!}</td>
                    </tr>
                </#list>
            </table>
            <#else >无分析详情
        </#if>
        </div>
    </div>
</div>
</div>
</div>
</div>
<div style="text-align: center;padding-top: 20px;">
    <a class="btn btn-primary" onclick="exportExcel();">导出excel</a>
</div>
</div>
<script src="<@com.rootPath/>/js/jquery/jquery_1.9.0.js"></script>
<script src="<@com.rootPath/>/js/portal/lib/bootstrap.js"></script>
<script src="<@com.rootPath/>/js/jquery/jquery.tools.min.js"></script>
<script src="<@com.rootPath/>/static/js/plugins.js"></script>
<script src="<@com.rootPath/>/static/js/lib/colResizable-1.3.min.js"></script>
<script type="text/javascript">

//    $(function(){
//        $("table").each(function(){
//            $(this).colResizable({
//                liveDrag:true,
//                minWidth:80
//            });
//        });
//    });

    function detailInfo(index) {

        $("td[rel]").overlay({
            closeOnClick:true
        });
    }


    /**
     * 导出excel
     */
    function exportExcel() {
        var fileType = ".xlsx";
        var officeVersion = '${env.getEnv("office.plugin.version")!}';
        if(officeVersion=='old')
            fileType = ".xls";
        if ($("#xz").hasClass("active")) {
            if ($('#xzTab1').hasClass("active") || $('#xzTab2').hasClass("active"))
                openPostWindow("<@com.rootPath/>/geometryService/export/excel", '${tdlyxzExcel}', "tdlyxz_analysis" + fileType);
            else
                openPostWindow("<@com.rootPath/>/geometryService/export/excel", '${xzExcel}', "zhfx_xz" + fileType);


        } else if ($("#gh").hasClass("active")) {

            if ($("#ghyt").hasClass("active"))
                openPostWindow("<@com.rootPath/>/geometryService/export/excel", '${ghExcel}', "zhfx_gh" + fileType);
            else
                openPostWindow("<@com.rootPath/>/geometryService/export/excel", '${tdghscExcel}', "ghscfx_analysis" + fileType);

        } else if ($("#bp").hasClass("active")) {
            openPostWindow("<@com.rootPath/>/geometryService/export/excel", '${bpExcel}', "zhfx_bp" + fileType);
        } else {

            openPostWindow("<@com.rootPath/>/geometryService/export/excel", '${gdExcel}', "zhfx_gd" + fileType);
        }

    }
    function openPostWindow(url, data, fileName)
    {
        if(data=="")
        {
            alert("无导出数据!");
            return;
        }
        var tempForm = document.createElement("form");
        tempForm.method = "post";
        tempForm.action = url;
        var hideInput1 = document.createElement("input");
        hideInput1.type = "hidden";
        hideInput1.name = "data"
        hideInput1.value = data;
        var hideInput2 = document.createElement("input");
        hideInput2.type = "hidden";
        hideInput2.name = "fileName"
        hideInput2.value = fileName;
        tempForm.appendChild(hideInput1);
        if (fileName != null && fileName != "null" && fileName != "")
            tempForm.appendChild(hideInput2);
        document.body.appendChild(tempForm);
        tempForm.submit();
        document.body.removeChild(tempForm);
    }
</script>
</body>
</html>