/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.service.impl;

import cn.gtmap.onemap.platform.Constant;
import cn.gtmap.onemap.platform.dao.SpatialDao;
import cn.gtmap.onemap.platform.dao.impl.ArcSDEDaoImpl;
import cn.gtmap.onemap.platform.dao.impl.OracleSpatialDaoImpl;
import cn.gtmap.onemap.platform.entity.Configuration;
import cn.gtmap.onemap.platform.entity.LayerRegion;
import cn.gtmap.onemap.platform.entity.dict.Dict;
import cn.gtmap.onemap.platform.entity.dict.Item;
import cn.gtmap.onemap.platform.event.GISDaoException;
import cn.gtmap.onemap.platform.event.GeometryServiceException;
import cn.gtmap.onemap.platform.event.JSONMessageException;
import cn.gtmap.onemap.platform.service.AgsGeoemtryService;
import cn.gtmap.onemap.platform.service.GISService;
import cn.gtmap.onemap.platform.service.GeometryService;
import cn.gtmap.onemap.platform.service.MapService;
import cn.gtmap.onemap.platform.service.WebMapService;
import cn.gtmap.onemap.platform.service.impl.BaseLogger;
import cn.gtmap.onemap.platform.service.impl.GISServiceImpl;
import cn.gtmap.onemap.platform.support.spring.ApplicationContextHelper;
import cn.gtmap.onemap.platform.utils.ArrayUtils;
import cn.gtmap.onemap.platform.utils.EnumUtils;
import cn.gtmap.onemap.platform.utils.Utils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gtis.config.AppConfig;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.imageio.ImageIO;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.map.AbstractHashedMap;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.collections.map.MultiKeyMap;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.xfire.client.Client;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.Geometries;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

/*
 * Exception performing whole class analysis ignored.
 */
public class GISServiceImpl
extends BaseLogger
implements GISService {
    private final String SE_SHAPE_FIELD = "SHAPE";
    private final String SE_SHAPE_AREA = "SHAPE_AREA";
    private final String OG_PRO_PERFIX = "OG_PRO_";
    private final String SEARCH_LAYERS = "layers";
    private final String EXPORT_TYPE_GH = "gh";
    private final String EXPORT_TYPE_XZ = "xz";
    private final String DICT_TDLYXZ = "tdlyxz";
    private static final String LAYER_MIDDLE_FIX_E = "_E_";
    private static final String LAYER_MIDDLE_FIX_H = "_H_";
    private SpatialDao spatialDao;
    @Autowired
    private GeometryService geometryService;
    @Autowired
    private AgsGeoemtryService agsGeoemtryService;
    @Autowired
    private MapService mapService;
    @Autowired
    private WebMapService webMapService;
    private Map searchConfig;
    private Map exportConfig;

    public void setSearchConfig(Resource path) {
        try {
            this.searchConfig = (Map)JSON.parseObject((String)IOUtils.toString((URI)path.getURI(), (String)"utf-8"), Map.class);
        }
        catch (IOException e) {
            this.logger.error(" search config can't found ");
        }
    }

    public void setExportConfig(Resource path) {
        try {
            this.exportConfig = (Map)JSON.parseObject((String)IOUtils.toString((URI)path.getURI(), (String)"utf-8"), Map.class);
        }
        catch (IOException e) {
            this.logger.error(" export config can't found ");
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
        }
    }

    public void initialize(Constant.SpatialType type) {
        switch (1.$SwitchMap$cn$gtmap$onemap$platform$Constant$SpatialType[type.ordinal()]) {
            case 1: {
                this.spatialDao = (SpatialDao)ApplicationContextHelper.createBean(ArcSDEDaoImpl.class);
                break;
            }
            case 2: {
                this.spatialDao = (SpatialDao)ApplicationContextHelper.createBean(OracleSpatialDaoImpl.class);
            }
        }
    }

    public List<?> query(String layerName, String where, String[] columns, boolean returnGeometry, String dataSource) {
        Assert.notNull((Object)layerName, (String)this.getMessage("layer.name.notnull", new Object[0]));
        Assert.notNull((Object)where, (String)this.getMessage("query.where.notnull", new Object[0]));
        return this.spatialDao.query(layerName, where, columns, returnGeometry, dataSource);
    }

    public List<?> query(String layerName, String wkt, String[] columns, String dataSource) {
        Assert.notNull((Object)layerName, (String)this.getMessage("layer.name.notnull", new Object[0]));
        Assert.notNull((Object)wkt, (String)this.getMessage("query.geometry.notnull", new Object[0]));
        return this.spatialDao.query(layerName, wkt, columns, dataSource);
    }

    public List<?> query(String layerName, Geometry geometry, String[] columns, String dataSource) {
        return this.query(layerName, geometry.toText(), columns, dataSource);
    }

    public List<?> query(String layerName, SimpleFeature feature, String[] columns, String dataSource) {
        CoordinateReferenceSystem layerCRS = this.spatialDao.getLayerCRS(layerName, dataSource);
        CoordinateReferenceSystem sourceCRS = feature.getFeatureType().getCoordinateReferenceSystem();
        Geometry geometry = (Geometry)feature.getDefaultGeometry();
        if (sourceCRS == null) {
            CoordinateReferenceSystem coordinateReferenceSystem = sourceCRS = geometry.getSRID() != 0 ? this.geometryService.getCRSBySRID(String.valueOf(geometry.getSRID())) : null;
        }
        if (sourceCRS != null && !sourceCRS.equals(layerCRS)) {
            geometry = this.geometryService.project(geometry, sourceCRS, layerCRS);
        }
        return this.query(layerName, geometry.toText(), columns, dataSource);
    }

    public List<?> intersect(String layerName, String wktPlygon, String[] returnFields, String dataSource) {
        Assert.notNull((Object)layerName, (String)this.getMessage("layer.name.notnull", new Object[0]));
        return this.spatialDao.intersect(layerName, wktPlygon, returnFields, dataSource);
    }

    public List<?> intersect(String layerName, Polygon polygon, String[] returnFields, String dataSource) {
        return this.intersect(layerName, polygon.toText(), returnFields, dataSource);
    }

    public List<?> intersect(String layerName, Geometry geometry, CoordinateReferenceSystem sourceCRS, String[] outFields, String dataSource) {
        Assert.notNull((Object)geometry, (String)this.getMessage("geometry.notnull", new Object[0]));
        CoordinateReferenceSystem layerCRS = this.spatialDao.getLayerCRS(layerName, dataSource);
        if (sourceCRS == null) {
            CoordinateReferenceSystem coordinateReferenceSystem = sourceCRS = geometry.getSRID() != 0 ? this.geometryService.getCRSBySRID(String.valueOf(geometry.getSRID())) : null;
        }
        if (sourceCRS != null) {
            geometry = this.geometryService.project(geometry, sourceCRS, layerCRS);
        }
        ArrayList result = new ArrayList();
        if (geometry instanceof GeometryCollection) {
            for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                try {
                    Geometry geo = geometry.getGeometryN(i);
                    result.addAll(this.intersect(layerName, geo, outFields, dataSource));
                    this.addGeoProperty2List(result, geo);
                    continue;
                }
                catch (Exception e) {
                    this.logger.error(e.getLocalizedMessage());
                }
            }
        } else {
            result.addAll(this.intersect(layerName, geometry, outFields, dataSource));
            this.addGeoProperty2List(result, geometry);
        }
        return result;
    }

    public List<?> intersect(String layerName, Geometry geometry, String[] outFields, String dataSource) {
        ArrayList results = new ArrayList();
        CoordinateReferenceSystem sourceCRS = null;
        CoordinateReferenceSystem layerCRS = this.spatialDao.getLayerCRS(layerName, dataSource);
        sourceCRS = geometry.getSRID() != 0 ? this.geometryService.getCRSBySRID(String.valueOf(geometry.getSRID())) : null;
        String regionField = null;
        if (layerCRS instanceof GeographicCRS) {
            LayerRegion layerRegion = this.geometryService.getLayerRegion(layerName);
            if (!this.isNull((Object)layerRegion.getSourceLayerCRS())) {
                sourceCRS = layerRegion.getSourceLayerCRS();
            } else if (!this.isNull((Object)layerRegion.getRegionField())) {
                regionField = layerRegion.getRegionField();
                if (!this.checkFieldInLayer(regionField, layerName, dataSource)) {
                    throw new RuntimeException(this.getMessage("field.not.in.layer", new Object[]{regionField, layerName}));
                }
                if (!this.isNull((Object)outFields) && !ArrayUtils.contains((String[])outFields, (String)regionField, (boolean)true)) {
                    outFields = ArrayUtils.add2Arrays((String[])outFields, (String)regionField);
                }
            }
        }
        if (geometry instanceof GeometryCollection) {
            for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                try {
                    Geometry geo = geometry.getGeometryN(i);
                    List queryResults = this.query(layerName, geo, outFields, dataSource);
                    if (layerCRS instanceof GeographicCRS) {
                        if (this.isNull((Object)sourceCRS) && queryResults.size() > 0) {
                            sourceCRS = this.geometryService.getCRSByRegionCode(String.valueOf(((Map)queryResults.get(0)).get(regionField)));
                        }
                        geo = this.geometryService.project(geo, layerCRS, this.isNull((Object)sourceCRS) ? layerCRS : sourceCRS);
                    }
                    HashMap<String, Object> result = null;
                    for (int j = 0; j < queryResults.size(); ++j) {
                        Map map = (Map)queryResults.get(j);
                        Geometry geo1 = this.geometryService.readWKT(map.get("SHAPE").toString());
                        if (layerCRS instanceof GeographicCRS) {
                            geo1 = this.geometryService.project(geo1, layerCRS, sourceCRS);
                        }
                        Geometry geometryResult = null;
                        try {
                            if (this.isNull((Object)sourceCRS)) {
                                sourceCRS = layerCRS;
                            }
                            geometryResult = this.geometryService.readWKT(this.agsGeoemtryService.intersection(geo1.toText(), geo.toText(), sourceCRS.toWKT()));
                        }
                        catch (Exception e) {
                            geometryResult = this.geometryService.forceSimplify(geo1, this.geometryService.getSimplifyTolerance()).intersection(geo);
                            this.logger.error(" geometry is invalid,[{}]", (Object)e.getLocalizedMessage());
                        }
                        if (geometryResult.isEmpty()) continue;
                        result = new HashMap<String, Object>();
                        result.putAll(map);
                        result.put("SHAPE_AREA", this.agsGeoemtryService.getGeometryArea(geometryResult.toText()));
                        if (layerCRS instanceof GeographicCRS) {
                            try {
                                geometryResult = this.geometryService.project(geometryResult, sourceCRS, layerCRS);
                            }
                            catch (GeometryServiceException e) {
                                geometryResult = this.geometryService.simplify(geometryResult, this.geometryService.getSimplifyTolerance());
                                geometryResult = this.geometryService.project(geometryResult, sourceCRS, layerCRS);
                            }
                        }
                        result.put("SHAPE", geometryResult.toText());
                        result.put("OG_SHAPE_AREA", this.agsGeoemtryService.getGeometryArea(geo1.toText()));
                        results.add(result);
                    }
                    continue;
                }
                catch (Exception e) {
                    this.logger.error(e.getLocalizedMessage());
                }
            }
        } else {
            List queryResults = this.query(layerName, geometry, outFields, dataSource);
            if (layerCRS instanceof GeographicCRS) {
                if (this.isNull((Object)sourceCRS) && queryResults.size() > 0) {
                    sourceCRS = this.geometryService.getCRSByRegionCode(String.valueOf(((Map)queryResults.get(0)).get(regionField)));
                }
                geometry = this.geometryService.project(geometry, layerCRS, this.isNull((Object)sourceCRS) ? layerCRS : sourceCRS);
            }
            HashMap<String, Object> result = null;
            for (int j = 0; j < queryResults.size(); ++j) {
                Map map = (Map)queryResults.get(j);
                Geometry geo1 = this.geometryService.readWKT(map.get("SHAPE").toString());
                if (layerCRS instanceof GeographicCRS) {
                    geo1 = this.geometryService.project(geo1, layerCRS, sourceCRS);
                }
                Geometry geometryResult = null;
                try {
                    if (this.isNull((Object)sourceCRS)) {
                        sourceCRS = layerCRS;
                    }
                    geometryResult = this.geometryService.readWKT(this.agsGeoemtryService.intersection(geo1.toText(), geometry.toText(), sourceCRS.toWKT()));
                }
                catch (Exception e) {
                    this.logger.info(" geometry is invalid,[{}]", (Object)e.getLocalizedMessage());
                    geometryResult = this.geometryService.forceSimplify(geo1, this.geometryService.getSimplifyTolerance()).intersection(geometry);
                }
                if (geometryResult.isEmpty()) continue;
                result = new HashMap<String, Object>();
                result.putAll(map);
                result.put("SHAPE_AREA", this.agsGeoemtryService.getGeometryArea(geometryResult.toText()));
                if (layerCRS instanceof GeographicCRS) {
                    try {
                        geometryResult = this.geometryService.project(geometryResult, sourceCRS, layerCRS);
                    }
                    catch (GeometryServiceException e) {
                        geometryResult = this.geometryService.simplify(geometryResult, this.geometryService.getSimplifyTolerance());
                        geometryResult = this.geometryService.project(geometryResult, sourceCRS, layerCRS);
                    }
                }
                result.put("SHAPE", geometryResult.toText());
                result.put("OG_SHAPE_AREA", this.agsGeoemtryService.getGeometryArea(geo1.toText()));
                results.add(result);
            }
        }
        return results;
    }

    public List<?> intersectByGeoJSON(String layerName, String geoJson, String[] outField, String dataSource) {
        Object geo = this.geometryService.readUnTypeGeoJSON(geoJson);
        CoordinateReferenceSystem sourceCRS = null;
        List results = null;
        if (geo instanceof Geometry) {
            Geometry geometry = (Geometry)geo;
            if (!geometry.isValid()) {
                geometry = this.createValidGeometry(geometry);
            }
            sourceCRS = geometry.getSRID() != 0 ? this.geometryService.getCRSBySRID(String.valueOf(geometry.getSRID())) : null;
            results = this.intersect(layerName, geometry, sourceCRS, outField, dataSource);
        } else if (geo instanceof SimpleFeature) {
            SimpleFeature feature = (SimpleFeature)geo;
            results = this.addFeaturePros2List(this.intersectBySimpleFeature(layerName, feature, outField, dataSource), feature);
        } else if (geo instanceof FeatureCollection) {
            FeatureCollection collection = (FeatureCollection)geo;
            results = new ArrayList();
            FeatureIterator iterator = ((FeatureCollection)geo).features();
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                results.addAll(this.addFeaturePros2List(this.intersectBySimpleFeature(layerName, feature, outField, dataSource), feature));
            }
        }
        return results;
    }

    public List<?> intersect4(String layerName, String geoJson, String[] outField, String dataSource) {
        Object geo = this.geometryService.readUnTypeGeoJSON(geoJson);
        CoordinateReferenceSystem sourceCrs = null;
        CoordinateReferenceSystem layerCrs = this.spatialDao.getLayerCRS(layerName, dataSource);
        List results = null;
        if (geo instanceof Geometry) {
            Geometry geometry = (Geometry)geo;
            if (!geometry.isValid()) {
                geometry = this.createValidGeometry(geometry);
            }
            results = this.bufferIntersect(layerName, geometry, layerCrs, outField, dataSource);
        } else if (geo instanceof SimpleFeature) {
            SimpleFeature feature = (SimpleFeature)geo;
            Geometry geometry = (Geometry)feature.getDefaultGeometry();
            if (!geometry.isValid()) {
                geometry = this.createValidGeometry(geometry);
            }
            sourceCrs = feature.getFeatureType().getCoordinateReferenceSystem();
            this.setFeaturePros2Geo(feature, geometry);
            results = this.addFeaturePros2List(this.bufferIntersect(layerName, geometry, sourceCrs, outField, dataSource), feature);
        } else if (geo instanceof FeatureCollection) {
            results = new ArrayList();
            FeatureIterator iterator = ((FeatureCollection)geo).features();
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                Geometry geometry = (Geometry)feature.getDefaultGeometry();
                if (!geometry.isValid()) {
                    geometry = this.createValidGeometry(geometry);
                }
                sourceCrs = feature.getFeatureType().getCoordinateReferenceSystem();
                this.setFeaturePros2Geo(feature, geometry);
                results.addAll(this.addFeaturePros2List(this.bufferIntersect(layerName, geometry, sourceCrs, outField, dataSource), feature));
            }
        }
        return results;
    }

    public List<?> bufferIntersect(String layerName, Geometry sourceGeometry, CoordinateReferenceSystem sourceCRS, String[] outFields, String dataSource) {
        ArrayList results = new ArrayList();
        CoordinateReferenceSystem layerCRS = this.spatialDao.getLayerCRS(layerName, dataSource);
        String regionField = null;
        if (layerCRS instanceof GeographicCRS) {
            LayerRegion layerRegion = this.geometryService.getLayerRegion(layerName);
            if (!this.isNull((Object)layerRegion.getSourceLayerCRS())) {
                sourceCRS = layerRegion.getSourceLayerCRS();
            } else if (!this.isNull((Object)layerRegion.getRegionField())) {
                regionField = layerRegion.getRegionField();
                if (!this.checkFieldInLayer(regionField, layerName, dataSource)) {
                    throw new RuntimeException(this.getMessage("field.not.in.layer", new Object[]{regionField, layerName}));
                }
                if (!this.isNull((Object)outFields) && !ArrayUtils.contains((String[])outFields, (String)regionField, (boolean)true)) {
                    outFields = ArrayUtils.add2Arrays((String[])outFields, (String)regionField);
                }
            }
        }
        if (sourceGeometry instanceof GeometryCollection) {
            for (int i = 0; i < sourceGeometry.getNumGeometries(); ++i) {
                try {
                    Geometry beforeGeo = sourceGeometry.getGeometryN(i);
                    Geometry afterGeometry = null;
                    afterGeometry = !this.isNull((Object)layerCRS) ? this.geometryService.project(beforeGeo, sourceCRS, layerCRS) : beforeGeo;
                    Geometry tmpGeo = afterGeometry.buffer(0.002);
                    List queryResults = this.query(layerName, tmpGeo, outFields, dataSource);
                    CoordinateReferenceSystem tmpProjectedCRS = null;
                    if (sourceCRS instanceof GeographicCRS && layerCRS instanceof GeographicCRS) {
                        if (queryResults.size() > 0) {
                            tmpProjectedCRS = this.geometryService.getCRSByRegionCode(String.valueOf(((Map)queryResults.get(0)).get(regionField)));
                        }
                        beforeGeo = this.geometryService.project(beforeGeo, layerCRS, this.isNull(tmpProjectedCRS) ? layerCRS : tmpProjectedCRS);
                    }
                    HashMap<String, Object> result = null;
                    for (int j = 0; j < queryResults.size(); ++j) {
                        Map map = (Map)queryResults.get(j);
                        Geometry geo1 = this.geometryService.readWKT(map.get("SHAPE").toString());
                        if (layerCRS instanceof GeographicCRS) {
                            geo1 = this.geometryService.project(geo1, layerCRS, this.isNull((Object)tmpProjectedCRS) ? sourceCRS : tmpProjectedCRS);
                        }
                        Geometry geometryResult = null;
                        try {
                            geometryResult = this.geometryService.readWKT(this.agsGeoemtryService.intersection(geo1.toText(), beforeGeo.toText(), sourceCRS.toWKT()));
                        }
                        catch (Exception e) {
                            this.logger.error(" geometry is invalid,[{}]", (Object)e.getLocalizedMessage());
                            geometryResult = this.geometryService.forceSimplify(geo1, this.geometryService.getSimplifyTolerance()).intersection(beforeGeo);
                        }
                        if (geometryResult.isEmpty()) continue;
                        result = new HashMap<String, Object>();
                        result.putAll(map);
                        result.put("SHAPE_AREA", this.agsGeoemtryService.getGeometryArea(geometryResult.toText()));
                        if (layerCRS instanceof GeographicCRS) {
                            try {
                                geometryResult = this.geometryService.project(geometryResult, this.isNull((Object)tmpProjectedCRS) ? sourceCRS : tmpProjectedCRS, layerCRS);
                            }
                            catch (GeometryServiceException e) {
                                geometryResult = this.geometryService.simplify(geometryResult, this.geometryService.getSimplifyTolerance());
                                geometryResult = this.geometryService.project(geometryResult, this.isNull((Object)tmpProjectedCRS) ? sourceCRS : tmpProjectedCRS, layerCRS);
                            }
                        }
                        result.put("SHAPE", geometryResult.toText());
                        result.put("OG_SHAPE_AREA", this.agsGeoemtryService.getGeometryArea(geo1.toText()));
                        results.add(result);
                    }
                    continue;
                }
                catch (Exception e) {
                    this.logger.error(e.getLocalizedMessage());
                }
            }
        } else {
            Geometry afterGeometry = null;
            afterGeometry = !this.isNull((Object)layerCRS) ? this.geometryService.project(sourceGeometry, sourceCRS, layerCRS) : sourceGeometry;
            Geometry tmpGeo = afterGeometry.buffer(0.002);
            List queryResults = this.query(layerName, tmpGeo, outFields, dataSource);
            CoordinateReferenceSystem tmpProjectedCRS = null;
            if (sourceCRS instanceof GeographicCRS && layerCRS instanceof GeographicCRS) {
                if (queryResults.size() > 0) {
                    tmpProjectedCRS = this.geometryService.getCRSByRegionCode(String.valueOf(((Map)queryResults.get(0)).get(regionField)));
                }
                sourceGeometry = this.geometryService.project(sourceGeometry, layerCRS, this.isNull(tmpProjectedCRS) ? layerCRS : tmpProjectedCRS);
            }
            HashMap<String, Object> result = null;
            for (int j = 0; j < queryResults.size(); ++j) {
                Map map = (Map)queryResults.get(j);
                Geometry geo1 = this.geometryService.readWKT(map.get("SHAPE").toString());
                if (layerCRS instanceof GeographicCRS) {
                    geo1 = this.geometryService.project(geo1, layerCRS, this.isNull((Object)tmpProjectedCRS) ? sourceCRS : tmpProjectedCRS);
                }
                Geometry geometryResult = null;
                try {
                    geometryResult = this.geometryService.readWKT(this.agsGeoemtryService.intersection(geo1.toText(), sourceGeometry.toText(), sourceCRS.toWKT()));
                }
                catch (Exception e) {
                    this.logger.error(" geometry is invalid,[{}]", (Object)e.getLocalizedMessage());
                    geometryResult = this.geometryService.forceSimplify(geo1, this.geometryService.getSimplifyTolerance()).intersection(sourceGeometry);
                }
                if (geometryResult.isEmpty()) continue;
                result = new HashMap<String, Object>();
                result.putAll(map);
                result.put("SHAPE_AREA", this.agsGeoemtryService.getGeometryArea(geometryResult.toText()));
                if (layerCRS instanceof GeographicCRS) {
                    try {
                        geometryResult = this.geometryService.project(geometryResult, this.isNull((Object)tmpProjectedCRS) ? sourceCRS : tmpProjectedCRS, layerCRS);
                    }
                    catch (GeometryServiceException e) {
                        geometryResult = this.geometryService.simplify(geometryResult, this.geometryService.getSimplifyTolerance());
                        geometryResult = this.geometryService.project(geometryResult, this.isNull((Object)tmpProjectedCRS) ? sourceCRS : tmpProjectedCRS, layerCRS);
                    }
                }
                result.put("SHAPE", geometryResult.toText());
                result.put("OG_SHAPE_AREA", this.agsGeoemtryService.getGeometryArea(geo1.toText()));
                results.add(result);
            }
        }
        return results;
    }

    private List<?> intersectBySimpleFeature(String layerName, SimpleFeature feature, String[] outField, String dataSource) {
        CoordinateReferenceSystem sourceCRS = null;
        Geometry geometry = (Geometry)feature.getDefaultGeometry();
        if (!geometry.isValid()) {
            geometry = this.createValidGeometry(geometry);
        }
        this.setFeaturePros2Geo(feature, geometry);
        try {
            sourceCRS = feature.getFeatureType().getCoordinateReferenceSystem();
            return this.intersect(layerName, geometry, sourceCRS, outField, dataSource);
        }
        catch (Exception e) {
            this.logger.error("intersect analysis - feature json crs not define [{}]", (Object)e.getLocalizedMessage());
            return null;
        }
    }

    public List<?> intersect2(String layerName, String geoJson, String[] outField, String dataSource) {
        List results = this.intersectByGeoJSON(layerName, geoJson, outField, dataSource);
        return results;
    }

    public List<?> intersect3(String layerName, String geoJson, String[] outField, String dataSource) {
        Object geo = this.geometryService.readUnTypeGeoJSON(geoJson);
        CoordinateReferenceSystem sourceCrs = null;
        CoordinateReferenceSystem layerCrs = this.spatialDao.getLayerCRS(layerName, dataSource);
        List results = null;
        if (geo instanceof Geometry) {
            Geometry geometry = (Geometry)geo;
            if (!geometry.isValid()) {
                geometry = this.createValidGeometry(geometry);
            }
            results = this.intersect(layerName, geometry, outField, dataSource);
        } else if (geo instanceof SimpleFeature) {
            SimpleFeature feature = (SimpleFeature)geo;
            Geometry geometry = (Geometry)feature.getDefaultGeometry();
            if (!geometry.isValid()) {
                geometry = this.createValidGeometry(geometry);
            }
            if (!this.isNull((Object)(sourceCrs = feature.getFeatureType().getCoordinateReferenceSystem())) && !this.isNull((Object)layerCrs)) {
                geometry = this.geometryService.project(geometry, sourceCrs, layerCrs);
            }
            this.setFeaturePros2Geo(feature, geometry);
            results = this.addFeaturePros2List(this.intersect(layerName, geometry, outField, dataSource), feature);
        } else if (geo instanceof FeatureCollection) {
            results = new ArrayList();
            FeatureIterator iterator = ((FeatureCollection)geo).features();
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                Geometry geometry = (Geometry)feature.getDefaultGeometry();
                if (!geometry.isValid()) {
                    geometry = this.createValidGeometry(geometry);
                }
                if (!this.isNull((Object)(sourceCrs = feature.getFeatureType().getCoordinateReferenceSystem())) && !this.isNull((Object)layerCrs)) {
                    geometry = this.geometryService.project(geometry, sourceCrs, layerCrs);
                }
                this.setFeaturePros2Geo(feature, geometry);
                results.addAll(this.addFeaturePros2List(this.intersect(layerName, geometry, outField, dataSource), feature));
            }
        }
        return results;
    }

    private Geometry createValidGeometry(Geometry geometry) {
        try {
            if (geometry instanceof Polygon) {
                Polygon polygon = (Polygon)geometry;
                GeometryFactory factory = geometry.getFactory();
                ArrayList<Polygon> polygons = new ArrayList<Polygon>();
                Polygon exteriorPolygon = new Polygon((LinearRing)polygon.getExteriorRing(), null, factory);
                polygons.add(exteriorPolygon);
                for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
                    LinearRing interiorRing = (LinearRing)polygon.getInteriorRingN(i);
                    Polygon interiorPolygon = new Polygon(interiorRing, null, factory);
                    polygons.add(interiorPolygon);
                }
                ArrayList<Polygon> newPolygons = new ArrayList<Polygon>();
                ArrayList excludePolygons = new ArrayList();
                for (Polygon temp : polygons) {
                    if (excludePolygons.contains(temp = this.getPolygonWithHoles(polygons, excludePolygons, temp))) continue;
                    newPolygons.add(temp);
                }
                return new MultiPolygon(newPolygons.toArray(new Polygon[0]), factory);
            }
            if (geometry instanceof MultiPolygon) {
                MultiPolygon multiPolygon = (MultiPolygon)geometry;
                ArrayList<Polygon> polygonList = new ArrayList<Polygon>();
                for (int j = 0; j < multiPolygon.getNumGeometries(); ++j) {
                    Polygon polygon = (Polygon)multiPolygon.getGeometryN(j);
                    if (!polygon.isValid()) {
                        MultiPolygon tempMultiPolygon = (MultiPolygon)this.createValidGeometry((Geometry)polygon);
                        for (int k = 0; k < tempMultiPolygon.getNumGeometries(); ++k) {
                            polygonList.add((Polygon)tempMultiPolygon.getGeometryN(k));
                        }
                        continue;
                    }
                    polygonList.add(polygon);
                }
                return new MultiPolygon(polygonList.toArray(new Polygon[0]), multiPolygon.getFactory());
            }
            this.logger.info("geometryType has not been supported yet");
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
        }
        return null;
    }

    private Polygon getPolygonWithHoles(List<Polygon> srcPolygons, List<Polygon> excludePolygons, Polygon polygon) {
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        for (Polygon item : srcPolygons) {
            if (polygon.equals((Geometry)item) || excludePolygons.contains(polygon) || !polygon.contains((Geometry)item)) continue;
            holes.add((LinearRing)item.getExteriorRing());
            excludePolygons.add(item);
        }
        if (holes.size() > 0) {
            return new Polygon((LinearRing)polygon.getExteriorRing(), holes.toArray(new LinearRing[0]), polygon.getFactory());
        }
        return polygon;
    }

    private List addFeaturePros2List(List<Map> value, SimpleFeature feature) {
        for (Map item : value) {
            for (Property p : feature.getProperties()) {
                if (p.getName().getLocalPart().equals("geometry")) continue;
                item.put("OG_PRO_".concat(p.getName().getLocalPart()), p.getValue());
            }
        }
        return value;
    }

    public String insert(String layerName, Map<String, Object> columns, String dataSource) {
        LayerRegion layerRegion = this.geometryService.getLayerRegion(layerName);
        if (!this.isNull((Object)layerRegion.getRegionField())) {
            boolean contains = false;
            for (Map.Entry<String, Object> entry : columns.entrySet()) {
                if (!layerRegion.getRegionField().equalsIgnoreCase(entry.getKey()) || !this.geometryService.containsRegionValue(String.valueOf(entry.getValue()))) continue;
                contains = true;
                break;
            }
            if (!contains) {
                throw new RuntimeException(this.getMessage("insert.region.field.not.null", new Object[]{layerName, layerRegion.getRegionField()}));
            }
        }
        return this.spatialDao.insert(layerName, columns, dataSource);
    }

    public String insert(String layerName, String geoJSON, String dataSource) {
        CoordinateReferenceSystem layerCRS = this.spatialDao.getLayerCRS(layerName, dataSource);
        Object geo = this.geometryService.readUnTypeGeoJSON(geoJSON);
        if (geo instanceof FeatureCollection) {
            Map columns = null;
            SimpleFeatureCollection featureCollection = (SimpleFeatureCollection)geo;
            SimpleFeatureIterator featureIterator = featureCollection.features();
            while (featureIterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)featureIterator.next();
                CoordinateReferenceSystem sourceCRS = this.geometryService.readFeatureJSONCRS(this.geometryService.toFeatureJSON((Object)feature));
                columns = this.geometryService.simpleFeature2Map(feature);
                for (Map.Entry entry : columns.entrySet()) {
                    if (!(entry.getValue() instanceof Geometry)) continue;
                    Geometry geometry = (Geometry)entry.getValue();
                    if (layerCRS != null && sourceCRS != null) {
                        geometry = this.geometryService.project(geometry, sourceCRS, layerCRS);
                    }
                    columns.put("SHAPE", geometry.toText());
                    columns.remove(entry.getKey());
                }
                if (featureIterator.hasNext()) {
                    this.insert(layerName, columns, dataSource);
                    continue;
                }
                return this.insert(layerName, columns, dataSource);
            }
        }
        return this.insert(layerName, this.geoJSON2Map(geoJSON, layerCRS), dataSource);
    }

    public String insert2(String layerName, String geoJSON, String dataSource) {
        CoordinateReferenceSystem layerCRS = this.spatialDao.getLayerCRS(layerName, dataSource);
        Object geo = this.geometryService.readUnTypeGeoJSON(geoJSON);
        if (geo instanceof FeatureCollection) {
            LinkedHashMap<String, Object> resultFc = new LinkedHashMap<String, Object>();
            resultFc.put("type", "FeatureCollection");
            ArrayList<LinkedHashMap> resultFeatures = new ArrayList<LinkedHashMap>();
            Map columns = null;
            SimpleFeatureCollection featureCollection = (SimpleFeatureCollection)geo;
            SimpleFeatureIterator featureIterator = featureCollection.features();
            while (featureIterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)featureIterator.next();
                CoordinateReferenceSystem sourceCRS = this.geometryService.readFeatureJSONCRS(this.geometryService.toFeatureJSON((Object)feature));
                columns = this.geometryService.simpleFeature2Map(feature);
                for (String key : columns.keySet()) {
                    if (!(columns.get(key) instanceof Geometry)) continue;
                    Geometry geometry = (Geometry)columns.get(key);
                    if (layerCRS != null && sourceCRS != null) {
                        geometry = this.geometryService.project(geometry, sourceCRS, layerCRS);
                    }
                    columns.put("SHAPE", geometry.toText());
                    columns.remove(key);
                    break;
                }
                String objectId = this.insert(layerName, columns, dataSource);
                LinkedHashMap featureMap = (LinkedHashMap)JSON.parseObject((String)this.geometryService.toFeatureJSON((Object)feature), LinkedHashMap.class);
                JSONObject properties = (JSONObject)featureMap.get("properties");
                properties.put("OBJECTID", (Object)objectId);
                resultFeatures.add(featureMap);
            }
            resultFc.put("features", resultFeatures);
            return JSON.toJSONString(resultFc);
        }
        if (geo instanceof SimpleFeature) {
            SimpleFeature feature = (SimpleFeature)geo;
            LinkedHashMap featureMap = (LinkedHashMap)JSON.parseObject((String)this.geometryService.toFeatureJSON((Object)feature), LinkedHashMap.class);
            JSONObject properties = (JSONObject)featureMap.get("properties");
            String objectId = this.insert(layerName, this.geoJSON2Map(geoJSON, layerCRS), dataSource);
            properties.put("OBJECTID", (Object)objectId);
            return JSON.toJSONString((Object)featureMap);
        }
        return null;
    }

    public String insert2(String layerName, String geoJSON, boolean check, String dataSource) {
        if (check) {
            CoordinateReferenceSystem layerCRS = this.spatialDao.getLayerCRS(layerName, dataSource);
            Object geo = this.geometryService.readUnTypeGeoJSON(geoJSON);
            if (geo instanceof FeatureCollection) {
                LinkedHashMap<String, Object> resultFc = new LinkedHashMap<String, Object>();
                resultFc.put("type", "FeatureCollection");
                ArrayList<LinkedHashMap> resultFeatures = new ArrayList<LinkedHashMap>();
                Map columns = null;
                SimpleFeatureCollection featureCollection = (SimpleFeatureCollection)geo;
                SimpleFeatureIterator featureIterator = featureCollection.features();
                while (featureIterator.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)featureIterator.next();
                    List list = this.query(layerName, feature, null, dataSource);
                    if (list.size() > 0) {
                        this.logger.error("\u56fe\u5f62\u5df2\u5728\u6b64\u56fe\u5c42\u4e2d\u5b58\u5728,\u63d2\u5165\u5931\u8d25!\u3010{}\u3011", (Object)this.geometryService.toFeatureJSON((Object)feature).toString());
                        if (featureIterator.hasNext()) continue;
                        throw new GISDaoException(GISDaoException.Method.INSERT, "\u56fe\u5f62\u5df2\u5728\u6b64\u56fe\u5c42\u4e2d\u5b58\u5728,\u63d2\u5165\u5931\u8d25!", GISDaoException.Type.ARC_SDE);
                    }
                    CoordinateReferenceSystem sourceCRS = this.geometryService.readFeatureJSONCRS(this.geometryService.toFeatureJSON((Object)feature));
                    columns = this.geometryService.simpleFeature2Map(feature);
                    try {
                        for (String key : columns.keySet()) {
                            if (!(columns.get(key) instanceof Geometry)) continue;
                            Geometry geometry = (Geometry)columns.get(key);
                            if (layerCRS != null && sourceCRS != null) {
                                geometry = this.geometryService.project(geometry, sourceCRS, layerCRS);
                            }
                            columns.put("SHAPE", geometry.toText());
                            columns.remove(key);
                            break;
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getLocalizedMessage());
                        throw new RuntimeException(e.getLocalizedMessage());
                    }
                    String objectId = this.insert(layerName, columns, dataSource);
                    LinkedHashMap featureMap = (LinkedHashMap)JSON.parseObject((String)this.geometryService.toFeatureJSON((Object)feature), LinkedHashMap.class);
                    JSONObject properties = (JSONObject)featureMap.get("properties");
                    properties.put("OBJECTID", (Object)objectId);
                    resultFeatures.add(featureMap);
                }
                resultFc.put("features", resultFeatures);
                return JSON.toJSONString(resultFc);
            }
            if (geo instanceof SimpleFeature) {
                SimpleFeature feature = (SimpleFeature)geo;
                List list = this.query(layerName, feature, null, dataSource);
                if (list.size() > 0) {
                    this.logger.error("\u56fe\u5f62\u5df2\u5728\u6b64\u56fe\u5c42\u4e2d\u5b58\u5728,\u63d2\u5165\u5931\u8d25!\u3010{}\u3011", (Object)geoJSON);
                    throw new GISDaoException(GISDaoException.Method.INSERT, "\u56fe\u5f62\u5df2\u5728\u6b64\u56fe\u5c42\u4e2d\u5b58\u5728,\u63d2\u5165\u5931\u8d25!", GISDaoException.Type.ARC_SDE);
                }
                LinkedHashMap featureMap = (LinkedHashMap)JSON.parseObject((String)this.geometryService.toFeatureJSON((Object)feature), LinkedHashMap.class);
                JSONObject properties = (JSONObject)featureMap.get("properties");
                String objectId = this.insert(layerName, this.geoJSON2Map(geoJSON, layerCRS), dataSource);
                properties.put("OBJECTID", (Object)objectId);
                return JSON.toJSONString((Object)featureMap);
            }
        } else {
            return this.insert2(layerName, geoJSON, dataSource);
        }
        return null;
    }

    public boolean update(String layerName, String primaryKey, Map<String, Object> columns, String dataSource) {
        return this.spatialDao.update(layerName, primaryKey, columns, dataSource);
    }

    public boolean update(String layerName, String primaryKey, String geoJSON, String dataSource) {
        CoordinateReferenceSystem layerCRS = this.spatialDao.getLayerCRS(layerName, dataSource);
        return this.update(layerName, primaryKey, this.geoJSON2Map(geoJSON, layerCRS), dataSource);
    }

    public boolean delete(String layerName, String primaryKey, String dataSource) {
        return this.spatialDao.delete(layerName, primaryKey, dataSource);
    }

    public Map tdlyxzAnalysis(String dltbLayerName, String xzdwLayerName, String geometry, String[] outFields, String dataSource) {
        Assert.notNull((Object)geometry, (String)this.getMessage("geometry.notnull", new Object[0]));
        HashMap<String, Double> analysisResult = new HashMap<String, Double>();
        HashMap<String, Double> analysisTemp = new HashMap<String, Double>();
        String[] dltbOutFields = ArrayUtils.add2Arrays((String[])outFields, (String[])new String[]{"DLMC", "ZLDWDM", "TBBH"});
        List results = this.intersectByGeoJSON(dltbLayerName, geometry, dltbOutFields, dataSource);
        for (Map result : results) {
            String dlmc;
            Double area = Double.parseDouble(String.valueOf(result.get("SHAPE_AREA")));
            if (!(area > 0.4)) continue;
            analysisResult.put(dlmc, (analysisResult.containsKey(dlmc = String.valueOf(result.get("DLMC"))) ? (Double)analysisResult.get(dlmc) : 0.0) + area);
            analysisTemp.put(String.valueOf(result.get("ZLDWDM")) + String.valueOf(result.get("TBBH")), area);
        }
        String[] xzdwOutFields = ArrayUtils.add2Arrays((String[])outFields, (String[])new String[]{"DLMC", "KD", "KCTBDWDM2", "KCTBDWDM1", "KCTBBH1", "KCTBBH2"});
        List xzResults = this.intersectByGeoJSON(xzdwLayerName, geometry, xzdwOutFields, dataSource);
        for (Map result : xzResults) {
            Double length = Double.parseDouble(String.valueOf(result.get("SHAPE_AREA")));
            if (!(length > 0.08)) continue;
            String dlmc = String.valueOf(result.get("DLMC"));
            Double kd = Double.parseDouble(String.valueOf(result.get("KD")));
            analysisResult.put(dlmc, (analysisResult.containsKey(dlmc) ? (Double)analysisResult.get(dlmc) : 0.0) + length * kd);
            String where = "ZLDWDM='" + result.get("KCTBDWDM1") + "' and TBBH='" + result.get("KCTBBH1") + "'";
            List temps = new ArrayList();
            try {
                temps = this.query(dltbLayerName, where, ArrayUtils.add2Arrays((String[])outFields, (String[])new String[]{"DLMC"}), true, dataSource);
            }
            catch (Exception e) {
                this.logger.error("tdlyxzAnalysis error [{}] ", (Object)e.getLocalizedMessage());
            }
            String kctb1Key = String.valueOf(result.get("KCTBDWDM1")) + String.valueOf(result.get("KCTBBH1"));
            if (StringUtils.isBlank((String)((String)result.get("KCTBDWDM2")))) {
                for (Map temp : temps) {
                    String tmpDlmc = String.valueOf(temp.get("DLMC"));
                    analysisResult.put(tmpDlmc, (Double)analysisResult.get(tmpDlmc) - length * kd);
                    analysisTemp.put(kctb1Key, (Double)analysisTemp.get(kctb1Key) - length * kd);
                }
                continue;
            }
            Tag tag = Tag.NO;
            String tmpDlmc = "";
            String tmpDlmc1 = "";
            Double tmpXzdwKd = 0.0;
            String tmpXzdwKctbdwdm1 = "";
            String tmpXzdwKctbbh1 = "";
            for (Map tmp : temps) {
                tmpDlmc = String.valueOf(tmp.get("DLMC"));
                if (analysisTemp.containsKey(kctb1Key)) {
                    Double tmpValue = (Double)analysisTemp.get(kctb1Key);
                    if (tmpValue - length / 2.0 * kd > 0.0) {
                        analysisResult.put(tmpDlmc, (Double)analysisResult.get(tmpDlmc) - length / 2.0 * kd);
                        tmpXzdwKd = length / 2.0 * kd;
                        tmpDlmc1 = tmpDlmc;
                        tmpXzdwKctbbh1 = String.valueOf(result.get("KCTBBH1"));
                        tmpXzdwKctbdwdm1 = String.valueOf(result.get("KCTBDWDM1"));
                        analysisTemp.put(tmpXzdwKctbdwdm1 + tmpXzdwKctbbh1, tmpValue - length / 2.0 * kd);
                        continue;
                    }
                    tag = Tag.YES;
                    continue;
                }
                tag = Tag.YES;
            }
            where = "ZLDWDM='" + result.get("KCTBDWDM2") + "' and TBBH='" + result.get("KCTBBH2") + "'";
            try {
                temps = this.query(dltbLayerName, where, new String[]{"DLMC"}, true, dataSource);
            }
            catch (Exception e) {
                this.logger.error("tdlyxzAnalysis error [{}] ", (Object)e.getLocalizedMessage());
                temps.clear();
            }
            String kctb2Key = String.valueOf(result.get("KCTBDWDM2")) + String.valueOf(result.get("KCTBBH2"));
            for (Map tmp : temps) {
                tmpDlmc = String.valueOf(tmp.get("DLMC"));
                if (analysisTemp.containsKey(kctb2Key)) {
                    Double tmpValue = (Double)analysisTemp.get(kctb2Key);
                    if (tmpValue - length / 2.0 * kd > 0.0) {
                        if (!Tag.YES.equals((Object)tag)) {
                            analysisResult.put(tmpDlmc, (Double)analysisResult.get(tmpDlmc) - length / 2.0 * kd);
                            analysisTemp.put(kctb2Key, tmpValue - length * kd);
                            continue;
                        }
                        analysisResult.put(tmpDlmc, (Double)analysisResult.get(tmpDlmc) - length / 2.0 * kd);
                        analysisTemp.put(kctb2Key, tmpValue - length * kd);
                        continue;
                    }
                    tmpDlmc = tmpDlmc1;
                    analysisResult.put(tmpDlmc, (Double)analysisResult.get(tmpDlmc) - tmpXzdwKd);
                    analysisTemp.put(kctb1Key, (Double)analysisTemp.get(kctb1Key) - tmpXzdwKd);
                    continue;
                }
                tmpDlmc = tmpDlmc1;
                analysisResult.put(tmpDlmc, (Double)analysisResult.get(tmpDlmc) - tmpXzdwKd);
                analysisTemp.put(kctb1Key, (Double)analysisTemp.get(kctb1Key) - tmpXzdwKd);
            }
        }
        return analysisResult;
    }

    public Map tdlyxzAnalysis(String regionCode, String geometry, String dataSource) {
        regionCode = Utils.formatRegionCode((String)regionCode);
        String dltb = TDXZ.DLTB.name().concat("_H_").concat(regionCode);
        String xzdw = TDXZ.XZDW.name().concat("_H_").concat(regionCode);
        return this.tdlyxzAnalysis2(dltb, xzdw, geometry, dataSource);
    }

    public Map tdlyxzAnalysis2(String dltbLayerName, String xzdwLayerName, String geometry, String dataSource) {
        Map<String, String> detailValue;
        if (StringUtils.isBlank((String)dltbLayerName)) {
            throw new RuntimeException(this.getMessage("analysis.tdlyxz.params.error", new Object[]{"\u5730\u7c7b\u56fe\u6591\u56fe\u5c42\u540d\u79f0\u4e3a\u7a7a\uff01"}));
        }
        if (StringUtils.isBlank((String)xzdwLayerName)) {
            throw new RuntimeException(this.getMessage("analysis.tdlyxz.params.error", new Object[]{"\u7ebf\u72b6\u5730\u7269\u56fe\u5c42\u540d\u79f0\u4e3a\u7a7a\uff01"}));
        }
        if (StringUtils.isBlank((String)geometry)) {
            throw new RuntimeException(this.getMessage("analysis.tdlyxz.params.error", new Object[]{"\u5206\u6790\u5730\u5757\u5750\u6807\u4e3a\u7a7a\uff01"}));
        }
        boolean useWcf = AppConfig.getBooleanProperty((String)"analysis.useWcf");
        if (useWcf) {
            String wcfUrl = AppConfig.getProperty((String)"wcfUrl");
            String wcfMethod = AppConfig.getProperty((String)"wcfMethod");
            if (StringUtils.isBlank((String)wcfUrl)) {
                throw new RuntimeException(this.getMessage("analysis.wcf.url.null", new Object[0]));
            }
            if (StringUtils.isBlank((String)wcfMethod)) {
                throw new RuntimeException(this.getMessage("analysis.wcf.method.null", new Object[0]));
            }
            this.logger.info("----\u542f\u7528webservice\u8fdb\u884c\u571f\u5730\u5229\u7528\u73b0\u72b6\u5206\u6790----");
            this.logger.info("[wcf\u5730\u5740:]" + wcfUrl);
            return this.tdlyxzAnalysisByWcf(dltbLayerName, xzdwLayerName, geometry, wcfUrl, wcfMethod);
        }
        HashMap<String, Double> dlMap = new HashMap<String, Double>();
        HashMap<String, Double> bhMap = new HashMap<String, Double>();
        MultiKeyMap analysisDetailMap = MultiKeyMap.decorate((AbstractHashedMap)new HashedMap());
        String[] columns = new String[]{"DLMC"};
        List xzdwDltbResult = new ArrayList();
        List dltbAnalysisResult = new ArrayList();
        List xzdwAnalysisResult = new ArrayList();
        try {
            dltbAnalysisResult = this.intersect3(dltbLayerName, geometry, "DLMC;ZLDWDM;TBBH;ZLDWMC;QSXZ;DLBM;TBMJ;QSDWDM;QSDWMC".split(";"), dataSource);
        }
        catch (Exception e) {
            this.logger.error("tdlyxzAnalysis dltb error [{}] ", (Object)e.getLocalizedMessage());
        }
        if (dltbAnalysisResult.size() > 0) {
            for (int i = 0; i < dltbAnalysisResult.size(); ++i) {
                Double tmpArea = Double.parseDouble(String.valueOf(((Map)dltbAnalysisResult.get(i)).get("SHAPE_AREA")));
                if (!(tmpArea > 0.4)) continue;
                if (dlMap.containsKey(((Map)dltbAnalysisResult.get(i)).get("DLMC"))) {
                    dlMap.put(String.valueOf(((Map)dltbAnalysisResult.get(i)).get("DLMC")), (Double)dlMap.get(((Map)dltbAnalysisResult.get(i)).get("DLMC")) + tmpArea);
                } else {
                    dlMap.put(String.valueOf(((Map)dltbAnalysisResult.get(i)).get("DLMC")), tmpArea);
                }
                bhMap.put(String.valueOf(((Map)dltbAnalysisResult.get(i)).get("ZLDWDM")) + String.valueOf(((Map)dltbAnalysisResult.get(i)).get("TBBH")), tmpArea);
                if (analysisDetailMap.containsKey((Object)String.valueOf(((Map)dltbAnalysisResult.get(i)).get("ZLDWDM")), (Object)String.valueOf(((Map)dltbAnalysisResult.get(i)).get("TBBH")))) {
                    detailValue = (Map)analysisDetailMap.get((Object)String.valueOf(((Map)dltbAnalysisResult.get(i)).get("ZLDWDM")), (Object)String.valueOf(((Map)dltbAnalysisResult.get(i)).get("TBBH")));
                    detailValue.put("CCMJ", (String)((Object)Double.valueOf(MapUtils.getDouble(detailValue, (Object)"CCMJ", (Double)0.0) + tmpArea)));
                    continue;
                }
                detailValue = new HashMap<String, String>();
                detailValue.put("ZLDWDM", String.valueOf(((Map)dltbAnalysisResult.get(i)).get("ZLDWDM")));
                detailValue.put("ZLDWMC", String.valueOf(((Map)dltbAnalysisResult.get(i)).get("ZLDWMC")));
                detailValue.put("TBBH", String.valueOf(((Map)dltbAnalysisResult.get(i)).get("TBBH")));
                detailValue.put("QSXZ", String.valueOf(((Map)dltbAnalysisResult.get(i)).get("QSXZ")));
                detailValue.put("DLMC", String.valueOf(((Map)dltbAnalysisResult.get(i)).get("DLMC")));
                detailValue.put("DLBM", String.valueOf(((Map)dltbAnalysisResult.get(i)).get("DLBM")));
                detailValue.put("TBMJ", String.valueOf(((Map)dltbAnalysisResult.get(i)).get("TBMJ")));
                detailValue.put("QSDWDM", String.valueOf(((Map)dltbAnalysisResult.get(i)).get("QSDWDM")));
                detailValue.put("QSDWMC", String.valueOf(((Map)dltbAnalysisResult.get(i)).get("QSDWMC")));
                detailValue.put("CCMJ", (String)((Object)tmpArea));
                analysisDetailMap.put((Object)String.valueOf(((Map)dltbAnalysisResult.get(i)).get("ZLDWDM")), (Object)String.valueOf(((Map)dltbAnalysisResult.get(i)).get("TBBH")), detailValue);
            }
        }
        try {
            xzdwAnalysisResult = this.intersect3(xzdwLayerName, geometry, "DLMC;KD;KCTBDWDM2;KCTBDWDM1;KCTBBH1;KCTBBH2;QSDWDM1;XZDWBH;QSXZ;DLBM;XZDWMJ;QSDWMC1".split(";"), dataSource);
        }
        catch (Exception e) {
            this.logger.error("tdlyxzAnalysis xzdw error [{}] ", (Object)e.getLocalizedMessage());
        }
        if (xzdwAnalysisResult.size() > 0) {
            for (int i = 0; i < xzdwAnalysisResult.size(); ++i) {
                HashMap<String, Double> detailValue2;
                Map<String, Double> detailValue3;
                Double tmpValue;
                String tmpDlmcKey;
                Double tmpLength = Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("SHAPE_AREA")));
                if (dlMap.containsKey(((Map)xzdwAnalysisResult.get(i)).get("DLMC"))) {
                    dlMap.put(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLMC")), (Double)dlMap.get(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLMC"))) + tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                } else {
                    dlMap.put(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLMC")), tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                }
                if (analysisDetailMap.containsKey((Object)(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")))) {
                    detailValue = (Map)analysisDetailMap.get((Object)(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")));
                    detailValue.put("CCMJ", (String)((Object)Double.valueOf(Double.valueOf(String.valueOf(detailValue.get("CCMJ"))) + tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))))));
                } else {
                    detailValue = new HashMap();
                    detailValue.put("ZLDWDM", String.valueOf(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))));
                    detailValue.put("ZLDWMC", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("")));
                    detailValue.put("TBBH", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")));
                    detailValue.put("QSXZ", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSXZ")));
                    detailValue.put("DLMC", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLMC")));
                    detailValue.put("DLBM", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLBM")));
                    detailValue.put("TBMJ", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWMJ")));
                    detailValue.put("QSDWDM1", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")));
                    detailValue.put("QSDWMC", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWMC1")));
                    detailValue.put("CCMJ", (String)((Object)Double.valueOf(tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))))));
                    analysisDetailMap.put((Object)(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")), detailValue);
                }
                if (StringUtils.isBlank((String)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2"))) || String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2")).equalsIgnoreCase("null")) {
                    String tmpWhereClause = "ZLDWDM='" + ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1") + "' and TBBH='" + ((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1") + "'";
                    try {
                        xzdwDltbResult = this.query(dltbLayerName, tmpWhereClause, columns, true, dataSource);
                    }
                    catch (Exception e) {
                        this.logger.error("tdlyxzAnalysis error [{}] ", (Object)e.getLocalizedMessage());
                    }
                    String tmpKey = String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1"));
                    if (xzdwDltbResult.size() <= 0 || !bhMap.containsKey(tmpKey)) continue;
                    for (int j = 0; j < xzdwDltbResult.size(); ++j) {
                        dlMap.put(String.valueOf(((Map)xzdwDltbResult.get(j)).get("DLMC")), (Double)dlMap.get(String.valueOf(((Map)xzdwDltbResult.get(j)).get("DLMC"))) - tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                        bhMap.put(tmpKey, (Double)bhMap.get(tmpKey) - tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                        if (analysisDetailMap.containsKey((Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1")), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")))) {
                            Map detailValue4 = (Map)analysisDetailMap.get((Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1")), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")));
                            detailValue4.put("CCMJ", Double.valueOf(String.valueOf(detailValue4.get("CCMJ"))) - tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                            continue;
                        }
                        this.logger.error(this.getMessage("analysis.tdlyxz.kc.error", new Object[]{"ERROR", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")), String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLBM")), String.valueOf(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2"), ((Map)xzdwAnalysisResult.get(i)).get("XZDWMJ"), tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD")))}));
                    }
                    continue;
                }
                String kouchuTag = "no";
                double kouchuMj = 0.0;
                String kouchuDlmc = "";
                String kouchuZldwdm = "";
                String kouchuTbbh = "";
                String tmpWhereClause = "ZLDWDM='" + ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1") + "' and TBBH='" + ((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1") + "'";
                try {
                    xzdwDltbResult = this.query(dltbLayerName, tmpWhereClause, columns, true, dataSource);
                }
                catch (Exception e) {
                    this.logger.error("tdlyxzAnalysis error [{}] ", (Object)e.getLocalizedMessage());
                }
                if (xzdwDltbResult.size() > 0) {
                    for (int j = 0; j < xzdwDltbResult.size(); ++j) {
                        tmpDlmcKey = String.valueOf(((Map)xzdwDltbResult.get(j)).get("DLMC"));
                        if (bhMap.containsKey(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")))) {
                            tmpValue = (Double)bhMap.get(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")));
                            if (tmpValue - tmpLength / 2.0 * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))) > 0.0) {
                                dlMap.put(tmpDlmcKey, (Double)dlMap.get(tmpDlmcKey) - tmpLength / 2.0 * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                                kouchuMj = tmpLength / 2.0 * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD")));
                                kouchuDlmc = tmpDlmcKey;
                                kouchuZldwdm = String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"));
                                kouchuTbbh = String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1"));
                                bhMap.put(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")), tmpValue - tmpLength / 2.0 * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                                detailValue3 = (Map)analysisDetailMap.get((Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1")), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")));
                                detailValue3.put("CCMJ", Double.valueOf(String.valueOf(detailValue3.get("CCMJ"))) - kouchuMj);
                                continue;
                            }
                            kouchuTag = "yes";
                            detailValue3 = new HashMap<String, Object>();
                            detailValue3.put("ZLDWDM", (Double)((Object)("error\u9762\u79ef\u8fc7\u5c0f" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1")))));
                            detailValue3.put("TBBH", (Double)((Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1"))));
                            detailValue3.put("TBMJ", tmpValue);
                            detailValue3.put("CCMJ", tmpLength / 2.0 * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                            analysisDetailMap.put((Object)("error\u9762\u79ef\u8fc7\u5c0f" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"))), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")), detailValue3);
                            continue;
                        }
                        kouchuTag = "yes";
                        this.logger.error(this.getMessage("analysis.tdlyxz.kc.error", new Object[]{"\u6ca1\u6709\u5360\u7528", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")), String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLBM")), String.valueOf(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2"), ((Map)xzdwAnalysisResult.get(i)).get("XZDWMJ"), tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD")))}));
                        detailValue2 = new HashMap<String, Double>();
                        detailValue2.put("ZLDWDM", (Double)((Object)("error\u6ca1\u6709\u5360\u7528" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1")))));
                        detailValue2.put("TBBH", (Double)((Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1"))));
                        analysisDetailMap.put((Object)("error\u6ca1\u6709\u5360\u7528" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"))), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")), detailValue2);
                    }
                    if (xzdwDltbResult.size() == 0) {
                        kouchuTag = "yes";
                        this.logger.error(this.getMessage("analysis.tdlyxz.kc.error", new Object[]{"\u6ca1\u6709\u627e\u5230", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")), String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLBM")), String.valueOf(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2"), ((Map)xzdwAnalysisResult.get(i)).get("XZDWMJ"), tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD")))}));
                        HashMap<String, String> detailValue5 = new HashMap<String, String>();
                        detailValue5.put("ZLDWDM", "error,\u6ca1\u6709\u627e\u5230" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1")));
                        detailValue5.put("TBBH", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")));
                        analysisDetailMap.put((Object)("error,\u6ca1\u6709\u627e\u5230" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"))), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")), detailValue5);
                    }
                } else {
                    kouchuTag = "yes";
                    this.logger.error(this.getMessage("analysis.tdlyxz.kc.error", new Object[]{"\u6ca1\u6709\u627e\u5230", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")), String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLBM")), String.valueOf(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2"), ((Map)xzdwAnalysisResult.get(i)).get("XZDWMJ"), tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD")))}));
                    HashMap<String, String> detailValue6 = new HashMap<String, String>();
                    detailValue6.put("ZLDWDM", "error,\u6ca1\u6709\u627e\u5230" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1")));
                    detailValue6.put("TBBH", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")));
                    analysisDetailMap.put((Object)("error,\u6ca1\u6709\u627e\u5230" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"))), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")), detailValue6);
                }
                tmpWhereClause = "ZLDWDM='" + ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2") + "' and TBBH='" + ((Map)xzdwAnalysisResult.get(i)).get("KCTBBH2") + "'";
                try {
                    xzdwDltbResult = this.query(dltbLayerName, tmpWhereClause, columns, true, dataSource);
                }
                catch (Exception e) {
                    this.logger.error("tdlyxzAnalysis error [{}] ", (Object)e.getLocalizedMessage());
                }
                if (xzdwDltbResult.size() <= 0) continue;
                for (int j = 0; j < xzdwDltbResult.size(); ++j) {
                    tmpDlmcKey = String.valueOf(((Map)xzdwDltbResult.get(j)).get("DLMC"));
                    if (bhMap.containsKey(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH2")))) {
                        tmpValue = (Double)bhMap.get(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH2")));
                        if (tmpValue - tmpLength / 2.0 * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))) > 0.0) {
                            if (!kouchuTag.equals("yes")) {
                                dlMap.put(tmpDlmcKey, (Double)dlMap.get(tmpDlmcKey) - tmpLength / 2.0 * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                                detailValue3 = (Map)analysisDetailMap.get((Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2")), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH2")));
                                detailValue3.put("CCMJ", Double.valueOf(String.valueOf(detailValue3.get("CCMJ"))) - tmpLength / 2.0 * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                                bhMap.put(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH2")), tmpValue - tmpLength / 2.0 * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                                continue;
                            }
                            dlMap.put(tmpDlmcKey, (Double)dlMap.get(tmpDlmcKey) - tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                            bhMap.put(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH2")), tmpValue - tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                            detailValue3 = (Map)analysisDetailMap.get((Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2")), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH2")));
                            detailValue3.put("CCMJ", Double.valueOf(String.valueOf(detailValue3.get("CCMJ"))) - tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                            continue;
                        }
                        try {
                            tmpDlmcKey = kouchuDlmc;
                            dlMap.put(tmpDlmcKey, (Double)dlMap.get(tmpDlmcKey) - kouchuMj);
                        }
                        catch (Exception ex) {
                            throw new RuntimeException(this.getMessage("analysis.tdlyxz.kc.error", new Object[]{"\u9762\u79ef\u6263\u9664\u9519\u8bef\uff0c\u51fa\u73b0\u65e0\u6cd5\u6263\u9664\u60c5\u51b5\uff0c\u8bf7\u68c0\u67e5\uff0c\u8bf7\u7528\u5b9e\u5730\u52d8\u6d4b\u5750\u6807\u53e0\u52a0\u5230\u56fe\u5f62\u4e0a\uff01!", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")), String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLBM")), String.valueOf(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2"), ((Map)xzdwAnalysisResult.get(i)).get("XZDWMJ"), tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD")))}));
                        }
                        bhMap.put(kouchuZldwdm + kouchuTbbh, (Double)bhMap.get(kouchuZldwdm + kouchuTbbh) - kouchuMj);
                        detailValue3 = (Map)analysisDetailMap.get((Object)kouchuZldwdm, (Object)kouchuTbbh);
                        detailValue3.put("CCMJ", Double.valueOf(String.valueOf(detailValue3.get("CCMJ"))) - kouchuMj);
                        HashMap<String, Object> detailValue1 = new HashMap<String, Object>();
                        detailValue1.put("ZLDWDM", "error\u9762\u79ef\u8fc7\u5c0f" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2")));
                        detailValue1.put("TBBH", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH2")));
                        detailValue1.put("TBMJ", tmpValue);
                        detailValue1.put("CCMJ", tmpLength / 2.0 * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                        analysisDetailMap.put((Object)("error\u9762\u79ef\u8fc7\u5c0f" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2"))), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH2")), detailValue1);
                        continue;
                    }
                    try {
                        tmpDlmcKey = kouchuDlmc;
                        dlMap.put(tmpDlmcKey, (Double)dlMap.get(tmpDlmcKey) - kouchuMj);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(this.getMessage("analysis.tdlyxz.kc.error", new Object[]{"\u571f\u5730\u5229\u7528\u73b0\u72b6\u5e95\u56fe\u4e2d\u73b0\u72b6\u5730\u7269\u6263\u9664\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5!", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")), String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLBM")), String.valueOf(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2"), ((Map)xzdwAnalysisResult.get(i)).get("XZDWMJ"), tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD")))}));
                    }
                    bhMap.put(kouchuZldwdm + kouchuTbbh, (Double)bhMap.get(kouchuZldwdm + kouchuTbbh) - kouchuMj);
                    detailValue2 = (HashMap<String, Double>)analysisDetailMap.get((Object)kouchuZldwdm, (Object)kouchuTbbh);
                    detailValue2.put("CCMJ", Double.valueOf(String.valueOf(detailValue2.get("CCMJ"))) - kouchuMj);
                    this.logger.error(this.getMessage("analysis.tdlyxz.kc.error", new Object[]{"\u6ca1\u6709\u5360\u7528", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")), String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLBM")), String.valueOf(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2"), ((Map)xzdwAnalysisResult.get(i)).get("XZDWMJ"), tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD")))}));
                    HashMap<String, String> detailValue1 = new HashMap<String, String>();
                    detailValue1.put("ZLDWDM", "error\u6ca1\u6709\u5360\u7528" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2")));
                    detailValue1.put("TBBH", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH2")));
                    analysisDetailMap.put((Object)("error\u6ca1\u6709\u5360\u7528" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2"))), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH2")), detailValue1);
                }
            }
        }
        HashMap<String, Cloneable> resultMap = new HashMap<String, Cloneable>();
        resultMap.put("analysisArea", dlMap);
        ArrayList<Object> resultDetailList = new ArrayList<Object>();
        for (Object tmpKey : analysisDetailMap.keySet()) {
            resultDetailList.add(analysisDetailMap.get(tmpKey));
        }
        resultMap.put("analysisAreaDetail", resultDetailList);
        return resultMap;
    }

    public List<?> tdghscAnalysis(String layerType, String regionCode, String geometry, String[] outFields, String dataSource) {
        if (StringUtils.isBlank((String)layerType)) {
            throw new RuntimeException(this.getMessage("layer.type.notnull", new Object[0]));
        }
        String layerName = layerType.concat("_E_").concat(Utils.formatRegionCode((String)regionCode));
        return this.intersect3(layerName, geometry, outFields, dataSource);
    }

    public Map tdghscAnalysis(String regionCode, String geometry, String[] outFields, String dataSource) {
        HashMap<String, List> result = new HashMap<String, List>();
        for (GHSC item : GHSC.values()) {
            result.put(GHSC.access$000((GHSC)item), this.tdghscAnalysis(item.name(), regionCode, geometry, outFields, dataSource));
        }
        return result;
    }

    public String tdghscAnalysis2(String layerType, String regionCode, String geometry, String[] outFields, String dataSource) {
        List result = this.tdghscAnalysis(layerType, regionCode, geometry, outFields, dataSource);
        FeatureCollection collection = this.geometryService.list2FeatureCollection(result, null, null);
        return this.geometryService.toFeatureJSON((Object)collection);
    }

    public Map tdghscAnalysis2(String regionCode, String geometry, String[] outFields, String dataSource) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (GHSC item : GHSC.values()) {
            result.put(GHSC.access$000((GHSC)item), this.tdghscAnalysis2(item.name(), regionCode, geometry, outFields, dataSource));
        }
        return result;
    }

    public Map tdghscResult(Map analysisResult) {
        HashMap resultMap = new HashMap();
        try {
            for (GHSC item : GHSC.values()) {
                ArrayList list = new ArrayList();
                HashMap<String, Object> total = new HashMap<String, Object>();
                HashMap ghMap = new HashMap();
                double totalArea = 0.0;
                JSONObject singleObj = JSON.parseObject((String)analysisResult.get(GHSC.access$000((GHSC)item)).toString());
                JSONArray features = JSON.parseArray((String)singleObj.get((Object)"features").toString());
                totalArea = this.getTotalArea(features);
                total.put("LXMC", "\u5730\u5757\u603b\u9762\u79ef");
                total.put("AREA", totalArea);
                list.add(total);
                switch (item.ordinal()) {
                    case 0: {
                        Map properties;
                        JSONObject feature;
                        LinkedHashMap<String, String> detailMap;
                        int i;
                        HashMap<String, Object> temp;
                        double per;
                        double area;
                        ArrayList detail;
                        for (EnumUtils.TDYTQ tDYTQ : EnumUtils.TDYTQ.values()) {
                            detail = new ArrayList();
                            area = this.getAreaByLxdm("TDYTQLXDM", features, tDYTQ.getLxdm());
                            per = 0.0;
                            if (totalArea > 0.0) {
                                per = area / totalArea * 100.0;
                            }
                            temp = new HashMap<String, Object>();
                            temp.put("LXMC", tDYTQ.name());
                            temp.put("AREA", area);
                            temp.put("PER", per);
                            for (i = 0; i < features.size(); ++i) {
                                detailMap = new LinkedHashMap<String, String>();
                                feature = (JSONObject)features.get(i);
                                properties = (Map)feature.get((Object)"properties");
                                if (!tDYTQ.getLxdm().equals(properties.get("TDYTQLXDM"))) continue;
                                detailMap.put("\u7c7b\u578b\u540d\u79f0", tDYTQ.name());
                                detailMap.put("\u7c7b\u578b\u4ee3\u7801", (String)properties.get("TDYTQLXDM"));
                                detailMap.put("\u5730\u5757\u9762\u79ef", (String)properties.get("OG_SHAPE_AREA"));
                                detailMap.put("\u6807\u8bc6\u7801", (String)properties.get("BSM"));
                                detailMap.put("\u9762\u79ef", (String)properties.get("SHAPE_AREA"));
                                detail.add(detailMap);
                            }
                            temp.put("detail", detail);
                            list.add(temp);
                            this.logger.info(tDYTQ.name() + area);
                        }
                        break;
                    }
                    case 1: {
                        Map properties;
                        JSONObject feature;
                        LinkedHashMap<String, String> detailMap;
                        int i;
                        HashMap<String, Object> temp;
                        double per;
                        double area;
                        ArrayList detail;
                        for (EnumUtils.TDYTQ tDYTQ : EnumUtils.JSYDGZQ.values()) {
                            detail = new ArrayList();
                            area = this.getAreaByLxdm("GZQLXDM", features, tDYTQ.getLxdm());
                            per = 0.0;
                            if (totalArea > 0.0) {
                                per = area / totalArea * 100.0;
                            }
                            temp = new HashMap();
                            temp.put("LXMC", tDYTQ.name());
                            temp.put("AREA", area);
                            temp.put("PER", per);
                            for (i = 0; i < features.size(); ++i) {
                                detailMap = new LinkedHashMap();
                                feature = (JSONObject)features.get(i);
                                properties = (Map)feature.get((Object)"properties");
                                if (!tDYTQ.getLxdm().equals(properties.get("GZQLXDM"))) continue;
                                detailMap.put("\u7c7b\u578b\u540d\u79f0", tDYTQ.name());
                                detailMap.put("\u7c7b\u578b\u4ee3\u7801", (String)properties.get("GZQLXDM"));
                                detailMap.put("\u5730\u5757\u9762\u79ef", (String)properties.get("OG_SHAPE_AREA"));
                                detailMap.put("\u6807\u8bc6\u7801", (String)properties.get("BSM"));
                                detailMap.put("\u9762\u79ef", (String)properties.get("SHAPE_AREA"));
                                detail.add(detailMap);
                            }
                            temp.put("detail", detail);
                            list.add(temp);
                            this.logger.info(tDYTQ.name() + area);
                        }
                        break;
                    }
                    case 2: {
                        Map properties;
                        JSONObject feature;
                        LinkedHashMap<String, String> detailMap;
                        int i;
                        HashMap<String, Object> temp;
                        double per;
                        double area;
                        ArrayList detail;
                        for (EnumUtils.TDYTQ tDYTQ : EnumUtils.GHJBNTTZ.values()) {
                            detail = new ArrayList();
                            area = this.getAreaByLxdm("TZLXDM", features, tDYTQ.getLxdm());
                            per = 0.0;
                            if (totalArea > 0.0) {
                                per = area / totalArea * 100.0;
                            }
                            temp = new HashMap();
                            temp.put("LXMC", tDYTQ.name());
                            temp.put("AREA", area);
                            temp.put("PER", per);
                            for (i = 0; i < features.size(); ++i) {
                                detailMap = new LinkedHashMap();
                                feature = (JSONObject)features.get(i);
                                properties = (Map)feature.get((Object)"properties");
                                if (!tDYTQ.getLxdm().equals(properties.get("TZLXDM"))) continue;
                                detailMap.put("\u7c7b\u578b\u540d\u79f0", tDYTQ.name());
                                detailMap.put("\u7c7b\u578b\u4ee3\u7801", (String)properties.get("TZLXDM"));
                                detailMap.put("\u5730\u5757\u9762\u79ef", (String)properties.get("OG_SHAPE_AREA"));
                                detailMap.put("\u6807\u8bc6\u7801", (String)properties.get("BSM"));
                                detailMap.put("\u9762\u79ef", (String)properties.get("SHAPE_AREA"));
                                detail.add(detailMap);
                            }
                            temp.put("detail", detail);
                            list.add(temp);
                            this.logger.info(tDYTQ.name());
                        }
                        break;
                    }
                    case 3: {
                        Map properties;
                        JSONObject feature;
                        LinkedHashMap<String, String> detailMap;
                        int i;
                        HashMap<String, Object> temp;
                        double per;
                        double area;
                        ArrayList detail;
                        for (EnumUtils.TDYTQ tDYTQ : EnumUtils.MZZDJSXM.values()) {
                            detail = new ArrayList();
                            area = this.getAreaByLxdm("XMLXDM", features, tDYTQ.getLxdm());
                            per = 0.0;
                            if (totalArea > 0.0) {
                                per = area / totalArea * 100.0;
                            }
                            temp = new HashMap();
                            temp.put("LXMC", tDYTQ.name());
                            temp.put("AREA", area);
                            temp.put("PER", per);
                            for (i = 0; i < features.size(); ++i) {
                                detailMap = new LinkedHashMap();
                                feature = (JSONObject)features.get(i);
                                properties = (Map)feature.get((Object)"properties");
                                if (!tDYTQ.getLxdm().equals(properties.get("XMLXDM"))) continue;
                                detailMap.put("\u7c7b\u578b\u540d\u79f0", tDYTQ.name());
                                detailMap.put("\u7c7b\u578b\u4ee3\u7801", (String)properties.get("XMLXDM"));
                                detailMap.put("\u5730\u5757\u9762\u79ef", (String)properties.get("OG_SHAPE_AREA"));
                                detailMap.put("\u6807\u8bc6\u7801", (String)properties.get("BSM"));
                                detailMap.put("\u9762\u79ef", (String)properties.get("SHAPE_AREA"));
                                detail.add(detailMap);
                            }
                            temp.put("detail", detail);
                            list.add(temp);
                            this.logger.info(tDYTQ.getLxdm());
                        }
                        break;
                    }
                }
                ghMap.put("info", list);
                resultMap.put(GHSC.access$000((GHSC)item), ghMap);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return resultMap;
    }

    public Map tdghscResult(String layerType, String analysisResult) {
        HashMap resultMap = new HashMap();
        try {
            JSONObject fc = JSON.parseObject((String)analysisResult);
            JSONArray features = (JSONArray)fc.get((Object)"features");
            ArrayList list = new ArrayList();
            HashMap<String, Object> total = new HashMap<String, Object>();
            HashMap ghMap = new HashMap();
            double totalArea = 0.0;
            totalArea = this.getTotalArea(features);
            total.put("LXMC", "\u5730\u5757\u603b\u9762\u79ef");
            total.put("AREA", totalArea);
            list.add(total);
            for (GHSC item : GHSC.values()) {
                if (!item.name().equals(layerType)) continue;
                switch (item.ordinal()) {
                    case 0: {
                        Map properties;
                        JSONObject feature;
                        HashMap<String, String> detailMap;
                        int i;
                        HashMap<String, Object> temp;
                        double per;
                        double area;
                        ArrayList detail;
                        for (EnumUtils.TDYTQ tDYTQ : EnumUtils.TDYTQ.values()) {
                            detail = new ArrayList();
                            area = this.getAreaByLxdm("TDYTQLXDM", features, tDYTQ.getLxdm());
                            per = 0.0;
                            if (totalArea > 0.0) {
                                per = area / totalArea * 100.0;
                            }
                            temp = new HashMap<String, Object>();
                            temp.put("LXMC", tDYTQ.name());
                            temp.put("AREA", area);
                            temp.put("PER", per);
                            for (i = 0; i < features.size(); ++i) {
                                detailMap = new HashMap<String, String>();
                                feature = (JSONObject)features.get(i);
                                properties = (Map)feature.get((Object)"properties");
                                if (!tDYTQ.getLxdm().equals(properties.get("TDYTQLXDM"))) continue;
                                detailMap.put("\u7c7b\u578b\u540d\u79f0", tDYTQ.name());
                                detailMap.put("\u7c7b\u578b\u4ee3\u7801", (String)properties.get("TDYTQLXDM"));
                                detailMap.put("\u5730\u5757\u9762\u79ef", (String)properties.get("OG_SHAPE_AREA"));
                                detailMap.put("\u6807\u8bc6\u7801", (String)properties.get("BSM"));
                                detailMap.put("\u9762\u79ef", (String)properties.get("SHAPE_AREA"));
                                detail.add(detailMap);
                            }
                            temp.put("detail", detail);
                            list.add(temp);
                            this.logger.info(tDYTQ.name() + area);
                        }
                        break;
                    }
                    case 1: {
                        Map properties;
                        JSONObject feature;
                        HashMap<String, String> detailMap;
                        int i;
                        HashMap<String, Object> temp;
                        double per;
                        double area;
                        ArrayList detail;
                        for (EnumUtils.TDYTQ tDYTQ : EnumUtils.JSYDGZQ.values()) {
                            detail = new ArrayList();
                            area = this.getAreaByLxdm("GZQLXDM", features, tDYTQ.getLxdm());
                            per = 0.0;
                            if (totalArea > 0.0) {
                                per = area / totalArea * 100.0;
                            }
                            temp = new HashMap();
                            temp.put("LXMC", tDYTQ.name());
                            temp.put("AREA", area);
                            temp.put("PER", per);
                            for (i = 0; i < features.size(); ++i) {
                                detailMap = new LinkedHashMap();
                                feature = (JSONObject)features.get(i);
                                properties = (Map)feature.get((Object)"properties");
                                if (!tDYTQ.getLxdm().equals(properties.get("GZQLXDM"))) continue;
                                detailMap.put("\u7c7b\u578b\u540d\u79f0", tDYTQ.name());
                                detailMap.put("\u7c7b\u578b\u4ee3\u7801", (String)properties.get("GZQLXDM"));
                                detailMap.put("\u5730\u5757\u9762\u79ef", (String)properties.get("OG_SHAPE_AREA"));
                                detailMap.put("\u6807\u8bc6\u7801", (String)properties.get("BSM"));
                                detailMap.put("\u9762\u79ef", (String)properties.get("SHAPE_AREA"));
                                detail.add(detailMap);
                            }
                            temp.put("detail", detail);
                            list.add(temp);
                            this.logger.info(tDYTQ.name() + area);
                        }
                        break;
                    }
                    case 2: {
                        Map properties;
                        JSONObject feature;
                        HashMap<String, String> detailMap;
                        int i;
                        HashMap<String, Object> temp;
                        double per;
                        double area;
                        ArrayList detail;
                        for (EnumUtils.TDYTQ tDYTQ : EnumUtils.GHJBNTTZ.values()) {
                            detail = new ArrayList();
                            area = this.getAreaByLxdm("TZLXDM", features, tDYTQ.getLxdm());
                            per = 0.0;
                            if (totalArea > 0.0) {
                                per = area / totalArea * 100.0;
                            }
                            temp = new HashMap();
                            temp.put("LXMC", tDYTQ.name());
                            temp.put("AREA", area);
                            temp.put("PER", per);
                            for (i = 0; i < features.size(); ++i) {
                                detailMap = new LinkedHashMap();
                                feature = (JSONObject)features.get(i);
                                properties = (Map)feature.get((Object)"properties");
                                if (!tDYTQ.getLxdm().equals(properties.get("TZLXDM"))) continue;
                                detailMap.put("\u7c7b\u578b\u540d\u79f0", tDYTQ.name());
                                detailMap.put("\u7c7b\u578b\u4ee3\u7801", (String)properties.get("TZLXDM"));
                                detailMap.put("\u5730\u5757\u9762\u79ef", (String)properties.get("OG_SHAPE_AREA"));
                                detailMap.put("\u6807\u8bc6\u7801", (String)properties.get("BSM"));
                                detailMap.put("\u9762\u79ef", (String)properties.get("SHAPE_AREA"));
                                detail.add(detailMap);
                            }
                            temp.put("detail", detail);
                            list.add(temp);
                            this.logger.info(tDYTQ.name());
                        }
                        break;
                    }
                    case 3: {
                        Map properties;
                        JSONObject feature;
                        HashMap<String, String> detailMap;
                        int i;
                        HashMap<String, Object> temp;
                        double per;
                        double area;
                        ArrayList detail;
                        for (EnumUtils.TDYTQ tDYTQ : EnumUtils.MZZDJSXM.values()) {
                            detail = new ArrayList();
                            area = this.getAreaByLxdm("XMLXDM", features, tDYTQ.getLxdm());
                            per = 0.0;
                            if (totalArea > 0.0) {
                                per = area / totalArea * 100.0;
                            }
                            temp = new HashMap();
                            temp.put("LXMC", tDYTQ.name());
                            temp.put("AREA", area);
                            temp.put("PER", per);
                            for (i = 0; i < features.size(); ++i) {
                                detailMap = new LinkedHashMap();
                                feature = (JSONObject)features.get(i);
                                properties = (Map)feature.get((Object)"properties");
                                if (!tDYTQ.getLxdm().equals(properties.get("XMLXDM"))) continue;
                                detailMap.put("\u7c7b\u578b\u540d\u79f0", tDYTQ.name());
                                detailMap.put("\u7c7b\u578b\u4ee3\u7801", (String)properties.get("XMLXDM"));
                                detailMap.put("\u5730\u5757\u9762\u79ef", (String)properties.get("OG_SHAPE_AREA"));
                                detailMap.put("\u6807\u8bc6\u7801", (String)properties.get("BSM"));
                                detailMap.put("\u9762\u79ef", (String)properties.get("SHAPE_AREA"));
                                detail.add(detailMap);
                            }
                            temp.put("detail", detail);
                            list.add(temp);
                            this.logger.info(tDYTQ.getLxdm());
                        }
                        break;
                    }
                }
                ghMap.put("info", list);
                resultMap.put(GHSC.access$000((GHSC)item), ghMap);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return resultMap;
    }

    public LinkedHashMap tdghscExcelData(Map result) {
        LinkedHashMap map = new LinkedHashMap();
        for (Object key : result.keySet()) {
            ArrayList list = new ArrayList();
            List keyList = (List)((Map)result.get(key)).get("info");
            for (int i = 1; i < keyList.size(); ++i) {
                Map temp = (Map)keyList.get(i);
                ArrayList<Object> tempList = new ArrayList<Object>();
                tempList.add(temp.get("LXMC"));
                tempList.add(Math.round(Double.valueOf(temp.get("AREA").toString())));
                list.add(tempList);
            }
            map.put(key, list);
        }
        return map;
    }

    public List<Map> tdlyxzResult(Map analysisResult, String tpl) {
        ArrayList<Map> resultList = new ArrayList<Map>();
        try {
            List detailList = (List)analysisResult.get("analysisAreaDetail");
            ArrayList dwdmList = new ArrayList();
            for (int i = 0; i < detailList.size(); ++i) {
                HashMap<String, Object> temp = new HashMap<String, Object>();
                ArrayList<Map> list = new ArrayList<Map>();
                boolean tag = false;
                Map map = (Map)detailList.get(i);
                String xzqmc = null;
                if (!map.containsKey("QSDWMC")) continue;
                xzqmc = MapUtils.getString((Map)map, (Object)"QSDWMC");
                list.add(map);
                temp.put("xzqmc", xzqmc);
                temp.put("qsxz", MapUtils.getString((Map)map, (Object)"QSXZ"));
                temp.put("detail", list);
                if (dwdmList.size() > 0) {
                    for (Map map2 : dwdmList) {
                        if (this.isNull((Object)xzqmc) || !xzqmc.equals(MapUtils.getString((Map)map2, (Object)"xzqmc"))) continue;
                        List tempList = (List)map2.get("detail");
                        tempList.addAll((List)temp.get("detail"));
                        tag = true;
                        break;
                    }
                }
                if (tag) continue;
                dwdmList.add(temp);
            }
            List groupList = this.getTdlyxzDictList(tpl);
            for (int j = 0; j < dwdmList.size(); ++j) {
                Map dwMap = (Map)dwdmList.get(j);
                List detailMaps = (List)dwMap.get("detail");
                ArrayList categoryA = new ArrayList();
                for (Map item : groupList) {
                    HashMap hashMap = new HashMap();
                    hashMap.put("dlmc", item.get("dlmc"));
                    hashMap.put("dlbm", item.get("dlbm"));
                    hashMap.put("detail", new ArrayList());
                    hashMap.put("area", 0);
                    for (Map detailMap : detailMaps) {
                        String dlbm = detailMap.get("DLBM").toString();
                        double ccmj = Double.valueOf(detailMap.get("CCMJ").toString());
                        if (!item.get("dlbm").toString().equals(dlbm.substring(0, 2))) continue;
                        hashMap.put("area", MapUtils.getDouble(hashMap, (Object)"area", (Double)0.0) + ccmj);
                        this.add2List((List)hashMap.get("detail"), detailMap);
                    }
                    categoryA.add(hashMap);
                }
                HashMap<String, Object> temp = new HashMap<String, Object>();
                temp.put("xzqmc", String.valueOf(dwMap.get("xzqmc")));
                temp.put("qsxz", String.valueOf(dwMap.get("qsxz")));
                temp.put("area", this.getSumArea(categoryA));
                temp.put("categoryA", categoryA);
                temp.put("categoryB", this.getCategoryB(categoryA));
                resultList.add(temp);
            }
            HashMap<String, Object> totalMap = new HashMap<String, Object>();
            totalMap.put("xzqmc", "\u5408\u8ba1");
            totalMap.put("area", this.getSumArea(resultList));
            totalMap.put("categoryA", this.getSumCategoryA(resultList));
            totalMap.put("categoryB", this.getSumCategoryB(resultList));
            resultList.add(totalMap);
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return resultList;
    }

    public List<Map> getSumCategoryA(List<Map> list) {
        assert (list != null);
        ArrayList result = null;
        if (list.size() > 0) {
            result = new ArrayList();
            List firstList = (List)list.get(0).get("categoryA");
            for (Map map : firstList) {
                HashMap temp = new HashMap();
                temp.put("dlbm", map.get("dlbm"));
                temp.put("dlmc", map.get("dlmc"));
                temp.put("area", 0);
                for (Map item : list) {
                    List groupList = (List)item.get("categoryA");
                    for (Map groupMap : groupList) {
                        if (!temp.get("dlbm").equals(groupMap.get("dlbm"))) continue;
                        temp.put("area", MapUtils.getDouble(temp, (Object)"area", (Double)0.0) + MapUtils.getDouble((Map)groupMap, (Object)"area", (Double)0.0));
                    }
                }
                result.add(temp);
            }
        }
        return result;
    }

    public Map getSumCategoryB(List<Map> list) {
        assert (list != null);
        HashMap result = null;
        if (list.size() > 0) {
            result = new HashMap();
            for (Map item : list) {
                Map categoryB = (Map)item.get("categoryB");
                for (Object key : categoryB.keySet()) {
                    result.put(key, MapUtils.getDouble(result, key, (Double)0.0) + MapUtils.getDouble((Map)categoryB, key, (Double)0.0));
                }
            }
        }
        return result;
    }

    public double getXzAreaByKey(List<Map> list, String key) {
        assert (key != null);
        double area = 0.0;
        for (Map map : list) {
            if (!map.containsKey(key)) continue;
            area += MapUtils.getDouble((Map)map, (Object)key, (Double)0.0).doubleValue();
        }
        return area;
    }

    public double getXzAreaByField(List<Map> list, String field, String value, double conv) {
        if (this.isNull((Object)conv)) {
            conv = 1.0;
        }
        assert (field != null);
        assert (value != null);
        double area = 0.0;
        List<String> values = Arrays.asList(value.split(","));
        for (Map map : list) {
            if (!values.contains(map.get(field))) continue;
            area += ((Double)map.get("area")).doubleValue();
        }
        return area * conv;
    }

    public LinkedHashMap tdlyxzExcelData(List<Map> result) {
        LinkedHashMap map = new LinkedHashMap();
        DecimalFormat df = new DecimalFormat("0.00");
        if (result.size() > 0) {
            ArrayList list1 = new ArrayList();
            ArrayList list2 = new ArrayList();
            map.put("\u4e00\u7ea7\u5206\u7c7b", list1);
            map.put("\u4e8c\u7ea7\u5206\u7c7b", list2);
            for (Map item : result) {
                ArrayList<Object> temp1 = new ArrayList<Object>();
                ArrayList<Object> temp2 = new ArrayList<Object>();
                temp1.add(item.get("xzqmc"));
                temp1.add(df.format(MapUtils.getDouble((Map)item, (Object)"area", (Double)0.0)));
                temp2.add(item.get("xzqmc"));
                temp2.add(df.format(MapUtils.getDouble((Map)item, (Object)"area", (Double)0.0)));
                List categoryA = (List)item.get("categoryA");
                Map categoryB = (Map)item.get("categoryB");
                for (Map cMap : categoryA) {
                    temp1.add(df.format(MapUtils.getDouble((Map)cMap, (Object)"area", (Double)0.0)));
                }
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"01", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"011", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"012", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"013", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"02", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"021", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"022", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"023", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"03", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"031", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"032", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"033", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"04", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"041", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"042", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"043", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"20", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"201", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"202", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"203", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"204", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"205", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"10", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"101", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"102", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"104", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"105", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"106", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"107", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"11", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"111", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"112", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"113", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"114", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"115", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"116", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"117", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"118", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"119", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"12", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"122", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"123", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"124", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"125", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"126", (Double)0.0)));
                temp2.add(df.format(MapUtils.getDouble((Map)categoryB, (Object)"127", (Double)0.0)));
                list1.add(temp1);
                list2.add(temp2);
            }
        }
        return map;
    }

    public List<LinkedHashMap> analysisExcelData(List list) {
        ArrayList<LinkedHashMap> result = new ArrayList<LinkedHashMap>();
        for (int i = 0; i < list.size(); ++i) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            ArrayList<Object> headerList = new ArrayList<Object>();
            ArrayList dataList = new ArrayList();
            JSONObject obj = (JSONObject)list.get(i);
            JSONArray children = (JSONArray)obj.get((Object)"children");
            for (int j = 0; j < children.size(); ++j) {
                JSONArray child = (JSONArray)children.get(j);
                ArrayList<Object> temp = new ArrayList<Object>();
                for (int m = 0; m < child.size(); ++m) {
                    JSONObject field = (JSONObject)child.get(m);
                    if (j == 0) {
                        headerList.add(field.get((Object)"alias"));
                    }
                    if (field.get((Object)"value") instanceof BigDecimal) {
                        temp.add(this.processValue(Double.valueOf(((BigDecimal)field.get((Object)"value")).doubleValue()), 3));
                        continue;
                    }
                    temp.add(field.get((Object)"value"));
                }
                dataList.add(temp);
            }
            map.put("name", obj.get((Object)"alias"));
            map.put("header", headerList);
            map.put("data", dataList);
            result.add(map);
        }
        return result;
    }

    public List<Map> gzqydExcelData(List list) {
        try {
            ArrayList<Map> result = new ArrayList<Map>();
            for (int i = 0; i < list.size(); ++i) {
                HashMap<String, Object> tempMap = new HashMap<String, Object>();
                ArrayList tempList = new ArrayList();
                Map item = (Map)list.get(0);
                List values = (List)item.get("value");
                for (Map value : values) {
                    ArrayList<Object> temp = new ArrayList<Object>(8);
                    temp.add(0, String.valueOf(value.get("OG_PRO_XZQMC")));
                    temp.add(1, String.valueOf(value.get("OG_PRO_REGIONCODE")));
                    temp.add(2, String.valueOf(value.get("OG_PRO_PRONAME")));
                    temp.add(3, Double.valueOf(String.valueOf(value.get("011"))));
                    temp.add(3, Double.valueOf(String.valueOf(value.get("012"))));
                    temp.add(3, Double.valueOf(String.valueOf(value.get("020"))));
                    temp.add(3, Double.valueOf(String.valueOf(value.get("030"))));
                    temp.add(3, Double.valueOf(String.valueOf(value.get("040"))));
                    tempList.add(temp);
                }
                tempMap.put("value", tempList);
                tempMap.put("type", (String)item.get("type"));
                result.add(tempMap);
            }
            return result;
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public Map<String, Object> dtExcelData(Map<String, Object> data) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.isNull(data)) {
            return null;
        }
        try {
            for (String key : data.keySet()) {
                Map map = (Map)data.get(key);
                if (this.isNull((Object)map)) {
                    return result;
                }
                List info = new ArrayList();
                List detail = new ArrayList();
                HashMap sheet = new HashMap();
                if (key.equals("xz")) {
                    if (!this.isNull(map.get("detail"))) {
                        detail = (List)map.get("detail");
                        ArrayList xzList = new ArrayList();
                        for (Map xzMap : detail) {
                            ArrayList<String> xzTmpList = new ArrayList<String>();
                            xzTmpList.add(this.isNull(xzMap.get("qsmc")) ? "" : xzMap.get("qsmc"));
                            xzTmpList.add(this.isNull(xzMap.get("nydZmj")) ? "" : xzMap.get("nydZmj"));
                            xzTmpList.add(this.isNull(xzMap.get("gdMj")) ? "" : xzMap.get("gdMj"));
                            xzTmpList.add(this.isNull(xzMap.get("011")) ? "" : xzMap.get("011"));
                            xzTmpList.add(this.isNull(xzMap.get("012")) ? "" : xzMap.get("012"));
                            xzTmpList.add(this.isNull(xzMap.get("013")) ? "" : xzMap.get("013"));
                            xzTmpList.add(this.isNull(xzMap.get("021")) ? "" : xzMap.get("021"));
                            xzTmpList.add(this.isNull(xzMap.get("022")) ? "" : xzMap.get("022"));
                            xzTmpList.add(this.isNull(xzMap.get("023")) ? "" : xzMap.get("023"));
                            xzTmpList.add(this.isNull(xzMap.get("031")) ? "" : xzMap.get("031"));
                            xzTmpList.add(this.isNull(xzMap.get("032")) ? "" : xzMap.get("032"));
                            xzTmpList.add(this.isNull(xzMap.get("033")) ? "" : xzMap.get("033"));
                            xzTmpList.add(this.isNull(xzMap.get("041")) ? "" : xzMap.get("041"));
                            xzTmpList.add(this.isNull(xzMap.get("042")) ? "" : xzMap.get("042"));
                            xzTmpList.add(this.isNull(xzMap.get("122")) ? "" : xzMap.get("122"));
                            xzTmpList.add(this.isNull(xzMap.get("104")) ? "" : xzMap.get("104"));
                            xzTmpList.add(this.isNull(xzMap.get("114")) ? "" : xzMap.get("114"));
                            xzTmpList.add(this.isNull(xzMap.get("117")) ? "" : xzMap.get("117"));
                            xzTmpList.add(this.isNull(xzMap.get("123")) ? "" : xzMap.get("123"));
                            xzTmpList.add(this.isNull(xzMap.get("jsydZmj")) ? "" : xzMap.get("jsydZmj"));
                            xzTmpList.add(this.isNull(xzMap.get("201")) ? "" : xzMap.get("123"));
                            xzTmpList.add(this.isNull(xzMap.get("202")) ? "" : xzMap.get("202"));
                            xzTmpList.add(this.isNull(xzMap.get("203")) ? "" : xzMap.get("203"));
                            xzTmpList.add(this.isNull(xzMap.get("204")) ? "" : xzMap.get("204"));
                            xzTmpList.add(this.isNull(xzMap.get("205")) ? "" : xzMap.get("205"));
                            xzTmpList.add(this.isNull(xzMap.get("101")) ? "" : xzMap.get("101"));
                            xzTmpList.add(this.isNull(xzMap.get("102")) ? "" : xzMap.get("102"));
                            xzTmpList.add(this.isNull(xzMap.get("105")) ? "" : xzMap.get("105"));
                            xzTmpList.add(this.isNull(xzMap.get("106")) ? "" : xzMap.get("106"));
                            xzTmpList.add(this.isNull(xzMap.get("107")) ? "" : xzMap.get("107"));
                            xzTmpList.add(this.isNull(xzMap.get("113")) ? "" : xzMap.get("113"));
                            xzTmpList.add(this.isNull(xzMap.get("118")) ? "" : xzMap.get("118"));
                            xzTmpList.add(this.isNull(xzMap.get("wlydZmj")) ? "" : xzMap.get("wlydZmj"));
                            xzTmpList.add(this.isNull(xzMap.get("043")) ? "" : xzMap.get("043"));
                            xzTmpList.add(this.isNull(xzMap.get("124")) ? "" : xzMap.get("124"));
                            xzTmpList.add(this.isNull(xzMap.get("125")) ? "" : xzMap.get("125"));
                            xzTmpList.add(this.isNull(xzMap.get("126")) ? "" : xzMap.get("126"));
                            xzTmpList.add(this.isNull(xzMap.get("127")) ? "" : xzMap.get("127"));
                            xzTmpList.add(this.isNull(xzMap.get("121")) ? "" : xzMap.get("121"));
                            xzTmpList.add(this.isNull(xzMap.get("111")) ? "" : xzMap.get("111"));
                            xzTmpList.add(this.isNull(xzMap.get("112")) ? "" : xzMap.get("112"));
                            xzTmpList.add(this.isNull(xzMap.get("115")) ? "" : xzMap.get("115"));
                            xzTmpList.add(this.isNull(xzMap.get("116")) ? "" : xzMap.get("116"));
                            xzTmpList.add(this.isNull(xzMap.get("119")) ? "" : xzMap.get("119"));
                            xzTmpList.add(this.isNull(xzMap.get("zmj")) ? "" : xzMap.get("zmj"));
                            xzList.add(xzTmpList);
                        }
                        if (xzList.size() > 0) {
                            sheet.put("Sheet1", xzList);
                        }
                    }
                    result.put(String.valueOf(key), sheet);
                    continue;
                }
                if (key.equals("bp")) {
                    ArrayList list1 = new ArrayList();
                    ArrayList list2 = new ArrayList();
                    if (!this.isNull(map.get("info"))) {
                        info = (List)map.get("info");
                    }
                    if (!this.isNull(map.get("detail"))) {
                        detail = (List)map.get("detail");
                    }
                    if (info.size() > 0 && detail.size() > 0) {
                        for (Map temp : info) {
                            ArrayList tempList = new ArrayList();
                            tempList.add(temp.get("label"));
                            tempList.add(temp.get("area_pfm"));
                            tempList.add(temp.get("area_gq"));
                            tempList.add(temp.get("area_m"));
                            list1.add(tempList);
                        }
                        ArrayList<String> keyList = new ArrayList<String>();
                        for (Object detailKey : ((Map)detail.get(0)).keySet()) {
                            keyList.add(String.valueOf(detailKey));
                        }
                        list2.add(keyList);
                        for (Map detailTmp : detail) {
                            ArrayList tempList = new ArrayList();
                            for (String key1 : keyList) {
                                tempList.add(detailTmp.get(key1));
                            }
                            list2.add(tempList);
                        }
                        sheet.put("\u62a5\u6279\u6c47\u603b", list1);
                        sheet.put("\u62a5\u6279\u8be6\u60c5", list2);
                    }
                    result.put(String.valueOf(key), sheet);
                    continue;
                }
                ArrayList list = new ArrayList();
                ArrayList bpList = new ArrayList();
                if (!this.isNull(map.get("detail"))) {
                    detail = (List)map.get("detail");
                    ArrayList<String> firstRow = new ArrayList<String>();
                    ArrayList<String> secondRow = new ArrayList<String>();
                    firstRow.add("\u7528\u9014");
                    secondRow.add("\u9762\u79ef");
                    for (Map ghMap : detail) {
                        firstRow.add((String)ghMap.get("label"));
                        secondRow.add((String)ghMap.get("area"));
                    }
                    bpList.add(secondRow);
                    sheet.put("header", firstRow);
                    sheet.put("data", bpList);
                    list.add(sheet);
                }
                result.put(String.valueOf(key), list);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return result;
    }

    public double processValue(Double value, int precision) {
        switch (precision) {
            case 1: {
                return (double)Math.round(value * 100.0) / 100.0;
            }
            case 2: {
                return (double)Math.round(value * 100.0) / 100.0;
            }
            case 3: {
                return (double)Math.round(value * 100.0) / 100.0;
            }
        }
        return Math.round(value * 100.0) / 100L;
    }

    public double getSumArea(List<Map> list) {
        assert (list != null);
        double area = 0.0;
        if (list.size() > 0) {
            for (Map map : list) {
                area += Double.valueOf(String.valueOf(map.get("area")).toString()).doubleValue();
            }
        }
        return area;
    }

    public Map getCategoryB(List<Map> list) {
        HashMap result = new HashMap();
        try {
            for (Map map : list) {
                result.put(map.get("dlbm"), map.get("area"));
                if (!map.containsKey("detail")) continue;
                List detailList = (List)map.get("detail");
                for (Map detail : detailList) {
                    result.put(detail.get("dlbm"), detail.get("area"));
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return result;
    }

    public List<Map> add2List(List<Map> list, Map map) {
        boolean tag = false;
        String dlbm = map.get("DLBM").toString();
        double area = Double.valueOf(map.get("CCMJ").toString());
        HashMap<String, Object> temp = new HashMap<String, Object>();
        try {
            for (Map item : list) {
                if (!item.get("dlbm").equals(dlbm)) continue;
                double newArea = Double.valueOf(item.get("area").toString()) + area;
                item.put("area", newArea);
                tag = true;
            }
            if (!tag) {
                temp.put("area", area);
                temp.put("dlbm", dlbm);
                list.add(temp);
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return list;
    }

    public List<Map> tdlyxzResult2(Map analysisResult, String tpl) {
        double area;
        ArrayList<Map> resultList = new ArrayList<Map>();
        List list = (List)analysisResult.get("analysisAreaDetail");
        List groupList = this.getTdlyxzDictList(tpl);
        for (Map map : list) {
            String dlbm = map.get("DLBM").toString();
            area = Double.valueOf(map.get("CCMJ").toString());
            for (Map groupMap : groupList) {
                if (!groupMap.get("dlbm").toString().equals(dlbm.substring(0, 2))) continue;
                double newArea = Double.valueOf(groupMap.get("area").toString()) + area;
                ((List)groupMap.get("detail")).add(map);
                groupMap.put("area", newArea);
            }
        }
        for (int i = 0; i < groupList.size(); ++i) {
            Map map;
            map = (Map)groupList.get(i);
            HashMap temp = new HashMap();
            area = Double.valueOf(map.get("area").toString());
            if (!(area > 0.0)) continue;
            temp.put("dlmc", map.get("dlmc"));
            temp.put("area", map.get("area"));
            temp.put("detail", map.get("detail"));
            resultList.add(temp);
        }
        return resultList;
    }

    public List search(String value, boolean returnGeometry) {
        if (this.searchConfig == null) {
            throw new RuntimeException(this.getMessage("search.config.not.found", new Object[0]));
        }
        ArrayList result = new ArrayList();
        List layers = (List)this.searchConfig.get("layers");
        for (Map layer : layers) {
            String name = (String)layer.get("layer");
            String[] fields = ((String)layer.get("fields")).split(",");
            String where = this.getWhereClause(fields, value);
            result.addAll(this.spatialDao.query(name, where, fields, returnGeometry, 10, null));
        }
        return result;
    }

    public InputStream exportMap(String where, String mapScale, int width, int height, String type) {
        ByteArrayInputStream inputStream;
        Graphics2D graphics2D;
        if (this.exportConfig == null) {
            this.logger.info("\u65e0\u914d\u7f6e\u4fe1\u606f");
            return null;
        }
        int bgWidth = width + 10;
        int bgHeight = height + 10;
        String imageSize = width + "," + height;
        double scale = 0.0;
        if (StringUtils.isNotBlank((String)mapScale)) {
            scale = Double.valueOf(mapScale);
        }
        ArrayList<BufferedImage> baseImages = new ArrayList<BufferedImage>();
        BufferedImage topImage = null;
        BufferedImage resultImage = new BufferedImage(width, height, 4);
        ReferencedEnvelope envelope = null;
        Map operaLayer = (Map)this.exportConfig.get("operaLayer");
        List ghLayers = (List)this.exportConfig.get("ghLayers");
        List xzLayers = (List)this.exportConfig.get("xzLayers");
        String layerName = (String)operaLayer.get("layerName");
        String dataSource = (String)operaLayer.get("dataSource");
        String url = (String)operaLayer.get("url");
        List list = this.query(layerName, where, null, true, dataSource);
        if (list.size() > 0) {
            BufferedImage tempImage2;
            FeatureCollection featureCollection = this.geometryService.list2FeatureCollection(list, null, null);
            envelope = featureCollection.getBounds();
            topImage = this.getExportImage((Envelope)envelope, url, imageSize, scale);
            if (type.equals("gh")) {
                for (Map item : ghLayers) {
                    tempImage2 = this.getExportImage((Envelope)envelope, (String)item.get("url"), bgWidth + "," + bgHeight, scale);
                    baseImages.add(tempImage2);
                }
            } else if (type.equals("xz")) {
                for (Map item : xzLayers) {
                    tempImage2 = this.getExportImage((Envelope)envelope, (String)item.get("url"), bgWidth + "," + bgHeight, scale);
                    baseImages.add(tempImage2);
                }
            } else {
                this.logger.error("type is not found");
            }
            graphics2D = resultImage.createGraphics();
            resultImage = graphics2D.getDeviceConfiguration().createCompatibleImage(width, height, 3);
            graphics2D.dispose();
            graphics2D = resultImage.createGraphics();
            if (baseImages.size() > 0) {
                for (BufferedImage tempImage2 : baseImages) {
                    graphics2D.drawImage(tempImage2, 0, 0, tempImage2.getWidth(), tempImage2.getHeight(), null);
                }
            }
        } else {
            this.logger.info("\u672a\u67e5\u8be2\u5230\u5730\u5757!");
            return null;
        }
        graphics2D.drawImage(topImage, 0, 0, topImage.getWidth(), topImage.getHeight(), null);
        graphics2D.dispose();
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)resultImage, "png", out);
            inputStream = new ByteArrayInputStream(out.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return inputStream;
    }

    public Map multipleAnalysis(String geometry, List analysisLayers, String dataSource, String tpl) {
        if (this.isNull((Object)analysisLayers)) {
            throw new RuntimeException("no analysis Layers");
        }
        if (this.isNull((Object)geometry)) {
            throw new JSONMessageException("geometry is null");
        }
        String xzdwLyr = null;
        String dltbLyr = null;
        String tdghscYear = null;
        HashMap<String, Object> result = new HashMap<String, Object>();
        List tdlyxzResult = new ArrayList();
        try {
            ArrayList analysisList = new ArrayList();
            for (int i = 0; i < analysisLayers.size(); ++i) {
                String[] fields;
                Map layer = (Map)analysisLayers.get(i);
                String lyrName = (String)layer.get("layerName");
                String outFields = layer.get("fields").toString();
                String[] stringArray = fields = "*".equals(outFields) ? null : outFields.split(",");
                if (layer.get("id").equals(IdTag.xzdw.name())) {
                    xzdwLyr = (String)layer.get("layerName");
                    continue;
                }
                if (layer.get("id").equals(IdTag.dltb.name())) {
                    dltbLyr = (String)layer.get("layerName");
                    continue;
                }
                List list = this.intersectByGeoJSON(lyrName, geometry, fields, dataSource);
                HashMap temp = new HashMap();
                temp.put(MTag.GROUP.name(), layer.get("group"));
                temp.put(MTag.ID.name(), layer.get("id"));
                temp.put(MTag.RESULT.name(), list);
                analysisList.add(temp);
                if (!layer.get("group").equals(MultipleAnalysis.GH.name().toLowerCase())) continue;
                tdghscYear = Arrays.asList(layer.get("layerName").toString().split("_E_")).get(1);
            }
            if (StringUtils.isNotBlank(xzdwLyr) && StringUtils.isNotBlank(dltbLyr)) {
                Map tdlyxzMap = this.tdlyxzAnalysis2(dltbLyr, xzdwLyr, geometry, dataSource);
                tdlyxzResult = this.tdlyxzResult(tdlyxzMap, tpl);
                result.put("tdlyxz", tdlyxzResult);
            }
            if (!this.isNull(tdghscYear) && !result.containsKey("tdghsc")) {
                Map tdghscMap = this.tdghscAnalysis2(tdghscYear, geometry, null, dataSource);
                result.put("tdghsc", this.tdghscResult(tdghscMap));
            }
            Map groupMap = this.groupList(analysisList, MTag.GROUP.name());
            groupMap.put(MultipleAnalysis.XZ.name().toLowerCase(), tdlyxzResult);
            if (!groupMap.isEmpty()) {
                result.put("result", this.parseMultiAnalysis(groupMap, geometry));
            }
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return result;
    }

    public Map multipleAnalysisExcel(Map analysisMap) {
        ArrayList tempList;
        String keyUpp;
        ArrayList wrapList;
        ArrayList dataList;
        ArrayList<String> headerList;
        Map detailItem;
        List detailList;
        Map excelMap;
        Map temp;
        HashMap<String, Map> result = new HashMap<String, Map>();
        result.put("gh", this.getSheetMap("sheet1", analysisMap.get("ghResult"), false));
        LinkedHashMap<String, String> map = null;
        ArrayList list = null;
        DecimalFormat df = new DecimalFormat("0.00");
        DecimalFormat df_h = new DecimalFormat("0.0000");
        if (analysisMap.containsKey("bpInfo")) {
            temp = (Map)analysisMap.get("bpInfo");
            list = new ArrayList();
            for (String key : temp.keySet()) {
                map = new LinkedHashMap<String, String>();
                if (key.equals(BpTag.YB_AREA.name())) {
                    map.put("lx", "\u5df2\u62a5");
                } else if (key.equals(BpTag.WB_AREA.name())) {
                    map.put("lx", "\u672a\u62a5");
                } else if (key.equals(BpTag.TOTAL_AREA.name())) {
                    map.put("lx", "\u5408\u8ba1");
                }
                map.put(key, df.format(MapUtils.getDouble((Map)temp, (Object)key, (Double)0.0)));
                map.put("yb_h", df_h.format(MapUtils.getDouble((Map)temp, (Object)key, (Double)0.0) * UNITS.access$100((UNITS)UNITS.HECTARE)));
                map.put("yb_a", df.format(MapUtils.getDouble((Map)temp, (Object)key, (Double)0.0) * UNITS.access$100((UNITS)UNITS.ACRES)));
                list.add(map);
            }
            excelMap = this.getSheetMap("\u62a5\u6279\u6c47\u603b", list, false);
            if (analysisMap.containsKey("bpDetail")) {
                detailList = (List)analysisMap.get("bpDetail");
                list = new ArrayList();
                if (detailList.size() > 0) {
                    detailItem = (Map)detailList.get(0);
                    headerList = new ArrayList<String>();
                    dataList = new ArrayList();
                    wrapList = new ArrayList();
                    for (String key : detailItem.keySet()) {
                        keyUpp = key.toUpperCase().trim();
                        if (keyUpp.contains("SHAPE") || keyUpp.contains("SHAPE_AREA") || keyUpp.contains("OG_PRO_")) continue;
                        headerList.add(key);
                    }
                    if (headerList.size() > 0) {
                        wrapList.add(headerList);
                        dataList.addAll(wrapList);
                    }
                    for (Map detailMap : detailList) {
                        wrapList = new ArrayList();
                        tempList = new ArrayList();
                        for (String header : headerList) {
                            tempList.add(detailMap.get(header));
                        }
                        if (tempList.size() <= 0) continue;
                        wrapList.add(tempList);
                        dataList.addAll(wrapList);
                    }
                    if (dataList.size() > 0) {
                        excelMap.put("\u62a5\u6279\u8be6\u60c5", dataList);
                    }
                }
            }
            result.put("bp", excelMap);
        }
        if (analysisMap.containsKey("gdInfo")) {
            temp = (Map)analysisMap.get("gdInfo");
            list = new ArrayList();
            for (String key : temp.keySet()) {
                map = new LinkedHashMap();
                if (key.equals(GdTag.YG_AREA.name())) {
                    map.put("lx", "\u5df2\u4f9b");
                } else if (key.equals(GdTag.WG_AREA.name())) {
                    map.put("lx", "\u672a\u4f9b");
                } else if (key.equals(GdTag.TOTAL_AREA.name())) {
                    map.put("lx", "\u5408\u8ba1");
                }
                map.put(key, df.format(MapUtils.getDouble((Map)temp, (Object)key, (Double)0.0)));
                map.put("yg_h", df_h.format(MapUtils.getDouble((Map)temp, (Object)key, (Double)0.0) * UNITS.access$100((UNITS)UNITS.HECTARE)));
                map.put("yg_a", df.format(MapUtils.getDouble((Map)temp, (Object)key, (Double)0.0) * UNITS.access$100((UNITS)UNITS.ACRES)));
                list.add(map);
            }
            excelMap = this.getSheetMap("\u4f9b\u5730\u6c47\u603b", list, false);
            if (analysisMap.containsKey("gdDetail")) {
                detailList = (List)analysisMap.get("gdDetail");
                list = new ArrayList();
                if (detailList.size() > 0) {
                    detailItem = (Map)detailList.get(0);
                    headerList = new ArrayList();
                    dataList = new ArrayList();
                    wrapList = new ArrayList();
                    for (String key : detailItem.keySet()) {
                        keyUpp = key.toUpperCase().trim();
                        if (keyUpp.contains("SHAPE") || keyUpp.contains("SHAPE_AREA") || keyUpp.contains("OG_PRO_")) continue;
                        headerList.add(key);
                    }
                    if (headerList.size() > 0) {
                        wrapList.add(headerList);
                        dataList.addAll(wrapList);
                    }
                    for (Map detailMap : detailList) {
                        wrapList = new ArrayList();
                        tempList = new ArrayList();
                        for (String header : headerList) {
                            tempList.add(detailMap.get(header));
                        }
                        if (tempList.size() <= 0) continue;
                        wrapList.add(tempList);
                        dataList.addAll(wrapList);
                    }
                    if (dataList.size() > 0) {
                        excelMap.put("\u4f9b\u5730\u8be6\u60c5", dataList);
                    }
                }
            }
            result.put("gd", excelMap);
        }
        if (analysisMap.containsKey("xzResult")) {
            result.put("xz", this.getSheetMap("sheet1", analysisMap.get("xzResult"), true));
        }
        return result;
    }

    public Map<String, List> getSheetMap(String sheetName, Object data, boolean isXz) {
        HashMap sheet = null;
        ArrayList sheetList = null;
        DecimalFormat df = new DecimalFormat("0.00");
        try {
            if (data instanceof Map) {
                Map temp = (Map)data;
                sheetList = new ArrayList();
                ArrayList tempList = new ArrayList();
                for (Object key : ((Map)data).keySet()) {
                    tempList.add(temp.get(key));
                }
                sheetList.add(tempList);
                sheet = new HashMap();
                sheet.put(sheetName, sheetList);
            } else if (data instanceof List) {
                List temp = (List)data;
                sheetList = new ArrayList();
                for (Map item : temp) {
                    ArrayList<Object> itemList = new ArrayList<Object>();
                    if (isXz && item.keySet().size() > 0) {
                        itemList.add(item.get(XzTag.QSMC.name()));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)XzTag.NYD_AREA.name(), (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)XzTag.GD_AREA.name(), (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"011", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"012", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"013", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"021", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"022", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"023", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"031", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"032", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"033", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"041", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"042", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"122", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"104", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"114", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"117", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"123", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)XzTag.JSYD_AREA.name(), (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"201", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"202", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"203", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"204", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"205", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"101", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"102", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"105", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"106", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"107", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"113", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"118", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)XzTag.WLYD_AREA.name(), (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"043", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"124", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"125", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"126", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"127", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"121", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"111", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"112", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"115", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"116", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)"119", (Double)0.0)));
                        itemList.add(df.format(MapUtils.getDouble((Map)item, (Object)XzTag.TOTAL_AREA.name(), (Double)0.0)));
                        itemList.add("");
                    } else {
                        for (Object key : item.keySet()) {
                            itemList.add(item.get(key));
                        }
                    }
                    sheetList.add(itemList);
                }
                sheet = new HashMap();
                sheet.put(sheetName, sheetList);
            }
        }
        catch (Exception e) {
            this.logger.error("generate sheet error:" + e.getLocalizedMessage());
            throw new RuntimeException("generate sheet error:" + e.getLocalizedMessage());
        }
        return sheet;
    }

    public Map<String, List> list2Map(List<Map> list) {
        assert (list != null);
        HashMap<String, List> result = new HashMap<String, List>();
        for (Map item : list) {
            result.put(item.get(MTag.ID.name()).toString(), (List)item.get(MTag.RESULT.name()));
        }
        return result;
    }

    public Map parseMultiAnalysis(Map<String, List> map, String geometry) {
        HashMap<String, Cloneable> result = new HashMap<String, Cloneable>();
        Object geo = this.geometryService.readUnTypeGeoJSON(geometry);
        DecimalFormat df_h = new DecimalFormat("0.0000");
        double geoArea = this.getAreaByGeometry(geo, 1.0);
        this.logger.info("[geometry area]:" + geoArea);
        try {
            Map ghMap = this.list2Map(map.get(MultipleAnalysis.GH.name().toLowerCase()));
            Map bpMap = this.list2Map(map.get(MultipleAnalysis.BP.name().toLowerCase()));
            Map gdMap = this.list2Map(map.get(MultipleAnalysis.GD.name().toLowerCase()));
            List xzList = map.get(MultipleAnalysis.XZ.name().toLowerCase());
            LinkedHashMap<String, String> ghResult = new LinkedHashMap<String, String>();
            LinkedHashMap<String, Double> bpInfo = new LinkedHashMap<String, Double>();
            LinkedHashMap<String, Double> gdInfo = new LinkedHashMap<String, Double>();
            List bpDetail = new ArrayList();
            List gdDetail = new ArrayList();
            ArrayList<LinkedHashMap> xzResult = new ArrayList<LinkedHashMap>();
            ArrayList gyList = new ArrayList();
            ArrayList jtList = new ArrayList();
            if (!ghMap.isEmpty()) {
                List tdytqList = (List)ghMap.get(IdTag.tdytq.name());
                List jqdltbList = (List)ghMap.get(IdTag.jqdltb.name());
                List jsydgzqList = (List)ghMap.get(IdTag.jsydgzq.name());
                ghResult.put(GhTag.JBNT_AREA.name(), df_h.format(this.getAreaByField(tdytqList, "TDYTQLXDM", "010", UNITS.access$100((UNITS)UNITS.HECTARE))));
                ghResult.put(GhTag.YBNT_AREA.name(), df_h.format(this.getAreaByField(tdytqList, "TDYTQLXDM", "020", UNITS.access$100((UNITS)UNITS.HECTARE))));
                ghResult.put(GhTag.SY_AREA.name(), df_h.format(this.getAreaByField(jqdltbList, "DLMC", "\u519c\u7530\u6c34\u5229\u7528\u5730", UNITS.access$100((UNITS)UNITS.HECTARE))));
                ghResult.put(GhTag.LD_AREA.name(), df_h.format(this.getAreaByField(jqdltbList, "DLMC", "\u6797\u5730", UNITS.access$100((UNITS)UNITS.HECTARE))));
                ghResult.put(GhTag.YD_AREA.name(), df_h.format(this.getAreaByField(jqdltbList, "DLMC", "\u56ed\u5730", UNITS.access$100((UNITS)UNITS.HECTARE))));
                ghResult.put(GhTag.YXJSQ_AREA.name(), df_h.format(this.getAreaByField(jsydgzqList, "GZQLXDM", "010", UNITS.access$100((UNITS)UNITS.HECTARE))));
                ghResult.put(GhTag.YTJJSQ_AREA.name(), df_h.format(this.getAreaByField(jsydgzqList, "GZQLXDM", "020", UNITS.access$100((UNITS)UNITS.HECTARE))));
                ghResult.put(GhTag.WLYD_AREA.name(), df_h.format(this.getAreaByField(jqdltbList, "DLMC", "\u6ee9\u6d82,\u6cb3\u6d41\u6c34\u9762,\u6e56\u6cca\u6c34\u9762,\u81ea\u7136\u4fdd\u7559\u5730", UNITS.access$100((UNITS)UNITS.HECTARE))));
            }
            if (!bpMap.isEmpty()) {
                bpDetail = (List)bpMap.get(IdTag.bpdk.name());
                bpInfo.put(BpTag.YB_AREA.name(), this.getAreaByList(bpDetail, 1.0));
                bpInfo.put(BpTag.WB_AREA.name(), geoArea - this.getAreaByList(bpDetail, 1.0) < 0.0 ? 0.0 : geoArea - this.getAreaByList(bpDetail, 1.0));
                bpInfo.put(BpTag.TOTAL_AREA.name(), geoArea);
            }
            if (!gdMap.isEmpty()) {
                gdDetail = (List)gdMap.get(IdTag.gddk.name());
                gdInfo.put(GdTag.YG_AREA.name(), this.getAreaByList(gdDetail, 1.0));
                gdInfo.put(GdTag.WG_AREA.name(), geoArea - this.getAreaByList(gdDetail, 1.0) < 0.0 ? 0.0 : geoArea - this.getAreaByList(gdDetail, 1.0));
                gdInfo.put(GdTag.TOTAL_AREA.name(), geoArea);
            }
            if (!this.isNull((Object)xzList)) {
                for (Map xzMap : xzList) {
                    LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
                    Map categoryB = (Map)xzMap.get("categoryB");
                    if (xzMap.containsKey("qsxz")) {
                        if (QSXZ.access$200((QSXZ)QSXZ.GY).indexOf(String.valueOf(xzMap.get("qsxz"))) > -1) {
                            gyList.add(item);
                            item.put(XzTag.QSMC.name(), xzMap.get("xzqmc") + "(" + QsTag.access$300((QsTag)QsTag.gy) + ")");
                        } else {
                            jtList.add(item);
                            item.put(XzTag.QSMC.name(), xzMap.get("xzqmc") + "(" + QsTag.access$300((QsTag)QsTag.jt) + ")");
                        }
                    } else {
                        item.put(XzTag.QSMC.name(), xzMap.get("xzqmc"));
                    }
                    item.put("011", MapUtils.getDouble((Map)categoryB, (Object)"011", (Double)0.0));
                    item.put("012", MapUtils.getDouble((Map)categoryB, (Object)"012", (Double)0.0));
                    item.put("013", MapUtils.getDouble((Map)categoryB, (Object)"013", (Double)0.0));
                    item.put("021", MapUtils.getDouble((Map)categoryB, (Object)"021", (Double)0.0));
                    item.put("022", MapUtils.getDouble((Map)categoryB, (Object)"022", (Double)0.0));
                    item.put("023", MapUtils.getDouble((Map)categoryB, (Object)"023", (Double)0.0));
                    item.put("031", MapUtils.getDouble((Map)categoryB, (Object)"031", (Double)0.0));
                    item.put("032", MapUtils.getDouble((Map)categoryB, (Object)"032", (Double)0.0));
                    item.put("033", MapUtils.getDouble((Map)categoryB, (Object)"033", (Double)0.0));
                    item.put("041", MapUtils.getDouble((Map)categoryB, (Object)"041", (Double)0.0));
                    item.put("042", MapUtils.getDouble((Map)categoryB, (Object)"042", (Double)0.0));
                    item.put("122", MapUtils.getDouble((Map)categoryB, (Object)"122", (Double)0.0));
                    item.put("104", MapUtils.getDouble((Map)categoryB, (Object)"104", (Double)0.0));
                    item.put("114", MapUtils.getDouble((Map)categoryB, (Object)"114", (Double)0.0));
                    item.put("117", MapUtils.getDouble((Map)categoryB, (Object)"117", (Double)0.0));
                    item.put("123", MapUtils.getDouble((Map)categoryB, (Object)"123", (Double)0.0));
                    item.put("201", MapUtils.getDouble((Map)categoryB, (Object)"201", (Double)0.0));
                    item.put("202", MapUtils.getDouble((Map)categoryB, (Object)"202", (Double)0.0));
                    item.put("203", MapUtils.getDouble((Map)categoryB, (Object)"203", (Double)0.0));
                    item.put("204", MapUtils.getDouble((Map)categoryB, (Object)"204", (Double)0.0));
                    item.put("205", MapUtils.getDouble((Map)categoryB, (Object)"205", (Double)0.0));
                    item.put("101", MapUtils.getDouble((Map)categoryB, (Object)"101", (Double)0.0));
                    item.put("102", MapUtils.getDouble((Map)categoryB, (Object)"102", (Double)0.0));
                    item.put("105", MapUtils.getDouble((Map)categoryB, (Object)"105", (Double)0.0));
                    item.put("106", MapUtils.getDouble((Map)categoryB, (Object)"106", (Double)0.0));
                    item.put("107", MapUtils.getDouble((Map)categoryB, (Object)"107", (Double)0.0));
                    item.put("113", MapUtils.getDouble((Map)categoryB, (Object)"113", (Double)0.0));
                    item.put("118", MapUtils.getDouble((Map)categoryB, (Object)"118", (Double)0.0));
                    item.put("043", MapUtils.getDouble((Map)categoryB, (Object)"043", (Double)0.0));
                    item.put("124", MapUtils.getDouble((Map)categoryB, (Object)"124", (Double)0.0));
                    item.put("125", MapUtils.getDouble((Map)categoryB, (Object)"125", (Double)0.0));
                    item.put("126", MapUtils.getDouble((Map)categoryB, (Object)"126", (Double)0.0));
                    item.put("127", MapUtils.getDouble((Map)categoryB, (Object)"127", (Double)0.0));
                    item.put("121", MapUtils.getDouble((Map)categoryB, (Object)"121", (Double)0.0));
                    item.put("111", MapUtils.getDouble((Map)categoryB, (Object)"111", (Double)0.0));
                    item.put("112", MapUtils.getDouble((Map)categoryB, (Object)"112", (Double)0.0));
                    item.put("115", MapUtils.getDouble((Map)categoryB, (Object)"115", (Double)0.0));
                    item.put("116", MapUtils.getDouble((Map)categoryB, (Object)"116", (Double)0.0));
                    item.put("119", MapUtils.getDouble((Map)categoryB, (Object)"119", (Double)0.0));
                    item.put(XzTag.GD_AREA.name(), this.getAreaByMapKeys(categoryB, Arrays.asList("011,012,013".split(",")), 1.0));
                    item.put(XzTag.LD_AREA.name(), this.getAreaByMapKeys(categoryB, Arrays.asList("021,022,023".split(",")), 1.0));
                    item.put(XzTag.YD_AREA.name(), this.getAreaByMapKeys(categoryB, Arrays.asList("031,032,033".split(",")), 1.0));
                    item.put(XzTag.MCD_AREA.name(), this.getAreaByMapKeys(categoryB, Arrays.asList("041,042".split(",")), 1.0));
                    item.put(XzTag.QTNYD_AREA.name(), this.getAreaByMapKeys(categoryB, Arrays.asList("122,104,114,117,123".split(",")), 1.0));
                    item.put(XzTag.JMD_AREA.name(), this.getAreaByMapKeys(categoryB, Arrays.asList("201,202,203,204,205".split(",")), 1.0));
                    item.put(XzTag.JT_AREA.name(), this.getAreaByMapKeys(categoryB, Arrays.asList("101,102,105,106,107".split(",")), 1.0));
                    item.put(XzTag.SL_AREA.name(), this.getAreaByMapKeys(categoryB, Arrays.asList("113,118".split(",")), 1.0));
                    item.put(XzTag.WLYTD_AREA.name(), this.getAreaByMapKeys(categoryB, Arrays.asList("043,124,125,126,127,121".split(",")), 1.0));
                    item.put(XzTag.QTTD_AREA.name(), this.getAreaByMapKeys(categoryB, Arrays.asList("111,112,115,116,119".split(",")), 1.0));
                    item.put(XzTag.NYD_AREA.name(), MapUtils.getDouble(item, (Object)XzTag.GD_AREA.name()) + MapUtils.getDouble(item, (Object)XzTag.YD_AREA.name()) + MapUtils.getDouble(item, (Object)XzTag.LD_AREA.name()) + MapUtils.getDouble(item, (Object)XzTag.MCD_AREA.name()) + MapUtils.getDouble(item, (Object)XzTag.QTNYD_AREA.name()));
                    item.put(XzTag.JSYD_AREA.name(), MapUtils.getDouble(item, (Object)XzTag.JMD_AREA.name()) + MapUtils.getDouble(item, (Object)XzTag.JT_AREA.name()) + MapUtils.getDouble(item, (Object)XzTag.SL_AREA.name()));
                    item.put(XzTag.WLYD_AREA.name(), MapUtils.getDouble(item, (Object)XzTag.WLYTD_AREA.name()) + MapUtils.getDouble(item, (Object)XzTag.QTTD_AREA.name()));
                    item.put(XzTag.TOTAL_AREA.name(), MapUtils.getDouble((Map)xzMap, (Object)"area"));
                    xzResult.add(item);
                }
            }
            LinkedHashMap gyMap = this.qsList2Map(gyList, QsTag.gy.name());
            LinkedHashMap jtMap = this.qsList2Map(jtList, QsTag.jt.name());
            if (!gyMap.isEmpty()) {
                xzResult.add(xzResult.size() - 1, gyMap);
            }
            if (!jtMap.isEmpty()) {
                xzResult.add(xzResult.size() - 1, jtMap);
            }
            result.put("ghResult", ghResult);
            result.put("bpInfo", bpInfo);
            result.put("bpDetail", (Cloneable)((Object)bpDetail));
            result.put("gdInfo", gdInfo);
            result.put("gdDetail", (Cloneable)((Object)gdDetail));
            result.put("xzResult", xzResult);
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return result;
    }

    public LinkedHashMap qsList2Map(List<LinkedHashMap> list, String type) {
        assert (list != null);
        assert (type != null);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        try {
            if (list.size() > 0) {
                if (type.equals(QsTag.gy.name())) {
                    result.put(XzTag.QSMC.name(), "\u5408\u8ba1\u56fd\u6709");
                }
                if (type.equals(QsTag.jt.name())) {
                    result.put(XzTag.QSMC.name(), "\u5408\u8ba1\u96c6\u4f53");
                }
                result.put("011", this.getDouValueByField(list, "011"));
                result.put("012", this.getDouValueByField(list, "012"));
                result.put("013", this.getDouValueByField(list, "013"));
                result.put("021", this.getDouValueByField(list, "021"));
                result.put("022", this.getDouValueByField(list, "022"));
                result.put("023", this.getDouValueByField(list, "023"));
                result.put("031", this.getDouValueByField(list, "031"));
                result.put("032", this.getDouValueByField(list, "032"));
                result.put("033", this.getDouValueByField(list, "033"));
                result.put("041", this.getDouValueByField(list, "041"));
                result.put("042", this.getDouValueByField(list, "042"));
                result.put("122", this.getDouValueByField(list, "122"));
                result.put("104", this.getDouValueByField(list, "104"));
                result.put("114", this.getDouValueByField(list, "114"));
                result.put("117", this.getDouValueByField(list, "117"));
                result.put("123", this.getDouValueByField(list, "123"));
                result.put("201", this.getDouValueByField(list, "201"));
                result.put("202", this.getDouValueByField(list, "202"));
                result.put("203", this.getDouValueByField(list, "203"));
                result.put("204", this.getDouValueByField(list, "204"));
                result.put("205", this.getDouValueByField(list, "205"));
                result.put("101", this.getDouValueByField(list, "101"));
                result.put("102", this.getDouValueByField(list, "102"));
                result.put("105", this.getDouValueByField(list, "105"));
                result.put("106", this.getDouValueByField(list, "106"));
                result.put("107", this.getDouValueByField(list, "107"));
                result.put("113", this.getDouValueByField(list, "113"));
                result.put("118", this.getDouValueByField(list, "118"));
                result.put("111", this.getDouValueByField(list, "111"));
                result.put("112", this.getDouValueByField(list, "112"));
                result.put("115", this.getDouValueByField(list, "115"));
                result.put("116", this.getDouValueByField(list, "116"));
                result.put("119", this.getDouValueByField(list, "119"));
                result.put("043", this.getDouValueByField(list, "043"));
                result.put("124", this.getDouValueByField(list, "124"));
                result.put("125", this.getDouValueByField(list, "125"));
                result.put("126", this.getDouValueByField(list, "126"));
                result.put("127", this.getDouValueByField(list, "127"));
                result.put("121", this.getDouValueByField(list, "121"));
                result.put(XzTag.GD_AREA.name(), this.getDouValueByField(list, XzTag.GD_AREA.name()));
                result.put(XzTag.LD_AREA.name(), this.getDouValueByField(list, XzTag.LD_AREA.name()));
                result.put(XzTag.YD_AREA.name(), this.getDouValueByField(list, XzTag.YD_AREA.name()));
                result.put(XzTag.MCD_AREA.name(), this.getDouValueByField(list, XzTag.MCD_AREA.name()));
                result.put(XzTag.QTNYD_AREA.name(), this.getDouValueByField(list, XzTag.QTNYD_AREA.name()));
                result.put(XzTag.JMD_AREA.name(), this.getDouValueByField(list, XzTag.JMD_AREA.name()));
                result.put(XzTag.JT_AREA.name(), this.getDouValueByField(list, XzTag.JT_AREA.name()));
                result.put(XzTag.SL_AREA.name(), this.getDouValueByField(list, XzTag.SL_AREA.name()));
                result.put(XzTag.WLYTD_AREA.name(), this.getDouValueByField(list, XzTag.WLYTD_AREA.name()));
                result.put(XzTag.QTTD_AREA.name(), this.getDouValueByField(list, XzTag.QTTD_AREA.name()));
                result.put(XzTag.NYD_AREA.name(), this.getDouValueByField(list, XzTag.NYD_AREA.name()));
                result.put(XzTag.JSYD_AREA.name(), this.getDouValueByField(list, XzTag.JSYD_AREA.name()));
                result.put(XzTag.WLYD_AREA.name(), this.getDouValueByField(list, XzTag.WLYD_AREA.name()));
                result.put(XzTag.TOTAL_AREA.name(), this.getDouValueByField(list, XzTag.TOTAL_AREA.name()));
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public Map<String, List> groupList(List list, String groupKey) {
        HashMap<String, List> resultMap = new HashMap<String, List>();
        try {
            for (int i = 0; i < list.size(); ++i) {
                Map item = (Map)list.get(i);
                if (!item.containsKey(groupKey)) continue;
                String groupValue = (String)item.get(groupKey);
                ArrayList<Map> temp = (ArrayList<Map>)resultMap.get(groupValue);
                if (this.isNull((Object)temp)) {
                    temp = new ArrayList<Map>();
                    temp.add(item);
                    resultMap.put(groupValue, temp);
                    continue;
                }
                temp.add(item);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return resultMap;
    }

    public List<Map> jctbAnalysis(String geometry, List analysisLayers, String dataSource, Map unit) {
        if (this.isNull((Object)analysisLayers)) {
            throw new RuntimeException("no analysis Layers");
        }
        if (this.isNull((Object)geometry)) {
            throw new JSONMessageException("geometry is null");
        }
        if (this.isNull((Object)unit)) {
            throw new JSONMessageException("unit is null");
        }
        ArrayList results = null;
        try {
            Object geo = this.geometryService.readUnTypeGeoJSON(geometry);
            if (geo instanceof FeatureCollection) {
                results = new ArrayList<Map>();
                FeatureIterator iterator = ((FeatureCollection)geo).features();
                while (iterator.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)iterator.next();
                    Map map = this.singleJctbAnalysis(feature, analysisLayers, dataSource, unit);
                    results.add(map);
                }
            } else if (geo instanceof SimpleFeature) {
                results = new ArrayList();
                results.add(this.singleJctbAnalysis((SimpleFeature)geo, analysisLayers, dataSource, unit));
            }
        }
        catch (GeometryServiceException e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.GEOJSON_PARSE_EXCEPTION, e.getLocalizedMessage());
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return results;
    }

    public List jctbExcelData(List<Map> list) {
        ArrayList result = null;
        if (this.isNull(list)) {
            return null;
        }
        result = new ArrayList();
        for (Map item : list) {
            ArrayList<Object> temp = new ArrayList<Object>();
            temp.add(list.indexOf(item) + 1);
            temp.add(this.isNull(item.get("OG_PRO_JCBH")) ? "" : item.get("OG_PRO_JCBH"));
            temp.add(this.isNull(item.get("OG_PRO_TBLX")) ? "" : item.get("OG_PRO_TBLX"));
            temp.add(this.isNull(item.get("OG_PRO_BSM")) ? "" : item.get("OG_PRO_BSM"));
            temp.add(this.isNull(item.get("OG_PRO_XZMC")) ? "" : item.get("OG_PRO_XZMC"));
            temp.add(this.isNull(item.get("OG_PRO_XMMC")) ? "" : item.get("OG_PRO_XMMC"));
            temp.add(this.isNull(item.get("OG_PRO_JSDW")) ? "" : item.get("OG_PRO_JSDW"));
            temp.add(this.isNull(item.get("OG_PRO_JCMJ")) ? "" : item.get("OG_PRO_JCMJ"));
            temp.add(this.isNull(item.get("JC_GD_AREA")) ? "" : item.get("JC_GD_AREA"));
            temp.add(item.get(JTag.BP_AREA.name()).equals(0) ? "" : item.get(JTag.BP_AREA.name()));
            temp.add(item.get(JTag.BP_GD_AREA.name()).equals(0) ? "" : item.get(JTag.BP_GD_AREA.name()));
            temp.add(item.get(JTag.YG_AREA.name()).equals(0) ? "" : item.get(JTag.YG_AREA.name()));
            temp.add(item.get(JTag.WG_AREA.name()).equals(0) ? "" : item.get(JTag.WG_AREA.name()));
            temp.add(item.get(JTag.WPYJ_AREA.name()).equals(0) ? "" : item.get(JTag.WPYJ_AREA.name()));
            temp.add(item.get(JTag.WPYJ_GD_AREA.name()).equals(0) ? "" : item.get(JTag.WPYJ_GD_AREA.name()));
            temp.add(item.get(JTag.YXJSQ_AREA.name()).equals(0) ? "" : item.get(JTag.YXJSQ_AREA.name()));
            temp.add(item.get(JTag.JBNT_AREA.name()).equals(0) ? "" : item.get(JTag.JBNT_AREA.name()));
            temp.add(item.get(JTag.YBNTQ_AREA.name()).equals(0) ? "" : item.get(JTag.YBNTQ_AREA.name()));
            temp.add(" ");
            temp.add(" ");
            temp.add(" ");
            temp.add(" ");
            temp.add(" ");
            temp.add(" ");
            temp.add(this.isNull(item.get(JTag.PCMC.name())) ? "" : item.get(JTag.PCMC.name()));
            temp.add(this.isNull(item.get(JTag.NZYPW.name())) ? "" : item.get(JTag.NZYPW.name()));
            temp.add(this.isNull(item.get(JTag.GDBH.name())) ? "" : item.get(JTag.GDBH.name()));
            temp.add(item.get(JTag.SSNYD_AREA.name()).equals(0) ? "" : item.get(JTag.SSNYD_AREA.name()));
            temp.add(this.isNull(item.get(JTag.SSNYD_BH.name())) ? "" : item.get(JTag.SSNYD_BH.name()));
            temp.add(item.get(JTag.LSYD_AREA.name()).equals(0) ? "" : item.get(JTag.LSYD_AREA.name()));
            temp.add(this.isNull(item.get(JTag.LSYD_BH.name())) ? "" : item.get(JTag.LSYD_BH.name()));
            temp.add(" ");
            temp.add(" ");
            temp.add(" ");
            result.add(temp);
        }
        return result;
    }

    public Map tdlyxzAnalysisByWcf(String dltbLayerName, String xzdwLayerName, String geometry, String wcfUrl, String wcfMethod) {
        if (StringUtils.isBlank((String)dltbLayerName)) {
            throw new RuntimeException(this.getMessage("analysis.tdlyxz.params.error", new Object[]{"\u5730\u7c7b\u56fe\u6591\u56fe\u5c42\u540d\u79f0\u4e3a\u7a7a\uff01"}));
        }
        if (StringUtils.isBlank((String)xzdwLayerName)) {
            throw new RuntimeException(this.getMessage("analysis.tdlyxz.params.error", new Object[]{"\u7ebf\u72b6\u5730\u7269\u56fe\u5c42\u540d\u79f0\u4e3a\u7a7a\uff01"}));
        }
        if (StringUtils.isBlank((String)geometry)) {
            throw new RuntimeException(this.getMessage("analysis.tdlyxz.params.error", new Object[]{"\u5206\u6790\u5730\u5757\u5750\u6807\u4e3a\u7a7a\uff01"}));
        }
        if (StringUtils.isBlank((String)wcfUrl)) {
            throw new RuntimeException(this.getMessage("tdlyxz.wcf.url.null", new Object[0]));
        }
        if (StringUtils.isBlank((String)wcfMethod)) {
            throw new RuntimeException(this.getMessage("tdlyxz.wcf.method.null", new Object[0]));
        }
        try {
            Object[] objects;
            Client client = new Client(new URL(wcfUrl));
            JSONObject params = new JSONObject();
            params.put(WCFTag.AnalyseGeoJSON.name(), (Object)geometry);
            params.put(WCFTag.TBLayerName.name(), (Object)dltbLayerName);
            params.put(WCFTag.XWLayerName.name(), (Object)xzdwLayerName);
            params.put(WCFTag.UseGlobalArea.name(), (Object)false);
            try {
                objects = client.invoke(wcfMethod, (Object[])new String[]{JSON.toJSONString((Object)params)});
            }
            catch (Exception e) {
                this.logger.error(this.getMessage("tdlyxz.wcf.error", new Object[]{e.getLocalizedMessage()}));
                throw new RuntimeException(this.getMessage("tdlyxz.wcf.error", new Object[]{e.getLocalizedMessage()}));
            }
            Map analysisMap = (Map)JSON.parseObject((String)String.valueOf(objects[0]), Map.class);
            if (!analysisMap.isEmpty()) {
                this.logger.info("[wcf \u5206\u6790\u7ed3\u679c:]" + JSON.toJSONString((Object)analysisMap));
            }
            List tbFeatures = (List)MapUtils.getObject((Map)analysisMap, (Object)WCFTag.TBFeatures.name());
            List xwFeatures = (List)MapUtils.getObject((Map)analysisMap, (Object)WCFTag.XWFeatures.name());
            List summary = (List)MapUtils.getObject((Map)analysisMap, (Object)WCFTag.Summary.name());
            Map dlbmSummary = (Map)((Map)summary.get(0)).get("SummaryByDLDM");
            ArrayList detailList = new ArrayList();
            HashMap analysisArea = new HashMap();
            HashMap<String, Object> detailMap = null;
            if (!this.isNull((Object)tbFeatures) && tbFeatures.size() > 0 && !((Map)tbFeatures.get(0)).isEmpty()) {
                for (Map tb : tbFeatures) {
                    detailMap = new HashMap<String, Object>();
                    HashMap<String, Object> kctbMap = new HashMap<String, Object>();
                    String kcdlbm = MapUtils.getString((Map)tb, (Object)WCFTag.KCDLBM.name());
                    double tkmj = MapUtils.getDoubleValue((Map)tb, (Object)WCFTag.TKMJ.name(), (double)0.0);
                    if (!this.isNull((Object)kcdlbm) && tkmj > 0.0) {
                        kctbMap.put("CCMJ", tkmj);
                        kctbMap.put("QSDWDM", MapUtils.getString((Map)tb, (Object)WCFTag.QSDWDM.name()));
                        kctbMap.put("QSDWMC", MapUtils.getString((Map)tb, (Object)WCFTag.QSDWMC.name()));
                        kctbMap.put("DLBM", kcdlbm);
                        kctbMap.put("DLMC", EnumUtils.findByDlbm((String)kcdlbm).name());
                        kctbMap.put("QSXZ", MapUtils.getString((Map)tb, (Object)"QSXZ"));
                        detailList.add(kctbMap);
                    }
                    detailMap.put("CCMJ", MapUtils.getDoubleValue((Map)tb, (Object)WCFTag.TBDLMJ.name(), (double)0.0));
                    detailMap.put("QSDWDM", MapUtils.getString((Map)tb, (Object)WCFTag.QSDWDM.name()));
                    detailMap.put("QSDWMC", MapUtils.getString((Map)tb, (Object)WCFTag.QSDWMC.name()));
                    detailMap.put("DLBM", MapUtils.getString((Map)tb, (Object)"DLBM"));
                    detailMap.put("DLMC", MapUtils.getString((Map)tb, (Object)"DLMC"));
                    detailMap.put("QSXZ", MapUtils.getString((Map)tb, (Object)"QSXZ"));
                    detailList.add(detailMap);
                }
            }
            if (!this.isNull((Object)xwFeatures) && xwFeatures.size() > 0 && !((Map)xwFeatures.get(0)).isEmpty()) {
                for (Map xw : xwFeatures) {
                    detailMap = new HashMap();
                    detailMap.put("CCMJ", MapUtils.getDoubleValue((Map)xw, (Object)WCFTag.XZDWMJ.name(), (double)0.0));
                    detailMap.put("QSDWDM", MapUtils.getString((Map)xw, (Object)WCFTag.QSDWDM1.name()));
                    detailMap.put("QSDWMC", MapUtils.getString((Map)xw, (Object)WCFTag.QSDWMC1.name()));
                    detailMap.put("DLBM", MapUtils.getString((Map)xw, (Object)"DLBM"));
                    detailMap.put("DLMC", MapUtils.getString((Map)xw, (Object)"DLMC"));
                    detailMap.put("QSXZ", MapUtils.getString((Map)xw, (Object)"QSXZ"));
                    detailList.add(detailMap);
                }
            }
            for (Object key : dlbmSummary.keySet()) {
                String dlbm = String.valueOf(key).substring(4);
                analysisArea.put(this.getDlmc(detailList, dlbm), dlbmSummary.get(key));
            }
            HashMap<String, Cloneable> result = new HashMap<String, Cloneable>();
            result.put("analysisAreaDetail", detailList);
            result.put("analysisArea", analysisArea);
            return result;
        }
        catch (Exception e) {
            this.logger.error(this.getMessage("tdlyxz.wcf.error", new Object[]{e.getLocalizedMessage()}));
            throw new RuntimeException(this.getMessage("tdlyxz.wcf.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    public String getDlmc(List<Map> list, String dm) {
        for (Map entry : list) {
            String dlbm = MapUtils.getString((Map)entry, (Object)"DLBM");
            if (!dlbm.equals(dm)) continue;
            return MapUtils.getString((Map)entry, (Object)"DLMC");
        }
        return dm;
    }

    public Map tdlyxzAnalysisByWcf(String year, String geometry, String wcfUrl, String wcfMethod) {
        String dltb = TDXZ.DLTB.name().concat("_H_").concat(year);
        String xzdw = TDXZ.XZDW.name().concat("_H_").concat(year);
        return this.tdlyxzAnalysisByWcf(dltb, xzdw, geometry, wcfUrl, wcfMethod);
    }

    public Map singleJctbAnalysis(SimpleFeature feature, List analysisLayers, String dataSource, Map unit) {
        HashMap<String, Object> result = null;
        double conv = UNITS.access$100((UNITS)UNITS.ACRES);
        HashMap<String, List> analysisMap = new HashMap<String, List>();
        DecimalFormat df_jctb = new DecimalFormat("0.0");
        if (!this.isNull((Object)unit)) {
            df_jctb.applyPattern(MapUtils.getString((Map)unit, (Object)"format", (String)"0.0"));
            String ualias = MapUtils.getString((Map)unit, (Object)"alias");
            for (UNITS us : UNITS.values()) {
                if (!UNITS.access$400((UNITS)us).equals(ualias)) continue;
                conv = UNITS.access$100((UNITS)us);
                break;
            }
        }
        try {
            String dltbLyr = null;
            String xzdwLyr = null;
            String bpLyr = null;
            for (int i = 0; i < analysisLayers.size(); ++i) {
                Map layer = (Map)analysisLayers.get(i);
                String lyrId = layer.get("id").toString();
                if (lyrId.equals("dltb")) {
                    dltbLyr = String.valueOf(layer.get("layerName"));
                    continue;
                }
                if (lyrId.equals("xzdw")) {
                    xzdwLyr = String.valueOf(layer.get("layerName"));
                    continue;
                }
                if (lyrId.equals("bpdk")) {
                    bpLyr = MapUtils.getString((Map)layer, (Object)"layerName");
                }
                String lyrName = (String)layer.get("layerName");
                String outFields = layer.get("fields").toString();
                String[] fields = "*".equals(outFields) ? null : outFields.split(",");
                List analysisList = this.intersectBySimpleFeature(lyrName, feature, fields, dataSource);
                analysisMap.put(lyrId.toUpperCase(), analysisList);
                this.logger.info("[" + lyrId.toUpperCase() + "]\u5206\u6790\u7ed3\u679c\u6570:" + analysisList.size());
            }
            Map tdlyxzMap = this.tdlyxzAnalysis2(dltbLyr, xzdwLyr, this.geometryService.toFeatureJSON((Object)feature), dataSource);
            Map tdlyxzAnalysisArea = (Map)tdlyxzMap.get("analysisArea");
            if (!tdlyxzAnalysisArea.isEmpty()) {
                for (Object key : tdlyxzAnalysisArea.keySet()) {
                    this.logger.info("[tdlyxz]\u5206\u6790\u7ed3\u679c:" + key + tdlyxzAnalysisArea.get(key));
                }
            }
            List bpList = (List)analysisMap.get(JCTB.BPDK.name());
            List gdList = (List)analysisMap.get(JCTB.GDDK.name());
            List jsydgzqList = (List)analysisMap.get(JCTB.JSYDGZQ.name());
            List tdytqList = (List)analysisMap.get(JCTB.TDYTQ.name());
            List ssnydList = (List)analysisMap.get(JCTB.SSNYD.name());
            List lsydList = (List)analysisMap.get(JCTB.LSYD.name());
            double lsydBpArea = this.getIntersectArea(lsydList, bpLyr, dataSource) * conv;
            double ssnydBpArea = this.getIntersectArea(ssnydList, bpLyr, dataSource) * conv;
            result = new HashMap<String, Object>();
            for (Property p : feature.getProperties()) {
                if (p.getName().getLocalPart().equals("geometry") || p.getName().getLocalPart().equals("crs")) continue;
                result.put("OG_PRO_".concat(p.getName().getLocalPart()), p.getValue());
            }
            double geoArea = MapUtils.getDoubleValue(result, (Object)"OG_PRO_".concat("JCMJ"), (double)0.0);
            if (geoArea == 0.0) {
                geoArea = this.getAreaByGeometry((Object)feature, conv);
            }
            result.put(JTag.JC_GD_AREA.name(), df_jctb.format((MapUtils.getDouble((Map)tdlyxzAnalysisArea, (Object)"\u6c34\u7530", (Double)0.0) + MapUtils.getDouble((Map)tdlyxzAnalysisArea, (Object)"\u6c34\u6d47\u5730", (Double)0.0) + MapUtils.getDouble((Map)tdlyxzAnalysisArea, (Object)"\u65f1\u5730", (Double)0.0)) * conv));
            result.put(JTag.BP_AREA.name(), df_jctb.format(this.getAreaByList(bpList, conv)));
            result.put(JTag.BP_GD_AREA.name(), df_jctb.format(this.getBpGdArea(bpList, dltbLyr, xzdwLyr, dataSource) * conv));
            result.put(JTag.YG_AREA.name(), df_jctb.format(this.getAreaByList(gdList, conv)));
            result.put(JTag.WG_AREA.name(), df_jctb.format(geoArea - MapUtils.getDouble(result, (Object)JTag.YG_AREA.name(), (Double)0.0) < 0.0 ? 0.0 : geoArea - MapUtils.getDouble(result, (Object)JTag.YG_AREA.name(), (Double)0.0)));
            result.put(JTag.WPYJ_AREA.name(), df_jctb.format(geoArea - MapUtils.getDouble(result, (Object)JTag.BP_AREA.name(), (Double)0.0) < 0.0 ? 0.0 : geoArea - MapUtils.getDouble(result, (Object)JTag.BP_AREA.name(), (Double)0.0)));
            result.put(JTag.WPYJ_GD_AREA.name(), df_jctb.format(MapUtils.getDouble(result, (Object)JTag.JC_GD_AREA.name(), (Double)0.0) - MapUtils.getDouble(result, (Object)JTag.BP_GD_AREA.name(), (Double)0.0) < 0.0 ? 0.0 : MapUtils.getDouble(result, (Object)JTag.JC_GD_AREA.name(), (Double)0.0) - MapUtils.getDouble(result, (Object)JTag.BP_GD_AREA.name(), (Double)0.0)));
            result.put(JTag.YXJSQ_AREA.name(), df_jctb.format(this.getAreaByField(jsydgzqList, "GZQLXDM", "010", conv)));
            result.put(JTag.JBNT_AREA.name(), df_jctb.format(this.getAreaByField(tdytqList, "TDYTQLXDM", "010", conv)));
            result.put(JTag.YBNTQ_AREA.name(), df_jctb.format(this.getAreaByField(tdytqList, "TDYTQLXDM", "020", conv)));
            result.put(JTag.PCMC.name(), this.getStrValueByField(bpList, "PCJC"));
            result.put(JTag.NZYPW.name(), this.getStrValueByField(bpList, "PZWH"));
            result.put(JTag.GDBH.name(), this.getStrValueByField(gdList, "XMBH"));
            result.put(JTag.LSYD_AREA.name(), df_jctb.format(this.getAreaByList(lsydList, conv) - lsydBpArea));
            result.put(JTag.SSNYD_AREA.name(), df_jctb.format(this.getAreaByList(ssnydList, conv) - ssnydBpArea));
            result.put(JTag.LSYD_BH.name(), this.getStrValueByField(lsydList, "BH"));
            result.put(JTag.SSNYD_BH.name(), this.getStrValueByField(ssnydList, "BH"));
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return result;
    }

    public double getBpGdArea(List<Map> list, String dltb, String xzdw, String dataSource) {
        double area = 0.0;
        try {
            for (Map map : list) {
                String wktPolygon = String.valueOf(map.get("SHAPE"));
                Map tdlyxzMap = this.tdlyxzAnalysis2(dltb, xzdw, this.geometryService.toGeoJSON(this.geometryService.readWKT(wktPolygon)), dataSource);
                Map tdlyxzAnalysisArea = (Map)tdlyxzMap.get("analysisArea");
                area += MapUtils.getDouble((Map)tdlyxzAnalysisArea, (Object)"\u6c34\u7530", (Double)0.0) + MapUtils.getDouble((Map)tdlyxzAnalysisArea, (Object)"\u6c34\u6d47\u5730", (Double)0.0) + MapUtils.getDouble((Map)tdlyxzAnalysisArea, (Object)"\u65f1\u5730", (Double)0.0);
            }
        }
        catch (GeometryServiceException e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return area;
    }

    public double getIntersectArea(List<Map> list, String layerName, String dataSource) {
        double area = 0.0;
        try {
            for (Map map : list) {
                String wktPolygon = MapUtils.getString((Map)map, (Object)"SHAPE");
                List intersectResult = this.intersect(layerName, wktPolygon, null, dataSource);
                if (this.isNull((Object)intersectResult) || intersectResult.size() <= 0) continue;
                area += this.getAreaByList(intersectResult, 1.0);
            }
        }
        catch (GeometryServiceException e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return area;
    }

    public double getAreaByList(List<Map> list, double conv) {
        if (this.isNull((Object)conv)) {
            conv = 1.0;
        }
        double area = 0.0;
        for (Map map : list) {
            double value = (Double)map.get("SHAPE_AREA");
            area += value;
        }
        return area * conv;
    }

    public double getAreaByGeometry(Object geo, double conv) {
        if (this.isNull((Object)conv)) {
            conv = 1.0;
        }
        double area = 0.0;
        try {
            SimpleFeature feature = null;
            if (geo instanceof SimpleFeature) {
                feature = (SimpleFeature)geo;
                CoordinateReferenceSystem sourceCRS = feature.getFeatureType().getCoordinateReferenceSystem();
                CoordinateReferenceSystem targetCrs = this.geometryService.parseUndefineSR("2364");
                Geometry geometry = (Geometry)feature.getDefaultGeometry();
                if (sourceCRS != null && sourceCRS instanceof GeographicCRS) {
                    geometry = this.geometryService.project((Geometry)feature.getDefaultGeometry(), sourceCRS, targetCrs);
                }
                area = this.isPolygon(geometry) ? geometry.getArea() : geometry.getLength();
            } else if (geo instanceof FeatureCollection) {
                FeatureIterator iterator = ((FeatureCollection)geo).features();
                while (iterator.hasNext()) {
                    feature = (SimpleFeature)iterator.next();
                    area += this.getAreaByGeometry((Object)feature, conv);
                }
            } else if (geo instanceof Geometry) {
                Geometry temp = (Geometry)geo;
                area = this.isPolygon(temp) ? temp.getArea() : temp.getLength();
            }
        }
        catch (GeometryServiceException e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return area * conv;
    }

    public double getAreaByMapKeys(Map map, List keys, double conv) {
        if (this.isNull((Object)conv)) {
            conv = 1.0;
        }
        assert (map != null);
        assert (keys != null);
        double area = 0.0;
        for (Object key : map.keySet()) {
            if (!keys.contains(key)) continue;
            area += MapUtils.getDouble((Map)map, key, (Double)0.0).doubleValue();
        }
        return area * conv;
    }

    public double getAreaByField(List<Map> list, String field, String value, double conv) {
        if (this.isNull((Object)conv)) {
            conv = 1.0;
        }
        assert (field != null);
        assert (value != null);
        double area = 0.0;
        List<String> values = Arrays.asList(value.split(","));
        for (Map map : list) {
            if (!values.contains(map.get(field))) continue;
            area += ((Double)map.get("SHAPE_AREA")).doubleValue();
        }
        return area * conv;
    }

    public String getStrValueByField(List<Map> list, String field) {
        StringBuilder sb = new StringBuilder();
        assert (field != null);
        for (Map map : list) {
            if (!map.containsKey(field)) continue;
            if (StringUtils.isNotBlank((String)sb.toString())) {
                sb.append(",");
            }
            if (this.isNull(map.get(field))) continue;
            sb.append(map.get(field));
        }
        return sb.toString();
    }

    public double getDouValueByField(List<LinkedHashMap> list, String field) {
        double value = 0.0;
        assert (field != null);
        for (Map map : list) {
            if (this.isNull(map.get(field))) continue;
            value += MapUtils.getDouble((Map)map, (Object)field, (Double)0.0).doubleValue();
        }
        return value;
    }

    public double getDouValueByField2(List<Map> list, String field) {
        double value = 0.0;
        assert (field != null);
        for (Map map : list) {
            if (this.isNull(map.get(field))) continue;
            value += Double.valueOf(map.get(field).toString()).doubleValue();
        }
        return value;
    }

    public double getXzdwAreaByField(List<Map> list, String field, String value, double conv) {
        if (this.isNull((Object)conv)) {
            conv = 1.0;
        }
        double area = 0.0;
        List<String> values = Arrays.asList(value.split(","));
        if (this.isNull(list)) {
            return area * conv;
        }
        for (Map map : list) {
            if (!values.contains(map.get(field))) continue;
            area += this.getXzdwArea((Object)map, 1.0);
        }
        return area * conv;
    }

    public double getXzdwArea(Object xzdw, double conv) {
        if (this.isNull((Object)conv)) {
            conv = 1.0;
        }
        double area = 0.0;
        Map map = null;
        try {
            if (xzdw instanceof Map) {
                map = (Map)xzdw;
                double length = Double.parseDouble(String.valueOf(map.get("SHAPE_AREA")));
                double kd = Double.parseDouble(String.valueOf(map.get("KD")));
                area = length * kd;
            } else if (xzdw instanceof List) {
                List list = (List)xzdw;
                for (int i = 0; i < list.size(); ++i) {
                    map = (Map)list.get(i);
                    area += this.getXzdwArea((Object)map, 1.0);
                }
            }
        }
        catch (NumberFormatException e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return area * conv;
    }

    private BufferedImage getExportImage(Envelope envelope, String url, String imageSize, double mapScale) {
        BufferedImage image = null;
        String bbox = "bbox=" + envelope.getMinX() + "," + envelope.getMinY() + "," + envelope.getMaxX() + "," + envelope.getMaxY();
        String size = "size=" + imageSize;
        StringBuilder exportUrl = new StringBuilder();
        exportUrl.append(url);
        exportUrl.append("/export?");
        exportUrl.append(bbox);
        exportUrl.append("&");
        exportUrl.append(size);
        exportUrl.append("&");
        exportUrl.append("&");
        if (mapScale > 0.0) {
            exportUrl.append("mapScale=" + mapScale);
        }
        exportUrl.append("&");
        exportUrl.append("transparent=true&");
        exportUrl.append("format=png&");
        exportUrl.append("f=image");
        HttpClient httpClient = new HttpClient();
        GetMethod getMethod = new GetMethod(exportUrl.toString());
        try {
            httpClient.executeMethod((HttpMethod)getMethod);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(getMethod.getResponseBody());
            if (((InputStream)inputStream).available() > 0) {
                image = ImageIO.read(inputStream);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return image;
    }

    private double getTotalArea(JSONArray features) {
        double area = 0.0;
        for (int i = 0; i < features.size(); ++i) {
            JSONObject object = (JSONObject)features.get(i);
            JSONObject property = (JSONObject)object.get((Object)"properties");
            area += Double.parseDouble(property.get((Object)"SHAPE_AREA").toString());
        }
        return area;
    }

    private double getAreaByLxdm(String field, JSONArray features, String lxdm) {
        double area = 0.0;
        for (int i = 0; i < features.size(); ++i) {
            JSONObject object = (JSONObject)features.get(i);
            JSONObject property = (JSONObject)object.get((Object)"properties");
            if (property.get((Object)field) == null) {
                return 0.0;
            }
            if (!property.get((Object)field).equals(lxdm)) continue;
            area += Double.parseDouble(property.get((Object)"SHAPE_AREA").toString());
        }
        return area;
    }

    private String getWhereClause(String[] fields, String keyword) {
        String or = " or ";
        StringBuilder b = new StringBuilder();
        for (String field : fields) {
            b.append(field);
            b.append(" like '");
            b.append(keyword);
            b.append("%'");
            b.append(or);
        }
        b.delete(b.length() - or.length(), b.length());
        return b.toString();
    }

    private Map<String, Object> geoJSON2Map(String geoJSON, CoordinateReferenceSystem targetCRS) {
        Object geo = this.geometryService.readUnTypeGeoJSON(geoJSON);
        Map<String, Object> columns = null;
        if (geo instanceof Geometry) {
            columns = new HashMap<String, Object>();
            columns.put("SHAPE", ((Geometry)geo).toText());
        } else if (geo instanceof SimpleFeature) {
            SimpleFeature feature = (SimpleFeature)geo;
            CoordinateReferenceSystem sourceCRS = this.geometryService.readFeatureJSONCRS(geoJSON);
            columns = this.geometryService.simpleFeature2Map(feature);
            try {
                for (String key : columns.keySet()) {
                    if (!(columns.get(key) instanceof Geometry)) continue;
                    Geometry geometry = (Geometry)columns.get(key);
                    if (targetCRS != null && sourceCRS != null) {
                        geometry = this.geometryService.project(geometry, sourceCRS, targetCRS);
                    }
                    columns.put("SHAPE", geometry.toText());
                    columns.remove(key);
                }
            }
            catch (Exception e) {
                this.logger.error(e.getLocalizedMessage());
                throw new RuntimeException(e.getLocalizedMessage());
            }
        } else {
            if (geo instanceof GeometryCollection) {
                throw new RuntimeException("current omp version don't support GeometryCollection ");
            }
            if (geo instanceof FeatureCollection) {
                throw new RuntimeException("current omp version don't support FeatureCollection ");
            }
            throw new RuntimeException(this.getMessage("geometry.undefined", new Object[0]));
        }
        return columns;
    }

    private Geometry setFeaturePros2Geo(SimpleFeature feature, Geometry geometry) {
        HashMap<String, Object> map = null;
        if (geometry instanceof GeometryCollection) {
            for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                Geometry geo = geometry.getGeometryN(i);
                map = new HashMap();
                for (Property p : feature.getProperties()) {
                    if (p.getName().equals((Object)"geometry")) continue;
                    map.put(p.getName().getLocalPart(), p.getValue());
                }
                geo.setUserData(map);
            }
        } else {
            map = new HashMap<String, Object>();
            for (Property p : feature.getProperties()) {
                if (p.getName().getLocalPart().equals("geometry")) continue;
                map.put(p.getName().getLocalPart(), p.getValue());
            }
            geometry.setUserData(map);
        }
        return geometry;
    }

    private List<?> addGeoProperty2List(List<Map<String, Object>> list, Geometry geometry) {
        if (geometry.getUserData() == null) {
            return list;
        }
        for (Map<String, Object> item : list) {
            Map pros = (Map)geometry.getUserData();
            for (Map.Entry entry : pros.entrySet()) {
                item.put("G_".concat((String)entry.getKey()), entry.getValue());
            }
        }
        return list;
    }

    private List<Map> getTdlyxzDictList(String tpl) {
        ArrayList<Map> groupList = new ArrayList<Map>();
        try {
            Configuration configuration = this.webMapService.getConfig(tpl);
            List dicts = configuration.getDicts();
            for (Dict dict : dicts) {
                if (!"tdlyxz".equals(dict.getName())) continue;
                List dictItems = dict.getDictItems();
                for (Item item : dictItems) {
                    HashMap<String, Object> temp = new HashMap<String, Object>();
                    temp.put("dlbm", item.getName());
                    temp.put("dlmc", item.getTitle());
                    temp.put("area", 0);
                    groupList.add(temp);
                }
            }
        }
        catch (Exception e) {
            this.logger.error(this.getMessage("get.dict.error", new Object[]{tpl}));
            throw new RuntimeException(this.getMessage("get.dict.error", new Object[]{tpl}));
        }
        if (groupList.size() == 0) {
            this.logger.error(this.getMessage("get.dict.error", new Object[]{tpl}));
            throw new RuntimeException(this.getMessage("get.dict.error", new Object[]{tpl}));
        }
        return groupList;
    }

    private boolean checkFieldInLayer(String field, String layerName, String dataSource) {
        return ArrayUtils.contains((String[])this.spatialDao.getLayerColumns(layerName, dataSource), (String)field, (boolean)true);
    }

    private boolean isPolygon(Geometry geometry) {
        String geometryType = geometry.getGeometryType();
        if (geometryType.equals(Geometries.POLYGON.getName()) || geometryType.equals(Geometries.MULTIPOLYGON.getName())) {
            return true;
        }
        if (geometryType.equals(Geometries.LINESTRING.getName()) || geometryType.equals(Geometries.MULTILINESTRING.getName())) {
            return false;
        }
        if (geometryType.equals(Geometries.GEOMETRYCOLLECTION.getName())) {
            return geometry.getArea() > 0.0;
        }
        return false;
    }
}

