/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.controller.portal2;

import cn.gtmap.onemap.platform.entity.ThematicMap;
import cn.gtmap.onemap.platform.entity.TplType;
import cn.gtmap.onemap.platform.event.JSONMessageException;
import cn.gtmap.onemap.platform.service.MapService;
import cn.gtmap.onemap.platform.service.ThematicMapService;
import cn.gtmap.onemap.platform.service.TplTypeService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"portal2/tpl"})
public class TplsController {
    @Autowired
    TplTypeService tplTypeService;
    @Autowired
    ThematicMapService thematicMapService;
    @Autowired
    private MapService mapService;

    @RequestMapping(value={"index"})
    public String tplTypes(Model model) {
        model.addAttribute("types", (Object)this.thematicMapService.getAll());
        return "portal2/tpl/types";
    }

    @Deprecated
    @RequestMapping(value={"list"})
    public String list(Model model, @RequestParam(value="typeId") String typeId) {
        TplType type = this.tplTypeService.getTplType(typeId);
        model.addAttribute("tpls", (Object)this.tplTypeService.getTplByType(type.getId()));
        model.addAttribute("type", (Object)type);
        return "portal2/tpl/list";
    }

    @RequestMapping(value={"/tree"})
    public String treeList(Model model, @RequestParam(value="typeId") String typeId) {
        ThematicMap thematicMap = (ThematicMap)this.thematicMapService.getById(typeId);
        model.addAttribute("tpl", (Object)thematicMap.getTpl());
        model.addAttribute("type", (Object)thematicMap);
        return "portal2/tpl/treeList";
    }

    @RequestMapping(value={"/{tpl}/specialServices"})
    @ResponseBody
    public List specialServices(@PathVariable String tpl) throws Exception {
        try {
            return this.tplTypeService.getSpecialServices(tpl);
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }
}

