/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.controller;

import cn.gtmap.onemap.model.Field;
import cn.gtmap.onemap.model.Map;
import cn.gtmap.onemap.platform.entity.Function;
import cn.gtmap.onemap.platform.service.MapService;
import cn.gtmap.onemap.platform.support.spring.BaseController;
import cn.gtmap.onemap.service.MetadataService;
import com.alibaba.fastjson.JSON;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

public class PortalController
extends BaseController {
    @Autowired
    private MetadataService metadataService;
    @Autowired
    private MapService mapService;

    @RequestMapping(value={"/fields/{layerId}"})
    @ResponseBody
    public List<Field> getFields(@PathVariable(value="layerId") String layerId) {
        try {
            return this.metadataService.getFields(layerId);
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            return null;
        }
    }

    @RequestMapping(value={"/{tpl}/function/save"})
    @ResponseBody
    public String insertFunction(@PathVariable String tpl, @RequestParam(value="serviceId") String serviceId, @RequestParam(value="type") int type, @RequestParam(value="functionStr") String functionStr) {
        try {
            Function function = (Function)JSON.parseObject((String)functionStr, Function.class);
            if (this.mapService.getFunctionByType(serviceId, type, tpl) == null) {
                this.mapService.saveFunction(function, serviceId, tpl);
                return "\u4fdd\u5b58\u529f\u80fd\u6210\u529f";
            }
            return "\u529f\u80fd\u5df2\u5b58\u5728";
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            return "\u4fdd\u5b58\u529f\u80fd\u5f02\u5e38";
        }
    }

    @RequestMapping(value={"/getMap/{mapId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Map getMap(@PathVariable String mapId) {
        Map map = this.metadataService.getMap(mapId);
        map.removeAttribute("layers");
        map.removeAttribute("serviceProvider");
        return map;
    }
}

