/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.controller;

import cn.gtmap.onemap.platform.entity.Configuration;
import cn.gtmap.onemap.platform.entity.LocationMark;
import cn.gtmap.onemap.platform.event.GISDaoException;
import cn.gtmap.onemap.platform.event.JSONMessageException;
import cn.gtmap.onemap.platform.service.GISManager;
import cn.gtmap.onemap.platform.service.LocationMarkService;
import cn.gtmap.onemap.platform.service.MapService;
import cn.gtmap.onemap.platform.service.QueryService;
import cn.gtmap.onemap.platform.service.SearchService;
import cn.gtmap.onemap.platform.service.WebMapService;
import cn.gtmap.onemap.platform.support.spring.BaseController;
import cn.gtmap.onemap.platform.utils.Utils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.esri.sde.sdk.client.SeError;
import com.esri.sde.sdk.client.SeException;
import com.gtis.common.util.UUIDGenerator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/map"})
public class MapController
extends BaseController {
    @Autowired
    private WebMapService webMapService;
    @Autowired
    private MapService mapService;
    @Autowired
    private LocationMarkService locationMarkService;
    @Autowired
    private QueryService queryService;
    @Autowired
    private GISManager gisManager;
    @Autowired
    private SearchService searchService;

    @RequestMapping(value={"/{tpl}"}, method={RequestMethod.GET})
    public String index(@PathVariable String tpl, Model model) {
        model.addAttribute("tpl", (Object)tpl);
        return "map";
    }

    @RequestMapping(value={"/{tpl}/config"})
    @ResponseBody
    public Configuration config(@PathVariable String tpl) throws Exception {
        try {
            Assert.notNull((Object)tpl, (String)this.getMessage("map.tpl.notnull", new Object[0]));
            return this.webMapService.getConfig(tpl);
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/{tpl}/regioncode"})
    @ResponseBody
    public Map regionCode(@PathVariable String tpl, @RequestParam(value="regionCode") String regionCode, @RequestParam(value="sr", required=false) String sr, @RequestParam(value="year", defaultValue="current", required=false) String year) {
        try {
            return this.webMapService.getRegionInfo(Utils.formatRegionCode((String)regionCode), sr);
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("map.regioncode.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @Deprecated
    @RequestMapping(value={"/{tpl}/regionshape"})
    @ResponseBody
    public Map regionShape(@PathVariable String tpl, @RequestParam(value="regionCode") String regionCode) {
        try {
            return this.webMapService.getRegionInfo(regionCode, tpl);
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("map.regioncode.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/{tpl}/services"})
    @ResponseBody
    public Object getServices(@PathVariable String tpl, @RequestParam(value="simple", required=false) Boolean simple) {
        try {
            return this.webMapService.getServicesWithClassify(tpl, !this.isNull((Object)simple) && simple != false ? WebMapService.SC_MODE.SIMPLIFY : WebMapService.SC_MODE.NORMAL);
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("map.services.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/mark/{id}"})
    @ResponseBody
    public LocationMark getLocationMark(@PathVariable String id) {
        try {
            Assert.notNull((Object)id, (String)this.getMessage("id.notnull", new Object[0]));
            return this.locationMarkService.get(id);
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("map.locationMark.error", new Object[]{id, e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/mark/{owner}/marks"})
    @ResponseBody
    public List<LocationMark> getLocationMarks(@PathVariable String owner, @RequestParam(value="publicity") String publicity) {
        try {
            Assert.notNull((Object)owner, (String)"owner can't be null");
            return this.locationMarkService.getLocationMarksByOwnerOrPublicity(owner, publicity);
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("map.locationMark.error", new Object[]{owner, e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/mark/{owner}/save"})
    @ResponseBody
    public void save(@PathVariable(value="owner") String owner, @RequestParam(value="data") String data) {
        try {
            Assert.notNull((Object)owner, (String)"owner can't be null");
            LocationMark locationMark = (LocationMark)JSONObject.parseObject((String)data, LocationMark.class);
            if (StringUtils.isBlank((String)locationMark.getId())) {
                locationMark.setId(UUIDGenerator.generate());
            }
            if (locationMark.getCreateAt() == null) {
                locationMark.setCreateAt(new Date());
            }
            this.locationMarkService.save(locationMark);
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("map.locationMarkSave.error", new Object[]{owner, e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/mark/{id}/delete"})
    @ResponseBody
    public void delete(@PathVariable String id) {
        try {
            Assert.notNull((Object)id, (String)this.getMessage("id.notnull", new Object[0]));
            this.locationMarkService.delete(id);
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("map.locationMarkDelete.error", new Object[]{id, e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/query"})
    @ResponseBody
    public String query(@RequestParam(value="serverType") String serverType, @RequestParam(value="url") String url, HttpServletRequest request) {
        String result = null;
        try {
            Assert.notNull((Object)serverType, (String)"serverType can't be null");
            Assert.notNull((Object)url, (String)"url can't be null");
            this.logger.debug("do query : [{}]", (Object)url);
            if ("ags".equals(serverType)) {
                result = this.queryService.executeAgsQuery(url, null, request);
            } else if ("gtmap".equals(serverType)) {
                result = this.queryService.executeGtMapQuery(url, null);
            }
            this.logger.debug("query result [{}]", (Object)result);
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("map.query.error", new Object[]{serverType, e.getLocalizedMessage()}));
        }
        return result;
    }

    @RequestMapping(value={"/sde/config"})
    @ResponseBody
    public Object sdeConfig(@RequestParam(value="server") String server, @RequestParam(value="port") int port, @RequestParam(value="password") String password, @RequestParam(value="database") String database) {
        try {
            return this.gisManager.getSdeManager().getConfiguration(server, port, password);
        }
        catch (SeException e) {
            throw new JSONMessageException(GISDaoException.formateSeError((SeError)e.getSeError()));
        }
    }

    @RequestMapping(value={"/sde/start"})
    @ResponseBody
    public void sdeStart(@RequestParam(value="server") String server, @RequestParam(value="port") int port, @RequestParam(value="password") String password, @RequestParam(value="database") String database) {
        try {
            this.gisManager.getSdeManager().startInstance(server, port, database, password);
        }
        catch (SeException e) {
            throw new JSONMessageException(GISDaoException.formateSeError((SeError)e.getSeError()));
        }
    }

    @RequestMapping(value={"/sde/stop"})
    @ResponseBody
    public void sdeStop(@RequestParam(value="server") String server, @RequestParam(value="port") int port, @RequestParam(value="password") String password, @RequestParam(value="database") String database) {
        try {
            this.gisManager.getSdeManager().stopInstance(server, port, password);
        }
        catch (SeException e) {
            throw new JSONMessageException(GISDaoException.formateSeError((SeError)e.getSeError()));
        }
    }

    @RequestMapping(value={"/search"})
    @ResponseBody
    public List search(@RequestParam(value="q", required=true) String value, @RequestParam(value="s", defaultValue="true") boolean simple, @RequestParam(value="l", defaultValue="10") int limit) {
        return this.searchService.search(value, limit, simple);
    }

    @RequestMapping(value={"/search/groups"})
    @ResponseBody
    public String[] searchGroups() {
        return this.searchService.groups();
    }

    @RequestMapping(value={"/agsurl"})
    @ResponseBody
    public Map getAgsRealUrl(@RequestParam(value="layers") String layers) {
        try {
            return this.mapService.getAGSRealPath((List)JSON.parseObject((String)layers, List.class));
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/{tpl}/clearServiceCache"})
    @ResponseBody
    public boolean clearServiceCache(@PathVariable(value="tpl") String tpl) {
        try {
            return this.webMapService.clearServiceCache(tpl);
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/{tpl}/clearRegionCache"})
    @ResponseBody
    public boolean clearRegionCache() {
        try {
            return this.webMapService.clearRegionCache();
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }
}

