/**
 *
 * Created by alex on 2017/7/22.
 * portal 首页
 */
layui.define(['jquery', 'layer', 'element', 'form', 'upload', 'table'], function (exports) {
    // 引入此模块对应的样式文件
    layui.link('/oma/static/css/portal.css');

    var layer = layui.layer,
        form = layui.form, table = layui.table,
        $ = layui.jquery,
        upload = layui.upload;

    var viewModel;//模板渲染数据
    var featureCollection; //导入解析出的全部数据
    var analysisAll = false;//是否分析全部图形
    var analysisFeatures = []; //待分析数据
    var crs = null;

    /**
     * 初始化渲染模板
     */
    function initViewModel(data) {
        if (data.features && data.features.length > 0) {
            featureCollection = data.features;
        }
        viewModel = {
            models: ko.observableArray(data.models || []),
            // features: ko.observableArray(data.features || []),
            reportInfo: ko.observableArray(data.report === undefined ? undefined : [data.report]),
            clearable: ko.observable(false),
            defaultName: '导入地块'
        };
        ko.applyBindings(viewModel);
    }

    /**
     * 初始化文件上传
     */
    function initUpload() {
        upload.render({
            elem: "#upfile",
            url: '/oma/portal/upload',
            title: '导入文件',
            accept: 'file',
            exts: 'txt|xls|xlsx|zip|dwg|ZIP',
            before: function () {
                showMsg('文件解析中...', false);
            },
            done: function (ret) {
                layer.closeAll();
                if (ret.hasOwnProperty("success")) {
                    showMsg(ret.msg, 2000, 5, 6);
                    return;
                }
                var fc = ret.feature;
                crs = fc.crs;
                if (crs === undefined) {
                    crs = {type: 'name', properties: {name: 'EPSG:2364'}};
                }
                layui.each(fc.features, function (index, item) {
                    item.crs = crs;
                });
                featureCollection = fc.features;
                // viewModel.features(featureCollection);
                if (ret.hasOwnProperty("report")) {
                    viewModel.reportInfo([ret.report]);
                } else {
                    viewModel.reportInfo([]);
                }

                initTable();
                initTips();
                form.render();
            }
        });
    }

    /**
     * 初始化tooltip
     */
    function initTips() {

        $(".btn-sketch").on('mouseenter', function () {
            layer.tips($(this).attr('layer-tip'), $(this), {tips: 2});
        });

        /**
         * $(".btn-sketch").off('click').on('click', function () {
            var index = $(this).data("index");
            layui.data('localData', {key:'sketch', value: featureCollection[index]});
            layer.open({
                type: 2,
                title: "图形",
                skin: 'layui-layer-molv',
                area: ['600px', '450px'],
                content: '/oma/portal/sketch'
            });
        });*/
    }

    /**
     * 初始化表格
     */
    function initTable(queryData) {
        table.render({
            id: 'itable',
            elem: '#itable',
            limit: queryData ? queryData.length : featureCollection ? featureCollection.length : 0,
            data: queryData ? queryData : featureCollection,
            cols: [[
                {type: 'checkbox', fixed: 'left', width: '5%', LAY_CHECKED: false}
                , {field: 'Name', title: '地块名称', width: '30%', align: 'left', unresize: true, templet: '#nameTpl'}
                , {field: 'Area', title: '地块面积(平方米)', width: '40%', align: 'left', unresize: true, templet: '#areaTpl'}
                , {fixed: 'right', title: '位置图', toolbar: '#barDemo', width: '25%', align: 'left', unresize: true}
            ]]
        });

    }

    /**
     * 初始化事件监听
     */
    function initListener(props) {
        //查询按钮监听
        $("#searchBtn").on('click', function () {
            var searchStr = $("#searchInput").val();
            if (searchStr != '') {
                showMsg('查询中...', false);
                var arr = ko.utils.arrayFilter(featureCollection, function (el, index) {
                    var props = el.properties;
                    for (var k in props) {
                        if (typeof props[k] === 'string') {
                            if (props[k].toString().indexOf(searchStr) > -1) {
                                return true;
                            }
                        }
                    }
                });
                layer.closeAll();

                if (arr.length > 0) {
                    analysisFeatures = [];
                    // viewModel.features(arr);
                    clearChecked();
                    initTable(arr);
                    viewModel.clearable(true);
                }
            }
        });
        //拓扑检查按钮监听
        $("#topoBtn").on('click', function () {
            if (featureCollection == undefined) {
                layer.alert("请先上传数据！", {title: '友情提示!'});
            } else if (analysisFeatures.length === 0 && !analysisAll) {
                showMsg('分析图形为空!', 2000, 5, 6);
                return;
            } else {
                $.ajax({
                    type: 'post',
                    url: '/oma/portal/topo',
                    data: {
                        geometry: ko.utils.stringifyJson({
                            "type": "FeatureCollection",
                            "features": featureCollection
                        })
                    },
                    success: function (_r) {
                        if (_r == null || _r === "") {
                            layer.alert("无拓扑错误");
                        } else {
                            layer.alert(_r, {title: '拓扑异常!'});
                        }
                    }
                });
            }
        });
        //清除查询按钮监听
        $("#clearSearchBtn").on('click', function () {
            // viewModel.features(featureCollection);
            $("#searchInput").val('');
            clearChecked();
            initTable();
            analysisFeatures = [];
            viewModel.clearable(false);
            initTips();
        });

        /*form.on('checkbox(choose)', function (data) {
         var index = data.value;
         if (data.elem.checked) {
         analysisFeatures.push(featureCollection[index]);
         } else {
         analysisAll = false;
         var i = $.inArray(featureCollection[index], analysisFeatures);
         if (i >= 0) {
         analysisFeatures.splice(i, 1);
         }
         }
         var child = $(data.elem).parents('table').find('tbody input[type="checkbox"]');
         var childChecked = $(data.elem).parents('table').find('tbody input[type="checkbox"]:checked');
         if(childChecked.length == child.length){
         $(data.elem).parents('table').find('thead input#allChoose').get(0).checked = true;
         }else{
         $(data.elem).parents('table').find('thead input#allChoose').get(0).checked = false;
         }
         form.render('checkbox');

         });*/

        /*form.on('checkbox(allChoose)',function (data) {
         var child = $(data.elem).parents('table').find('tbody input[type="checkbox"]');
         child.each(function(index, item){
         item.checked = data.elem.checked;
         });
         if (!data.elem.checked) {
         analysisFeatures = [];
         }else{
         analysisFeatures = featureCollection;
         }
         form.render('checkbox');
         analysisAll = data.elem.checked;
         });*/

        //监听表格复选框选择
        table.on('checkbox(itable)', function (obj) {
            if (obj.type === 'all') {
                if (obj.checked) {
                    analysisFeatures = featureCollection;
                }
                else {
                    analysisFeatures = [];
                }
                analysisAll = obj.checked;
            }
            else {
                if (obj.checked) {
                    analysisFeatures.push(obj.data);
                }
                else {
                    analysisAll = false;
                    var i = $.inArray(obj.data, analysisFeatures);
                    if (i >= 0) {
                        analysisFeatures.splice(i, 1);
                    }
                }
            }
        });

        //监听工具条
        table.on('tool(itable)', function (obj) {
            if (obj.event === 'detail') {
                /**
                 * 判断是否为IE8版本及其以下版本
                 * */
                var ieversion = IEVersion();
                if (ieversion <= 8 && ieversion != -1) {
                    layer.alert("若需查看形状,请使用现代浏览器或高版本IE！")
                    return;
                }
                layui.data('localData', {key: 'sketch', value: obj.data});
                layer.open({
                    type: 2,
                    title: "图形",
                    skin: 'layui-layer-molv',
                    area: ['600px', '450px'],
                    content: '/oma/portal/sketch'
                });
            }
        });

        //分析按钮监听
        $(".ana-btn").on("click", function () {
            var modelId = $(this).data("mid");
            doAnalysis(modelId);
        });
        initTips();
    }

    /**
     * 执行分析
     * @param type
     */
    function doAnalysis(type) {
        if (analysisFeatures.length === 0 && !analysisAll) {
            showMsg('分析图形为空!', 2000, 5, 6);
            return;
        }
        var form = $("<form method='post' style='display:none;' target='_blank'></form>"), input;
        form.attr({"action": "portal/analysis"});
        input = $("<input type='hidden' name='geometry'>");
        //var crsArr = crs.properties.name.split(':');
        if (analysisAll) {
            input.val(ko.utils.stringifyJson({"type": "FeatureCollection", "features": featureCollection}));
        } else {
            input.val(ko.utils.stringifyJson({"type": "FeatureCollection", "features": analysisFeatures}));
        }
        form.append(input);
        input = $("<input type='hidden' name='type'>");
        input.val(type);
        form.append(input);
        if (viewModel.reportInfo() != undefined) {
            input = $("<input type='hidden' name='reportInfo'>");
            input.val(ko.utils.stringifyJson(getReportInfo()));
            form.append(input);
        }
        form.appendTo(document.body);
        form.submit();
        document.body.removeChild(form[0]);
    }

    /**
     * 组织报件上报面积信息
     * @returns {*}
     */
    function getReportInfo() {
        if (analysisAll) {
            return viewModel.reportInfo();
        } else {
            var ret = undefined;
            layui.each(analysisFeatures, function (idx, feature) {
                var props = feature.properties;
                if (props && props.hasOwnProperty("INFO")) {
                    var info = props.INFO;
                    if (typeof info === 'string') {
                        var tmp = $.parseJSON(info);
                        if (ret === undefined) {
                            ret = $.extend(ret, tmp);
                        } else {
                            ret.area = ret.area + tmp.area;
                            ret.gdArea = ret.gdArea + tmp.gdArea;
                            ret.jsydArea = ret.jsydArea + tmp.jsydArea;
                            ret.nydArea = ret.nydArea + tmp.nydArea;
                            ret.wlydArea = ret.wlydArea + tmp.wlydArea;
                        }
                    }
                }
            });
            return ret;
        }
    }

    /**
     * show msg
     * @param m
     * @param time
     */
    function showMsg(m, time, icon, shift) {
        return layer.msg(m || '加载中..', {
            icon: icon || 16,
            shade: 0.5,
            time: time,
            shift: shift || 0
        });
    }

    /**
     * 查询时清除选择
     * */
    function clearChecked() {
        layui.each(featureCollection, function (index, item) {
            if (item.LAY_CHECKED) {
                item.LAY_CHECKED = false;
            }
        });
    }

    /**
     * 判断浏览器内核类型
     * */
    function IEVersion() {
        var userAgent = navigator.userAgent; //取得浏览器的userAgent字符串
        var isIE = userAgent.indexOf("compatible") > -1 && userAgent.indexOf("MSIE") > -1; //判断是否IE<11浏览器
        var isEdge = userAgent.indexOf("Edge") > -1 && !isIE; //判断是否IE的Edge浏览器
        var isIE11 = userAgent.indexOf('Trident') > -1 && userAgent.indexOf("rv:11.0") > -1;
        if (isIE) {
            var reIE = new RegExp("MSIE (\\d+\\.\\d+);");
            reIE.test(userAgent);
            var fIEVersion = parseFloat(RegExp["$1"]);
            if (fIEVersion == 7) {
                return 7;
            } else if (fIEVersion == 8) {
                return 8;
            } else if (fIEVersion == 9) {
                return 9;
            } else if (fIEVersion == 10) {
                return 10;
            } else {
                return 6;//IE版本<=7
            }
        } else if (isEdge) {
            return 'edge';//edge
        } else if (isIE11) {
            return 11; //IE11
        } else {
            return -1;//不是ie浏览器
        }
    }

    exports('portal', {
        // 定义模块的api接口
        init: function (props) {
            try {
                console.log("portal 初始化...");
                var data = props.data;
                if (data != undefined) {
                    crs = data.feature.crs;
                    layui.each(data.feature.features, function (index, item) {
                        item.crs = crs;
                    });
                    initViewModel({
                        models: ko.utils.parseJson(props.models),
                        features: data.feature.features,
                        report: data.report
                    });
                    form.render();
                    table.render();
                } else {
                    initViewModel({models: ko.utils.parseJson(props.models)});
                }
                initUpload();
                initTable();
                initListener(props);
                console.log("portal 初始化成功");
            } catch (e) {
                console.error(e);
            }
        }
    });
});