/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.analysis.controller;

import cn.gtmap.onemap.analysis.core.BaseController;
import cn.gtmap.onemap.analysis.service.AnalyzeService;
import cn.gtmap.onemap.analysis.support.JSONMessageException;
import cn.gtmap.onemap.service.GeoService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/portal"})
public class PortalController
extends BaseController {
    @Autowired
    private final AnalyzeService analyzeService;
    @Autowired
    private final GeoService geoService;

    @Autowired
    public PortalController(AnalyzeService analyzeService, GeoService geoService) {
        this.analyzeService = analyzeService;
        this.geoService = geoService;
    }

    @RequestMapping(value={""})
    public String exe(Model model) {
        model.addAttribute("models", (Object)JSON.toJSONString((Object)this.analyzeService.getModels()));
        return "portal";
    }

    @RequestMapping(value={"/topo"}, method={RequestMethod.POST})
    @ResponseBody
    public String geoTopoCheck(@RequestParam(value="geometry") String geometry) {
        try {
            return this.geoService.findTopoError(geometry);
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/upload"})
    @ResponseBody
    public String zipUpload(@RequestParam(value="file") MultipartFile file, HttpServletResponse response) {
        response.setContentType("text/json");
        response.setCharacterEncoding("UTF-8");
        try {
            return JSON.toJSONString((Object)this.analyzeService.parseGeoFile(file));
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("file.upload.err", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/sketch"})
    public String viewFeature() {
        return "sketch";
    }

    @RequestMapping(value={"/analysis"})
    public String analysis(@RequestParam(value="geometry") String geometry, @RequestParam(value="type") String type, @RequestParam(value="reportInfo", required=false) String reportInfo, Model model) {
        block18: {
            String geo = geometry;
            try {
                Object resultAll = this.analyzeService.analyze(type, geometry);
                Map result = (Map)resultAll;
                Map results = (Map)result.get("results");
                HashMap mapLone = Maps.newHashMap();
                if (this.isNotNull((Object)results)) {
                    mapLone.putAll(results);
                }
                result.remove("results");
                if ("multi".equalsIgnoreCase(type)) {
                    try {
                        Map analysisResult = result;
                        model.addAttribute("result", (Object)analysisResult);
                        model.addAttribute("geometry", (Object)geo);
                        model.addAttribute("ogArea", (Object)MapUtils.getDoubleValue((Map)analysisResult, (Object)"ogArea", (double)0.0));
                        analysisResult.remove("ogArea");
                        HashMap<String, String> shpRet = new HashMap<String, String>();
                        boolean exportDiffShp = false;
                        if (analysisResult.containsKey("diffShpId")) {
                            model.addAttribute("diffShpId", analysisResult.get("diffShpId"));
                            analysisResult.remove("diffShpId");
                        }
                        for (String key : analysisResult.keySet()) {
                            Map r;
                            Map tmp = (Map)analysisResult.get(key);
                            if (tmp.containsKey("iframeData")) {
                                model.addAttribute(key.concat("iframeData"), tmp.get("iframeData"));
                            }
                            if (tmp.containsKey("shpId")) {
                                shpRet.put(key, MapUtils.getString((Map)tmp, (Object)"shpId"));
                            } else if (tmp.get("result") instanceof Map && (r = (Map)tmp.get("result")) != null && !r.isEmpty() && r.containsKey("shpId")) {
                                shpRet.put(key, MapUtils.getString((Map)r, (Object)"shpId"));
                            }
                            if (tmp.containsKey("diffShpId")) {
                                shpRet.put(key.concat("_diff"), MapUtils.getString((Map)tmp, (Object)"diffShpId"));
                                exportDiffShp = true;
                                continue;
                            }
                            if (!(tmp.get("result") instanceof Map) || (r = (Map)tmp.get("result")) == null || r.isEmpty() || !r.containsKey("diffShpId")) continue;
                            shpRet.put(key.concat("_diff"), MapUtils.getString((Map)r, (Object)"diffShpId"));
                            exportDiffShp = true;
                        }
                        model.addAttribute("shp", (Object)JSON.toJSONString(shpRet));
                        model.addAttribute("exportDiffShp", (Object)exportDiffShp);
                        HashMap mapData = new HashMap();
                        HashMap summaryData = new HashMap();
                        for (Map.Entry entry : analysisResult.entrySet()) {
                            Map value = (Map)entry.getValue();
                            mapData.put(String.valueOf(entry.getKey()), value.get("result"));
                            summaryData.put(String.valueOf(entry.getKey()), value.get("summary"));
                        }
                        model.addAttribute("summaryData", (Object)JSON.toJSONString(summaryData));
                        break block18;
                    }
                    catch (Exception e) {
                        this.logger.error(e.getLocalizedMessage());
                        throw new JSONMessageException(e.getLocalizedMessage());
                    }
                }
                if ("custom".equalsIgnoreCase(type)) {
                    Map map = result;
                    model.addAttribute("info", map.get("info"));
                    model.addAttribute("general", map.get("general"));
                    model.addAttribute("excelData", map.get("excelData"));
                    model.addAttribute("excelList", map.get("excelList"));
                } else {
                    model.addAttribute("data", (Object)result);
                    model.addAttribute("jsData", (Object)JSON.toJSONString((Object)result));
                    model.addAttribute("xlsData", (Object)this.analyzeService.generateXlsData(type, (Object)result));
                    model.addAttribute("geo", (Object)geometry);
                    if (JSON.parse((String)reportInfo) instanceof JSONArray && ((JSONArray)JSON.parse((String)reportInfo)).size() > 0) {
                        model.addAttribute("reportInfo", (Object)this.analyzeService.reportAll(reportInfo));
                    } else {
                        model.addAttribute("reportInfo", JSON.parse((String)reportInfo));
                    }
                    model.addAttribute("dataLone", (Object)mapLone);
                    model.addAttribute("dataDk", (Object)JSON.toJSONString((Object)mapLone, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
                }
            }
            catch (JSONMessageException e) {
                throw new JSONMessageException(e.getLocalizedMessage());
            }
        }
        return "analysis/".concat(type);
    }
}

