/**
 * Created by Administrator on 2017/7/26.
 */
layui.define(['jquery', 'layer', 'element', 'laytpl'], function (exports) {

    //引入此模块对应的样式文件
    layui.link('/oma/static/css/analysis.css');

    var $ = layui.jquery, layer = layui.layer, element = layui.element(), laytpl= layui.laytpl;
    //存放分析结果, 分析类型
    var analysisData = undefined, type = undefined,ompUrl = undefined,gpUrl = undefined;

    /**
     * 初始化变量
     * @param options
     */
    function initVars(options) {
        if(typeof options.data === 'object') {
            analysisData = options.data;
            console.log(analysisData);
        }
        else {
            analysisData = options.data != undefined && $.trim(options.data) != '' ? $.parseJSON(options.data) : undefined;
            type = options.type;
        }
        ompUrl = options.ompUrl;
        gpUrl = options.gpUrl;
        console.log(options.ompUrl);
    }

    /**
     * 初始化事件绑定
     */
    function initEvents(options) {
        //绑定导出事件
        $(".analysis-nav a").on('click', function () {
            var $this= $(this);
            if(options.type!="multi"){
            if(analysisData == undefined) {
                layer.msg('未找到导出数据', {icon: 5});
                return false;
            }
            //todo..
                switch ($this.data('export')) {
                    case 'excel':
                        var typeAnalysis = options.type;
                        if (options.type == "tdlyxz") {
                            /**
                             * tdlyxz响应
                             */
                            var result = {};
                            result = options.xlsData;
                            for (items in result){
                                var itemXz = $('.tdlyxz').data('items');
                                if(items == itemXz){
                                    var resultXz ={array:result[items]};
                                    if (typeof options.xlsData == "object")
                                        multiExportExcelXz(JSON.stringify(resultXz));
                                    else
                                        multiExportExcelXz(resultXz);
                                }
                            }
                        } else {
                            if (typeof options.xlsData == "object")
                                multiExportExcel(typeAnalysis, JSON.stringify(options.xlsData));
                            else
                                multiExportExcel(typeAnalysis, options.xlsData);
                        }
                        break;
                    case 'shp':
                        var shipIdXz = $('.tdlyxz').data('shpid');
                        multiExportFeature(shipIdXz,0);
                        break;
                    case 'cad':
                        var shipIdXz = $('.tdlyxz').data('shpid');
                        multiExportFeature(shipIdXz,1);
                        break;
                }
            }else{
                var $thisAna =$(".layer-clear .layui-this.analysis-select");
                var analysisType = $thisAna.data("type");
                var excelData = $thisAna.data("exceldata");
                var shpId =  $thisAna.data("shpid");
                switch ($this.data('export')) {
                    case 'excel':
                        multiExportExcel(analysisType,JSON.stringify(excelData));
                        break;
                    case 'shp':
                        multiExportFeature(shpId,0);
                        break;
                    case 'cad':
                        multiExportFeature(shpId,1);
                        break;
                }
            }

        });
        //切换年份
        $(".year-nav a").on('click', function(){
            var id = $(this).data('target');
            if (id != undefined) {
                $('.main-content').removeClass('layui-show').addClass('layui-hide');
                setTimeout(function(){
                    $(id).removeClass('layui-hide').addClass('layui-show');
                },100);
            }
        });

        $(".multi-tab-title a").on('click',function () {
            var id = $(this).data('target');
            $('.multi-main-content').removeClass('layui-show').addClass('layui-hide');
            $(id).removeClass('layui-hide').addClass('layui-show');
        });
        /*规划审查分析和基本基本农田分析模块导航栏特殊配置*/
        if(options.type == "tdgh" || options.type == "jbnt"){
            $("#tdghHide").hide()
        }
        if(options.type=="jbnt"){
            $(".layui-nav.analysis-nav").on(function(){
                $(this).css("float","right")
            })
        }
        /*规划审查模块，详细信息按钮响应事件*/
        $("#ghDetails").hide();
        $('.layui-btn.ghDetails').on('click', function(){
            var othis = $(this), method = othis.data('method');
            var detail = othis.data('detail').split("-");
            var data = analysisData[detail[0]];
            var details=[];
            layui.each(data.info, function(index, item){
                if(item.LXMC === detail[1]) {
                    details = item.detail;
                }
            });
            //弹窗显示详细信息
            layer.open({
                type: 1
                ,title: '详细信息'
                ,area: ['755px', '500px']
                ,shade: 0.5
                ,maxmin: true
                ,zIndex: layer.zIndex
                ,content:  renderPage($("#ghDetailTpl").html(), {data: details})
                ,success: function (layero) {
                    //layer.setTop(layero);
                }
            });
        });
        $('.multi-gh-detail').on('click', function(){
            var detail = $(this).data("details");
                layer.open({
                    type: 1,
                    title: '详细信息',
                    area: ['800px', '400px'],
                    shade: 0.5,
                    maxmin: true,
                    zIndex: layer.zIndex,
                    content: detail,
                    success: function (layero) {
                        layer.setTop(layero);
                    }
                });
        });
        /**
         * 导出word(综合分析报告)
         */
        $("#exportMultiReport").on("click",function(){
            exportWord();
        });
    }

    /**
     * laytpl渲染模板,同步方式
     * @param template
     * @param data
     */
    function renderPage(template, data) {
        var tpl = laytpl(template);
        return tpl.render(data);
    }

    /**
     * 导出word(分析报告)
     * */
    function exportWord() {
        var content = [];
        var $liArr = $("#multiSummary").find("ol").find("li");
        $.each($liArr, function (idx, item) {
            var text = $(item).text();
            var val = (idx + 1) + ":" + ($.trim(text)).replace(/\\\n/g, "").replace(/m2/g, " 平方米");
            content.push(val);
        });
        setTimeout(function () {
            if (content.length > 0) {
                openPostWindow(ompUrl+"/geometryService/export/analysis", JSON.stringify({data: content}),
                    "multi_report_n.xml", "doc");
            }
        }, 500);
    }

    function exportFeatures(f,type) {
        var shpId = $(f).data('shpid');
        if (shpId == null && shpId == '') {
            layer.msg("生成shpId失败 无法执行导出操作");
            return;
        }
        var shpUrl = '/omp/file/download/'.concat(shpId);
        var gpUrl = '';
        switch (type) {
            case 0:
                window.location.target = '_blank';
                window.location.href = shpUrl;
                break;
            case 1:
                if (gpUrl == '') {
                    alert("导出dwg所需的GP服务地址为空，请检查配置!");
                    return;
                }
                $.ajax({
                    type: 'post',
                    url: '<@com.rootPath/>/geometryService/rest/export/dwg',
                    data: {shpUrl: shpUrl, gpUrl: gpUrl},
                    success: function (_r) {
                        if (_r && _r.success == false)
                            alert(_r.msg);
                        else {
                            window.location.target = '_blank';
                            window.location.href = _r.result;
                        }
                    },
                    fail: function () {
                        alert(arguments[2]);
                    }
                });
                break;
        }
    }
    /**
     * 导出分析结果至excel
     * @param type 0---基本样式 1----报件对比样式
     */
    function exportExcel(f,type) {
        var data = $(f).data('excel');
        switch (type) {
            case 0:
                openPostWindow("<@com.rootPath/>/geometryService/export/analysis", JSON.stringify(data), "tdlyxz.xml");
                break;
            case 1:
                openPostWindow("<@com.rootPath/>/geometryService/export/analysis", JSON.stringify(data), "tdlyxz_report.xml");
                break;
        }
    }

    /**
     * 综合分析导出图形
     * @param shpId
     * @param type
     */
    function multiExportFeature(shpId,type) {
        if (shpId == null || shpId == '') {
            layer.msg("生成shpId失败 无法执行导出操作");
            return;
        }
        var shpUrl = ompUrl+'/file/download/'.concat(shpId);
        switch (type) {
            case 0:
                window.location.target = '_blank';
                window.location.href = shpUrl;
                break;
            case 1:
                if (gpUrl == '') {
                    alert("导出dwg所需的GP服务地址为空，请检查配置!");
                    return;
                }
                $.ajax({
                    type: 'post',
                    async: true,
                    url: ompUrl+'/geometryService/rest/export/dwg',
                    data: {shpUrl: shpUrl, gpUrl: gpUrl},
                    dataType:'jsonp',
                    success: function (_r) {
                        if (_r && _r.success == false)
                            alert(_r.msg);
                        else {
                            window.location.target = '_blank';
                            window.location.href = _r.result;
                        }
                    },
                    fail: function () {
                        alert(arguments[2]);
                    }
                });
                break;
        }
    }

    /**
     * 导出excel
     */
    function multiExportExcel(type,data) {
        var fileType = ".xlsx";
        switch (type) {
            case 'tdlyxz':
                openPostWindowXZ(ompUrl+"/geometryService/export/analysis",JSON.stringify(analysisData), "tdlyxz_oma.xml");
                break;
            case 'tdgh':
                openPostWindow(ompUrl+"/geometryService/export/excel", data, "ghscfx_analysis" + fileType);
                break;
            case 'jbnt':
                debugger;
                openPostWindow(ompUrl+"/geometryService/export/analysis", data, "jbnt.xml");
                break;
            case 'bp':
                openPostWindow(ompUrl+"/geometryService/export/excel", data, "bpfx_analysis" + fileType);
                break;
            case 'gd':
                openPostWindow(ompUrl+"/geometryService/export/excel", data, "gdfx_analysis" + fileType);
                break;
            case 'kc':
                openPostWindow(ompUrl+"/geometryService/export/excel", data, "kcfx_analysis" + fileType);
                break;
            case 'dz':
                openPostWindow(ompUrl+"/geometryService/export/excel", data, "dzfx_analysis" + fileType);
                break;
            case 'zd':
                openPostWindow(ompUrl+"/geometryService/export/excel", data, "zdfx_analysis" + fileType);
                break;
            case 'cl':
                openPostWindow(ompUrl+"/geometryService/export/excel",data, "clbzdfx_analysis" + fileType);
                break;
            case 'sp':
                openPostWindow(ompUrl+"/geometryService/export/excel",data, "spkzdfx_analysis" + fileType);
                break;
            case 'nt':
                openPostWindow(ompUrl+"/geometryService/export/excel", data, "jbntfx_analysis" + fileType);
                break;
            case 'dj':
                openPostWindow(ompUrl+"/geometryService/export/excel", data, "dj_analysis" + fileType);
                break;
            case 'gyjsydfx':
                openPostWindow(ompUrl+"/geometryService/export/excel", data, "gyjsyd_analysis" + fileType);
                break;
            case 'custom':
                openPostWindow(ompUrl+"/geometryService/export/excel", data, null);
                break;
            default:
                openPostWindow(ompUrl+"/geometryService/export/excel", data ,"default" + fileType);
                break;
            }
    }

    /**
     * tdlyxzLonely
     */
    function multiExportExcelXz(dataXz){
        openPostWindow(ompUrl+"/geometryService/export/analysis",dataXz, "tdlyxzLonely.xml");
    }

    /***
     * for tdlyxz
     * @param url
     * @param data
     * @param fileName
     */
    function openPostWindowXZ(url, data, fileName) {
        if (data == "") {
            alert("无导出数据!");
            return;
        }
        var tempForm = document.createElement("form");
        tempForm.method = "post";
        tempForm.action = url;
        var hideInput1 = document.createElement("input");
        hideInput1.type = "hidden";
        hideInput1.name = "data";
        hideInput1.value = data;
        var hideInput2 = document.createElement("input");
        hideInput2.type = "hidden";
        hideInput2.name = "fileName";
        hideInput2.value = fileName;
        tempForm.appendChild(hideInput1);
        if (fileName != null && fileName != "null" && fileName != "")
            tempForm.appendChild(hideInput2);
        document.body.appendChild(tempForm);
        tempForm.submit();
        document.body.removeChild(tempForm);
    }

    function openPostWindow(url, data, fileName, fileType) {
        if (data == "") {
            layer.msg("无导出数据!",{icon: 5});
            return;
        }
        var tempForm = document.createElement("form");
        tempForm.method = "post";
        tempForm.action = url;
        var hideInput1 = document.createElement("input");
        hideInput1.type = "hidden";
        hideInput1.name = "data";
        hideInput1.value = data;
        var hideInput2 = document.createElement("input");
        hideInput2.type = "hidden";
        hideInput2.name = "fileName";
        hideInput2.value = fileName;

        var hideInput3 = document.createElement("input");
        hideInput3.type = "hidden";
        hideInput3.name = "fileType";
        hideInput3.value = fileType;

        tempForm.appendChild(hideInput1);
        if (fileName != null && fileName != "null" && fileName != "")
            tempForm.appendChild(hideInput2);
        if (fileType != null && fileType != "null" && fileType != "")
            tempForm.appendChild(hideInput3);
        document.body.appendChild(tempForm);
        tempForm.submit();
        document.body.removeChild(tempForm);
    }

    exports('analysis', {
        init: function (options) {
            try {
                console.log("分析页面初始化......");
                initVars(options);
                initEvents(options);
                console.log("分析页面初始化成功");
            } catch (e) {
                console.error(e);
            }
        }
    });
});