/**
 * Created by alex on 2017/7/23.
 * admin 系统设置页面
 */
layui.define(['jquery', 'element', 'form', 'layer', 'laytpl'], function (exports) {
    //引入此模块对应的样式文件
    layui.link('/oma/static/css/admin.css');
    var element = layui.element();
    var $ = layui.jquery, layer = layui.layer, form = layui.form(), laytpl = layui.laytpl;

    var tabFilter = 'admin';
    var existTabs = [];
    var currTabIndex = 0;

    var models, dicts = [];
    var rule = undefined;

    /**
     * 变量赋值
     * @param data
     */
    function initVars(data) {
        models = $.parseJSON(data.models);
        rule = $.parseJSON(data.rule);
        dicts = $.parseJSON(data.dicts);
    }

    /**
     * 初始化
     */
    function initEvents() {
        element.init();
        //显隐左侧导航
        $(".hide-menu").on('click', function () {
            $(".admin-layout-main").toggleClass("hide-aside");
        });

        //左侧导航切换事件
        element.on('nav(admin)', function (elem) {
            var layid = $(elem).data('tid');
            var title = $(elem).find("a > cite").text();
            var exists = existsTab(layid);
            //若已经存在 则切换到该tab 否则增加这个tab
            if (exists) {
                element.tabChange(tabFilter, layid);
            } else {
                addTab(layid, $(elem).find('a > i').html(), title,
                    renderPage($("#" + layid + "Tpl").html(), {models: models, rule: rule, dicts: dicts}), true);
                form.render();//重新渲染form
                //设定tab-content的最大高度
                $(".layui-tab-content").css('max-height', window.innerHeight - 140);

                if (layid === 'rule') {
                    ruleEventListener();
                    return;
                }
                if (layid === 'other') {
                    otherEventListener();
                    return;
                }
                if (layid === 'analysis') {
                    new addListeners().analysisEventListener();
                    return;
                }
            }
        });

        //监听tab切换事件
        element.on('tab(admin)', function (data) {
            //保存当前选中的tab index
            currTabIndex = data;
        });
    }

    var ALIAS_MAPPING = {
        funid: "ID",
        year: "年份",
        dltb: "地类图斑",
        xzdw: "现状地物"

    };
    /**
     * 分析设置监听页面
     * @param layid
     */
    function addListeners(params) {
        /**
         * 参数弹框及详情
         */
        this.data_info = function () {
            var idx = -1;
           //var form;
            if (typeof(params) == "undefined") {
                form_val = "<div style='text-align: center;font-size: 25px;margin-top: 80px'>" + "无参数" +"</div>"+"+<div><ul class=\"models-new-list\"></div>+";
            } else {
                if (!(typeof(params) == "object")) {
                    form_val = "<div style='text-align: center;font-size: 14px'>" + params + "</div>";
                } else {
                    var form_val = "";//最后结果值
                    //循环数组

                    for (var i = 0; i < params.length; i++) {
                        var arr=[];
                        var p = params[i];
                        $.each(p, function (key, val) {
                            var tmp={};
                            var nKey = ALIAS_MAPPING[key] || key;
                            $.extend(tmp, {
                                name: key,
                                alias: nKey,
                                val: val
                            });
                            arr.push(tmp);
                        });
                        if (arr.length > 0) {
                            form_val +=  renderPage($("#paramsTpl").html(), {data: arr});
                        }
                    }

                }

            }
            //参数弹出框
            var itemTpl = '<li>' +
                '<div class="layui-inline">' +
                '<div class="layui-input-inline">' +
                '<input type="text" name="items[{{ d.index }}].key" value="{{ d.key }}" autocomplete="off" class="layui-input">' +
                '</div>' +
                '<div class="layui-input-inline">' +
                '<input type="text" name="items[{{ d.index }}].value" value="{{ d.value }}" autocomplete="off" class="layui-input">' +
                '</div>' +
                '<a class="layui-btn layui-btn-mini layui-btn-danger models-item-del"><i class="layui-icon">&#x1006;</i></a>' +
                '</div>' +
                '</li>';

            layer.open({
                type: 1 //此处以iframe举例
                , title: '参数详情'
                , area: ['450px', '300px']
                , shade: 0.5
                , maxmin: true
                , btn: ['添加','保存']
                , btn1: function (){
                    idx = idx + 1;
                    $(".models-new-list").append(renderPage(itemTpl, {key: '', value: '', index: idx}));
                    $('.models-item-del').on('click', function () {
                        $(this).parent().parent().remove();
                    });
                }
                , btn2: function () {
                    $.each($(".param-form"), function (idx, form) {
                        var arr = $(form).serializeArray();
                        var tmp = {};
                        layui.each(arr, function (idx, item) {
                            tmp[item.name] = item.value;
                        });
                        $.extend(params[idx], tmp);
                    });
                    submit(function () {
                        layer.closeAll();
                    });
                }
                , content: form_val
                , zIndex: layer.zIndex //重点1
                , success: function (layero) {
                    var btn = layero.find('.layui-layer-btn');
                    btn.find('.layui-layer-btn1').attr({"lay-filter":"formNewModels","lay-submit":"formNewModels"});
                   /* var div ="<div class=\"layui-input-inline\"></div>";
                    div.append(btn.find('.layui-layer-btn1'));
                    var div1 = "<div class=\"layui-inline\"></div>";
                    div1.append(div);*/

                    //form_val += "</br>"+ addTpl;
                    layer.setTop(layero); //重点2
                }
            });
        };

        /**
         * 新增一行
         */
        this.addTr = function () {
            var td1 = $('<td width="20px" height="27px"><div><input type="checkbox"   lay-skin="primary"  /></div></td>');//checkbox
            var td2 = $('<td width="45px" height="27px"><input id="id" type="text"  autocomplete="off" class="layui-input"></td>');//id
            var td3 = $('<td width="90px" height="27px"><input id="name"type="text"  autocomplete="off" class="layui-input"></td>');//名称
            var td4 = $('<td width="40px" height="27px"><input id="dataSource" type="text"   autocomplete="off" class="layui-input"></td>');//数据源
            var td5 = $('<td width="150px" height="27px"><input id="layerName" type="text"   autocomplete="off" class="layui-input"></td>');//图层名
            var td6 = $('<td width="90px" height="27px"><input id="outFields" type="text"   autocomplete="off" class="layui-input"></td>');//返回字段
            var td7 = $('<td width="90px" height="27px"></td>');//操作
            var button_save = $('<button class="layui-btn layui-btn-normal layui-btn-mini save">\n' +
                '                            <i class="layui-icon">&#xe605;</i>\n' +
                '                            保存\n' +
                '                        </button>');
            var button_info = $('<button class="layui-btn layui-btn-mini info">\n' +
                '                            <i class="layui-icon">&#xe64e;</i>\n' +
                '                            参数\n' +
                '                        </button>')
            var tr = $('<tr></tr>');
            var tbody = $("#tbody");
            tbody.append(tr).append(td1, td2, td3, td4, td5, td6, td7);
            td7.append(button_info, button_save);

            new addListeners().click();

        };
        /**
         * 保存数据
         * @param data
         */
        this.saveData = function (data,state) {
            models = data;
            layer.msg('提交数据中...', {
                icon: 16,
                shade: 0.6,
                time: false,
                shift: 0
            });
            $.ajax({
                type: 'POST',
                url: '/oma/admin/rest/save',
                data: {analyzeSet: JSON.stringify({dicts: dicts, rule: rule, models: models})},
                dataType: 'json',
                success: function (ret) {
                    layer.closeAll();
                    if (ret.msg) {
                        layer.alert('提交失败：' + ret.msg, {title: '提示', icon: 5, shift: 16});
                        return;
                    }
                    layer.msg(state, {icon: 1, time: 2000});
                    refreshActiveTab(renderPage($('#analysisTpl').html(), {models: models}));
                    form.render();
                    new addListeners().analysisEventListener();
                }
            });

        };

        /**
         * 操作点击事件
         */
        this.click = function () {
            $(".layui-btn.layui-btn-normal.layui-btn-mini.save").on('click', function () {
                //alert("保存成功");
                var models_ = [];
                var data_id = $("#id").val();
                if(data_id == "") data_id =Math.random()+"id";
                var newData = {
                    id: data_id,
                    layerName: $("#layerName").val(),
                    dataSource:$("#dataSource").val(),
                    name: $("#name").val(),
                    outFields: $("#outFields").val()
                };

                if(models != "") models_ = models; //判断无数据时
                models_.push(newData);

                //传入数据保存
                new addListeners().saveData(models_,"保存成功");
            });

            //绑定参数点击事件
            $(".layui-btn.layui-btn-mini.info").on('click', function () {
                var detai = $(this).data('info');
                var params;
                if (typeof(detai) == "undefined") {
                    params = detai;
                    new addListeners(params).data_info();
                }
                params
                for (var i = 0; i < models.length; i++) {
                    if (models[i].id == detai) {
                        params = models[i].params;
                        new addListeners(params).data_info();
                    }
                }
            });

        };

        /**
         * 删除数据
         * @param selData
         */
        this.delTr = function (selData) {
            //批量删除字典项
            if (selData.length === 0) {
                layer.msg('先选择一项!');
                return;
            }
            layui.each(selData, function (idx, item) {
                var selIndex = $.inArray(item, models);
                if (selIndex > -1) {
                    models.splice(selIndex, 1);
                }
            });
            new addListeners().saveData(models,"删除成功");

        };

        /**
         * 分析监听
         */
        this.analysisEventListener = function(){
            //全选
            var selData = [];
            form.on('checkbox(dictsChoseAll)', function (data) {
                if (!data.elem.checked) {
                    selData = [];
                } else {
                    selData = models;
                }
                var child = $(data.elem).parents('table').find('tbody input[type="checkbox"]');
                child.each(function (index, item) {
                    item.checked = data.elem.checked;4
                });
                form.render('checkbox');//渲染checkebox
            });
            //单选
            form.on('checkbox(sel-choose-single)', function (data) {
                var index = data.value;
                if (data.elem.checked) {
                    selData.push(models[index]);
                } else {
                    var i = $.inArray(models[index], selData);
                    if (i >= 0) {
                        selData.splice(i, 1);
                    }
                }
                form.render('checkbox');
            });
            new addListeners().click();//操作点击方法

            //新增和删除
            $(".addTr").on('click', function () {
                //alert("heihei");
                var operate = $(this).data('operate');
                switch (operate) {
                    case 'add':
                        new addListeners().addTr();//增加
                        break;
                    case 'del':
                        new addListeners().delTr(selData);//删除
                        break;
                    default:
                        break;
                };

            });
        }

    }


    /**
     * 处理 rule 页面的事件
     */
    function ruleEventListener() {
        form.on('submit(formRule)', function (data) {
            var field = data.field;
            $.each(['checkTopoFirst', 'terminateWhenErr'], function (i, n) {
                if (!field.hasOwnProperty(n)) {
                    field[n] = false;
                }
            });
            $.extend(rule, field);
            submit();
            return false;
        });
    }

    /**
     * 处理 其他设置 页面的事件
     */
    function otherEventListener() {
        //编辑字典并提交
        form.on('submit(formEditDict)', function (data) {
            var field = data.field;
            console.log(field);
            saveDict($.param(field));
            return false;
        });
        $(".dict-item-remove").on('click', function () {
            var $li = $(this).parent().parent().parent();
            var $ul = $li.parent();
            $li.remove();
            //更新当前的li中的input的name
            $.each($ul.find('li'), function (idx, item) {
                $(item).find('input').eq(0).attr('name', 'items[' + idx + "].key");
                $(item).find('input').eq(1).attr('name', 'items[' + idx + "].value");
            });

        });
        var selDicts = [];
        //全选
        form.on('checkbox(dicts-choose-all)', function (data) {
            if (!data.elem.checked) {
                selDicts = [];
            } else {
                selDicts = dicts;
            }
            var child = $(data.elem).parents('table').find('tbody input[type="checkbox"]');
            child.each(function (index, item) {
                item.checked = data.elem.checked;
            });
            form.render('checkbox');
        });
        //单选
        form.on('checkbox(dicts-choose-single)', function (data) {
            var index = data.value;
            if (data.elem.checked) {
                selDicts.push(dicts[index]);
            } else {
                var i = $.inArray(dicts[index], selDicts);
                if (i >= 0) {
                    selDicts.splice(i, 1);
                }
            }
            // var child = $(data.elem).parents('table').find('tbody input[type="checkbox"]');
            // var childChecked = $(data.elem).parents('table').find('tbody input[type="checkbox"]:checked');
            // if (childChecked.length == child.length) {
            //     $(data.elem).parents('table').find('thead input#allChooseDict').get(0).checked = true;
            // } else {
            //     $(data.elem).parents('table').find('thead input#allChooseDict').get(0).checked = false;
            // }
            form.render('checkbox');
        });
        var itemTpl = '<li>' +
            '<div class="layui-inline">' +
            '<div class="layui-input-inline">' +
            '<input type="text" name="items[{{ d.index }}].key" value="{{ d.key }}" autocomplete="off" class="layui-input">' +
            '</div>' +
            '<div class="layui-input-inline">' +
            '<input type="text" name="items[{{ d.index }}].value" value="{{ d.value }}" autocomplete="off" class="layui-input">' +
            '</div>' +
            '<a class="layui-btn layui-btn-mini layui-btn-danger dict-item-del"><i class="layui-icon">&#x1006;</i></a>' +
            '</div>' +
            '</li>';
        //监听按钮事件
        $(".dict-btn").on('click', function () {
            var opera = $(this).data('opera');
            switch (opera) {
                case 'add':
                    //新增字典项
                    layer.open({
                        type: 1,
                        title: '新增字典',
                        skin: 'layui-layer-molv',
                        area: ['520px', '340px'],
                        content: renderPage($("#dictNewTpl").html(), {name: '', items: []}),
                        success: function () {
                            //提交字典项
                            form.on('submit(formNewDict)', function (data) {
                                var field = data.field;
                                saveDict($.param(field));
                                return false;
                            });
                            var idx = -1;
                            //添加子项
                            $("#dictNewItemBtn").on('click', function () {
                                idx = idx + 1;
                                $(".dict-new-list").append(renderPage(itemTpl, {key: '', value: '', index: idx}));
                                //移除子项
                                $('.dict-item-del').on('click', function () {
                                    $(this).parent().parent().remove();
                                });
                                return false;
                            });
                        }
                    });
                    break;
                case 'del':
                    //批量删除字典项
                    if (selDicts.length === 0) {
                        layer.msg('至少选择一项!');
                        return;
                    }
                    layui.each(selDicts, function (idx, item) {
                        var dictIndex = $.inArray(item, dicts);
                        if (dictIndex > -1) {
                            dicts.splice(dictIndex, 1);
                        }
                    });
                    submit(function () {
                        refreshActiveTab(renderPage($('#otherTpl').html(), {dicts: dicts}));
                        form.render();
                        otherEventListener();
                    });
                    break;
                default:
                    break;
            }
        });
    }

    /**
     * 保存字典项
     * @param data
     */
    function saveDict(data) {
        layer.msg('提交数据中...', {
            icon: 16,
            shade: 0.6,
            time: false,
            shift: 0
        });
        $.ajax({
            type: 'POST',
            url: '/oma/admin/rest/saveDict',
            data: data,
            dataType: 'json',
            success: function (ret) {
                layer.closeAll();
                if (ret.msg) {
                    layer.alert('保存失败：' + ret.msg, {title: '提示', icon: 5, shift: 16});
                    return;
                }
                layer.msg('保存成功', {icon: 1, time: 2000});
                var target = undefined;
                for (var i = 0, l = dicts.length; i < l; i++) {
                    var item = dicts[i];
                    if (item.name === ret.name) {
                        target = item;
                        break;
                    }
                }
                if (target) {
                    dicts[$.inArray(target, dicts)] = ret;
                } else {
                    dicts.push(ret);
                }
                //重新加载当前tab页面
                refreshActiveTab(renderPage($('#otherTpl').html(), {dicts: dicts}));
                form.render();
                otherEventListener();
            }
        });
    }

    /**
     * 保存整个配置信息
     * @param data
     */
    function submit(callback) {
        layer.msg('提交数据中...', {
            icon: 16,
            shade: 0.6,
            time: false,
            shift: 0
        });
        $.ajax({
            type: 'POST',
            url: '/oma/admin/rest/save',
            data: {analyzeSet: JSON.stringify({dicts: dicts, rule: rule, models: models})},
            dataType: 'json',
            success: function (ret) {
                layer.closeAll();
                if (ret.msg) {
                    layer.alert('提交失败：' + ret.msg, {title: '提示', icon: 5, shift: 16});
                    return;
                }
                layer.msg('保存成功', {icon: 1, time: 2000});
                if (callback) callback();
            }
        });
    }

    /**
     * laytpl渲染模板,同步方式
     * @param template
     * @param data
     */
    function renderPage(template, data) {
        var tpl = laytpl(template);
        return tpl.render(data);
    }

    /**
     * 刷新当前tab页的内容
     * @param content
     */
    function refreshActiveTab(content) {
        var $tabItem = $(".layui-tab-item[class$=layui-show]");
        if ($tabItem.length === 0) return;
        $tabItem.empty().append(content);
    }

    /**
     * 添加标签页
     * @param id
     * @param icon
     * @param title
     * @param content
     * @param closable
     */
    function addTab(id, icon, title, content, closable) {
        title = laytpl('<i class="layui-icon">{{ d.icon }}</i><cite> {{ d.title }}</cite>').render({
            icon: icon,
            title: title
        });
        if (closable) {
            title += '<i class="layui-icon layui-unselect layui-tab-close" data-id="' + id + '">&#x1006;</i>';
        }
        element.tabAdd(tabFilter, {
            title: title
            , content: content //支持传入html
            , id: id
        });
        element.tabChange(tabFilter, id);
        //存储该id
        existTabs.push(id);
        //移除tab事件
        $('.layui-tab-close').on('click', function () {
            var layid = $(this).data('id');
            if (existsTab(layid)) {
                element.tabDelete(tabFilter, layid);
                existTabs.splice($.inArray(layid, existTabs), 1);
                if (existTabs.length === 0) {
                    //去除左侧选中的导航
                    $("#adminNav .layui-nav-item").removeClass('layui-this');
                }
            }
        });
    }

    /**
     * 检测tab页是否已经加载
     * @param tabId
     */
    function existsTab(tabId) {
        return $.inArray(tabId, existTabs) > -1;
    }

    exports('admin', {
        init: function (props) {
            console.log('后台管理模块初始化...');
            initVars(props);
            initEvents();
            console.log('后台管理模块初始化成功!');
        }
    });
});
