<#--基础母版页面-->
<#macro base title="" hideHeader='false'>
<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>${title!}</title>
    <link rel="stylesheet" href="<@rootPath/>/static/tp/layui/css/layui.css">
    <link rel="stylesheet" href="<@rootPath/>/static/tp/pace/pace-theme-flash.css">
    <link rel="stylesheet" href="<@rootPath/>/static/css/global.css">
    <#if hideHeader == 'true'>
        <style>
            html body {
                margin-top: 15px;
            }
        </style>
    </#if>
    <script src="<@rootPath/>/static/tp/pace/pace.min.js"></script>
    <script src="<@rootPath/>/static/tp/layui/layui.js"></script>
    <script src="<@rootPath/>/static/js/global.js"></script>
</head>
<body>
<#--头部-->
<#if hideHeader=='true'>
<#else >
<div class="layui-header header" id="hideTopBar">
    <div class="main">
        <a class="logo" href="<@com.rootPath/>">
            数据分析子系统 <sup class="badge-pro layui-bg-green">pro</sup>
        </a>
        <div class="nav">
            <a href="<@com.rootPath/>/admin" target="_blank">
                <i class="layui-icon">&#xe620;</i>
                系统设置
            </a>
        </div>
    </div>
    <ul class="layui-nav analysis-nav" style="float: right">
        <li class="layui-nav-item">
            <a href="javascript:;">使用帮助</a>
            <dl class="layui-nav-child">
                <dd><a href="<@com.rootPath/>/static/doc/数据分析子系统PDF.pdf" target="_blank">PDF文档</a></dd>
                <dd><a href="<@com.rootPath/>/static/doc/数据分析子系统Word.docx" target="_blank">Word文档</a></dd>
            </dl>
        </li>
    </ul>
</div>
</#if>
    <#nested />
</body>
</html>
</#macro>

<#--分析结果母版页面-->
<#macro analysis title="">
<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>${title!}</title>
    <link rel="stylesheet" href="<@rootPath/>/static/tp/layui/css/layui.css">
    <link rel="stylesheet" href="<@rootPath/>/static/tp/pace/pace-theme-flash.css">
    <link rel="stylesheet" href="<@rootPath/>/static/css/global.css">
    <script src="<@rootPath/>/static/tp/pace/pace.min.js"></script>
    <script src="<@rootPath/>/static/tp/layui/layui.js"></script>
    <script src="<@rootPath/>/static/js/global.js"></script>
</head>
<body>
<#--头部-->
<div class="layui-header header">
    <div class="layui-main">
        <a class="logo" href="<@com.rootPath/>">数据分析子系统 <sup class="badge-pro layui-bg-green">pro</sup></a>
        <ul class="layui-nav analysis-nav">
            <li class="layui-nav-item">
                <a href="javascript:;" data-export="excel" onclick="#">导出excel</a>
            </li>
            <li class="layui-nav-item" id="tdghHide">
                <a href="javascript:;">导出图形</a>
                <dl class="layui-nav-child" >
                    <dd><a href="javascript:;" data-export="shp">shp压缩包(.zip)</a></dd>
                    <dd><a href="javascript:;" data-export="cad">cad文件(.dwg)</a></dd>
                </dl>
            </li>
        </ul>
    </div>
</div>
    <#nested />
</body>
</html>
</#macro>

<#macro rootPath>${springMacroRequestContext.getContextPath()}</#macro>