/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.analysis.support;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

public final class ListUtils {
    public static double getAreaByField(List<Map> list, String field, String value, String areaField, double conv) {
        if (conv == 0.0) {
            conv = 1.0;
        }
        assert (field != null);
        assert (value != null);
        double area = 0.0;
        List<String> array = Arrays.asList(value.split(","));
        for (Map map : list) {
            if (!array.contains(map.get(field))) continue;
            area += ((Double)map.get(areaField)).doubleValue();
        }
        return area * conv;
    }

    public String getStrValueByField(List<Map> list, String field) {
        StringBuilder sb = new StringBuilder();
        assert (field != null);
        for (Map map : list) {
            if (!map.containsKey(field)) continue;
            if (StringUtils.isNotBlank((String)sb.toString())) {
                sb.append(",");
            }
            if (map.get(field) == null) continue;
            sb.append(map.get(field));
        }
        return sb.toString();
    }

    public static String getStrValueByField(List<Map> list, String[] fields, String hyphen) {
        StringBuilder sb = new StringBuilder();
        assert (fields != null);
        List<String> array = Arrays.asList(fields);
        for (Map map : list) {
            if (StringUtils.isNotBlank((String)sb.toString())) {
                sb.append(",");
            }
            for (String f : array) {
                if (!map.containsKey(f) || map.get(f) == null) continue;
                if (array.indexOf(f) != 0) {
                    sb.append(hyphen);
                }
                sb.append(map.get(f));
            }
        }
        return sb.toString();
    }

    public static double getDouValueByField(List<Map> list, String field) {
        double value = 0.0;
        assert (field != null);
        for (Map map : list) {
            if (map.get(field) == null) continue;
            value += MapUtils.getDoubleValue((Map)map, (Object)field, (double)0.0);
        }
        return value;
    }

    public static double getSumByQueryField(List<Map> list, String queryField, List queryValue, String sumField) {
        double result = 0.0;
        assert (queryField != null);
        assert (queryValue != null);
        for (Map map : list) {
            if (!queryValue.contains(MapUtils.getString((Map)map, (Object)queryField))) continue;
            result += MapUtils.getDoubleValue((Map)map, (Object)sumField, (double)0.0);
        }
        return result;
    }

    public static double getSumByQueryField(List<Map> list, String queryField, String queryValue, String sumField) {
        double result = 0.0;
        assert (queryField != null);
        assert (queryValue != null);
        for (Map map : list) {
            if (!queryValue.equalsIgnoreCase(MapUtils.getString((Map)map, (Object)queryField))) continue;
            result += MapUtils.getDoubleValue((Map)map, (Object)sumField, (double)0.0);
        }
        return result;
    }

    public static double getSumByField(List<Map> list, String sumField) {
        double sum = 0.0;
        for (Map map : list) {
            if (!map.containsKey(sumField.toUpperCase())) continue;
            sum += MapUtils.getDoubleValue((Map)map, (Object)sumField, (double)0.0);
        }
        return sum;
    }

    public static Map groupSumByField(List<Map> list, String groupField, String sumFiled) {
        HashMap<String, Double> ret = new HashMap<String, Double>();
        for (Map map : list) {
            String value = MapUtils.getString((Map)map, (Object)groupField);
            double area = MapUtils.getDoubleValue((Map)map, (Object)sumFiled, (double)0.0);
            ret.put(value, area + MapUtils.getDoubleValue(ret, (Object)value, (double)0.0));
        }
        return ret;
    }
}

