/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.analysis.support;

import cn.gtmap.onemap.analysis.support.GeometryUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.esri.sde.sdk.pe.PeCoordinateSystem;
import com.esri.sde.sdk.pe.PeFactory;
import com.esri.sde.sdk.pe.PeProjectionException;
import com.gtis.common.util.UUIDGenerator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

/*
 * Exception performing whole class analysis ignored.
 */
public final class GeometryUtils {
    private static final String EPSG = "EPSG:";
    private static final Logger logger = LoggerFactory.getLogger(GeometryUtils.class);
    private static GeometryFactory factory = JTSFactoryFinder.getGeometryFactory();

    public static Geometry createValidGeometry(Geometry geometry) {
        try {
            if (geometry instanceof Polygon) {
                Polygon polygon = (Polygon)geometry;
                GeometryFactory factory = geometry.getFactory();
                ArrayList<Polygon> polygons = new ArrayList<Polygon>();
                Polygon exteriorPolygon = new Polygon((LinearRing)polygon.getExteriorRing(), null, factory);
                polygons.add(exteriorPolygon);
                for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
                    LinearRing interiorRing = (LinearRing)polygon.getInteriorRingN(i);
                    Polygon interiorPolygon = new Polygon(interiorRing, null, factory);
                    polygons.add(interiorPolygon);
                }
                ArrayList<Polygon> newPolygons = new ArrayList<Polygon>();
                ArrayList excludePolygons = new ArrayList();
                for (Polygon temp : polygons) {
                    if (excludePolygons.contains(temp = GeometryUtils.getPolygonWithHoles(polygons, excludePolygons, (Polygon)temp))) continue;
                    newPolygons.add(temp);
                }
                return new MultiPolygon(newPolygons.toArray(new Polygon[0]), factory);
            }
            if (geometry instanceof MultiPolygon) {
                MultiPolygon multiPolygon = (MultiPolygon)geometry;
                ArrayList<Polygon> polygonList = new ArrayList<Polygon>();
                for (int j = 0; j < multiPolygon.getNumGeometries(); ++j) {
                    Polygon polygon = (Polygon)multiPolygon.getGeometryN(j);
                    if (!polygon.isValid()) {
                        MultiPolygon tempMultiPolygon = (MultiPolygon)GeometryUtils.createValidGeometry((Geometry)polygon);
                        for (int k = 0; k < tempMultiPolygon.getNumGeometries(); ++k) {
                            polygonList.add((Polygon)tempMultiPolygon.getGeometryN(k));
                        }
                        continue;
                    }
                    polygonList.add(polygon);
                }
                return new MultiPolygon(polygonList.toArray(new Polygon[0]), multiPolygon.getFactory());
            }
            logger.info("geometryType has not been supported yet");
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage());
        }
        return null;
    }

    public static final Object parseGeoJSON(String value) {
        if (StringUtils.isBlank((String)value)) {
            throw new RuntimeException("GeoJSON can't be blank");
        }
        try {
            Map geo = (Map)JSON.parseObject((String)value, Map.class);
            if (!geo.containsKey(GeoTag.type.name())) {
                throw new RuntimeException("GeoJSON must have type key");
            }
            GeoTag tag = GeoTag.getTag((String)((String)geo.get(GeoTag.type.name())));
            switch (1.$SwitchMap$cn$gtmap$onemap$analysis$support$GeometryUtils$GeoTag[tag.ordinal()]) {
                case 1: {
                    return GeometryUtils.createPolygon((JSONArray)((JSONArray)geo.get(GeoTag.coordinates.name())));
                }
                case 2: {
                    return GeometryUtils.createGeometryCollection((JSONArray)((JSONArray)geo.get(GeoTag.geometries.name())));
                }
                case 3: {
                    return GeometryUtils.createMultiPolygon((JSONArray)((JSONArray)geo.get(GeoTag.coordinates.name())));
                }
                case 4: {
                    return GeometryUtils.createFeature((Map)geo);
                }
                case 5: {
                    return GeometryUtils.createFeatureCollection((JSONArray)((JSONArray)geo.get(GeoTag.features.name())));
                }
                case 6: {
                    return GeometryUtils.createPoint((JSONArray)((JSONArray)geo.get(GeoTag.coordinates.name())));
                }
                case 7: {
                    return GeometryUtils.createLine((JSONArray)((JSONArray)geo.get(GeoTag.coordinates.name())));
                }
                case 8: {
                    return GeometryUtils.createMultiPoint((JSONArray)((JSONArray)geo.get(GeoTag.coordinates.name())));
                }
                case 9: {
                    return GeometryUtils.createMultiLine((JSONArray)((JSONArray)geo.get(GeoTag.coordinates.name())));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(" Value isn't well-know format GeoJSON. detail error : [ " + e.getLocalizedMessage() + " ] ");
        }
        return null;
    }

    private static Polygon getPolygonWithHoles(List<Polygon> srcPolygons, List<Polygon> excludePolygons, Polygon polygon) {
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        for (Polygon item : srcPolygons) {
            if (polygon.equals((Geometry)item) || excludePolygons.contains(polygon) || !polygon.contains((Geometry)item)) continue;
            holes.add((LinearRing)item.getExteriorRing());
            excludePolygons.add(item);
        }
        if (holes.size() > 0) {
            return new Polygon((LinearRing)polygon.getExteriorRing(), holes.toArray(new LinearRing[0]), polygon.getFactory());
        }
        return polygon;
    }

    private static SimpleFeature createFeature(Map value) {
        Geometry geometry = null;
        CoordinateReferenceSystem crs = null;
        Map properties = null;
        if (value.containsKey(GeoTag.geometry.name())) {
            geometry = GeometryUtils.createGeometry((JSONObject)((JSONObject)value.get(GeoTag.geometry.name())));
        }
        if (value.containsKey(GeoTag.crs.name())) {
            crs = GeometryUtils.createCRS((JSONObject)((JSONObject)value.get(GeoTag.crs.name())));
        }
        if (value.containsKey(GeoTag.properties.name())) {
            properties = GeometryUtils.createPros((JSONObject)((JSONObject)value.get(GeoTag.properties.name())));
        }
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName(GeoTag.Feature.name());
        if (GeometryUtils.notNull((Object)geometry)) {
            typeBuilder.add(GeoTag.geometry.name(), Geometry.class);
        }
        if (GeometryUtils.notNull((Object)properties)) {
            Iterator i$ = properties.keySet().iterator();
            while (i$.hasNext()) {
                String key;
                typeBuilder.add(key, properties.get(key = (String)i$.next()) != null ? properties.get(key).getClass() : String.class);
            }
        }
        if (GeometryUtils.notNull((Object)crs)) {
            typeBuilder.add(GeoTag.crs.name(), String.class, crs);
        }
        SimpleFeatureType featureType = typeBuilder.buildFeatureType();
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(featureType);
        if (GeometryUtils.notNull((Object)geometry)) {
            featureBuilder.add((Object)geometry);
        }
        if (GeometryUtils.notNull((Object)properties)) {
            for (String key : properties.keySet()) {
                featureBuilder.add(properties.get(key));
            }
        }
        return featureBuilder.buildFeature(GeoTag.Feature.name().concat(UUIDGenerator.generate()));
    }

    private static FeatureCollection createFeatureCollection(JSONArray array) {
        DefaultFeatureCollection collection = new DefaultFeatureCollection(null, null);
        for (Object o : array) {
            collection.add(GeometryUtils.createFeature((Map)((Map)o)));
        }
        return collection;
    }

    private static Geometry createGeometry(JSONObject value) {
        GeoTag tag = GeoTag.getTag((String)((String)value.get((Object)GeoTag.type.name())));
        switch (1.$SwitchMap$cn$gtmap$onemap$analysis$support$GeometryUtils$GeoTag[tag.ordinal()]) {
            case 1: {
                return GeometryUtils.createPolygon((JSONArray)((JSONArray)value.get((Object)GeoTag.coordinates.name())));
            }
            case 2: {
                return GeometryUtils.createGeometryCollection((JSONArray)((JSONArray)value.get((Object)GeoTag.geometries.name())));
            }
            case 3: {
                return GeometryUtils.createMultiPolygon((JSONArray)((JSONArray)value.get((Object)GeoTag.coordinates.name())));
            }
            case 6: {
                return GeometryUtils.createPoint((JSONArray)((JSONArray)value.get((Object)GeoTag.coordinates.name())));
            }
            case 7: {
                return GeometryUtils.createLine((JSONArray)((JSONArray)value.get((Object)GeoTag.coordinates.name())));
            }
            case 8: {
                return GeometryUtils.createMultiPoint((JSONArray)((JSONArray)value.get((Object)GeoTag.coordinates.name())));
            }
            case 9: {
                return GeometryUtils.createMultiLine((JSONArray)((JSONArray)value.get((Object)GeoTag.coordinates.name())));
            }
        }
        throw new RuntimeException("unsupport geometry type : [ " + tag.name() + " ]");
    }

    public static GeometryCollection createGeometryCollection(JSONArray array) {
        ArrayList<Object> geometries = new ArrayList<Object>();
        for (Object o : array) {
            JSONObject value = (JSONObject)o;
            GeoTag tag = GeoTag.getTag((String)((String)value.get((Object)GeoTag.type.name())));
            switch (1.$SwitchMap$cn$gtmap$onemap$analysis$support$GeometryUtils$GeoTag[tag.ordinal()]) {
                case 1: {
                    geometries.add(GeometryUtils.createPolygon((JSONArray)((JSONArray)value.get((Object)GeoTag.coordinates.name()))));
                    break;
                }
                case 3: {
                    geometries.add(GeometryUtils.createMultiPolygon((JSONArray)((JSONArray)value.get((Object)GeoTag.coordinates.name()))));
                    break;
                }
                case 6: {
                    geometries.add(GeometryUtils.createPoint((JSONArray)((JSONArray)value.get((Object)GeoTag.coordinates.name()))));
                    break;
                }
                case 7: {
                    geometries.add(GeometryUtils.createLine((JSONArray)((JSONArray)value.get((Object)GeoTag.coordinates.name()))));
                    break;
                }
                case 8: {
                    geometries.add(GeometryUtils.createMultiPoint((JSONArray)((JSONArray)value.get((Object)GeoTag.coordinates.name()))));
                    break;
                }
                case 9: {
                    geometries.add(GeometryUtils.createMultiLine((JSONArray)((JSONArray)value.get((Object)GeoTag.coordinates.name()))));
                }
            }
        }
        return factory.createGeometryCollection(geometries.toArray(new Geometry[0]));
    }

    public static Polygon createPolygon(JSONArray array) {
        if (array.size() == 0) {
            throw new RuntimeException("Polygon specified with no rings");
        }
        try {
            LinearRing shell = GeometryUtils.createLinearRing((JSONArray)array.getJSONArray(0));
            LinearRing[] holes = null;
            if (array.size() > 1) {
                holes = new LinearRing[array.size() - 1];
                for (int i = 1; i < array.size(); ++i) {
                    holes[i - 1] = GeometryUtils.createLinearRing((JSONArray)array.getJSONArray(i));
                }
            }
            return factory.createPolygon(shell, holes);
        }
        catch (Exception e) {
            throw new RuntimeException("Polygon coordinates format error");
        }
    }

    public static MultiPolygon createMultiPolygon(JSONArray array) {
        if (array.size() == 0) {
            throw new RuntimeException(" no coordinates in MultiPolygon");
        }
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (Object o : array) {
            polygons.add(GeometryUtils.createPolygon((JSONArray)((JSONArray)o)));
        }
        return factory.createMultiPolygon(polygons.toArray(new Polygon[0]));
    }

    private static LinearRing createLinearRing(JSONArray array) {
        return factory.createLinearRing(GeometryUtils.coordinates((JSONArray)array));
    }

    public static Point createPoint(JSONArray array) {
        return factory.createPoint(GeometryUtils.coordinate((JSONArray)array));
    }

    public static Point createPoint(double x, double y) {
        Coordinate c = new Coordinate();
        c.x = x;
        c.y = y;
        return factory.createPoint(c);
    }

    private static MultiPoint createMultiPoint(JSONArray array) {
        return factory.createMultiPoint(GeometryUtils.coordinates((JSONArray)array));
    }

    public static LineString createLine(JSONArray array) {
        Assert.notNull((Object)array, (String)" line coordinates can't be null ");
        return factory.createLineString(GeometryUtils.coordinates((JSONArray)array));
    }

    private static MultiLineString createMultiLine(JSONArray array) {
        return factory.createMultiLineString(GeometryUtils.lineStrings((JSONArray)array));
    }

    public static Map createCrsMap(String value) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        HashMap<String, String> prop = new HashMap<String, String>();
        try {
            int srid = Integer.valueOf(value);
            map.put("type", "name");
            prop.put("name", "EPSG:".concat(value));
            map.put("properties", prop);
        }
        catch (NumberFormatException e) {
            map.put("type", "value");
            prop.put("value", value);
            map.put("properties", prop);
        }
        return map;
    }

    public static CoordinateReferenceSystem createCRS(JSONObject value) {
        try {
            GeoTag tag = GeoTag.getTag((String)((String)value.get((Object)GeoTag.type.name())));
            JSONObject pros = (JSONObject)value.get((Object)GeoTag.properties.name());
            switch (1.$SwitchMap$cn$gtmap$onemap$analysis$support$GeometryUtils$GeoTag[tag.ordinal()]) {
                case 10: {
                    String code = (String)pros.get((Object)GeoTag.name.name());
                    try {
                        if (code == null) {
                            return null;
                        }
                        int c = Integer.parseInt(code);
                        return CRS.parseWKT((String)GeometryUtils.getCoordinateSystem((int)c).toString());
                    }
                    catch (NumberFormatException e) {
                        if (code.contains("EPSG:")) {
                            return CRS.parseWKT((String)GeometryUtils.getCoordinateSystem((int)Integer.valueOf(code.substring("EPSG:".length(), code.length()))).toString());
                        }
                        return CRS.decode((String)code, (boolean)true);
                    }
                }
                case 11: {
                    String wkt = (String)pros.get((Object)GeoTag.value.name());
                    wkt = GeometryUtils.getCoordinateSystem((String)wkt).toString();
                    return CRS.parseWKT((String)wkt);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("parse crs exception : [ " + e.getLocalizedMessage() + " ]");
        }
        catch (PeProjectionException e) {
            throw new RuntimeException("parse crs exception : [ " + e.getLocalizedMessage() + " ]");
        }
        return null;
    }

    public static PeCoordinateSystem getCoordinateSystem(String wkt) throws PeProjectionException {
        return PeCoordinateSystem.fromString((String)wkt);
    }

    public static PeCoordinateSystem getCoordinateSystem(int srid) throws PeProjectionException {
        return PeFactory.coordsys((int)srid);
    }

    private static Map<String, Object> createPros(JSONObject value) {
        HashMap<String, Object> pros = new HashMap<String, Object>();
        for (String key : value.keySet()) {
            pros.put(key, value.get((Object)key));
        }
        return pros;
    }

    private static Coordinate coordinate(JSONArray array) {
        Assert.notNull((Object)array, (String)" coordinates can't be null ");
        Coordinate c = new Coordinate();
        c.x = array.getDoubleValue(0);
        c.y = array.getDoubleValue(1);
        return c;
    }

    private static Coordinate[] coordinates(JSONArray array) {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        for (Object o : array) {
            coordinates.add(GeometryUtils.coordinate((JSONArray)((JSONArray)o)));
        }
        return coordinates.toArray(new Coordinate[0]);
    }

    private static LineString[] lineStrings(JSONArray array) {
        ArrayList<LineString> lines = new ArrayList<LineString>();
        for (Object o : array) {
            lines.add(GeometryUtils.createLine((JSONArray)((JSONArray)o)));
        }
        return lines.toArray(new LineString[0]);
    }

    private static boolean notNull(Object value) {
        return value != null;
    }
}

