/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.analysis.service.impl;

import cn.gtmap.onemap.analysis.model.AnalyzeDict;
import cn.gtmap.onemap.analysis.model.AnalyzeSet;
import cn.gtmap.onemap.analysis.service.AnalyzeService;
import cn.gtmap.onemap.analysis.service.ConfigService;
import cn.gtmap.onemap.analysis.support.ApplicationContextHelper;
import cn.gtmap.onemap.analysis.support.ConfigUpdateEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.io.Resource;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class ConfigServiceImpl
implements ConfigService {
    private Yaml yaml;
    private File configFile;
    @Autowired
    private AnalyzeService analyzeService;

    @PostConstruct
    public void init() {
        DumperOptions option = new DumperOptions();
        option.setPrettyFlow(true);
        option.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yaml = new Yaml(option);
    }

    public void setConfigFile(Resource file) {
        try {
            this.configFile = file.getFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public AnalyzeSet save(AnalyzeSet analyzeSet) {
        try {
            this.yaml.dump((Object)analyzeSet, (Writer)new FileWriter(this.configFile));
            ApplicationContextHelper.getContext().publishEvent((ApplicationEvent)new ConfigUpdateEvent(analyzeSet));
            return analyzeSet;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public AnalyzeDict saveDict(AnalyzeDict analyzeDict) {
        List dictList = this.analyzeService.getDicts();
        Iterator iterator = dictList.iterator();
        boolean insert = true;
        while (iterator.hasNext()) {
            AnalyzeDict dict = (AnalyzeDict)iterator.next();
            if (!dict.equals((Object)analyzeDict)) continue;
            dict.setItems(analyzeDict.getItems());
            insert = false;
            break;
        }
        if (insert) {
            dictList.add(analyzeDict);
        }
        this.save(this.analyzeService.getAnalyzeSet());
        return analyzeDict;
    }
}

