/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.analysis.service.impl;

import cn.gtmap.onemap.analysis.core.BaseLogger;
import cn.gtmap.onemap.analysis.model.AnalyzeDict;
import cn.gtmap.onemap.analysis.model.AnalyzeModel;
import cn.gtmap.onemap.analysis.model.AnalyzeRule;
import cn.gtmap.onemap.analysis.model.AnalyzeSet;
import cn.gtmap.onemap.analysis.model.Item;
import cn.gtmap.onemap.analysis.service.AnalyzeService;
import cn.gtmap.onemap.analysis.service.impl.AnalyzeServiceImpl;
import cn.gtmap.onemap.analysis.support.ConfigUpdateEvent;
import cn.gtmap.onemap.analysis.support.Constants;
import cn.gtmap.onemap.analysis.support.GeometryUtils;
import cn.gtmap.onemap.analysis.support.HashMapUtils;
import cn.gtmap.onemap.analysis.support.JSONMessageException;
import cn.gtmap.onemap.analysis.support.ListUtils;
import cn.gtmap.onemap.analysis.support.ZipUtils;
import cn.gtmap.onemap.model.GeoFile;
import cn.gtmap.onemap.service.GeoService;
import cn.gtmap.onemap.util.ArrayUtils;
import cn.gtmap.onemap.util.GeosUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import org.yaml.snakeyaml.Yaml;
import sun.misc.BASE64Decoder;

/*
 * Exception performing whole class analysis ignored.
 */
public class AnalyzeServiceImpl
extends BaseLogger
implements AnalyzeService,
ApplicationListener<ConfigUpdateEvent> {
    private final String ZLDWDM = "ZLDWDM";
    private final String ZLDWMC = "ZLDWMC";
    private final String QSDWMC = "QSDWMC";
    private final String QSDWDM = "QSDWDM";
    private final String DLBM = "DLBM";
    private final String CCMJ = "CCMJ";
    private final String QSXZ = "QSXZ";
    private final String key_children = "children";
    private final String dict_tdlyxz_a = "tdlyxzA";
    private final String dict_tdlyxz_b = "tdlyxzB";
    private final String TAG_BJ = "bj";
    private static final String BJ_AREA = "area";
    private static final String BJ_AREA_NYD = "nydArea";
    private static final String BJ_AREA_GD = "gdArea";
    private static final String BJ_AREA_JSYD = "jsydArea";
    private static final String BJ_AREA_WLYD = "wlydArea";
    private GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
    private CoordinateReferenceSystem defaultCrs;
    @Autowired
    private GeoService geoService;
    private AnalyzeSet analyzeSet;
    private static final String LAYER_MIDDLE_FIX_H = "_H_";
    private static String zhPattern = "[\\u4e00-\\u9fa5]+";

    public void onApplicationEvent(ConfigUpdateEvent event) {
        Object set = event.getSource();
        if (this.isNotNull(set)) {
            this.analyzeSet = (AnalyzeSet)set;
        }
    }

    public void setAnalyzeSet(Resource analyzeSet) {
        Yaml yaml = new Yaml();
        try {
            this.analyzeSet = (AnalyzeSet)yaml.loadAs(IOUtils.toString((URI)analyzeSet.getURI(), (String)"utf-8"), AnalyzeSet.class);
        }
        catch (IOException e) {
            this.logger.error(e.getLocalizedMessage());
        }
    }

    public AnalyzeSet getAnalyzeSet() {
        return this.analyzeSet;
    }

    public List<AnalyzeModel> getModels() {
        return this.analyzeSet.getModels();
    }

    public AnalyzeRule getRule() {
        return this.analyzeSet.getRule();
    }

    public List<AnalyzeDict> getDicts() {
        return this.analyzeSet.getDicts();
    }

    public Object analyze(String modelId, String geometry) {
        AnalyzeModel model = this.analyzeSet.getModel(modelId);
        Assert.notNull((Object)model, (String)"\u5206\u6790\u6a21\u578b\u4e0d\u5b58\u5728!");
        try {
            if (this.analyzeSet.getRule().isCheckTopoFirst()) {
                this.checkTopo(geometry);
            }
            ANALYSIS_TYPE type = ANALYSIS_TYPE.valueOf((String)modelId);
            switch (4.$SwitchMap$cn$gtmap$onemap$analysis$service$impl$AnalyzeServiceImpl$ANALYSIS_TYPE[type.ordinal()]) {
                case 1: {
                    return this.landUseAnalyze(geometry);
                }
                case 2: {
                    return this.landPlanAnalyze(geometry);
                }
                case 3: {
                    return this.multipleAnalyze2(geometry);
                }
                case 4: {
                    return this.landFarmAnalyze(geometry);
                }
                case 5: {
                    return this.customAnalyze(geometry);
                }
            }
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            throw new RuntimeException(this.getMessage("ana.err", new Object[]{e.getLocalizedMessage()}));
        }
        return null;
    }

    private void checkTopo(String geometry) {
        try {
            String topoErr = this.geoService.findTopoError(geometry);
            if (this.isNotNull((Object)topoErr)) {
                throw new RuntimeException(topoErr);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public Map parseGeoFile(MultipartFile file) {
        LinkedHashMap ret = Maps.newLinkedHashMap();
        try {
            String[] fileNameArray = file.getOriginalFilename().split("\\.");
            String suffix = fileNameArray[fileNameArray.length - 1];
            GeosUtils.GeoFileType geoFileType = GeosUtils.GeoFileType.valueOf((String)suffix.toLowerCase());
            GeoFile geoFile = new GeoFile(file.getBytes(), geoFileType);
            String geoBefore = this.geoService.toGeoJSON(geoFile);
            Map obj = (Map)JSON.parseObject((String)geoBefore, Map.class);
            if ("bj".equalsIgnoreCase(MapUtils.getString((Map)obj, (Object)"type"))) {
                Map temp = (Map)obj.get("value");
                ret.put("feature", this.process(MapUtils.getString((Map)temp, (Object)"feature")));
                HashMap report = new HashMap();
                report.putAll(temp);
                report.remove("feature");
                ret.put("report", report);
            } else {
                ret.put("feature", this.process(geoBefore));
            }
        }
        catch (IllegalArgumentException e) {
            throw new JSONMessageException(this.getMessage("file.upload.err", new Object[]{"\u4e0d\u652f\u6301\u6b64\u7c7b\u6587\u4ef6\u89e3\u6790!"}));
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("file.upload.err", new Object[]{e.getLocalizedMessage()}));
        }
        return ret;
    }

    public Map parseBjXml(String bjXml) {
        Assert.notNull((Object)bjXml);
        byte[] buffer = null;
        try {
            Map<String, HashMap<String, Map>> ret = Maps.newLinkedHashMap();
            File tmp = new File("gt".concat(".xml"));
            this.decodeBase64File(bjXml, tmp.getAbsolutePath());
            REPORT_TYPE type = this.predicateReportFile(tmp);
            if (REPORT_TYPE.plot.equals((Object)type)) {
                ret = this.parseReportPlot(tmp);
            } else {
                int n;
                File zipFile = ZipUtils.doZip((String)tmp.getAbsolutePath(), null);
                FileInputStream fis = new FileInputStream(zipFile);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                int size = fis.available();
                byte[] b = new byte[size];
                while ((n = fis.read(b)) != -1) {
                    bos.write(b, 0, n);
                }
                fis.close();
                bos.close();
                buffer = bos.toByteArray();
                GeoFile geoFile = new GeoFile(buffer, GeosUtils.GeoFileType.zip);
                String geoBefore = this.geoService.toGeoJSON(geoFile);
                Map obj = (Map)JSON.parseObject((String)geoBefore, Map.class);
                Map temp = (Map)obj.get("value");
                ret.put("feature", (HashMap<String, Map>)this.process(MapUtils.getString((Map)temp, (Object)"feature")));
                HashMap report = new HashMap();
                report.putAll(temp);
                report.remove("feature");
                ret.put("report", report);
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    private void decodeBase64File(String base64Code, String targetPath) throws Exception {
        byte[] buffer = new BASE64Decoder().decodeBuffer(base64Code);
        FileOutputStream out = new FileOutputStream(targetPath);
        out.write(buffer);
        out.close();
    }

    private REPORT_TYPE predicateReportFile(File xmlFile) {
        Assert.notNull((Object)xmlFile);
        SAXReader reader = new SAXReader();
        try {
            Document document = reader.read((InputStream)new FileInputStream(xmlFile));
            Element root = document.getRootElement();
            return root.attribute("REPORTNAME") == null ? REPORT_TYPE.plot : REPORT_TYPE.whole;
        }
        catch (DocumentException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    private Map parseReportPlot(File xmlFile) {
        Assert.notNull((Object)xmlFile);
        LinkedHashMap ret = Maps.newLinkedHashMap();
        SAXReader reader = new SAXReader();
        Document document = null;
        try {
            document = reader.read((InputStream)new FileInputStream(xmlFile));
            Element root = document.getRootElement();
            List plotClassArea = root.selectSingleNode("DATA[@DATANAME='BL_SURVEY_AREA']").selectNodes("ROW");
            List surveyBoundRows = root.selectSingleNode("DATA[@DATANAME='BL_SURVEY_BOUND']").selectNodes("ROW");
            List actualPls = root.selectSingleNode("DATA[@DATANAME='BL_SURVEY_PLOT']").selectNodes("ROW");
            Node blPntCoords = root.selectSingleNode("DATA[@DATANAME='BL_PNT_COORD']");
            ArrayList<Map> features = new ArrayList<Map>();
            CoordinateReferenceSystem sourceCrs = null;
            for (Object item : actualPls) {
                if (!(item instanceof Element)) continue;
                Element row = (Element)item;
                String plId = row.attributeValue("PL_ID");
                String sbId = row.attributeValue("SB_ID");
                String plName = row.attributeValue("PL_NAME");
                Map feature = this.getFeatureFromBj(plId, sbId, plName, blPntCoords);
                if (sourceCrs == null) {
                    sourceCrs = (CoordinateReferenceSystem)feature.get("FEATURE_CRS");
                }
                feature.remove("FEATURE_CRS");
                features.add(feature);
            }
            ArrayList nFeatures = new ArrayList();
            Map groupedMap = AnalyzeServiceImpl.listConvertMap(features, (String)"SB_ID");
            for (String key : groupedMap.keySet()) {
                List fs = (List)groupedMap.get(key);
                Map info = this.getPlotClassArea(key, plotClassArea);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("ID", key);
                map.put("SB_ID", key);
                map.put("INFO", JSON.toJSONString((Object)info));
                for (Object row : surveyBoundRows) {
                    Element surveyBoundRow;
                    if (!(row instanceof Element) || !key.equals((surveyBoundRow = (Element)row).attributeValue("SB_ID"))) continue;
                    map.put("NAME", surveyBoundRow.attributeValue("PROJ_NAME"));
                    break;
                }
                map.put("SHAPE_AREA", (String)info.get("area"));
                if (fs.size() > 1) {
                    ArrayList<Polygon> polygons = new ArrayList<Polygon>();
                    for (Map f : fs) {
                        Geometry geo = this.readWKT(MapUtils.getString((Map)f, (Object)"SHAPE"));
                        if (!(geo instanceof Polygon)) continue;
                        polygons.add((Polygon)geo);
                    }
                    if (polygons.size() > 0) {
                        map.put("SHAPE", this.geometryFactory.createMultiPolygon(polygons.toArray(new Polygon[0])).toText());
                    }
                } else {
                    map.put("SHAPE", MapUtils.getString((Map)((Map)fs.get(0)), (Object)"SHAPE"));
                }
                nFeatures.add(map);
                ret.put("feature", JSON.parseObject((String)this.geoService.list2FeatureCollection(nFeatures, null, null)));
                HashMap report = new HashMap();
                report.put("title", map.get("NAME"));
                report.putAll(JSON.parseObject((String)((String)map.get("INFO"))));
                ret.put("report", report);
            }
        }
        catch (DocumentException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return ret;
    }

    private Map getPlotClassArea(String id, List rows) {
        HashMap<String, Double> result = new HashMap<String, Double>();
        ArrayList list = new ArrayList();
        double sumArea = 0.0;
        double buildArea = 0.0;
        double tilthArea = 0.0;
        double unusedArea = 0.0;
        double farmArea = 0.0;
        for (Object item : rows) {
            Element row;
            String sbId;
            if (!(item instanceof Element) || !id.equals(sbId = (row = (Element)item).attributeValue("SB_ID"))) continue;
            String dlbm = row.attributeValue("LAND_TYPE");
            String gyAttrVal = row.attributeValue("GY_AREA");
            String jtAttrVal = row.attributeValue("JT_AREA");
            Double jtArea = StringUtils.isBlank((String)jtAttrVal) ? 0.0 : Double.valueOf(jtAttrVal);
            Double gyArea = StringUtils.isBlank((String)gyAttrVal) ? 0.0 : Double.valueOf(gyAttrVal);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("dlbm", dlbm);
            map.put("area", jtArea + gyArea);
            list.add(map);
        }
        Map gMap = AnalyzeServiceImpl.listConvertMap(list, (String)"dlbm");
        if (!this.isNull((Object)gMap)) {
            Iterator i$ = gMap.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry item;
                Map.Entry entry = item = i$.next();
                List data = (List)MapUtils.getObject((Map)gMap, entry.getKey());
                double classArea = 0.0;
                for (Map tmp : data) {
                    classArea += MapUtils.getDouble((Map)tmp, (Object)"area", (Double)0.0).doubleValue();
                }
                if (AnalyzeServiceImpl.contains((String[])TDLYXZ_THREE_TYPE.TILTH.getDlbms(), (String)String.valueOf(entry.getKey()), (boolean)true)) {
                    tilthArea += classArea;
                }
                if (AnalyzeServiceImpl.contains((String[])TDLYXZ_THREE_TYPE.FARM.getDlbms(), (String)String.valueOf(entry.getKey()), (boolean)true)) {
                    farmArea += classArea;
                }
                if (AnalyzeServiceImpl.contains((String[])TDLYXZ_THREE_TYPE.BUILD.getDlbms(), (String)String.valueOf(entry.getKey()), (boolean)true)) {
                    buildArea += classArea;
                }
                if (AnalyzeServiceImpl.contains((String[])TDLYXZ_THREE_TYPE.UNUSED.getDlbms(), (String)String.valueOf(entry.getKey()), (boolean)true)) {
                    unusedArea += classArea;
                }
                sumArea += classArea;
            }
        }
        result.put("area", sumArea);
        result.put("nydArea", farmArea);
        result.put("gdArea", tilthArea);
        result.put("jsydArea", buildArea);
        result.put("wlydArea", unusedArea);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private Map getFeatureFromBj(String plId, String sbId, String plName, Node node) {
        HashMap<String, String> feature = new HashMap<String, String>();
        Object fearureCrs = null;
        feature.put("ID", plId);
        feature.put("NAME", plName);
        feature.put("SB_ID", sbId);
        LinkedHashMap rings = new LinkedHashMap();
        List rows = node.selectNodes("ROW[@PL_ID='" + plId + "']");
        ArrayList sortRows = new ArrayList();
        for (Object e : rows) {
            if (!(e instanceof Element)) continue;
            Element row = (Element)e;
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put("GROUP", row.attributeValue("ROUND_NO"));
            map.put("PNT", row.attributeValue("PNT_INDEX"));
            map.put("Y_COORD", row.attributeValue("X_COORD"));
            map.put("X_COORD", row.attributeValue("Y_COORD"));
            sortRows.add(map);
        }
        Collections.sort(sortRows, new /* Unavailable Anonymous Inner Class!! */);
        for (HashMap hashMap : sortRows) {
            String ringNo = String.valueOf(hashMap.get("GROUP"));
            double x = Double.valueOf((String)hashMap.get("X_COORD"));
            double y = Double.valueOf((String)hashMap.get("Y_COORD"));
            if (rings.containsKey(ringNo)) {
                ((List)rings.get(ringNo)).add(new Coordinate(x, y));
                continue;
            }
            ArrayList<Coordinate> ring = new ArrayList<Coordinate>();
            ring.add(new Coordinate(x, y));
            rings.put(ringNo, ring);
        }
        LinearRing shell = null;
        Object var11_14 = null;
        Collection coords = rings.values();
        for (List coordinates : coords) {
            Coordinate first = (Coordinate)coordinates.get(0);
            Coordinate last = (Coordinate)coordinates.get(coordinates.size() - 1);
            if (first.x == last.x && first.y == last.y) continue;
            coordinates.add(new Coordinate(first.x, first.y));
        }
        Polygon polygon = null;
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
        List coordinates22 = null;
        try {
            void var11_15;
            for (List coordinates22 : coords) {
                if (shell == null) {
                    shell = geometryFactory.createLinearRing(coordinates22.toArray(new Coordinate[0]));
                    continue;
                }
                if (var11_15 == null) {
                    ArrayList arrayList = new ArrayList();
                }
                var11_15.add(geometryFactory.createLinearRing(coordinates22.toArray(new Coordinate[0])));
            }
            polygon = geometryFactory.createPolygon(shell, var11_15 != null ? var11_15.toArray(new LinearRing[0]) : null);
        }
        catch (Exception e) {
            throw new RuntimeException(this.getMessage("bj.polygon.coords.error", new Object[]{plName, e.getLocalizedMessage(), JSON.toJSONString((Object)coordinates22)}));
        }
        feature.put("SHAPE", polygon.toText());
        return feature;
    }

    public Geometry readWKT(String wkt) {
        try {
            return new WKTReader(this.geometryFactory).read(wkt);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public static String listToString(List list, String separator) {
        StringBuilder sb = new StringBuilder();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                if (i <= list.size() - 2) {
                    sb.append(list.get(i));
                    sb.append(separator != null ? separator : ",");
                    continue;
                }
                sb.append(list.get(i));
            }
        }
        return sb.toString();
    }

    public static final boolean contains(String[] src, String des, boolean ignoreCase) {
        for (String item : src) {
            if (!StringUtils.isNotBlank((String)item) || !StringUtils.isNotBlank((String)des) || !(ignoreCase ? item.equalsIgnoreCase(des) : item.equals(des))) continue;
            return true;
        }
        return false;
    }

    public String generateXlsData(String modelId, Object analysisRet) {
        try {
            ANALYSIS_TYPE type = ANALYSIS_TYPE.valueOf((String)modelId);
            switch (4.$SwitchMap$cn$gtmap$onemap$analysis$service$impl$AnalyzeServiceImpl$ANALYSIS_TYPE[type.ordinal()]) {
                case 1: {
                    return "";
                }
                case 2: {
                    Map temp = (Map)analysisRet;
                    LinkedHashMap map = new LinkedHashMap();
                    for (Object key : temp.keySet()) {
                        ArrayList list = new ArrayList();
                        List keyList = (List)((Map)temp.get(key)).get("info");
                        for (int i = 1; i < keyList.size(); ++i) {
                            Map tmp = (Map)keyList.get(i);
                            ArrayList<Object> tempList = new ArrayList<Object>();
                            tempList.add(tmp.get("LXMC"));
                            tempList.add(Math.round(Double.valueOf(tmp.get("AREA").toString())));
                            list.add(tempList);
                        }
                        map.put(key, list);
                    }
                    return JSON.toJSONString(map);
                }
                case 3: {
                    return "";
                }
                case 4: {
                    ArrayList tempJbnt = new ArrayList((List)analysisRet);
                    LinkedHashMap mapJbnt = new LinkedHashMap();
                    mapJbnt.put("\u603b\u9762\u79ef", ((Map)tempJbnt.get(0)).get("total"));
                    mapJbnt.put("\u8015\u5730", ((Map)tempJbnt.get(0)).get("gd"));
                    mapJbnt.put("\u6c34\u7530", ((Map)tempJbnt.get(0)).get("011"));
                    mapJbnt.put("\u6c34\u6d47\u5730", ((Map)tempJbnt.get(0)).get("012"));
                    mapJbnt.put("\u65f1\u5730", ((Map)tempJbnt.get(0)).get("013"));
                    mapJbnt.put("\u53ef\u8c03\u6574\u5730\u7c7b\u9762\u79ef", ((Map)tempJbnt.get(0)).get("ktz"));
                    mapJbnt.put("\u679c\u56ed", ((Map)tempJbnt.get(0)).get("021"));
                    mapJbnt.put("\u8336\u56ed", ((Map)tempJbnt.get(0)).get("022"));
                    mapJbnt.put("\u5176\u4ed6\u56ed\u5730", ((Map)tempJbnt.get(0)).get("023"));
                    mapJbnt.put("\u6709\u6797\u5730", ((Map)tempJbnt.get(0)).get("031"));
                    mapJbnt.put("\u5176\u4ed6\u6797\u5730", ((Map)tempJbnt.get(0)).get("033"));
                    mapJbnt.put("\u4eba\u5de5\u7267\u8349\u5730", ((Map)tempJbnt.get(0)).get("042"));
                    mapJbnt.put("\u5751\u5858\u6c34\u9762", ((Map)tempJbnt.get(0)).get("114"));
                    return JSON.toJSONString(mapJbnt);
                }
            }
            return "";
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    private Map process(String geometry) {
        try {
            Map ret = (Map)JSON.parseObject((String)geometry, Map.class);
            List fs = (List)ret.get("features");
            CoordinateReferenceSystem crs = null;
            if (ret.get("crs") != null) {
                crs = GeometryUtils.createCRS((JSONObject)((JSONObject)ret.get("crs")));
            }
            if (crs instanceof GeographicCRS) {
                String projGeo = this.geoService.project(geometry, crs.toWKT(), "2364");
                Map tmp = (Map)JSON.parseObject((String)projGeo, Map.class);
                if (!tmp.containsKey("crs")) {
                    tmp.put("crs", GeometryUtils.createCrsMap((String)"2364"));
                }
                return this.process(JSON.toJSONString((Object)tmp));
            }
            for (Map f : fs) {
                Geometry g = (Geometry)GeometryUtils.parseGeoJSON((String)JSON.toJSONString(f.get("geometry")));
                double area = 0.0;
                IsValidOp isValidOp = new IsValidOp(g);
                if (this.isNotNull((Object)isValidOp.getValidationError())) {
                    g = GeometryUtils.createValidGeometry((Geometry)g);
                }
                if (g instanceof Polygon) {
                    area = g.getArea();
                } else if (g instanceof LinearRing) {
                    area = g.getLength();
                } else if (g instanceof MultiPolygon) {
                    MultiPolygon multiPolygon = (MultiPolygon)g;
                    for (int j = 0; j < multiPolygon.getNumGeometries(); ++j) {
                        Polygon polygon = (Polygon)multiPolygon.getGeometryN(j);
                        area += polygon.getArea();
                    }
                }
                Map properties = (Map)f.get("properties");
                properties.put("SHAPE_AREA", area);
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public Map landUseAnalyze(String geometry) {
        HashMap<String, List> ret = new HashMap<String, List>();
        AnalyzeModel analyzeModel = this.analyzeSet.getModel(ANALYSIS_TYPE.tdlyxz.name());
        String dataSource = analyzeModel.getDataSource();
        List years = (List)analyzeModel.getParams();
        Assert.notEmpty((Collection)years);
        for (Map tdlyxz : years) {
            String dltbLayerName = MapUtils.getString((Map)tdlyxz, (Object)"dltb");
            String xzdwLayerName = MapUtils.getString((Map)tdlyxz, (Object)"xzdw");
            try {
                ret.put(MapUtils.getString((Map)tdlyxz, (Object)"year"), this.landUseAnalyzeCore(geometry, dltbLayerName, xzdwLayerName, dataSource));
            }
            catch (Exception e) {
                this.logger.error(e.getLocalizedMessage());
            }
        }
        return ret;
    }

    private List<Map> landUseAnalyzeCore(String geometry, String dltbLyr, String xzdwLyr, String dataSource) {
        try {
            List details;
            ArrayList ret = Lists.newArrayList();
            Map analysisMap = this.geoService.tdlyxz(dltbLyr, xzdwLyr, geometry, dataSource);
            if (this.isNotNull((Object)analysisMap) && !analysisMap.isEmpty() && this.isNotNull((Object)(details = (List)analysisMap.get("analysisAreaDetail"))) && details.size() > 0) {
                String featureCollection;
                File shpFile;
                ArrayList<LinkedHashMap> dwdmList = new ArrayList<LinkedHashMap>();
                for (Map map : details) {
                    String zldwdm = MapUtils.getString((Map)map, (Object)"ZLDWDM");
                    String zldwmc = MapUtils.getString((Map)map, (Object)"ZLDWMC");
                    String qsdwmc = MapUtils.getString((Map)map, (Object)"QSDWMC");
                    String qsdwdm = MapUtils.getString((Map)map, (Object)"QSDWDM");
                    Collection filterRet = Collections2.filter(dwdmList, (Predicate)new /* Unavailable Anonymous Inner Class!! */);
                    if (filterRet.size() > 0) {
                        Map m = (Map)filterRet.iterator().next();
                        List tempList = (List)m.get("children");
                        tempList.add(map);
                        m.put("children", tempList);
                        continue;
                    }
                    LinkedHashMap temp = Maps.newLinkedHashMap();
                    temp.put("ZLDWMC".toLowerCase(), zldwmc);
                    temp.put("ZLDWDM".toLowerCase(), zldwdm);
                    temp.put("QSDWDM".toLowerCase(), qsdwdm);
                    temp.put("QSDWMC".toLowerCase(), qsdwmc);
                    temp.put("children", Lists.newArrayList((Object[])new Map[]{map}));
                    dwdmList.add(temp);
                }
                for (Map map : dwdmList) {
                    List list = (List)map.get("children");
                    LinkedHashMap mapA = this.groupByDict("tdlyxzA", list);
                    Map mapB = ListUtils.groupSumByField((List)list, (String)"DLBM", (String)"CCMJ");
                    LinkedHashMap mapC = this.groupByDict("tdlyxzB", list);
                    double total = HashMapUtils.getSumDoubleBy((Map)mapA);
                    mapB.putAll(mapA);
                    map.put("A", mapA);
                    map.put("B", mapB);
                    map.put("C", mapC);
                    map.put("total", total);
                    ret.add(map);
                }
                HashMap<String, Object> totalMap = new HashMap<String, Object>();
                LinkedHashMap linkedHashMap = this.groupByDict("tdlyxzA", details);
                totalMap.put("ZLDWMC".toLowerCase(), "\u5408\u8ba1");
                totalMap.put("total", HashMapUtils.getSumDoubleBy((Map)linkedHashMap));
                totalMap.put("A", linkedHashMap);
                totalMap.put("B", ListUtils.groupSumByField((List)details, (String)"DLBM", (String)"CCMJ"));
                totalMap.put("C", this.groupByDict("tdlyxzB", details));
                totalMap.put("GY", ListUtils.getSumByQueryField((List)details, (String)"QSXZ", (String)"10", (String)"CCMJ"));
                totalMap.put("JT", ListUtils.getSumByQueryField((List)details, (String)"QSXZ", (List)Lists.newArrayList((Object[])new String[]{"31", "32", "33"}), (String)"CCMJ"));
                List detailXz = (List)analysisMap.get("analysisAreaDetail");
                if (this.isNotNull((Object)detailXz) && detailXz.size() > 0 && (shpFile = this.geoService.exportToShp(featureCollection = this.geoService.list2FeatureCollection(detailXz, null, null))).exists()) {
                    totalMap.put("shpId", this.upload2FileStore(shpFile));
                }
                ret.add(totalMap);
            }
            return ret;
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("ana.err.xz", new Object[]{e.getLocalizedMessage()}));
        }
    }

    private LinkedHashMap groupByDict(String dictName, List<Map> list) {
        AnalyzeDict dict = this.analyzeSet.getDict(dictName);
        LinkedHashMap ret = Maps.newLinkedHashMap();
        for (Item item : dict.getItems()) {
            String k = item.getKey();
            String v = item.getValue();
            Collection filterRet = Collections2.filter(list, (Predicate)new /* Unavailable Anonymous Inner Class!! */);
            ret.put(k, filterRet.size() > 0 ? ListUtils.getSumByField((List)Lists.newArrayList((Iterable)filterRet), (String)"CCMJ") : 0.0);
        }
        return ret;
    }

    public Map landPlanAnalyze(String geometry) {
        AnalyzeModel analyzeModel = this.analyzeSet.getModel(ANALYSIS_TYPE.tdgh.name());
        String year = (String)analyzeModel.getParams();
        String outFields = this.isNull((Object)analyzeModel.getOutFields()) ? "*" : analyzeModel.getOutFields();
        String dataSource = analyzeModel.getDataSource();
        try {
            HashMap ret = new HashMap();
            Map map = this.geoService.tdghsc(year, geometry, outFields, dataSource);
            if (this.isNotNull((Object)map) && !map.isEmpty()) {
                for (Object k : map.keySet()) {
                    Object obj = map.get(k);
                    if (!(obj instanceof Map)) continue;
                    ret.put(k, obj);
                }
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public List<Map> landFarmAnalyze(String geometry) {
        List analysisResult;
        AnalyzeModel analyzeModel = this.analyzeSet.getModel(ANALYSIS_TYPE.jbnt.name());
        String layerName = analyzeModel.getLayerName();
        String dataSource = analyzeModel.getDataSource();
        ArrayList<Map> result = new ArrayList<Map>();
        try {
            analysisResult = this.geoService.intersect2(layerName, geometry, null, dataSource);
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("ana.err.jbnt", new Object[]{e.getLocalizedMessage()}));
        }
        if (this.isNotNull((Object)analysisResult)) {
            double conv = 1.0E-4;
            double area_011 = Math.round(ListUtils.getSumByQueryField((List)analysisResult, (String)"DLBM", (String)"011", (String)"SHAPE_AREA"));
            double area_012 = Math.round(ListUtils.getSumByQueryField((List)analysisResult, (String)"DLBM", (String)"012", (String)"SHAPE_AREA"));
            double area_013 = Math.round(ListUtils.getSumByQueryField((List)analysisResult, (String)"DLBM", (String)"013", (String)"SHAPE_AREA"));
            double area_022 = Math.round(ListUtils.getSumByQueryField((List)analysisResult, (String)"DLBM", (String)"022", (String)"SHAPE_AREA"));
            double area_021 = Math.round(ListUtils.getSumByQueryField((List)analysisResult, (String)"DLBM", (String)"021", (String)"SHAPE_AREA"));
            double area_023 = Math.round(ListUtils.getSumByQueryField((List)analysisResult, (String)"DLBM", (String)"023", (String)"SHAPE_AREA"));
            double area_031 = Math.round(ListUtils.getSumByQueryField((List)analysisResult, (String)"DLBM", (String)"031", (String)"SHAPE_AREA"));
            double area_033 = Math.round(ListUtils.getSumByQueryField((List)analysisResult, (String)"DLBM", (String)"033", (String)"SHAPE_AREA"));
            double area_042 = Math.round(ListUtils.getSumByQueryField((List)analysisResult, (String)"DLBM", (String)"042", (String)"SHAPE_AREA"));
            double area_114 = Math.round(ListUtils.getSumByQueryField((List)analysisResult, (String)"DLBM", (String)"114", (String)"SHAPE_AREA"));
            double gdArea = area_011 + area_012 + area_013;
            double ktzArea = area_022 + area_021 + area_023 + area_031 + area_033 + area_042 + area_114;
            double totalArea = gdArea + ktzArea;
            HashMap<String, Double> map = new HashMap<String, Double>();
            map.put("011", area_011 * conv);
            map.put("012", area_012 * conv);
            map.put("013", area_013 * conv);
            map.put("022", area_022 * conv);
            map.put("021", area_021 * conv);
            map.put("023", area_023 * conv);
            map.put("031", area_031 * conv);
            map.put("033", area_033 * conv);
            map.put("042", area_042 * conv);
            map.put("114", area_114 * conv);
            map.put("gd", gdArea * conv);
            map.put("ktz", ktzArea * conv);
            map.put("total", totalArea * conv);
            result.add(map);
        }
        return result;
    }

    public Map multipleAnalyze(String geometry) {
        AnalyzeModel analyzeModel = this.analyzeSet.getModel(ANALYSIS_TYPE.multi.name());
        return this.geoService.multiAnalyze((List)analyzeModel.getParams(), geometry);
    }

    public Map customAnalyze(String geometry) {
        AnalyzeModel analyzeModel = this.analyzeSet.getModel(ANALYSIS_TYPE.custom.name());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("layerName", analyzeModel.getLayerName());
        map.put("geometry", geometry);
        map.put("outFields", analyzeModel.getOutFields());
        map.put("titleField", analyzeModel.getTitleFields());
        map.put("fieldAlias", JSON.toJSONString((Object)analyzeModel.getFieldAlias()));
        map.put("dataSource", analyzeModel.getDataSource());
        return (Map)JSON.parseObject((String)AnalyzeServiceImpl.post((String)AppConfig.getProperty((String)"omp.url").concat("/geometryService/rest/analysis/common"), map).toString(), Map.class);
    }

    public Map multipleAnalyze2(String geometry) {
        AnalyzeModel analyzeModel = this.analyzeSet.getModel(ANALYSIS_TYPE.multi.name());
        List multiParams = (List)analyzeModel.getParams();
        if (this.isNull((Object)multiParams)) {
            throw new RuntimeException("params cannot be null");
        }
        if (this.isNull((Object)geometry)) {
            throw new RuntimeException("geometry cannot be null");
        }
        LinkedHashMap<String, Serializable> analysisResult = new LinkedHashMap<String, Serializable>();
        try {
            for (Map paraMap : multiParams) {
                List multiResult;
                List intersectResult;
                String year;
                String[] fields;
                String funId = MapUtils.getString((Map)paraMap, (Object)"funid");
                Boolean isOpen = MapUtils.getBoolean((Map)paraMap, (Object)"visible", (Boolean)false);
                String alias = paraMap.containsKey("alias") ? MapUtils.getString((Map)paraMap, (Object)"alias") : funId;
                String outFields = this.isNull((Object)MapUtils.getString((Map)paraMap, (Object)"returnFields")) ? "*" : MapUtils.getString((Map)paraMap, (Object)"returnFields");
                String[] stringArray = fields = "*".equals(outFields) ? null : outFields.split(",");
                if (!isOpen.booleanValue()) continue;
                List<String> layers = Arrays.asList(MapUtils.getString((Map)paraMap, (Object)"layerName", (String)"").split(","));
                String layerCrs = layers.get(0);
                String dataSource = MapUtils.getString((Map)paraMap, (Object)"dataSource");
                Boolean exportable = MapUtils.getBoolean((Map)paraMap, (Object)"exportable", (Boolean)false);
                HashMap<String, Object> singleResult = new HashMap<String, Object>();
                singleResult.put("alias", alias);
                ArrayList iGeos = new ArrayList();
                if (ANALYSIS_TYPE.tdlyxz.name().equals(funId)) {
                    String featureCollection;
                    File shpFile;
                    List detail;
                    String dltb = MapUtils.getString((Map)paraMap, (Object)"dltb");
                    String xzdw = MapUtils.getString((Map)paraMap, (Object)"xzdw");
                    year = MapUtils.getString((Map)paraMap, (Object)"year");
                    String groupBy = MapUtils.getString((Map)paraMap, (Object)"groupBy", (String)"ZLDWDM");
                    if (StringUtils.isBlank((String)dltb) && StringUtils.isBlank((String)xzdw) && StringUtils.isNotBlank((String)year)) {
                        dltb = "DLTB".concat("_H_").concat(year);
                        xzdw = "XZDW".concat("_H_").concat(year);
                    }
                    List xzResult = this.landUseAnalyzeCore(geometry, dltb, xzdw, dataSource);
                    Map map = this.geoService.tdlyxz(dltb, xzdw, geometry, dataSource);
                    if (exportable.booleanValue() && !this.isNull((Object)dltb) && this.isNotNull((Object)(detail = (List)map.get("analysisAreaDetail"))) && detail.size() > 0 && (shpFile = this.geoService.exportToShp(featureCollection = this.geoService.list2FeatureCollection(detail, null, null))).exists()) {
                        singleResult.put("shpId", this.upload2FileStore(shpFile));
                    }
                    singleResult.put("result", xzResult);
                    singleResult.put("unit", null);
                    singleResult.put("totalResult", xzResult.size() > 0 ? (Map)xzResult.get(xzResult.size() - 1) : new HashMap());
                    HashMap<String, Object> excelMap = new HashMap<String, Object>();
                    excelMap.put("result", xzResult);
                    excelMap.put("unit", "SQUARE");
                    singleResult.put("resultStr", JSON.toJSONString(excelMap));
                    analysisResult.put(funId, singleResult);
                    continue;
                }
                if (ANALYSIS_TYPE.tdgh.name().equals(funId)) {
                    String regionCode = "";
                    year = MapUtils.getString((Map)paraMap, (Object)"year");
                    if (StringUtils.isNotBlank((String)year)) {
                        regionCode = year;
                    }
                    Map map = this.geoService.tdghsc(regionCode, geometry, outFields, dataSource);
                    singleResult.put("result", map);
                    singleResult.put("excelData", JSON.toJSONString((Object)this.tdghscExcelData(map)));
                    analysisResult.put(funId, singleResult);
                    continue;
                }
                if (ANALYSIS_TYPE.gyjsydfx.name().equals(funId)) {
                    String groupKey = MapUtils.getString((Map)paraMap, (Object)"groupField");
                    if (this.isNull((Object)groupKey)) {
                        this.logger.error("gyjsydfx: groupField cnnot be null, skip the analysis");
                        continue;
                    }
                    ArrayUtils.add2Arrays((String[])fields, (String)groupKey);
                    ArrayList groupResultList = new ArrayList();
                    intersectResult = new ArrayList();
                    for (String layerName : layers) {
                        intersectResult = this.geoService.intersect2(layerName, geometry, outFields, dataSource);
                        if (intersectResult == null || intersectResult.size() <= 0) continue;
                        multiResult = this.multiAnalyResult(funId, layerName, fields, intersectResult);
                        Map groupResult = AnalyzeServiceImpl.listConvertMap((List)multiResult, (String)groupKey);
                        Iterator iter = groupResult.entrySet().iterator();
                        while (iter.hasNext()) {
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            Map.Entry groupEntry = iter.next();
                            ArrayList groupValue = (ArrayList)groupEntry.getValue();
                            map.put("type", groupEntry.getKey());
                            map.put("area", this.getDouValueByField((List)groupValue, "SHAPE_AREA"));
                            ArrayList info = new ArrayList();
                            for (Map tmp : groupValue) {
                            }
                            map.put("info", info);
                            groupResultList.add(map);
                        }
                        for (Map map : intersectResult) {
                            HashMap temp = new HashMap();
                            temp.putAll(map);
                            iGeos.add(temp);
                        }
                    }
                    if (iGeos.size() > 0) {
                        singleResult.put("shpId", this.generateShpZip(iGeos, null));
                    }
                    singleResult.put("total", this.getDouValueByField(intersectResult, "SHAPE_AREA"));
                    singleResult.put("result", groupResultList);
                    singleResult.put("unit", null);
                    HashMap<String, HashMap<String, Object>> _temp = new HashMap<String, HashMap<String, Object>>();
                    _temp.put(funId, singleResult);
                    Iterator tempEntry = _temp.entrySet().iterator();
                    while (tempEntry.hasNext()) {
                        ((Map)tempEntry.next().getValue()).put("excelData", JSON.toJSONString((Object)this.multiExcelData(_temp)));
                    }
                    analysisResult.putAll(_temp);
                    continue;
                }
                ArrayList multiLists = new ArrayList();
                ArrayList<Map> detailList = new ArrayList<Map>();
                intersectResult = new ArrayList();
                for (String layerName : layers) {
                    intersectResult = this.geoService.intersect2(layerName, geometry, outFields, dataSource);
                    if (intersectResult.size() <= 0) continue;
                    multiResult = this.multiAnalyResult(funId, layerName, fields, intersectResult);
                    multiLists.addAll(multiResult);
                    for (Map item : intersectResult) {
                        HashMap temp = new HashMap();
                        temp.putAll(item);
                        iGeos.add(temp);
                    }
                }
                double geoArea = this.geoArea(geometry);
                if (exportable.booleanValue() && iGeos.size() > 0) {
                    singleResult.put("shpId", this.generateShpZip(iGeos, null));
                }
                if (ANALYSIS_TYPE.bp.name().equals(funId) || ANALYSIS_TYPE.gd.name().equals(funId)) {
                    HashMap bpResult = new HashMap();
                    HashMap<String, Object> bpResult1 = new HashMap<String, Object>();
                    HashMap<String, Object> bpResult2 = new HashMap<String, Object>();
                    HashMap<String, Object> bpResult3 = new HashMap<String, Object>();
                    double bpArea = this.getDouValueByField(intersectResult, "SHAPE_AREA");
                    ArrayList<HashMap<String, Object>> infoList = new ArrayList<HashMap<String, Object>>();
                    bpResult1.put("type", ANALYSIS_TYPE.bp.name().equals(funId) ? "\u5df2\u62a5" : "\u5df2\u4f9b");
                    bpResult1.put("area", bpArea);
                    bpResult1.put("area_gq", bpArea * Constants.UNIT.HECTARE.getRatio());
                    bpResult1.put("area_m", bpArea * Constants.UNIT.ACRES.getRatio());
                    infoList.add(bpResult1);
                    bpResult2.put("type", ANALYSIS_TYPE.bp.name().equals(funId) ? "\u672a\u62a5" : "\u672a\u4f9b");
                    bpResult2.put("area", geoArea - bpArea);
                    bpResult2.put("area_gq", (geoArea - bpArea) * Constants.UNIT.HECTARE.getRatio());
                    bpResult2.put("area_m", (geoArea - bpArea) * Constants.UNIT.ACRES.getRatio());
                    infoList.add(bpResult2);
                    bpResult3.put("type", "\u5408\u8ba1");
                    bpResult3.put("area", geoArea);
                    bpResult3.put("area_gq", geoArea * Constants.UNIT.HECTARE.getRatio());
                    bpResult3.put("area_m", geoArea * Constants.UNIT.ACRES.getRatio());
                    infoList.add(bpResult3);
                    bpResult.put("info", infoList);
                    for (Map item : multiLists) {
                        detailList.add(item);
                    }
                    bpResult.put("detail", detailList);
                    singleResult.put("result", bpResult);
                } else {
                    String iframeUrl = MapUtils.getString((Map)paraMap, (Object)"iframeUrl");
                    if (this.isNotNull((Object)iframeUrl)) {
                        singleResult.put("iframeUrl", iframeUrl);
                        if (multiLists.size() > 0) {
                            singleResult.put("iframeData", JSON.toJSONString(multiLists));
                        }
                    }
                    for (Map item : multiLists) {
                        detailList.add(item);
                    }
                    singleResult.put("result", detailList);
                }
                singleResult.put("layer", layers);
                if (iGeos.size() > 0) {
                    singleResult.put("geojson", this.geoService.list2FeatureCollection(iGeos, null, null));
                }
                HashMap<String, HashMap<String, Object>> _temp = new HashMap<String, HashMap<String, Object>>();
                _temp.put(funId, singleResult);
                for (Object res : _temp.keySet()) {
                    Map _r = (Map)_temp.get(res);
                    _r.put("excelData", JSON.toJSONString((Object)this.multiExcelData(_temp)));
                }
                analysisResult.putAll(_temp);
            }
            if (!analysisResult.isEmpty()) {
                this.generateSummaryReport(analysisResult);
            }
            double ogArea = this.geoArea(geometry);
            analysisResult.put("ogArea", Double.valueOf(ogArea));
            return analysisResult;
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public String upload2FileStore(File file) {
        return this.fileload(AppConfig.getProperty((String)"omp.url") + "/file/upload/OMA-PRO", file);
    }

    private LinkedHashMap tdghscExcelData(Map result) {
        LinkedHashMap map = new LinkedHashMap();
        for (Object key : result.keySet()) {
            if ("detail".equals(key) || "shpId".equals(key)) continue;
            ArrayList list = new ArrayList();
            List keyList = (List)((Map)result.get(key)).get("info");
            for (int i = 1; i < keyList.size(); ++i) {
                Map temp = (Map)keyList.get(i);
                ArrayList<Object> tempList = new ArrayList<Object>();
                tempList.add(temp.get("LXMC"));
                tempList.add(Math.round(Double.valueOf(temp.get("AREA").toString())));
                list.add(tempList);
            }
            map.put(key, list);
        }
        return map;
    }

    private List<?> multiAnalyResult(String funid, String layerName, String[] fields, List<?> multiResult) {
        try {
            if (multiResult.size() < 1) {
                return null;
            }
            List<Object> rf = new ArrayList();
            if (fields != null) {
                rf = Arrays.asList(fields);
            }
            ArrayList multiLists = new ArrayList();
            for (int i = 0; i < multiResult.size(); ++i) {
                Map getMap = (Map)multiResult.get(i);
                LinkedHashMap setMap = new LinkedHashMap();
                for (String string : rf) {
                    if (!getMap.containsKey(string)) continue;
                    setMap.put(string, getMap.get(string));
                }
                double area = MapUtils.getDoubleValue((Map)getMap, (Object)"SHAPE_AREA", (double)0.0);
                String wkt = MapUtils.getString((Map)getMap, (Object)"SHAPE");
                setMap.put("GQ", area * Constants.UNIT.HECTARE.getRatio());
                setMap.put("M", area * Constants.UNIT.ACRES.getRatio());
                if ("SDE.CKQ".equals(layerName.toUpperCase())) {
                    setMap.put("KCTYPE", "\u91c7\u77ff\u6743");
                } else if ("SDE.TKQ".equals(layerName.toUpperCase())) {
                    setMap.put("KCTYPE", "\u63a2\u77ff\u6743");
                }
                multiLists.add(setMap);
            }
            return multiLists;
        }
        catch (Exception e) {
            this.logger.error(this.getMessage("analysis.multi.result.error", new Object[]{e.getLocalizedMessage()}));
            return null;
        }
    }

    public double getDouValueByField(List<Map> list, String field) {
        double value = 0.0;
        assert (field != null);
        for (Map map : list) {
            if (this.isNull(map.get(field))) continue;
            value += MapUtils.getDoubleValue((Map)map, (Object)field, (double)0.0);
        }
        return value;
    }

    public static Map listConvertMap(List list, String groupKey) {
        assert (list != null);
        assert (groupKey != null);
        HashMap<String, List> map = new HashMap<String, List>();
        if (list.size() > 0) {
            for (Object obj : list) {
                Map item = (Map)obj;
                if (!item.containsKey(groupKey)) continue;
                String key = MapUtils.getString((Map)item, (Object)groupKey);
                if (map.containsKey(key)) {
                    List list1 = (List)map.get(key);
                    list1.add(item);
                    map.put(key, list1);
                    continue;
                }
                ArrayList<Map> list2 = new ArrayList<Map>();
                list2.add(item);
                map.put(key, list2);
            }
            return map;
        }
        return null;
    }

    private String generateShpZip(List list, CoordinateReferenceSystem srcCrs) {
        String fc = this.geoService.list2FeatureCollection(list, null, null);
        if (this.isNotNull((Object)fc)) {
            try {
                File shpFile = this.geoService.exportToShp(fc);
                if (shpFile.exists()) {
                    return this.upload2FileStore(shpFile);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e.getLocalizedMessage());
            }
        }
        return null;
    }

    public LinkedHashMap multiExcelData(Map<String, Map> data) {
        LinkedHashMap excelMap = new LinkedHashMap();
        DecimalFormat df = new DecimalFormat("0.####");
        for (String key : data.keySet()) {
            ArrayList<List> list = new ArrayList<List>();
            ArrayList headerList = new ArrayList();
            Map aMap = data.get(key);
            String alias = MapUtils.getString((Map)aMap, (Object)"alias");
            if (ANALYSIS_TYPE.bp.name().equals(key.toString()) || ANALYSIS_TYPE.gd.name().equals(key.toString())) {
                Map bpmap = (Map)aMap.get("result");
                List bpTotal = (List)bpmap.get("info");
                List bpDesc = (List)bpmap.get("detail");
                ArrayList list2 = new ArrayList();
                for (int i = 0; i < bpTotal.size(); ++i) {
                    Map temp1 = (Map)bpTotal.get(i);
                    ArrayList<Object> tempList = new ArrayList<Object>();
                    tempList.add(temp1.get("type"));
                    tempList.add(df.format(Double.valueOf(temp1.get("area").toString())));
                    tempList.add(df.format(Double.valueOf(temp1.get("area_gq").toString())));
                    tempList.add(df.format(Double.valueOf(temp1.get("area_m").toString())));
                    list.add(tempList);
                }
                if (bpDesc.size() > 0) {
                    Map headMap = (Map)bpDesc.get(0);
                    for (Object k : headMap.keySet()) {
                        headerList.add(k);
                    }
                    list2.add(headerList);
                    for (int i = 0; i < bpDesc.size(); ++i) {
                        Map temp2 = (Map)bpDesc.get(i);
                        ArrayList<String> tempList = new ArrayList<String>();
                        for (Object fieldkey : temp2.keySet()) {
                            Object value = temp2.get(fieldkey);
                            if (value instanceof Double) {
                                tempList.add(df.format(MapUtils.getDoubleValue((Map)temp2, fieldkey, (double)0.0)));
                                continue;
                            }
                            tempList.add((String)temp2.get(fieldkey));
                        }
                        list2.add(tempList);
                    }
                }
                if ("bp".equals(key.toString())) {
                    excelMap.put("\u62a5\u6279\u6c47\u603b", list);
                    excelMap.put("\u62a5\u6279\u8be6\u60c5", list2);
                    continue;
                }
                excelMap.put("\u4f9b\u5730\u6c47\u603b", list);
                excelMap.put("\u4f9b\u5730\u8be6\u60c5", list2);
                continue;
            }
            List keyList = new ArrayList();
            Object obj = aMap.get("result");
            if (obj instanceof Map) {
                keyList = (List)((Map)obj).get("detail");
            } else if (obj instanceof List) {
                keyList = (List)obj;
            }
            if (keyList.size() == 0) {
                return excelMap;
            }
            headerList.addAll(AnalyzeServiceImpl.mapConvertList((Map)((Map)keyList.get(0)), (TYPE)TYPE.key));
            list.add(headerList);
            for (int i = 0; i < keyList.size(); ++i) {
                Map temp = (Map)keyList.get(i);
                list.add(AnalyzeServiceImpl.mapConvertList((Map)temp, (TYPE)TYPE.value));
            }
            excelMap.put(alias, list);
        }
        return excelMap;
    }

    private static List mapConvertList(Map map, TYPE type) {
        assert (map != null);
        assert (type != null);
        ArrayList<Object> list = new ArrayList<Object>();
        if (type.equals((Object)TYPE.key)) {
            for (Object key : map.keySet()) {
                list.add(key);
            }
        } else {
            for (Map.Entry entry : map.entrySet()) {
                Object val = entry.getValue();
                list.add(val == null ? "" : val);
            }
        }
        return list;
    }

    private void generateSummaryReport(LinkedHashMap<String, Object> map) {
        DecimalFormat df = new DecimalFormat("#.####");
        if (this.isNotNull(map) && !map.isEmpty()) {
            for (String key : map.keySet()) {
                Map item = (Map)map.get(key);
                HashMap<String, Object> summary = new HashMap<String, Object>();
                String alias = MapUtils.getString((Map)item, (Object)"alias");
                summary.put("alias", StringUtils.isBlank((String)alias) ? "" : alias.substring(0, alias.length() - 2));
                List analysisList = new ArrayList();
                Map analysisMap = new HashMap();
                if (item.get("result") instanceof Map) {
                    analysisMap = (Map)item.get("result");
                } else if (item.get("result") instanceof List) {
                    analysisList = (List)item.get("result");
                }
                try {
                    List info;
                    if ("tdlyxz".equalsIgnoreCase(String.valueOf(ANALYSIS_TYPE.valueOf((String)key)))) {
                        Map totalResult = (Map)item.get("totalResult");
                        Map categoryC = (Map)totalResult.get("C");
                        summary.put("total", MapUtils.getDoubleValue((Map)totalResult, (Object)"total", (double)0.0));
                        for (Object o : categoryC.keySet()) {
                            String dlmc = o.toString();
                            String area = df.format(MapUtils.getDoubleValue((Map)categoryC, (Object)"dlmc", (double)0.0));
                            if ("\u519c\u7528\u5730".equals(dlmc)) {
                                summary.put("nyd", area);
                                continue;
                            }
                            if ("\u5efa\u8bbe\u7528\u5730".equals(dlmc)) {
                                summary.put("jsyd", area);
                                continue;
                            }
                            if (!"\u672a\u5229\u7528\u5730".equals(dlmc)) continue;
                            summary.put("wlyd", area);
                        }
                    } else if ("bp".equalsIgnoreCase(String.valueOf(ANALYSIS_TYPE.valueOf((String)key)))) {
                        info = (List)analysisMap.get("info");
                        summary.put("yb", df.format(MapUtils.getDoubleValue((Map)((Map)info.get(0)), (Object)"area", (double)0.0)));
                        summary.put("wb", df.format(MapUtils.getDoubleValue((Map)((Map)info.get(1)), (Object)"area", (double)0.0)));
                        summary.put("total", MapUtils.getDoubleValue((Map)((Map)info.get(2)), (Object)"area", (double)0.0));
                    } else if ("gd".equalsIgnoreCase(String.valueOf(ANALYSIS_TYPE.valueOf((String)key)))) {
                        info = (List)analysisMap.get("info");
                        summary.put("yg", df.format(MapUtils.getDoubleValue((Map)((Map)info.get(0)), (Object)"area", (double)0.0)));
                        summary.put("wg", df.format(MapUtils.getDoubleValue((Map)((Map)info.get(1)), (Object)"area", (double)0.0)));
                        summary.put("total", MapUtils.getDoubleValue((Map)((Map)info.get(2)), (Object)"area", (double)0.0));
                    } else if ("cl".equalsIgnoreCase(String.valueOf(ANALYSIS_TYPE.valueOf((String)key)))) {
                        summary.put("total", analysisList.size());
                    } else if ("sp".equalsIgnoreCase(String.valueOf(ANALYSIS_TYPE.valueOf((String)key)))) {
                        summary.put("total", analysisList.size());
                    } else if ("tdgh".equalsIgnoreCase(String.valueOf(ANALYSIS_TYPE.valueOf((String)key)))) {
                        Map ghMap = (Map)item.get("result");
                        if (ghMap.containsKey("\u571f\u5730\u7528\u9014\u5206\u533a")) {
                            Map tmpMap = (Map)ghMap.get("\u571f\u5730\u7528\u9014\u5206\u533a");
                            info = (List)tmpMap.get("info");
                            summary.put("tdytq", df.format(MapUtils.getDoubleValue((Map)((Map)info.get(0)), (Object)"AREA", (double)0.0)));
                        }
                        if (ghMap.containsKey("\u5efa\u8bbe\u7528\u5730\u7ba1\u5236\u533a")) {
                            Map tmpMap = (Map)ghMap.get("\u5efa\u8bbe\u7528\u5730\u7ba1\u5236\u533a");
                            info = (List)tmpMap.get("info");
                            summary.put("jsydgzq", df.format(MapUtils.getDoubleValue((Map)((Map)info.get(0)), (Object)"AREA", (double)0.0)));
                        }
                        if (ghMap.containsKey("\u89c4\u5212\u57fa\u672c\u519c\u7530\u8c03\u6574")) {
                            Map tmpMap = (Map)ghMap.get("\u89c4\u5212\u57fa\u672c\u519c\u7530\u8c03\u6574");
                            info = (List)tmpMap.get("info");
                            summary.put("ghjbnttz", df.format(MapUtils.getDoubleValue((Map)((Map)info.get(0)), (Object)"AREA", (double)0.0)));
                        } else {
                            summary.put("ghjbnttz", 0.0);
                        }
                        if (ghMap.containsKey("\u91cd\u70b9\u5efa\u8bbe\u9879\u76ee")) {
                            Map tmpMap = (Map)ghMap.get("\u91cd\u70b9\u5efa\u8bbe\u9879\u76ee");
                            info = (List)tmpMap.get("info");
                            summary.put("zdjsxm", df.format(MapUtils.getDoubleValue((Map)((Map)info.get(0)), (Object)"AREA", (double)0.0)));
                        } else {
                            summary.put("zdjsxm", 0.0);
                        }
                        summary.put("total", Double.parseDouble(summary.get("tdytq").toString()) + Double.parseDouble(summary.get("jsydgzq").toString()) + Double.parseDouble(summary.get("ghjbnttz").toString()) + Double.parseDouble(summary.get("zdjsxm").toString()));
                    } else if ("tdlygh".equalsIgnoreCase(String.valueOf(ANALYSIS_TYPE.valueOf((String)key)))) {
                        Map fhghMap = (Map)analysisMap.get("fhgh");
                        Map bfhghMap = (Map)analysisMap.get("bfhgh");
                        Map ytjMap = (Map)analysisMap.get("ytj");
                        summary.put("fhgh", ((Map)fhghMap.get("total")).get("sum"));
                        summary.put("bfhgh", ((Map)bfhghMap.get("total")).get("sum"));
                        summary.put("ytj", ((Map)ytjMap.get("total")).get("sum"));
                        summary.put("total", MapUtils.getDoubleValue(summary, (Object)"fhgh", (double)0.0) + MapUtils.getDoubleValue(summary, (Object)"bfhgh", (double)0.0) + MapUtils.getDoubleValue(summary, (Object)"ytj", (double)0.0));
                    } else if ("gyjsydfx".equalsIgnoreCase(String.valueOf(ANALYSIS_TYPE.valueOf((String)key)))) {
                        summary.put("total", MapUtils.getDoubleValue((Map)item, (Object)"total", (double)0.0));
                    }
                }
                catch (Exception e) {
                    double total = 0.0;
                    summary.put("total", total);
                }
                item.put("summary", summary);
            }
        }
    }

    public double geoArea(String geometry) {
        try {
            Map geo = (Map)JSON.parseObject((String)geometry, Map.class);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("crs", geo.get("crs").toString());
            params.put("geometry", geometry);
            double area = Double.valueOf(AnalyzeServiceImpl.post((String)(AppConfig.getProperty((String)"omp.url") + "/geometryService/geo/area"), params).toString());
            return area;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public static final Object post(String url, Map data) {
        if (StringUtils.isBlank((String)url)) {
            throw new RuntimeException("request url is null");
        }
        HttpClient http = new HttpClient();
        PostMethod post = null;
        try {
            post = new PostMethod(AnalyzeServiceImpl.encode((String)url, (String)"utf-8"));
            if (data != null && !data.isEmpty()) {
                Iterator i$ = data.entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry item;
                    Map.Entry entry = item = i$.next();
                    Object value = entry.getValue();
                    post.addParameter((String)entry.getKey(), value instanceof String[] ? ((String[])entry.getValue())[0] : value.toString());
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return AnalyzeServiceImpl.request((HttpClient)http, (HttpMethod)post);
    }

    public static String encode(String str, String charset) throws UnsupportedEncodingException {
        str = str.replaceAll(" ", "+");
        Pattern p = Pattern.compile(zhPattern);
        Matcher m = p.matcher(str);
        StringBuffer b = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(b, URLEncoder.encode(m.group(0), charset));
        }
        m.appendTail(b);
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object request(HttpClient http, HttpMethod method) {
        String result;
        method.getParams().setSoTimeout(50000);
        method.getParams().setContentCharset("utf-8");
        method.getParams().setUriCharset("utf-8");
        try {
            int status = http.executeMethod(method);
            byte[] bytes = method.getResponseBody();
            result = IOUtils.toString((byte[])bytes, (String)"utf-8");
            if (200 == status) {
                String string = result;
                return string;
            }
        }
        catch (Exception e) {
            result = e.getLocalizedMessage();
        }
        finally {
            method.releaseConnection();
        }
        throw new RuntimeException("\u7f51\u7edc\u8bf7\u6c42\u5f02\u5e38: [" + result + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String fileload(String url, File file) {
        String body = "{}";
        if (url == null || url.equals("")) {
            return "URL\u53c2\u6570\u4e0d\u5408\u6cd5";
        }
        if (!file.exists()) {
            return "\u8981\u4e0a\u4f20\u7684\u6587\u4ef6\u4e0d\u5b58\u5728";
        }
        PostMethod postMethod = new PostMethod(url);
        try {
            FilePart fp = new FilePart("file", file);
            Part[] parts = new Part[]{fp};
            MultipartRequestEntity mre = new MultipartRequestEntity(parts, postMethod.getParams());
            postMethod.setRequestEntity((RequestEntity)mre);
            HttpClient client = new HttpClient();
            client.getHttpConnectionManager().getParams().setConnectionTimeout(50000);
            int status = client.executeMethod((HttpMethod)postMethod);
            if (status == 200) {
                InputStream inputStream = postMethod.getResponseBodyAsStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
                StringBuffer stringBuffer = new StringBuffer();
                String str = "";
                while ((str = br.readLine()) != null) {
                    stringBuffer.append(str);
                }
                body = stringBuffer.toString();
            } else {
                body = "fail";
            }
        }
        catch (Exception e) {
            this.logger.warn("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
        finally {
            postMethod.releaseConnection();
        }
        return body;
    }
}

