/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.analysis.controller;

import cn.gtmap.onemap.analysis.core.BaseController;
import cn.gtmap.onemap.analysis.service.AnalyzeService;
import cn.gtmap.onemap.analysis.support.JSONMessageException;
import cn.gtmap.onemap.service.GeoService;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/portal"})
public class PortalController
extends BaseController {
    @Autowired
    private AnalyzeService analyzeService;
    @Autowired
    private GeoService geoService;

    @RequestMapping(value={""})
    public String exe(Model model) {
        model.addAttribute("models", (Object)JSON.toJSONString((Object)this.analyzeService.getModels()));
        return "portal";
    }

    @RequestMapping(value={"/gateway"})
    public String exe(@RequestParam(value="report") String baseInfo, @RequestParam(value="hideTopBar", defaultValue="false") String hideTopBar, Model model) {
        Map bjMap = this.analyzeService.parseBjXml(baseInfo);
        model.addAttribute("data", (Object)JSON.toJSONString((Object)bjMap));
        model.addAttribute("hideTopBar", (Object)hideTopBar);
        model.addAttribute("models", (Object)JSON.toJSONString((Object)this.analyzeService.getModels()));
        return "portal";
    }

    @RequestMapping(value={"/topo"}, method={RequestMethod.POST})
    @ResponseBody
    public String geoTopoCheck(@RequestParam(value="geometry") String geometry) {
        try {
            return this.geoService.findTopoError(geometry);
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/upload"})
    @ResponseBody
    public Object zipUpload(@RequestParam(value="file") MultipartFile file) {
        try {
            return this.analyzeService.parseGeoFile(file);
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("file.upload.err", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/sketch"})
    public String viewFeature() {
        return "sketch";
    }

    @RequestMapping(value={"/analysis"})
    public String analysis(@RequestParam(value="geometry") String geometry, @RequestParam(value="type") String type, @RequestParam(value="reportInfo", required=false) String reportInfo, Model model) {
        block15: {
            try {
                Object result = this.analyzeService.analyze(type, geometry);
                if ("multi".equalsIgnoreCase(type)) {
                    try {
                        Map analysisResult = (Map)result;
                        model.addAttribute("result", (Object)analysisResult);
                        model.addAttribute("geometry", (Object)geometry);
                        model.addAttribute("ogArea", (Object)MapUtils.getDoubleValue((Map)analysisResult, (Object)"ogArea", (double)0.0));
                        analysisResult.remove("ogArea");
                        HashMap<String, String> shpRet = new HashMap<String, String>();
                        boolean exportDiffShp = false;
                        if (analysisResult.containsKey("diffShpId")) {
                            model.addAttribute("diffShpId", analysisResult.get("diffShpId"));
                            analysisResult.remove("diffShpId");
                        }
                        for (String key : analysisResult.keySet()) {
                            Map r;
                            Map tmp = (Map)analysisResult.get(key);
                            if (tmp.containsKey("iframeData")) {
                                model.addAttribute(key.concat("iframeData"), tmp.get("iframeData"));
                            }
                            if (tmp.containsKey("shpId")) {
                                shpRet.put(key, MapUtils.getString((Map)tmp, (Object)"shpId"));
                            } else if (tmp.get("result") instanceof Map && (r = (Map)tmp.get("result")) != null && !r.isEmpty() && r.containsKey("shpId")) {
                                shpRet.put(key, MapUtils.getString((Map)r, (Object)"shpId"));
                            }
                            if (tmp.containsKey("diffShpId")) {
                                shpRet.put(key.concat("_diff"), MapUtils.getString((Map)tmp, (Object)"diffShpId"));
                                exportDiffShp = true;
                                continue;
                            }
                            if (!(tmp.get("result") instanceof Map) || (r = (Map)tmp.get("result")) == null || r.isEmpty() || !r.containsKey("diffShpId")) continue;
                            shpRet.put(key.concat("_diff"), MapUtils.getString((Map)r, (Object)"diffShpId"));
                            exportDiffShp = true;
                        }
                        model.addAttribute("shp", (Object)JSON.toJSONString(shpRet));
                        model.addAttribute("exportDiffShp", (Object)exportDiffShp);
                        HashMap mapData = new HashMap();
                        HashMap summaryData = new HashMap();
                        for (Map.Entry entry : analysisResult.entrySet()) {
                            Map value = (Map)entry.getValue();
                            mapData.put(String.valueOf(entry.getKey()), value.get("result"));
                            summaryData.put(String.valueOf(entry.getKey()), value.get("summary"));
                        }
                        model.addAttribute("summaryData", (Object)JSON.toJSONString(summaryData));
                        break block15;
                    }
                    catch (Exception e) {
                        this.logger.error(e.getLocalizedMessage());
                        throw new JSONMessageException(e.getLocalizedMessage());
                    }
                }
                if ("custom".equalsIgnoreCase(type)) {
                    Map map = (Map)result;
                    model.addAttribute("info", map.get("info"));
                    model.addAttribute("general", map.get("general"));
                    model.addAttribute("excelData", map.get("excelData"));
                    model.addAttribute("excelList", map.get("excelList"));
                } else {
                    model.addAttribute("data", result);
                    model.addAttribute("jsData", (Object)JSON.toJSONString((Object)result));
                    model.addAttribute("xlsData", (Object)this.analyzeService.generateXlsData(type, result));
                    model.addAttribute("geo", (Object)geometry);
                    model.addAttribute("reportInfo", JSON.parse((String)reportInfo));
                }
            }
            catch (JSONMessageException e) {
                throw new JSONMessageException(e.getLocalizedMessage());
            }
        }
        return "analysis/".concat(type);
    }
}

