/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.analysis.controller;

import cn.gtmap.onemap.analysis.core.BaseController;
import cn.gtmap.onemap.analysis.model.AnalyzeDict;
import cn.gtmap.onemap.analysis.model.AnalyzeRule;
import cn.gtmap.onemap.analysis.model.AnalyzeSet;
import cn.gtmap.onemap.analysis.service.AnalyzeService;
import cn.gtmap.onemap.analysis.service.ConfigService;
import cn.gtmap.onemap.analysis.support.JSONMessageException;
import com.alibaba.fastjson.JSON;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/admin"})
public class AdminController
extends BaseController {
    @Autowired
    private AnalyzeService analyzeService;
    @Autowired
    private ConfigService configService;

    @RequestMapping(value={""})
    public String exe(Model model) {
        model.addAttribute("rule", (Object)JSON.toJSONString((Object)this.analyzeService.getRule()));
        model.addAttribute("models", (Object)JSON.toJSONString((Object)this.analyzeService.getModels()));
        model.addAttribute("dicts", (Object)JSON.toJSONString((Object)this.analyzeService.getDicts()));
        return "admin";
    }

    @RequestMapping(value={"/rest/models"})
    @ResponseBody
    public List getModels() {
        return this.analyzeService.getModels();
    }

    @RequestMapping(value={"/rest/rule"})
    @ResponseBody
    public AnalyzeRule getRule() {
        return this.analyzeService.getRule();
    }

    @RequestMapping(value={"/rest/dicts"})
    @ResponseBody
    public List<AnalyzeDict> getDicts() {
        return this.analyzeService.getDicts();
    }

    @RequestMapping(value={"/rest/save"}, method={RequestMethod.POST})
    @ResponseBody
    public AnalyzeSet save(@RequestParam String analyzeSet) {
        try {
            Assert.notNull((Object)analyzeSet);
            return this.configService.save((AnalyzeSet)JSON.parseObject((String)analyzeSet, AnalyzeSet.class));
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/rest/saveDict"})
    @ResponseBody
    public AnalyzeDict saveDict(AnalyzeDict dict) {
        try {
            Assert.notNull((Object)dict);
            return this.configService.saveDict(dict);
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }
}

