<#assign articles = page.getList()/>
<#assign totalPage = page.getTotalPage()/>
<#assign pageNumber = page.getPageNumber()/>
<#assign pageSize = page.getPageSize()/>
<#assign headTitle="业务管理"/>
<#assign bodyClass="bg04"/>
<#assign jsContent>
    <script>
        $(function(){
            var pageNumber = ${pageNumber!};
            var totalPage = ${totalPage!};

            //控制首页、上一页、下一页、末页按钮的功能
            if(pageNumber == 1){
                $("#firstPage").attr("disabled", "disabled");
                $("#prevPage").attr("disabled", "disabled");
                $("#firstPage a").attr("href", "#");
                $("#prevPage a").attr("href", "#");
            }

            if (pageNumber == totalPage){
                $("#lastPage").attr("disabled", "disabled");
                $("#nextPage").attr("disabled", "disabled");
                $("#lastPage a").attr("href", "#");
                $("#nextPage a").attr("href", "#");
            }

            $("#pageSelect").on("change", function(){
                var page = $(this).val();
                window.location = "<@com.rootPath/>/serviceManagement?channel=${channel!}&parentChannelDesc=${parentChannelDesc!}&page=" + page;
            });

            //tab页切换监听
            $("#myTab a").on("click", function(){
                debugger;
                var channel = $(this).attr("href").replace(/#/, "");
                window.location = "<@com.rootPath/>/serviceManagement?channel=" + channel + "&parentChannelDesc=${parentChannelDesc!}";
            });

            //左侧目录点击监听
            $(".muneList02 a").on("click", function(){
                var parentChannelDesc = $(this).data("title");
                var channel = $(this).data("channel");
                window.location = "<@com.rootPath/>/serviceManagement?channel=" + channel + "&parentChannelDesc=" + parentChannelDesc;
            });

            //点击标题 查看详情
            $(".article-title").on("click", function(){
                var title = $(this).data("title");
                window.location = "<@com.rootPath/>/article/cont?channel=${channel!}&title=" + title + "&headTitle=${headTitle!}&parentChannelDesc=${parentChannelDesc!}&bodyClass=${bodyClass!}";
            });

        });
    </script>
</#assign>

<@com.main title=headTitle js=jsContent bodyClass=bodyClass>
<section class="mainContent">
    <div class="Hui-wraper Hui-article " >
        <ul class="muneList02 muneList03">
            <li>
                <a href="#" data-title="规划计划" data-channel="424"><@com.isActive "规划计划" "${parentChannelDesc!}" "规划计划"></@com.isActive></a>
            </li>
            <li>
                <a href="#" data-title="建设用地" data-channel="433"><@com.isActive "建设用地" "${parentChannelDesc!}" "建设用地"></@com.isActive></a>
            </li>
            <li>
                <a href="#" data-title="地籍测绘" data-channel="437"><@com.isActive "地籍测绘" "${parentChannelDesc!}" "地籍测绘"></@com.isActive></a>
            </li>
            <li>
                <a href="#" data-title="统计信息" data-channel="348"><@com.isActive "统计信息" "${parentChannelDesc!}" "统计信息"></@com.isActive></a>
            </li>
            <li>
                <a href="#" data-title="土地利用" data-channel="417"><@com.isActive "土地利用" "${parentChannelDesc!}" "土地利用"></@com.isActive></a>
            </li>
            <li>
                <a href="#" data-title="矿产管理" data-channel="442"><@com.isActive "矿产管理" "${parentChannelDesc!}" "矿产管理"></@com.isActive></a>
            </li>
            <li>
                <a href="#" data-title="执法监察" data-channel="447"><@com.isActive "执法监察" "${parentChannelDesc!}" "执法监察"></@com.isActive></a>
            </li>
            <li>
                <a href="#" data-title="基准地价" data-channel="518"><@com.isActive "基准地价" "${parentChannelDesc!}" "基准地价"></@com.isActive></a>
            </li>
            <li>
                <a href="#" data-title="地质环境" data-channel="521"><@com.isActive "地质环境" "${parentChannelDesc!}" "地质环境"></@com.isActive></a>
            </li>
            <li>
                <a href="#" data-title="行政收费" data-channel="517"><@com.isActive "行政收费" "${parentChannelDesc!}" "行政收费"></@com.isActive></a>
            </li>
        </ul>


        <a href="<@com.rootPath/>/index" class="backIndex">返回首页</a>

        <div class="listContent01">
            <div class="tabbable tabs-top">
                <#if "${parentChannelDesc}"=="规划计划">
                    <ul class="nav nav-tabs" id="myTab">
                        <li <#if "${channel!}"=="424">class="active"</#if>>
                            <a data-toggle="tab" href="#424">
                                土地利用总体规划
                            </a>
                        </li>

                        <li <#if "${channel!}"=="425">class="active"</#if>>
                            <a data-toggle="tab" href="#425">
                                矿产资源总体规划
                            </a>
                        </li>
                    </ul>
                <#elseif "${parentChannelDesc}"=="建设用地">
                    <ul class="nav nav-tabs" id="myTab">
                        <li <#if "${channel!}"=="433">class="active"</#if>>
                            <a data-toggle="tab" href="#433">
                                建设用地审批程序
                            </a>
                        </li>

                        <li <#if "${channel!}"=="434">class="active"</#if>>
                            <a data-toggle="tab" href="#434">
                                建设用地预审结果
                            </a>
                        </li>

                        <li <#if "${channel!}"=="435">class="active"</#if>>
                            <a data-toggle="tab" href="#435">
                                建设用地预审程序
                            </a>
                        </li>

                        <li <#if "${channel!}"=="436">class="active"</#if>>
                            <a data-toggle="tab" href="#436">
                                耕地保护
                            </a>
                        </li>
                    </ul>
                <#elseif "${parentChannelDesc}"=="地籍测绘">
                    <ul class="nav nav-tabs" id="myTab">
                        <li <#if "${channel!}"=="437">class="active"</#if>>
                            <a data-toggle="tab" href="#437">
                                土地登记公告
                            </a>
                        </li>

                        <li <#if "${channel!}"=="438">class="active"</#if>>
                            <a data-toggle="tab" href="#438">
                                土地证遗失（注销）公告
                            </a>
                        </li>

                        <li <#if "${channel!}"=="439">class="active"</#if>>
                            <a data-toggle="tab" href="#439">
                                土地变更调查
                            </a>
                        </li>

                        <li <#if "${channel!}"=="440">class="active"</#if>>
                            <a data-toggle="tab" href="#440">
                                测绘资质管理
                            </a>
                        </li>

                        <li <#if "${channel!}"=="441">class="active"</#if>>
                            <a data-toggle="tab" href="#441">
                                土地登记依据、程序、要件、时限
                            </a>
                        </li>
                    </ul>
                <#elseif "${parentChannelDesc}"=="土地利用">
                    <ul class="nav nav-tabs" id="myTab">
                        <li <#if "${channel!}"=="417">class="active"</#if>>
                            <a data-toggle="tab" href="#417">
                                土地招拍挂出让公告
                            </a>
                        </li>

                        <li <#if "${channel!}"=="418">class="active"</#if>>
                            <a data-toggle="tab" href="#418">
                                土地供应计划
                            </a>
                        </li>

                        <li <#if "${channel!}"=="419">class="active"</#if>>
                            <a data-toggle="tab" href="#419">
                                土地出让结果公示
                            </a>
                        </li>

                        <li <#if "${channel!}"=="420">class="active"</#if>>
                            <a data-toggle="tab" href="#420">
                                划拨供地公示
                            </a>
                        </li>

                        <li <#if "${channel!}"=="537">class="active"</#if>>
                            <a data-toggle="tab" href="#537">
                                划拨供地结果公示
                            </a>
                        </li>

                        <li <#if "${channel!}"=="421">class="active"</#if>>
                            <a data-toggle="tab" href="#421">
                                闲置土地
                            </a>
                        </li>

                        <li <#if "${channel!}"=="422">class="active"</#if>>
                            <a data-toggle="tab" href="#422">
                                推介地块
                            </a>
                        </li>

                        <li <#if "${channel!}"=="597">class="active"</#if>>
                            <a data-toggle="tab" href="#prof597ile">
                                棚户区改造用地年度供应计划
                            </a>
                        </li>
                    </ul>
                <#elseif "${parentChannelDesc}"=="矿产管理">
                    <ul class="nav nav-tabs" id="myTab">
                        <li <#if "${channel!}"=="442">class="active"</#if>>
                            <a data-toggle="tab" href="#442">
                                采矿权审批结果公示
                            </a>
                        </li>

                        <li <#if "${channel!}"=="443">class="active"</#if>>
                            <a data-toggle="tab" href="#443">
                                采矿权审批程序
                            </a>
                        </li>

                        <li <#if "${channel!}"=="445">class="active"</#if>>
                            <a data-toggle="tab" href="#445">
                                矿业权转让公示
                            </a>
                        </li>

                        <li <#if "${channel!}"=="446">class="active"</#if>>
                            <a data-toggle="tab" href="#446">
                                矿业权招拍挂出让公告
                            </a>
                        </li>

                        <li <#if "${channel!}"=="444">class="active"</#if>>
                            <a data-toggle="tab" href="#444">
                                矿业权招拍挂出让结果公示
                            </a>
                        </li>
                    </ul>
                <#elseif "${parentChannelDesc}"=="执法监察">
                    <ul class="nav nav-tabs" id="myTab">
                        <li <#if "${channel!}"=="447">class="active"</#if>>
                            <a data-toggle="tab" href="#447">
                                土地违法典型案件处理结果
                            </a>
                        </li>

                        <li <#if "${channel!}"=="448">class="active"</#if>>
                            <a data-toggle="tab" href="#448">
                                矿产违法典型案件处理结果
                            </a>
                        </li>

                        <li <#if "${channel!}"=="449">class="active"</#if>>
                            <a data-toggle="tab" href="#449">
                                土地违法案件行政处罚程序
                            </a>
                        </li>

                        <li <#if "${channel!}"=="450">class="active"</#if>>
                            <a data-toggle="tab" href="#450">
                                矿产违法案件行政处罚程序
                            </a>
                        </li>

                        <li <#if "${channel!}"=="559">class="active"</#if>>
                            <a data-toggle="tab" href="#559">
                                供后监管
                            </a>
                        </li>
                    </ul>
                <#elseif "${parentChannelDesc}"=="基准地价">
                    <ul class="nav nav-tabs" id="myTab">
                        <li <#if "${channel!}"=="518">class="active"</#if>>
                            <a data-toggle="tab" href="#518">
                                基准地价公开
                            </a>
                        </li>

                        <li <#if "${channel!}"=="519">class="active"</#if>>
                            <a data-toggle="tab" href="#519">
                                地价动态监测信息公开
                            </a>
                        </li>

                        <li <#if "${channel!}"=="520">class="active"</#if>>
                            <a data-toggle="tab" href="#520">
                                标定地价公示
                            </a>
                        </li>
                    </ul>
                <#elseif "${parentChannelDesc}"=="地质环境">
                    <ul class="nav nav-tabs" id="myTab">
                        <li <#if "${channel!}"=="521">class="active"</#if>>
                            <a data-toggle="tab" href="#521">
                                公益性地质资料
                            </a>
                        </li>

                        <li <#if "${channel!}"=="522">class="active"</#if>>
                            <a data-toggle="tab" href="#522">
                                地质灾害预警预报
                            </a>
                        </li>
                    </ul>
                <#elseif "${parentChannelDesc}"=="行政收费">
                    <ul class="nav nav-tabs" id="myTab">
                        <li <#if "${channel!}"=="517">class="active"</#if>>
                            <a data-toggle="tab" href="#517">
                                土地、矿产资源依法收费
                            </a>
                        </li>
                    </ul>
                </#if>

                <#if articles?size gt 0>
                    <div class="tab-content bg-white">
                        <div id="${channnel!}" class="tab-pane in active">
                            <ul class="list01">
                                <#list articles as article>
                                    <li class="article-title" data-title="${article.title!}">
                                        <a class="article-title-a" href="#">${article.title!}</a>
                                        <span class="date">${article.date?date("yyyy-MM-dd")}</span>
                                    </li>
                                </#list>
                            </ul>
                            <div class="clearfix"></div>
                            <!-- 翻页 -->
                            <div class="tablePagination btn-toolbar text-c" style="margin:0px;">
                                <ul class="btn-group" style="margin:3px; 0px 0px 0px">
                                    <li id="firstPage" class="btn "><a href="<@com.rootPath/>/serviceManagement?channel=${channel!}&page=1&pageSize=${pageSize!}&parentChannelDesc=${parentChannelDesc!}"><i class="icon-fast-backward"></i></a></li>
                                    <li id="prevPage" class="btn "><a href="<@com.rootPath/>/serviceManagement?channel=${channel!}&page=${pageNumber-1!}&pageSize=${pageSize!}&parentChannelDesc=${parentChannelDesc!}"><i class="icon-step-backward"></i></a></li>
                                    <li class="">
                                        <select id="pageSelect" class="select" size="1" style="height:30px;">
                                            <#list 1..totalPage as pNumber>
                                                <option value="${pNumber!}" <#if pNumber==pageNumber>selected</#if>>${pNumber!}</option>
                                            </#list>
                                        </select>
                                    </li>
                                    <li id="nextPage" class="btn "><a href="<@com.rootPath/>/serviceManagement?channel=${channel!}&page=${pageNumber+1!}&pageSize=${pageSize!}&parentChannelDesc=${parentChannelDesc!}"><i class="icon-step-forward"></i></a></li>
                                    <li id="lastPage" class="btn "><a href="<@com.rootPath/>/serviceManagement?channel=${channel!}&page=${totalPage!}&pageSize=${pageSize!}&parentChannelDesc=${parentChannelDesc!}"><i class="icon-fast-forward"></i></a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                <#else >
                    <div class="tab-content bg-white">
                        <ul class="list01" style="list-style: none;">
                            <li style="text-align: center;">建设中, 暂无信息</li>
                        </ul>
                    </div>
                </#if>
            </div>
        </div>
    </div>
</section>
<footer class="footer">
    <p>版权所有 © 南京国图信息产业股份有限公司</p>
</footer>
</@com.main>