<#assign articles = page.getList()/>
<#assign totalPage = page.getTotalPage()/>
<#assign pageNumber = page.getPageNumber()/>
<#assign pageSize = page.getPageSize()/>
<#assign headTitle="法律法规"/>
<#assign bodyClass="bg06"/>
<#assign jsContent>
    <script>
        $(function(){
            var pageNumber = ${pageNumber!};
            var totalPage = ${totalPage!};

            //控制首页、上一页、下一页、末页按钮的功能
            if(pageNumber == 1){
                $("#firstPage").attr("disabled", "disabled");
                $("#prevPage").attr("disabled", "disabled");
                $("#firstPage a").attr("href", "#");
                $("#prevPage a").attr("href", "#");
            }

            if (pageNumber == totalPage){
                $("#lastPage").attr("disabled", "disabled");
                $("#nextPage").attr("disabled", "disabled");
                $("#lastPage a").attr("href", "#");
                $("#nextPage a").attr("href", "#");
            }

            //左侧目录监听
            $(".muneList02 a").on("click", function(){
                debugger;
                var channel = $(this).data("id");
                window.location = "<@com.rootPath/>/regulations?channel=" + channel +"&pageSize=${pageSize!}";
            });
            //页面下拉选择监听
            $("#pageSelect").on("change", function(){
                var page = $(this).val();
                window.location = "<@com.rootPath/>/regulations?channel=${channel!}&page=" + page + "&pageSize=${pageSize!}";
            });

            //标题点击监听 进行页面跳转
            $(".article-title").on("click", function(){
                var title = $(this).data("title");
                window.location = "<@com.rootPath/>/article/cont?channel=${channel!}&title=" + title + "&headTitle=${headTitle!}&bodyClass=${bodyClass!}&pageNumber=${pageNumber!}";
            });

        });
    </script>
</#assign>
<@com.main title=headTitle js=jsContent bodyClass=bodyClass>
<section class="mainContent">
    <div class="Hui-wraper Hui-article " >
        <ul class="muneList02 muneList03">
            <li>
                <a href="#" data-id="376" data-title="土地法律法规"><@com.isActive "376" "${channel!}" "土地法律法规"></@com.isActive></a>
            </li>
            <li>
                <a href="#" data-id="377" data-title="矿产法律法规"><@com.isActive "377" "${channel!}" "矿产法律法规"></@com.isActive></a>
            </li>
            <li>
                <a href="#" data-id="378" data-title="测绘法律法规"><@com.isActive "378" "${channel!}" "测绘法律法规"></@com.isActive></a>
            </li>
            <li>
                <a href="#" data-id="379" data-title="综合法规"><@com.isActive "379" "${channel!}" "综合法规"></@com.isActive></a>
            </li>
            <li>
                <a href="#" data-id="536" data-title="部省级文件"><@com.isActive "536" "${channel!}" "部省级文件"></@com.isActive></a>
            </li>
            <li>
                <a href="#" data-id="570" data-title="政策法规"><@com.isActive "570" "${channel!}" "政策法规"></@com.isActive></a>
            </li>

        </ul>


        <a href="<@com.rootPath/>/index" class="backIndex">返回首页</a>

        <#if articles?size gt 0>
            <div class="listContent01">
                <ul class="list01">
                    <#list articles as article>
                        <li class="article-title" data-title="${article.title!}" data-channel="${article.channel!}">
                            <a class="article-title-a" href="#">${article.title!}</a>
                            <span class="date">${article.date?date("yyyy-MM-dd")}</span>
                        </li>
                    </#list>
                </ul>
                <div class="clearfix"></div>
                <div class="tablePagination btn-toolbar text-c" style="margin:0px;">
                    <ul class="btn-group" style="margin:3px; 0px 0px 0px">
                        <li id="firstPage" class="btn "><a href="<@com.rootPath/>/regulations?channel=${channel!}&page=1&pageSize=${pageSize!}"><i class="icon-fast-backward"></i></a></li>
                        <li id="prevPage" class="btn "><a href="<@com.rootPath/>/regulations?channel=${channel!}&page=${pageNumber-1!}&pageSize=${pageSize!}"><i class="icon-step-backward"></i></a></li>
                        <li class="">
                            <select id="pageSelect" class="select" size="1" style="height:30px;">
                                <#list 1..totalPage as pNumber>
                                    <option value="${pNumber!}" <#if pNumber==pageNumber>selected</#if>>${pNumber!}</option>
                                </#list>
                            </select>
                        </li>
                        <li id="nextPage" class="btn "><a href="<@com.rootPath/>/regulations?channel=${channel!}&page=${pageNumber+1!}&pageSize=${pageSize!}"><i class="icon-step-forward"></i></a></li>
                        <li id="lastPage" class="btn "><a href="<@com.rootPath/>/regulations?channel=${channel!}&page=${totalPage!}&pageSize=${pageSize!}"><i class="icon-fast-forward"></i></a></li>
                    </ul>
                </div>
            </div>
        <#else >
            <div class="listContent01">
                <ul class="list01" style="list-style: none;">
                    <li style="text-align: center;">建设中, 暂无信息</li>
                </ul>
            </div>
        </#if>
    </div>
    </div>
</section>
<footer class="footer">
    <p>版权所有 © 南京国图信息产业股份有限公司</p>
</footer>
</@com.main>