<#assign articles = page.getList()/>
<#assign totalPage = page.getTotalPage()/>
<#assign pageNumber = page.getPageNumber()/>
<#assign pageSize = page.getPageSize()/>
<#assign cssContent>
<style>
    .article-title {
        cursor: pointer;
    }

    .date {
        color: #888888;
        font-family: Arial, Helvetica, sans-serif;
        font-size: 12px;
        float: right;
    }

    li {
        height: 36px;
        line-height: 35px;
        padding: 0px 10px 0px 4px;
    }

    .page {
        text-align: center;
    }

    .page a {
        border: 1px solid #6ca0cf;
    }

    .article-title span {
        margin-right: 40px;
    }

    #pageSelect {
        width: 70px;
        height: 25px;
        font-family: 微软雅黑;
    }

    .selected-channel {
        color: #888888;
    }
</style>
</#assign>
<#assign jsContent>
<script>
    var pageNumber = ${pageNumber!};
    var totalPage = ${totalPage!};
    var channel = "${channel!}";

    $(function () {
        if (pageNumber == 1) {
            $("#prevPage").hide();
            $("#firstPage").hide();
        }
        if (pageNumber == totalPage) {
            $("#lastPage").hide();
            $("#nextPage").hide();
        }
        if (totalPage == 1) {
            $("#pageInput").hide();
            $("#goToPage").hide();
        }
        addListener();
    });

    function addListener() {
        //标题名称点击
        $(".article-title").on("click", function () {
            var title = $(this).data("title");
            window.location = "<@com.rootPath/>" + "/article/content?title=" + title + "&channel=" + channel;
        });

        //页数跳转
        $("#pageSelect").on("change", function () {
            var page = $(this).val();
            window.location = "<@com.rootPath/>/page/list?page=" + page + "&pageSize=${pageSize!}&channel=${channel!}";
        });
    }

</script>
</#assign>

<@com.main js=jsContent css=cssContent>
<div style="width: 100%;" id="pageContent">
    <div style="width: 20%;float: left;">
        <ul>
            <li><a href="<@com.rootPath/>/page/list?page=1&pageSize=25&channel=tddj" style="cursor: pointer;"
                   class="<#if channel == "tddj">selected-channel</#if>">不动产登记结果</a></li>
            <li><a href="<@com.rootPath/>/page/list?page=1&pageSize=25&channel=tdcr" style="cursor: pointer;"
                   class="<#if channel == "tdcr">selected-channel</#if>">土地出让结果</a></li>
        </ul>
        <button type="button" id="backToHome">返回首页</button>
    </div>
    <div style="width:80%;float: left;height: 100%;overflow: auto;">
        <#if channel =="tddj">
            <table style="width: 100%">
                <tr>
                    <th width="20%" height="29" align="center">不动产权证号</th>
                    <th width="30%" align="center">不动产权利人</th>
                    <th width="30%" align="center">不动产坐落</th>
                    <th width="20%" align="center">不动产面积</th>
                </tr>
                <#list articles as article>
                ${article.get("content")!}
                </#list>
            </table>
        <#elseif channel == "tdcr">
            <table style="width: 100%;">
                <tr>
                    <th width="20%" height="29" align="center">序号</th>
                    <th width="30%" align="center">成交单位</th>
                    <th width="15%" align="center">出让面积</th>
                    <th width="15%" align="center">成交价格</th>
                    <th width="20%" align="center">成交时间</th>
                </tr>
                <#list articles as article>
                ${article.get("content")!}
                </#list>
            </table>
        <#else>
            <ul style="width: 95%;">
                <#list articles as article>
                    <li class="article-title" data-title='${article.get("title")!}'>${article.get("title")!} <span
                            class="date">${article.get("date")!}</span></li>
                </#list>
            </ul>
        </#if>
        <div class="page">目前在第${pageNumber!}页,共${totalPage!}页,共有${page.getTotalRow()!}条记录
            <a id="firstPage" href="<@com.rootPath/>/page/list?page=1&pageSize=${pageSize!}&channel=${channel!}">首&nbsp;&nbsp;&nbsp;&nbsp;页</a>
            <a id="prevPage"
               href="<@com.rootPath/>/page/list?page=${pageNumber-1!}&pageSize=${pageSize!}&channel=${channel!}">上一页</a>
            <a id="nextPage"
               href="<@com.rootPath/>/page/list?page=${pageNumber+1!}&pageSize=${pageSize!}&channel=${channel!}">下一页</a>
            <a id="lastPage"
               href="<@com.rootPath/>/page/list?page=${totalPage!}&pageSize=${pageSize!}&channel=${channel!}">末&nbsp;&nbsp;&nbsp;&nbsp;页</a>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            <label for="pageSelect">转到：</label>
            <select id="pageSelect">
                <#list 1..totalPage as t>
                    <#if t==pageNumber>
                        <option value="${t!}" selected>&nbsp;第${t!}页</option>
                    <#else>
                        <option value="${t!}">&nbsp;第${t!}页</option>
                    </#if>
                </#list>
            </select>
        </div>
    </div>
</div>
</@com.main>


