/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.crawler.news.web;

import cn.gtmap.crawler.news.core.BaseController;
import cn.gtmap.crawler.news.model.Article;
import cn.gtmap.crawler.news.plugin.spring.Inject;
import cn.gtmap.crawler.news.plugin.spring.IocInterceptor;
import cn.gtmap.crawler.news.service.ArticleCrawlerBean;
import cn.gtmap.crawler.news.service.ArticleOperationBean;
import cn.gtmap.crawler.news.service.SearchService;
import com.jfinal.aop.Before;
import com.jfinal.core.ActionKey;
import com.jfinal.plugin.activerecord.Page;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

@Before(value={IocInterceptor.class})
public class IndexController
extends BaseController {
    @Inject.BY_NAME
    ArticleCrawlerBean articleCrawlerBean;
    @Inject.BY_NAME
    ArticleOperationBean articleOperationBean;
    @Inject.BY_NAME
    SearchService searchService;
    private static String lxfl = "";
    private static String keywords = "";

    public void test() {
        List articles = Article.dao.find("select * from Article where channel= 349 order by date desc limit 0, 10");
        articles.size();
    }

    public void index() {
        this.render("index.ftl");
    }

    public void search() {
        String lxfl = this.getPara("lxfl");
        String keywords = this.getPara("keywords");
        try {
            if (StringUtils.isNotBlank((String)keywords)) {
                Set ret = this.searchService.search(lxfl, keywords);
                if (ret.size() == 0 && !"2".equals(lxfl)) {
                    List articleList = this.articleOperationBean.getArticleList(keywords);
                    for (int i = 0; i < articleList.size(); ++i) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("title", ((Article)articleList.get(i)).get("title"));
                        map.put("date", ((Article)articleList.get(i)).get("date"));
                        map.put("content", ((Article)articleList.get(i)).get("content"));
                        ret.add(map);
                    }
                }
                this.renderJsonResult((Object)ret);
            }
        }
        catch (Exception e) {
            this.renderJsonError(e);
        }
    }

    @ActionKey(value="/aboutus")
    public void aboutUs() {
        String channel = this.getPara("channel", "407");
        lxfl = this.getPara("lxfl");
        keywords = this.getPara("keywords");
        List articles = this.articleOperationBean.getAllArticleByChannel(channel, lxfl, keywords);
        this.setAttr("articles", (Object)articles);
        this.setAttr("channel", (Object)channel);
        this.render("modules/aboutus.ftl");
    }

    @ActionKey(value="/guide")
    public void guide() {
        String channel = "349";
        int page = this.getParaToInt("page", Integer.valueOf(1));
        int pageSize = this.getParaToInt("pageSize", Integer.valueOf(10));
        lxfl = this.getPara("lxfl");
        keywords = this.getPara("keywords");
        Page articlePage = this.articleOperationBean.getArticlePage(channel, page, pageSize, lxfl, keywords);
        this.setAttr("page", (Object)articlePage);
        this.setAttr("channel", (Object)channel);
        this.render("modules/guide.ftl");
    }

    @ActionKey(value="/resultNotice")
    public void resultNotice() {
        String channel = this.getPara("channel", "tddj");
        List articles = this.articleOperationBean.getAllArticleByChannel(channel, "", "");
        this.setAttr("channel", (Object)channel);
        this.setAttr("articles", (Object)articles);
        this.render("modules/resultNotice.ftl");
    }

    @ActionKey(value="/regulations")
    public void regulations() {
        String channel = this.getPara("channel", "376");
        int page = this.getParaToInt("page", Integer.valueOf(1));
        int pageSize = this.getParaToInt("pageSize", Integer.valueOf(10));
        Page articlePage = this.articleOperationBean.getArticlePage(channel, page, pageSize, "", "");
        this.setAttr("page", (Object)articlePage);
        this.setAttr("channel", (Object)channel);
        this.render("modules/regulations.ftl");
    }

    @ActionKey(value="/serviceManagement")
    public void serviceManagement() {
        String channel = this.getPara("channel", "424");
        int page = this.getParaToInt("page", Integer.valueOf(1));
        int pageSize = this.getParaToInt("pageSize", Integer.valueOf(9));
        Page articlePage = this.articleOperationBean.getArticlePage(channel, page, pageSize, "", "");
        this.setAttr("page", (Object)articlePage);
        this.setAttr("channel", (Object)channel);
        this.setAttr("parentChannelDesc", (Object)this.getPara("parentChannelDesc", "\u89c4\u5212\u8ba1\u5212"));
        this.render("modules/serviceManagement.ftl");
    }

    @ActionKey(value="/article/cont")
    public void getArticleContent() {
        String channel = this.getPara("channel");
        String title = this.getPara("title");
        Article article = this.articleOperationBean.getArticleContent(title, channel);
        this.setAttr("channel", (Object)channel);
        this.setAttr("article", (Object)article);
        this.setAttr("headTitle", (Object)this.getPara("headTitle"));
        this.setAttr("bodyClass", (Object)this.getPara("bodyClass"));
        this.setAttr("parentChannelDesc", (Object)this.getPara("parentChannelDesc", ""));
        this.render("content.ftl");
    }
}

