/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.crawler.news.service;

import cn.gtmap.crawler.news.core.BaseLogger;
import com.alibaba.fastjson.JSON;
import com.chenlb.mmseg4j.analysis.ComplexAnalyzer;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PreDestroy;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.NRTCachingDirectory;
import org.apache.lucene.util.Version;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class SearchService
extends BaseLogger
implements InitializingBean {
    private List<Map> content = Lists.newArrayList();
    private Analyzer analyzer = null;
    private IndexReader reader = null;
    private Directory directory = null;
    private IndexSearcher searcher = null;
    private Resource indexDir;
    private boolean update = true;
    private int maxCacheSize = 128;
    private boolean useMemoryDir = false;
    private String[] fields = new String[]{"dep", "charge", "telephone", "office", "desc"};

    public void setContent(Resource path) {
        try {
            this.content = (List)JSON.parseObject((String)IOUtils.toString((URI)path.getURI(), (String)"UTF-8"), List.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public void setUpdate(boolean enable) {
        this.update = enable;
    }

    public void setIndexDir(Resource indexDir) {
        this.indexDir = indexDir;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    public void setUseMemoryDir(boolean useMemoryDir) {
        this.useMemoryDir = useMemoryDir;
    }

    public Set search(String lxfl, String value) throws Exception {
        HashSet<Map> results = new HashSet<Map>();
        MultiFieldQueryParser parser = new MultiFieldQueryParser(Version.LUCENE_4_9, this.fields, this.analyzer);
        parser.setDefaultOperator(QueryParser.AND_OPERATOR);
        Query query = null;
        try {
            query = parser.parse(value);
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        try {
            if (lxfl == "2") {
                ScoreDoc[] hits;
                if (this.reader == null) {
                    this.reader = DirectoryReader.open((Directory)(this.directory != null ? this.directory : FSDirectory.open((File)this.indexDir.getFile())));
                }
                if (this.searcher == null) {
                    this.searcher = new IndexSearcher(this.reader);
                }
                TopDocs docs = this.searcher.search(query, 10);
                for (ScoreDoc hit : hits = docs.scoreDocs) {
                    results.add(this.doc2Map(this.searcher.doc(hit.doc)));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return results;
    }

    private Map doc2Map(Document doc) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (IndexableField field : doc.getFields()) {
            map.put(field.name(), field.stringValue());
        }
        return map;
    }

    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    @PreDestroy
    private void destory() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
            if (this.directory != null) {
                this.directory.close();
            }
        }
        catch (IOException e) {
            this.logger.error("close index reader error [{}]", (Object)e.getLocalizedMessage());
        }
        System.gc();
    }

    private void init() {
        this.analyzer = new ComplexAnalyzer();
        if (this.update) {
            this.createIndex();
        }
    }

    private boolean createIndex() {
        if (this.content.size() == 0) {
            this.logger.error("\u5f85\u68c0\u7d22\u5185\u5bb9\u4e3a\u7a7a! \u68c0\u67e5\u914d\u7f6e\u6587\u4ef6search.json");
        } else {
            try {
                this.logger.info("start create search index -- time : [{}]", (Object)new Date().toString());
                FSDirectory fsDirectory = FSDirectory.open((File)this.indexDir.getFile());
                this.directory = this.useMemoryDir ? new NRTCachingDirectory((Directory)fsDirectory, 10.0, (double)this.maxCacheSize) : fsDirectory;
                IndexWriterConfig config = new IndexWriterConfig(Version.LUCENE_4_9, this.analyzer);
                config.setMaxThreadStates(20);
                config.setRAMBufferSizeMB((double)this.maxCacheSize);
                config.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
                IndexWriter indexWriter = new IndexWriter(this.directory, config);
                this.indexContent(indexWriter);
                indexWriter.close();
                this.logger.info("create index success -- time : [{}]", (Object)new Date().toString());
                return true;
            }
            catch (IOException e) {
                this.logger.error("create index error [{}]", (Object)e.getLocalizedMessage());
            }
        }
        return false;
    }

    private void indexContent(IndexWriter writer) {
        try {
            for (Map item : this.content) {
                Document doc = new Document();
                for (Object k : item.keySet()) {
                    String key = (String)k;
                    doc.add((IndexableField)new TextField(key, MapUtils.getString((Map)item, (Object)key), Field.Store.YES));
                }
                try {
                    writer.addDocument((Iterable)doc);
                }
                catch (IOException e1) {
                    this.logger.error("document write error [{}]", (Object)e1.getLocalizedMessage());
                }
            }
            writer.commit();
            this.logger.info(" [{}] records has added to index", (Object)writer.numDocs());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.gc();
    }
}

