/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.crawler.news.service;

import cn.gtmap.crawler.news.core.ArticleCrawlerProcessor;
import cn.gtmap.crawler.news.core.BaseLogger;
import cn.gtmap.crawler.news.core.ResultCrawlerProcessor;
import cn.gtmap.crawler.news.model.Channel;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import us.codecraft.webmagic.Spider;
import us.codecraft.webmagic.processor.PageProcessor;

public class ArticleCrawlerBean
extends BaseLogger
implements InitializingBean {
    public static final String TDDJ_CHN = "tddj";
    public static final String TDCR_CHN = "tdcr";
    private Map crawlerConfig;
    private String baseUrl;
    private Set<Channel> channels = Sets.newHashSet();

    public void setCrawlerConfig(Resource path) {
        try {
            this.crawlerConfig = (Map)JSON.parseObject((String)IOUtils.toString((URI)path.getURI(), (String)"UTF-8"), Map.class);
            this.baseUrl = MapUtils.getString((Map)this.crawlerConfig, (Object)"baseUrl");
            this.channels = this.parseConfigChannels((List)this.crawlerConfig.get("channels"));
        }
        catch (IOException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    private Set<Channel> parseConfigChannels(List<Map> list) {
        HashSet channelSet = Sets.newHashSet();
        if (this.isNotNull(list) && list.size() > 0) {
            for (Map map : list) {
                String id = MapUtils.getString((Map)map, (Object)"id");
                String url = MapUtils.getString((Map)map, (Object)"url");
                if (this.isNotNull((Object)id) && this.isNotNull((Object)url)) {
                    channelSet.add(new Channel(id, url, MapUtils.getString((Map)map, (Object)"desc")));
                }
                if (!map.containsKey("children")) continue;
                channelSet.addAll(this.parseConfigChannels((List)map.get("children")));
            }
        }
        return channelSet;
    }

    public void execute() {
        for (Channel channel : this.channels) {
            this.executeByChannel(channel);
        }
    }

    public Channel findChannelById(String channelId) {
        Set filterChannels = Sets.filter((Set)this.channels, (Predicate)new /* Unavailable Anonymous Inner Class!! */);
        return (Channel)filterChannels.iterator().next();
    }

    protected void executeByChannel(Channel channel) {
        assert (channel != null);
        String channelId = channel.getId();
        String url = channel.getUrl();
        if (TDDJ_CHN.equals(channelId) || TDCR_CHN.equals(channelId)) {
            String pageUrl = this.baseUrl + url;
            Spider.create((PageProcessor)new ResultCrawlerProcessor()).addUrl(new String[]{pageUrl}).thread(10).runAsync();
        } else {
            String pageUrl = this.baseUrl + url + channelId;
            Spider.create((PageProcessor)new ArticleCrawlerProcessor()).addUrl(new String[]{pageUrl}).thread(10).runAsync();
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.isNull((Object)this.baseUrl)) {
            throw new RuntimeException("\u7f51\u7ad9\u5730\u5740\u4e0d\u53ef\u4e3a\u7a7a!");
        }
        if (this.channels.size() == 0) {
            this.logger.error("\u4fe1\u606f\u9891\u9053\u914d\u7f6e\u4e0d\u53ef\u90fd\u4e3a\u7a7a!");
        }
    }
}

