/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.crawler.news.core;

import cn.gtmap.crawler.news.ArticleSave;
import cn.gtmap.crawler.news.core.BaseLogger;
import cn.gtmap.crawler.news.model.Article;
import com.gtis.common.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.processor.PageProcessor;
import us.codecraft.webmagic.selector.Selectable;

public class ResultCrawlerProcessor
extends BaseLogger
implements PageProcessor {
    public static final String TDDJ_CHN = "tddj";
    public static final String TDCR_CHN = "tdcr";
    private Site site = Site.me().setRetryTimes(3).setSleepTime(5000);

    public void process(Page page) {
        Selectable tableInformation = page.getHtml().xpath("//div[@id='cx1']");
        Selectable pageContent = page.getHtml().xpath("//div[@class='page']");
        String pageUrl = page.getUrl().get();
        int total = Integer.parseInt(pageContent.xpath("//em[2]/text()").get());
        if (pageUrl.indexOf("?page") < 0) {
            ArrayList<String> pageUrls = new ArrayList<String>();
            for (int i = 1; i <= total; ++i) {
                pageUrls.add(pageUrl.concat("?page=") + String.valueOf(i));
            }
            page.addTargetRequests(pageUrls);
        } else {
            this.getInformation(tableInformation, pageUrl);
        }
    }

    public Site getSite() {
        return this.site;
    }

    private void getInformation(Selectable tableInformation, String pageUrl) {
        List trs = tableInformation.xpath("//tr").nodes();
        for (int j = 1; j < trs.size(); ++j) {
            Selectable tr = (Selectable)trs.get(j);
            List tds = tr.xpath("//td").nodes();
            for (int i = 0; i < tds.size(); ++i) {
                if (i != 0) continue;
                String idGetter = ((Selectable)tds.get(0)).links().get();
                String title = idGetter.split("=")[1];
                String channel = this.getChannelId(pageUrl);
                Article article = new Article();
                article.set("id", (Object)UUIDGenerator.generate());
                article.set("channel", (Object)channel);
                article.set("title", (Object)title);
                HashMap<String, String> map = new HashMap<String, String>();
                if (TDDJ_CHN.equals(channel)) {
                    map.put("bdcqzh", ((Selectable)tds.get(0)).xpath("//a/text()").get());
                    map.put("bdcqlr", tr.xpath("//td[2]/text()").get());
                    map.put("bdczl", tr.xpath("//td[3]/text()").get());
                    map.put("bdcmj", tr.xpath("//td[4]/text()").get());
                } else {
                    map.put("cjdw", tr.xpath("//td[2]/text()").get());
                    map.put("crmj", tr.xpath("//td[3]/text()").get());
                    map.put("cjjg", tr.xpath("//td[4]/text()").get());
                    map.put("cjsj", tr.xpath("//td[5]/text()").get());
                }
                article.set("content", (Object)tr.toString().replace("href", "h"));
                try {
                    ArticleSave.getArticleSave().saveArticle(article);
                    continue;
                }
                catch (Exception e) {
                    this.logger.error(e.getLocalizedMessage());
                }
            }
        }
    }

    private String getChannelId(String url) {
        String[] arr = url.split("web/");
        String[] part = arr[1].split("_");
        return part[0].split("Search")[1].toLowerCase();
    }
}

