/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.crawler.news;

import cn.gtmap.crawler.news.core.BaseLogger;
import cn.gtmap.crawler.news.model.Article;

public class ArticleSave
extends BaseLogger {
    private static volatile ArticleSave articleSave = null;

    private ArticleSave() {
    }

    public synchronized void saveArticle(Article article) {
        try {
            if (!this.isExist(article)) {
                article.save();
            } else {
                this.logger.error("the same data title:{},channel:{}", (Object)article.get("title").toString(), (Object)article.get("channel").toString());
            }
        }
        catch (Exception e) {
            this.logger.error("saveException:\u3010{}\u3011", (Object)e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArticleSave getArticleSave() {
        if (articleSave != null) {
            return articleSave;
        }
        Class<ArticleSave> clazz = ArticleSave.class;
        synchronized (ArticleSave.class) {
            if (articleSave == null) {
                articleSave = new ArticleSave();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return articleSave;
        }
    }

    private boolean isExist(Article article) {
        try {
            return Article.dao.findFirst("select * from Article t where t.title=? and channel = ?", new Object[]{article.get("title"), article.get("channel")}) != null;
        }
        catch (Exception e) {
            this.logger.error("selectException\u3010{}\u3011", (Object)e.getLocalizedMessage());
            return false;
        }
    }
}

