/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.crawler.news;

import cn.gtmap.crawler.news.model.Article;
import cn.gtmap.crawler.news.plugin.spring.SpringPlugin;
import cn.gtmap.crawler.news.web.IndexController;
import com.gtis.config.EgovConfigLoader;
import com.jfinal.config.Constants;
import com.jfinal.config.Handlers;
import com.jfinal.config.Interceptors;
import com.jfinal.config.JFinalConfig;
import com.jfinal.config.Plugins;
import com.jfinal.config.Routes;
import com.jfinal.core.JFinal;
import com.jfinal.json.FastJsonFactory;
import com.jfinal.json.IJsonFactory;
import com.jfinal.kit.LogKit;
import com.jfinal.kit.PathKit;
import com.jfinal.plugin.IPlugin;
import com.jfinal.plugin.activerecord.ActiveRecordPlugin;
import com.jfinal.plugin.activerecord.IDataSourceProvider;
import com.jfinal.plugin.activerecord.dialect.Dialect;
import com.jfinal.plugin.activerecord.dialect.Sqlite3Dialect;
import com.jfinal.plugin.c3p0.C3p0Plugin;
import com.jfinal.render.FreeMarkerRender;
import com.jfinal.render.ViewType;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModelException;
import java.io.File;

public class AppConfig
extends JFinalConfig {
    public void configConstant(Constants me) {
        this.loadEgovContext();
        this.loadPropertyFile(new File(this.getConfPath()));
        me.setViewType(ViewType.FREE_MARKER);
        me.setJsonFactory((IJsonFactory)FastJsonFactory.me());
        me.setBaseViewPath("/WEB-INF/views");
        me.setUrlParaSeparator("&");
        me.setDevMode(this.getPropertyToBoolean("dev.mode", Boolean.valueOf(false)).booleanValue());
    }

    public void configRoute(Routes me) {
        me.add("/", IndexController.class);
    }

    public void configPlugin(Plugins me) {
        me.add((IPlugin)new SpringPlugin(new String[]{PathKit.getRootClassPath() + "\\app-context.xml"}));
        C3p0Plugin cp = new C3p0Plugin(this.getProperty("db.url"), this.getProperty("db.user"), this.getProperty("db.password"));
        cp.setDriverClass("org.sqlite.JDBC");
        me.add((IPlugin)cp);
        ActiveRecordPlugin arp = new ActiveRecordPlugin((IDataSourceProvider)cp);
        arp.setShowSql(true);
        arp.setDialect((Dialect)new Sqlite3Dialect());
        me.add((IPlugin)arp);
        arp.addMapping("article", Article.class);
    }

    public void configInterceptor(Interceptors me) {
    }

    public void configHandler(Handlers me) {
    }

    public void afterJFinalStart() {
        Configuration fmConfiguration = FreeMarkerRender.getConfiguration();
        fmConfiguration.setClassicCompatible(true);
        fmConfiguration.setURLEscapingCharset("UTF-8");
        fmConfiguration.setTemplateUpdateDelay(0);
        try {
            fmConfiguration.setSharedVariable("base", (Object)JFinal.me().getContextPath());
            fmConfiguration.setSetting("auto_import", "WEB-INF/views/common/common.ftl as com");
        }
        catch (TemplateModelException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        catch (TemplateException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    protected String getConfPath() {
        String egovHome = com.gtis.config.AppConfig.getEgovHome();
        if (egovHome.contains("file:/")) {
            egovHome = egovHome.replaceFirst("file:/", "");
        }
        return egovHome.concat("conf/nsc/application.properties");
    }

    private void loadEgovContext() {
        try {
            EgovConfigLoader.load((String[])new String[0]);
        }
        catch (Exception e) {
            LogKit.error((String)"Egov config Context loader Error [{}]", (Throwable)e);
        }
    }
}

