/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.common.utils.qrcode;

import cn.gtmap.dysjy.common.utils.qrcode.QrCodeGenWrapper;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageConfig;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class QrCodeConfig {
    private String msg;
    private String logo;
    private Integer w;
    private Integer h;
    private MatrixToImageConfig matrixToImageConfig;
    private Map<EncodeHintType, Object> hints;
    private String picType;

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public Integer getW() {
        return this.w;
    }

    public void setW(Integer w) {
        this.w = w;
    }

    public Integer getH() {
        return this.h;
    }

    public void setH(Integer h) {
        this.h = h;
    }

    public MatrixToImageConfig getMatrixToImageConfig() {
        return this.matrixToImageConfig;
    }

    public void setMatrixToImageConfig(MatrixToImageConfig matrixToImageConfig) {
        this.matrixToImageConfig = matrixToImageConfig;
    }

    public Map<EncodeHintType, Object> getHints() {
        return this.hints;
    }

    public void setHints(Map<EncodeHintType, Object> hints) {
        this.hints = hints;
    }

    public String getPicType() {
        return this.picType;
    }

    public void setPicType(String picType) {
        this.picType = picType;
    }

    public String toString() {
        return "QrCodeConfig{msg='" + this.msg + '\'' + ", logo='" + this.logo + '\'' + ", w=" + this.w + ", h=" + this.h + ", matrixToImageConfig=" + this.matrixToImageConfig + ", hints=" + this.hints + ", picType='" + this.picType + '\'' + '}';
    }

    public static class QrCodeConfigBuilder {
        private static final MatrixToImageConfig DEFAULT_CONFIG = new MatrixToImageConfig();
        private String msg;
        private String logo;
        private Integer w;
        private Integer h;
        private Integer offColor;
        private Integer onColor;
        private String code;
        private Integer padding;
        private ErrorCorrectionLevel errorCorrection;
        private String picType;

        public String getMsg() {
            return this.msg;
        }

        public QrCodeConfigBuilder setMsg(String msg) {
            this.msg = msg;
            return this;
        }

        public String getLogo() {
            return this.logo;
        }

        public QrCodeConfigBuilder setLogo(String logo) {
            this.logo = logo;
            return this;
        }

        public Integer getW() {
            return this.w == null ? (this.h == null ? 200 : this.h) : this.w;
        }

        public QrCodeConfigBuilder setW(Integer w) {
            if (w != null && w < 0) {
                throw new IllegalArgumentException("???????????0");
            }
            this.w = w;
            return this;
        }

        public Integer getH() {
            if (this.w != null && this.w < 0) {
                throw new IllegalArgumentException("???????????0");
            }
            return this.h == null ? (this.w == null ? 200 : this.w) : this.h;
        }

        public QrCodeConfigBuilder setH(Integer h) {
            this.h = h;
            return this;
        }

        public Integer getOffColor() {
            return this.offColor == null ? -1 : this.offColor;
        }

        public QrCodeConfigBuilder setOffColor(Integer offColor) {
            this.offColor = offColor;
            return this;
        }

        public Integer getOnColor() {
            return this.onColor == null ? -16777216 : this.onColor;
        }

        public QrCodeConfigBuilder setOnColor(Integer onColor) {
            this.onColor = onColor;
            return this;
        }

        public String getCode() {
            return this.code == null ? "UTF-8" : this.code;
        }

        public QrCodeConfigBuilder setCode(String code) {
            this.code = code;
            return this;
        }

        public Integer getPadding() {
            if (this.padding == null) {
                return 1;
            }
            if (this.padding < 0) {
                return 0;
            }
            if (this.padding > 4) {
                return 4;
            }
            return this.padding;
        }

        public QrCodeConfigBuilder setPadding(Integer padding) {
            this.padding = padding;
            return this;
        }

        public String getPicType() {
            return this.picType == null ? "png" : this.picType;
        }

        public QrCodeConfigBuilder setPicType(String picType) {
            this.picType = picType;
            return this;
        }

        public ErrorCorrectionLevel getErrorCorrection() {
            return this.errorCorrection == null ? ErrorCorrectionLevel.H : this.errorCorrection;
        }

        public void setErrorCorrection(ErrorCorrectionLevel errorCorrection) {
            this.errorCorrection = errorCorrection;
        }

        private void validate() {
            if (this.msg == null || this.msg.length() == 0) {
                throw new IllegalArgumentException("????????????!");
            }
        }

        private QrCodeConfig create() {
            this.validate();
            QrCodeConfig qrCodeConfig = new QrCodeConfig();
            qrCodeConfig.setMsg(this.getMsg());
            qrCodeConfig.setH(this.getH());
            qrCodeConfig.setW(this.getW());
            qrCodeConfig.setLogo(this.getLogo());
            qrCodeConfig.setPicType(this.getPicType());
            HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>(3);
            hints.put(EncodeHintType.ERROR_CORRECTION, this.getErrorCorrection());
            hints.put(EncodeHintType.CHARACTER_SET, this.getCode());
            hints.put(EncodeHintType.MARGIN, this.getPadding());
            qrCodeConfig.setHints(hints);
            MatrixToImageConfig config = this.getOnColor() == -16777216 && this.getOffColor() == -1 ? DEFAULT_CONFIG : new MatrixToImageConfig(this.getOnColor().intValue(), this.getOffColor().intValue());
            qrCodeConfig.setMatrixToImageConfig(config);
            return qrCodeConfig;
        }

        public QrCodeConfig build() {
            return this.create();
        }

        public BufferedImage asBufferedImage() throws IOException, WriterException {
            return QrCodeGenWrapper.asBufferedImage(this.create());
        }

        public boolean asFile(String absFileName) throws IOException, WriterException {
            return QrCodeGenWrapper.asFile(this.create(), absFileName);
        }

        public String toString() {
            return "QrCodeConfigBuilder{msg='" + this.msg + '\'' + ", logo='" + this.logo + '\'' + ", w=" + this.w + ", h=" + this.h + ", offColor=" + this.offColor + ", onColor=" + this.onColor + ", code='" + this.code + '\'' + ", padding=" + this.padding + ", errorCorrection=" + this.errorCorrection + ", picType='" + this.picType + '\'' + '}';
        }
    }
}

