/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.common.utils.qrcode;

import cn.gtmap.dysjy.common.utils.qrcode.ImageUtil;
import cn.gtmap.dysjy.common.utils.qrcode.QrCodeConfig;
import com.google.zxing.common.BitMatrix;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class MatrixToImageUtil {
    public static BufferedImage toBufferedImage(QrCodeConfig qrCodeConfig, BitMatrix bitMatrix) throws IOException {
        int qrCodeWidth = bitMatrix.getWidth();
        int qrCodeHeight = bitMatrix.getHeight();
        BufferedImage qrCode = new BufferedImage(qrCodeWidth, qrCodeHeight, 1);
        for (int x = 0; x < qrCodeWidth; ++x) {
            for (int y = 0; y < qrCodeHeight; ++y) {
                qrCode.setRGB(x, y, bitMatrix.get(x, y) ? qrCodeConfig.getMatrixToImageConfig().getPixelOnColor() : qrCodeConfig.getMatrixToImageConfig().getPixelOffColor());
            }
        }
        if (qrCodeConfig.getLogo() != null && !"".equals(qrCodeConfig.getLogo())) {
            ImageUtil.insertLogo(qrCode, qrCodeConfig.getLogo());
        }
        int realQrCodeWidth = qrCodeConfig.getW();
        int realQrCodeHeight = qrCodeConfig.getH();
        if (qrCodeWidth != realQrCodeWidth || qrCodeHeight != realQrCodeHeight) {
            BufferedImage tmp = new BufferedImage(realQrCodeWidth, realQrCodeHeight, 1);
            tmp.getGraphics().drawImage(qrCode.getScaledInstance(realQrCodeWidth, realQrCodeHeight, 4), 0, 0, null);
            qrCode = tmp;
        }
        return qrCode;
    }
}

