/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.common.utils;

import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTVMerge;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STMerge;

public class TableUtil {
    private static final String MERGE_TYPE_BG = "bg";
    private static final String MERGE_TYPE_DYG = "dyg";

    public static void mergeTable(String mergeType, XWPFDocument document, int startIndex, int endIndex) {
        if (!mergeType.startsWith(MERGE_TYPE_BG)) {
            return;
        }
        try {
            XWPFTable startTabel = document.getTableArray(startIndex);
            XWPFTable endTabel = document.getTableArray(endIndex);
            for (int i = 0; i < endTabel.getRows().size(); ++i) {
                startTabel.addRow(endTabel.getRow(i));
            }
            int tablesIndex = document.getPosOfTable(endTabel);
            document.removeBodyElement(tablesIndex);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void mergeCell(String mergeType, XWPFDocument document, int tableIndex, int colIndex) {
        if (!mergeType.startsWith(MERGE_TYPE_DYG)) {
            return;
        }
        CTVMerge startMerge = CTVMerge.Factory.newInstance();
        startMerge.setVal(STMerge.RESTART);
        CTVMerge endMerge = CTVMerge.Factory.newInstance();
        endMerge.setVal(STMerge.CONTINUE);
        XWPFTable table = (XWPFTable)document.getTables().get(tableIndex);
        table.getRow(0).getCell(colIndex).getCTTc().getTcPr().setVMerge(startMerge);
        for (int i = 1; i <= table.getRows().size() - 1; ++i) {
            table.getRow(i).getCell(colIndex).getCTTc().getTcPr().setVMerge(endMerge);
        }
    }
}

