/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.common.utils;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DysjyDataUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DysjyDataUtil.class);
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public static String sum(List<Object> dataList, String key) {
        if (CollectionUtils.isEmpty(dataList)) {
            return "";
        }
        if (CollectionUtils.isEmpty(dataList = dataList.stream().filter(object -> StringUtils.isNotBlank((CharSequence)JSON.parseObject((String)JSON.toJSONString((Object)object)).getString(key))).collect(Collectors.toList()))) {
            return "";
        }
        List bigDecimalList = dataList.stream().map(object -> new BigDecimal(JSON.parseObject((String)JSON.toJSONString((Object)object)).getString(key))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(bigDecimalList)) {
            return "";
        }
        BigDecimal sum = BigDecimal.ZERO;
        for (BigDecimal bigDecimal : bigDecimalList) {
            sum = sum.add(bigDecimal);
        }
        return sum.toString();
    }

    public static String joinString(List dataList, String key, String delimiter) {
        try {
            List stringList;
            if (CollectionUtils.isEmpty((Collection)dataList)) {
                return "";
            }
            if (StringUtils.isBlank((CharSequence)delimiter)) {
                delimiter = ",";
            }
            if (CollectionUtils.isEmpty(stringList = dataList.stream().map(object -> JSON.parseObject((String)JSON.toJSONString((Object)object)).getString(key)).collect(Collectors.toList()))) {
                return "";
            }
            if (CollectionUtils.isEmpty(stringList = stringList.stream().filter(data -> StringUtils.isNotBlank((CharSequence)data)).collect(Collectors.toList()))) {
                return "";
            }
            return String.join((CharSequence)delimiter, stringList);
        }
        catch (Exception e) {
            LOGGER.error("joinString error dataList: {}, key: {}", new Object[]{JSON.toJSONString((Object)dataList), key, e});
            return "";
        }
    }

    public static String currentDate2String(String formatString) {
        try {
            if (StringUtils.isBlank((CharSequence)formatString)) {
                formatString = DEFAULT_DATE_FORMAT;
            }
            Date date = new Date();
            SimpleDateFormat format = new SimpleDateFormat(formatString);
            return format.format(new Date());
        }
        catch (Exception e) {
            LOGGER.error("currentDate2String error formatString: {}", (Object)formatString, (Object)e);
            return "";
        }
    }
}

