/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.common.utils;

import cn.gtmap.dysjy.common.domain.BdcDysjPzDO;
import cn.gtmap.dysjy.common.spirepdf.SpireOfficeUtil;
import cn.gtmap.pdf.utils.OfficeUtils;
import com.aspose.words.Document;
import com.aspose.words.FontSettings;
import com.aspose.words.License;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.docx4j.fonts.Mapper;

public class DyOfficeUtils {
    public static void docx2pdf(BdcDysjPzDO bdcDysjPzDO, String printPath, String tempWordFileName, String tempPdfFileName, int pageSize, Mapper fontMapper, String modelName) throws Exception {
        if (Objects.nonNull(bdcDysjPzDO) && StringUtils.isNotBlank((CharSequence)bdcDysjPzDO.getZhfs())) {
            if ("docx4j".equals(bdcDysjPzDO.getZhfs())) {
                OfficeUtils.convertDocxToPDF((String)tempWordFileName, (String)tempPdfFileName, (Mapper)fontMapper, (String)printPath, (String)modelName);
            } else if ("aspose".equals(bdcDysjPzDO.getZhfs())) {
                DyOfficeUtils.wordToPdf(tempWordFileName, tempPdfFileName, printPath);
            } else if (pageSize > 3) {
                DyOfficeUtils.wordToPdf(tempWordFileName, tempPdfFileName, printPath);
            } else {
                SpireOfficeUtil.convertDocxToPDF(tempWordFileName, tempPdfFileName, fontMapper);
            }
        } else if (pageSize > 3) {
            DyOfficeUtils.wordToPdf(tempWordFileName, tempPdfFileName, printPath);
        } else {
            SpireOfficeUtil.convertDocxToPDF(tempWordFileName, tempPdfFileName, fontMapper);
        }
    }

    private static void getLicense() throws Exception {
        String licenseStr = "<License>\n    <Data>\n        <Products>\n            <Product>Aspose.Total for Java</Product>\n            <Product>Aspose.Words for Java</Product>\n        </Products>\n        <EditionType>Enterprise</EditionType>\n        <SubscriptionExpiry>20991231</SubscriptionExpiry>\n        <LicenseExpiry>20991231</LicenseExpiry>\n        <SerialNumber>8bfe198c-7f0c-4ef8-8ff0-acc3237bf0d7</SerialNumber>\n    </Data>\n    <Signature>sNLLKGMUdF0r8O1kKilWAGdgfs2BvJb/2Xp8p5iuDVfZXmhppo+d0Ran1P9TKdjV4ABwAgKXxJ3jcQTqE/2IRfqwnPf8itN8aFZlV3TJPYeD3yWE7IT55Gz6EijUpC7aKeoohTb4w2fpox58wWoF3SNp6sK6jDfiAUGEHYJ9pjU=</Signature>\n</License>";
        try (InputStream is = IOUtils.toInputStream((String)licenseStr, (Charset)Charset.defaultCharset());){
            License license = new License();
            license.setLicense(is);
        }
    }

    private static void wordToPdf(String wordPath, String pdfPath, String printPath) throws Exception {
        DyOfficeUtils.getLicense();
        File file = new File(pdfPath);
        try (FileOutputStream os = new FileOutputStream(file);){
            Document doc = new Document(wordPath);
            FontSettings.setFontsFolder((String)printPath, (boolean)true);
            doc.save((OutputStream)os, 40);
        }
    }
}

