/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateUtils.class);
    public static final String sdf_China = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String sdf = "yyyy-MM-dd";
    public static final String sdf_ymd = "yyyyMMdd";
    public static final String sdf_ymdWithSpilt = "yyyy/MM/dd";
    public static final String sdf_ymdhms = "yyyy-MM-dd HH:mm:ss";
    public static final String sdf_ymdhm = "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206";
    public static final DateTimeFormatter DATE_FORMATYMDHMSF = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS", Locale.CHINA);
    public static final DateTimeFormatter DATE_FORMATYMDHMS = DateTimeFormatter.ofPattern("yyyyMMddHHmmss", Locale.CHINA);
    public static final DateTimeFormatter DATE_FORMATYMD = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5", Locale.CHINA);
    public static final DateTimeFormatter DATE_FORMATYMDHMS_SPLIT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.CHINA);
    public static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.CHINA);
    public static final DateTimeFormatter DATE_FORMAT_2 = DateTimeFormatter.ofPattern("yyyy-MM-dd", Locale.CHINA);
    public static final DateTimeFormatter DATE_FORMAT_3 = DateTimeFormatter.ofPattern("HH:mm:ss", Locale.CHINA);
    public static final DateTimeFormatter DATE_FORMAT_4 = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss", Locale.CHINA);
    public static final DateTimeFormatter DATE_FORMAT_5 = DateTimeFormatter.ofPattern("yyyy/MM/dd", Locale.CHINA);
    public static final DateTimeFormatter DATE_FORMATYMDHM = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206", Locale.CHINA);
    public static final DateTimeFormatter DATE_FORMAT_YYYY = DateTimeFormatter.ofPattern("yyyy", Locale.CHINA);
    public static final String DATE_NYR = "yyyyMMdd";
    public static final String DATE_NY = "yyyyMM";
    public static final String DATE_N = "yyyy";
    public static SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
    public static SimpleDateFormat format1 = new SimpleDateFormat("yyyyMMdd HH:mm:ss");

    public static Date dealDate(Date date, String time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(sdf);
        String dateStr = dateFormat.format(date) + " " + time;
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat(sdf_ymdhms);
        Date resultDate = null;
        try {
            resultDate = dateTimeFormat.parse(dateStr);
        }
        catch (ParseException e) {
            LOGGER.error(null, (Throwable)e);
        }
        return resultDate;
    }

    public static String formateTime(Date date, DateTimeFormatter dateTimeFormatter) {
        LocalDateTime localDateTime = DateUtils.date2LocalDateTime(date);
        return localDateTime.format(dateTimeFormatter);
    }

    public static String formateTimeYmdhms(Date date) {
        LocalDateTime localDateTime = DateUtils.date2LocalDateTime(date);
        return localDateTime.format(DATE_FORMATYMDHMS);
    }

    public static String formateYmdZw(Date date) {
        LocalDateTime localDateTime = DateUtils.date2LocalDateTime(date);
        return localDateTime.format(DATE_FORMATYMD);
    }

    public static String formateYmdhms(Date date) {
        LocalDateTime localDateTime = DateUtils.date2LocalDateTime(date);
        return localDateTime.format(DATE_FORMATYMDHMS_SPLIT);
    }

    public static Date formatDate(String str) {
        Date date = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)str)) {
                date = new SimpleDateFormat(sdf).parse(str);
            }
        }
        catch (Exception e) {
            LOGGER.info("\u65e5\u671f\u8f6c\u6362\u5931\u8d25\uff1a{}", (Object)str);
            try {
                date = new SimpleDateFormat("yyyyMMdd").parse(str);
            }
            catch (ParseException e1) {
                LOGGER.info("\u65e5\u671f\u8f6c\u6362\u5931\u8d25\uff1a{}", (Object)str);
                try {
                    date = new SimpleDateFormat(sdf_China).parse(str);
                }
                catch (ParseException e2) {
                    LOGGER.info("\u65e5\u671f\u8f6c\u6362\u5931\u8d25\uff1a{}", (Object)str);
                    try {
                        date = new SimpleDateFormat(sdf_ymdWithSpilt).parse(str);
                    }
                    catch (ParseException e3) {
                        LOGGER.info("\u65e5\u671f\u8f6c\u6362\u5931\u8d25\uff1a{}", (Object)str);
                        return null;
                    }
                }
            }
        }
        return date;
    }

    public static Date formatDate(String str, String pattern) {
        Date date = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)str)) {
                date = new SimpleDateFormat(pattern).parse(str);
            }
        }
        catch (ParseException e) {
            LOGGER.info("", (Throwable)e);
        }
        return date;
    }

    public static LocalDateTime date2LocalDateTime(Date date) {
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        return instant.atZone(zoneId).toLocalDateTime();
    }

    public static int getSeason(Date date) {
        int season = 0;
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int month = c.get(2);
        switch (month) {
            case 0: 
            case 1: 
            case 2: {
                season = 1;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                season = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                season = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                season = 4;
                break;
            }
        }
        return season;
    }

    public static long getDayTimeOfZeroHMS(Date date) {
        if (null == date) {
            return -1L;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime().getTime();
    }

    public static long getDayTimeOfLastHMS(Date date) {
        if (null == date) {
            return -1L;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime().getTime();
    }

    public static String getCurrYear() {
        GregorianCalendar today = new GregorianCalendar();
        String curYear = today.get(1) + "";
        return curYear;
    }

    public static String getCurrMD() {
        SimpleDateFormat sdf = new SimpleDateFormat("MMdd");
        GregorianCalendar today = new GregorianCalendar();
        String str = sdf.format(today.getTime());
        return str;
    }

    public static String getSpecifiedYear(int year, String dateFormat) {
        if (StringUtils.isBlank((CharSequence)dateFormat)) {
            dateFormat = sdf_ymdhms;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(1, year);
        return DateFormatUtils.format((Date)calendar.getTime(), (String)dateFormat);
    }

    public static String formateDateToString(Date date, DateTimeFormatter dateTimeFormatter) {
        if (Objects.isNull(date) || Objects.isNull(dateTimeFormatter)) {
            return "";
        }
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime localDateTime = instant.atZone(zoneId).toLocalDateTime();
        return localDateTime.format(dateTimeFormatter);
    }

    public static String getCurrentTimeStr() {
        LocalDateTime localDateTime = DateUtils.date2LocalDateTime(new Date());
        return localDateTime.format(DATE_FORMAT);
    }

    public static String convertTimeStr(String dateStr, DateTimeFormatter dateTimeFormatter) {
        try {
            Date date = new SimpleDateFormat(sdf_ymdhms).parse(dateStr);
            return DateUtils.formateTime(date, dateTimeFormatter);
        }
        catch (ParseException e) {
            LOGGER.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5931\u8d25\uff0c\u8f6c\u6362\u7684\u65e5\u671f\u5b57\u7b26\u4e32\u4e3a\uff1a{}", (Object)dateStr);
            return "";
        }
    }

    public static String getCurrYearMonth() {
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat format = new SimpleDateFormat(DATE_NY);
        return format.format(date);
    }

    public static String getCurrYearYear() {
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat format = new SimpleDateFormat(DATE_N);
        return format.format(date);
    }

    public static String getCurrDay() {
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return format.format(date);
    }

    public static String getLastMonthFirstDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(2, cal.get(2) - 1);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return DateFormatUtils.format((Date)cal.getTime(), (String)sdf_ymdhms);
    }

    public static String getLastSeasonStartTime(Date date) {
        int season = DateUtils.getSeason(date) - 1;
        Calendar cal = Calendar.getInstance();
        Integer year = cal.get(1);
        StringBuilder startTime = new StringBuilder();
        switch (season) {
            case 0: {
                startTime.append(year - 1).append("-09-01");
                break;
            }
            case 1: {
                startTime.append(year).append("-01-01");
                break;
            }
            case 2: {
                startTime.append(year).append("-04-01");
                break;
            }
            case 3: {
                startTime.append(year).append("-07-01");
                break;
            }
        }
        return startTime.append(" 00:00:00").toString();
    }

    public static Date getDateFromStr(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        long time = Long.parseLong(str);
        return new Date(time);
    }

    public static Date getYearFirstDay(int year) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(1, year);
        Date yearFirstDay = cal.getTime();
        return DateUtils.getStartDate(yearFirstDay);
    }

    public static Date getYearLastDay(int year) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(1, year);
        cal.roll(6, -1);
        Date yearLastDay = cal.getTime();
        return DateUtils.getFinallyDate(yearLastDay);
    }

    public static Date getFinallyDate(Date date) {
        String temp = format.format(date);
        temp = temp + " 23:59:59";
        try {
            return format1.parse(temp);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date getStartDate(Date date) {
        String temp = format.format(date);
        temp = temp + " 00:00:00";
        try {
            return format1.parse(temp);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getYesterDay(String today) {
        Calendar c = Calendar.getInstance();
        Date startTime = DateUtils.formatDate(today, sdf);
        c.setTime(startTime);
        c.set(5, c.get(5) - 1);
        return DateUtils.formateDateToString(c.getTime(), DATE_FORMAT_2);
    }

    public static String getTomorrow(String today) {
        Calendar c = Calendar.getInstance();
        Date startTime = DateUtils.formatDate(today, sdf);
        c.setTime(startTime);
        c.set(5, c.get(5) + 1);
        return DateUtils.formateDateToString(c.getTime(), DATE_FORMAT_2);
    }

    public static String exchangeHour(Integer time) {
        String result;
        if (time >= 24) {
            int day = time / 24;
            int hour = time % 24;
            result = hour == 0 ? day + "\u5929" : day + "\u5929" + hour + "\u5c0f\u65f6";
        } else {
            result = time + "\u5c0f\u65f6";
        }
        return result;
    }

    public static Date getFirstDayOfMonth(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        return c.getTime();
    }

    public static Date getFirstDayOfWeek(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        c.setFirstDayOfWeek(2);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(7, 2);
        return c.getTime();
    }

    public static Date getCurrentYearStartTime() {
        GregorianCalendar c = new GregorianCalendar();
        c.set(c.get(1), c.get(0) - 1, c.get(5), 0, 0, 0);
        c.set(5, ((Calendar)c).getActualMinimum(1));
        return c.getTime();
    }

    public static Date getFirstDayOfYear() {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(DateUtils.getCurrentYearStartTime());
        ((Calendar)c).add(1, 0);
        return c.getTime();
    }

    public static String exchangeMin(Integer minute) {
        String days = "";
        if (minute < 60) {
            days = minute + "\u5206\u949f";
        } else if (minute < 1440) {
            days = minute / 60 + "\u5c0f\u65f6" + minute % 60 + "\u5206\u949f";
        } else {
            int minuteValue = minute % 60;
            int hourValue = minute / 60 % 24;
            int dayValue = minute / 60 / 24;
            days = dayValue + "\u5929" + hourValue + "\u5c0f\u65f6" + minuteValue + "\u5206\u949f";
        }
        return days;
    }

    public static Date getSameDayOfNextMonth(Date date) throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int month = c.get(2);
        int day = c.get(5);
        c.set(5, 28);
        c.set(2, month + 1);
        int endDay = c.getActualMaximum(5);
        c.set(5, Math.min(day, endDay));
        date = c.getTime();
        return date;
    }
}

