/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.common.spirepdf.impl;

import cn.gtmap.dysjy.common.spirepdf.SpireDataService;
import cn.gtmap.dysjy.common.utils.qrcode.QrCodeConfig;
import cn.gtmap.dysjy.common.utils.qrcode.QrCodeGenWrapper;
import com.deepoove.poi.data.PictureRenderData;
import com.deepoove.poi.util.BytePictureUtils;
import com.google.zxing.WriterException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.imageio.ImageIO;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SpireDataServiceImpl
implements SpireDataService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpireDataServiceImpl.class);
    @Value(value="${print.path:/usr/local/bdc3/print/}")
    private String printPath;
    public static byte[] checkBoxY;
    public static byte[] checkBoxN;

    @PostConstruct
    public void init() {
        try {
            checkBoxY = FileUtils.readFileToByteArray((File)new File(this.printPath + "CheckboxY.png"));
            checkBoxN = FileUtils.readFileToByteArray((File)new File(this.printPath + "CheckboxN.png"));
        }
        catch (IOException e) {
            LOGGER.error("\u5bfc\u51faPDF\u3001WORD\u521d\u59cb\u5316\u83b7\u53d6\u590d\u9009\u6846\u56fe\u7247\u6570\u636e\u5931\u8d25\uff0c\u56e0\u4e3a\u672a\u627e\u5230\u5bf9\u5e94\u6587\u4ef6!");
        }
    }

    @Override
    public List<Map<String, Object>> getValDataList(String xmlData) throws DocumentException {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(10);
        Document document = DocumentHelper.parseText((String)xmlData.replaceAll("&", "&amp;"));
        Element root = document.getRootElement();
        result.add(this.getValDataMap(root));
        return result;
    }

    private Map getValDataMap(Element element) {
        if (null == element) {
            return null;
        }
        List datasList = element.elements("datas");
        if (CollectionUtils.isEmpty((Collection)datasList) || null == datasList.get(0)) {
            return null;
        }
        List dataList = ((Element)datasList.get(0)).elements("data");
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(dataList.size());
        for (Element data : dataList) {
            String name = data.attribute("name").getValue();
            String type = data.attribute("type").getValue();
            if (this.isImageType(type)) {
                this.addImageType(map, data, name, false, this.getHeightOrWidth(data, "height"), this.getHeightOrWidth(data, "width"));
                continue;
            }
            if (!this.isStrType(type)) continue;
            if (this.isCheckBox(name)) {
                this.addCheckBoxType(map, data, false);
                continue;
            }
            map.put(name, data.getText());
        }
        return this.getSubTables(element, map);
    }

    private boolean isImageType(String type) {
        return "image".equals(type) || "Image".equals(type) || "IMAGE".equals(type);
    }

    private boolean isStrType(String type) {
        return "String".equals(type) || "string".equals(type) || "STRING".equals(type);
    }

    private void addImageType(Map<String, Object> map, Element data, String name, boolean isSetPictureUrl, int height, int width) {
        try {
            String text = data.getText();
            if (StringUtils.isBlank((CharSequence)text)) {
                LOGGER.error("\u5bfc\u51faPDF\u3001WORD\u5904\u7406\u56fe\u7247\u4e2d\u6b62\uff0c\u9519\u8bef\u539f\u56e0\uff1a\u672a\u5b9a\u4e49\u56fe\u7247\u8def\u5f84\uff0c\u5bf9\u5e94\u5b57\u6bb5\u540d\u79f0\uff1a{}", (Object)name);
                return;
            }
            if (isSetPictureUrl) {
                map.put(name, text);
            } else if (text.startsWith("http") || text.startsWith("https")) {
                if (!this.isHtmlUrl(map, name, text)) {
                    map.put(name, new PictureRenderData(width, height, ".png", BytePictureUtils.getUrlBufferedImage((String)text)));
                } else {
                    map.put(name, new PictureRenderData(width, height, ".png", this.genBufferedImage(width, height, text)));
                }
            } else {
                File file = new File(text);
                if (file.exists()) {
                    map.put(name, new PictureRenderData(width, height, ".png", ImageIO.read(file)));
                } else {
                    map.put(name, new PictureRenderData(width, height, ".png", this.genBufferedImage(width, height, text)));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u51faPDF\u3001WORD\u5904\u7406\u56fe\u7247\u9519\u8bef\uff0c\u5bf9\u5e94\u5b57\u6bb5\uff1a{}\uff0c\u9519\u8bef\u539f\u56e0\uff1a", (Object)name, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isHtmlUrl(Map<String, Object> map, String name, String text) {
        HttpURLConnection urlConnection = null;
        try {
            URL url = new URL(text);
            urlConnection = (HttpURLConnection)url.openConnection();
            String contentType = urlConnection.getContentType();
            boolean bl = StringUtils.isNotBlank((CharSequence)contentType) && contentType.contains("text/html");
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6URL\u94fe\u63a5\u5f02\u5e38 url:" + text, (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            urlConnection.disconnect();
        }
    }

    private BufferedImage genBufferedImage(int width, int height, String context) throws IOException, WriterException {
        QrCodeConfig qrCodeConfig = QrCodeGenWrapper.createQrCodeConfig().setMsg(context).setH(height).setW(width).setPadding(0).build();
        return QrCodeGenWrapper.asBufferedImage(qrCodeConfig);
    }

    private void addCheckBoxType(Map<String, Object> map, Element data, boolean isSetPictureName) {
        String name = data.attribute("name").getValue();
        String itemName = name.replace("CHECKBOX#", "");
        itemName = itemName.replace("checkbox#", "");
        String text = data.getText();
        if (StringUtils.isNotBlank((CharSequence)text)) {
            String[] valArr;
            String[] textArr = text.split("_");
            for (String val : valArr = textArr[0].split(",")) {
                if (isSetPictureName) {
                    map.put(itemName + "_" + val, "CheckboxY.png");
                    continue;
                }
                map.put(itemName + "_" + val, new PictureRenderData(12, 12, ".png", checkBoxY));
            }
            if (textArr.length > 1) {
                String[] otherValArr;
                for (String val : otherValArr = textArr[1].split(",")) {
                    if (isSetPictureName) {
                        map.put(itemName + "_" + val, "CheckboxN.png");
                        continue;
                    }
                    map.put(itemName + "_" + val, new PictureRenderData(12, 12, ".png", checkBoxN));
                }
            }
        }
    }

    private Map getSubTables(Element element, Map<String, Object> map) {
        List detailElements = element.elements("detail");
        if (CollectionUtils.isEmpty((Collection)detailElements)) {
            return map;
        }
        for (Element detailElement : detailElements) {
            String tableId = detailElement.attribute("ID").getValue();
            List detailRowElements = detailElement.elements("row");
            if (CollectionUtils.isEmpty((Collection)detailRowElements)) continue;
            int maxZbxh = 0;
            ArrayList<HashMap<String, Object>> rowDataList = new ArrayList<HashMap<String, Object>>(detailRowElements.size());
            for (Element element2 : detailRowElements) {
                List rowDatas = element2.elements("data");
                if (!CollectionUtils.isNotEmpty((Collection)rowDatas)) continue;
                HashMap<String, Object> dataMap = new HashMap<String, Object>(rowDatas.size());
                for (Element rowData : rowDatas) {
                    String name = rowData.attribute("name").getValue();
                    String type = rowData.attribute("type").getValue();
                    String value = rowData.getText();
                    if (this.isImageType(type)) {
                        this.addImageType(dataMap, rowData, name, true, this.getHeightOrWidth(rowData, "height"), this.getHeightOrWidth(rowData, "width"));
                    } else if (this.isStrType(type)) {
                        if (this.isCheckBox(name)) {
                            this.addCheckBoxType(dataMap, rowData, true);
                        } else {
                            dataMap.put(name, value);
                        }
                    }
                    if (!"zbxh".equals(name) || !StringUtils.isNotBlank((CharSequence)value) || Integer.valueOf(value) <= maxZbxh) continue;
                    maxZbxh = Integer.valueOf(value);
                }
                rowDataList.add(dataMap);
            }
            if (tableId.startsWith("ZB_") || tableId.startsWith("zb_")) {
                for (Map map2 : rowDataList) {
                    String zbxh = String.valueOf(map2.get("zbxh"));
                    String subTableId = "TABLE_" + tableId + "_" + zbxh;
                    if (map.keySet().contains(subTableId)) {
                        ((List)map.get(subTableId)).add(map2);
                        continue;
                    }
                    ArrayList<Map> subTableDataList = new ArrayList<Map>(5);
                    subTableDataList.add(map2);
                    map.put(subTableId, subTableDataList);
                }
                continue;
            }
            if (tableId.startsWith("NQ_") || tableId.startsWith("nq_")) {
                map.put("TABLE_" + tableId, rowDataList);
                continue;
            }
            map.put("TABLE_" + tableId, rowDataList);
        }
        return map;
    }

    private int getHeightOrWidth(Element rowData, String attrName) {
        int result = 90;
        if (Objects.isNull(rowData)) {
            return result;
        }
        if (Objects.nonNull(rowData.attribute(attrName))) {
            return Integer.valueOf(rowData.attribute(attrName).getValue());
        }
        return result;
    }

    private boolean isCheckBox(String name) {
        return name.startsWith("CHECKBOX#") || name.startsWith("checkbox#");
    }
}

