/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.common.spirepdf;

import cn.gtmap.dysjy.common.domain.BdcDysjPzDO;
import cn.gtmap.dysjy.common.spirepdf.SpireDocService;
import cn.gtmap.dysjy.common.spirepdf.SpireOfficeUtil;
import cn.gtmap.dysjy.common.utils.TableUtil;
import cn.gtmap.pdf.service.TemplateClientDealService;
import cn.gtmap.pdf.utils.OfficeUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.aspose.words.Document;
import com.aspose.words.FontSettings;
import com.aspose.words.License;
import com.deepoove.poi.NiceXWPFDocument;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.xmlbeans.impl.values.XmlValueDisconnectedException;
import org.docx4j.fonts.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpirePdfTask
implements Callable<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpirePdfTask.class);
    private SpireDocService spireDocService;
    private Map<String, Object> pdfData;
    private int index;
    private String printPath;
    private String modelName;
    private Mapper fontMapper;
    private TemplateClientDealService templateSpecialDealService;
    private BdcDysjPzDO bdcDysjPzDO;

    public SpirePdfTask(SpireDocService spireDocService, Map<String, Object> pdfData, int index, String modelName, String printPath, Mapper fontMapper, TemplateClientDealService templateSpecialDealService, BdcDysjPzDO bdcDysjPzDO) {
        this.spireDocService = spireDocService;
        this.printPath = printPath;
        this.pdfData = pdfData;
        this.index = index;
        this.modelName = modelName;
        this.fontMapper = fontMapper;
        this.templateSpecialDealService = templateSpecialDealService;
        this.bdcDysjPzDO = bdcDysjPzDO;
    }

    /*
     * Loose catch block
     */
    @Override
    public String call() throws Exception {
        LOGGER.debug("PDF\u5bfc\u51fa\u6b63\u5728\u5904\u7406\u7b2c{}\u4efd\u6587\u4ef6\uff01", (Object)(this.index + 1));
        String tempWordFileName = SpireOfficeUtil.generateWordFileName(this.printPath);
        String tempPdfFileName = SpireOfficeUtil.generatePdfFileName(this.printPath, null);
        try {
            try (FileOutputStream wordFileOutStream = new FileOutputStream(tempWordFileName);){
                NiceXWPFDocument document = this.spireDocService.getNiceXWPFDocument(this.modelName, this.pdfData);
                this.deleteBlankParagraph((XWPFDocument)document);
                document = this.mergeTableAndCell(tempWordFileName, 0, "", document, this.bdcDysjPzDO);
                int pageSize = document.getProperties().getExtendedProperties().getUnderlyingProperties().getPages();
                document.write((OutputStream)wordFileOutStream);
                wordFileOutStream.flush();
                wordFileOutStream.close();
                if (Objects.nonNull(this.templateSpecialDealService)) {
                    this.templateSpecialDealService.dealTemplate(this.modelName, tempWordFileName);
                }
                this.docx2pdf(tempWordFileName, tempPdfFileName, pageSize);
                OfficeUtils.addWaterMarkConfigToPdfFile((String)tempPdfFileName, this.pdfData, (String)this.printPath, null);
                OfficeUtils.addPicWaterMarkConfigToPdfFile((String)tempPdfFileName, this.pdfData, (String)this.printPath);
                OfficeUtils.addQzPicConfigToPdfFile((String)tempPdfFileName, this.pdfData, (String)this.printPath);
                LOGGER.debug("\u5f53\u524d\u5904\u7406\u7b2c{}\u9875\u6587\u6863\u5b8c\u6210", (Object)(this.index + 1));
                String string = tempPdfFileName;
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            File wordFile = new File(tempWordFileName);
            if (wordFile.exists()) {
                wordFile.delete();
            }
        }
    }

    private void docx2pdf(String tempWordFileName, String tempPdfFileName, int pageSize) throws Exception {
        if (Objects.nonNull(this.bdcDysjPzDO) && StringUtils.isNotBlank((CharSequence)this.bdcDysjPzDO.getZhfs())) {
            if ("docx4j".equals(this.bdcDysjPzDO.getZhfs())) {
                OfficeUtils.convertDocxToPDF((String)tempWordFileName, (String)tempPdfFileName, (Mapper)this.fontMapper, (String)this.printPath, (String)this.modelName);
            } else if ("aspose".equals(this.bdcDysjPzDO.getZhfs())) {
                SpirePdfTask.wordToPdf(tempWordFileName, tempPdfFileName, this.printPath);
            } else if (pageSize > 3) {
                SpirePdfTask.wordToPdf(tempWordFileName, tempPdfFileName, this.printPath);
            } else {
                SpireOfficeUtil.convertDocxToPDF(tempWordFileName, tempPdfFileName, this.fontMapper);
            }
        } else if (pageSize > 3) {
            SpirePdfTask.wordToPdf(tempWordFileName, tempPdfFileName, this.printPath);
        } else {
            SpireOfficeUtil.convertDocxToPDF(tempWordFileName, tempPdfFileName, this.fontMapper);
        }
    }

    private static void getLicense() throws Exception {
        String licenseStr = "<License>\n    <Data>\n        <Products>\n            <Product>Aspose.Total for Java</Product>\n            <Product>Aspose.Words for Java</Product>\n        </Products>\n        <EditionType>Enterprise</EditionType>\n        <SubscriptionExpiry>20991231</SubscriptionExpiry>\n        <LicenseExpiry>20991231</LicenseExpiry>\n        <SerialNumber>8bfe198c-7f0c-4ef8-8ff0-acc3237bf0d7</SerialNumber>\n    </Data>\n    <Signature>sNLLKGMUdF0r8O1kKilWAGdgfs2BvJb/2Xp8p5iuDVfZXmhppo+d0Ran1P9TKdjV4ABwAgKXxJ3jcQTqE/2IRfqwnPf8itN8aFZlV3TJPYeD3yWE7IT55Gz6EijUpC7aKeoohTb4w2fpox58wWoF3SNp6sK6jDfiAUGEHYJ9pjU=</Signature>\n</License>";
        try (InputStream is = IOUtils.toInputStream((String)licenseStr, (Charset)Charset.defaultCharset());){
            License license = new License();
            license.setLicense(is);
        }
    }

    public static void wordToPdf(String wordPath, String pdfPath, String printPath) throws Exception {
        SpirePdfTask.getLicense();
        File file = new File(pdfPath);
        try (FileOutputStream os = new FileOutputStream(file);){
            Document doc = new Document(wordPath);
            FontSettings.setFontsFolder((String)printPath, (boolean)true);
            doc.save((OutputStream)os, 40);
        }
    }

    private NiceXWPFDocument mergeTableAndCell(String tempWordFileName, int delTime, String dealKey, NiceXWPFDocument document, BdcDysjPzDO bdcDysjPzDO) throws IOException {
        if (delTime >= 3) {
            return document;
        }
        if (Objects.isNull(bdcDysjPzDO)) {
            return document;
        }
        String hbbg = bdcDysjPzDO.getHbbg();
        if (StringUtils.isBlank((CharSequence)hbbg)) {
            return document;
        }
        String outKey = "";
        try {
            JSONObject jsonObject = JSON.parseObject((String)hbbg, (Feature[])new Feature[]{Feature.OrderedField});
            for (String jsonKey : jsonObject.keySet()) {
                if (StringUtils.isNotBlank((CharSequence)dealKey) && !StringUtils.equals((CharSequence)dealKey, (CharSequence)jsonKey)) continue;
                outKey = jsonKey;
                String value = jsonObject.getString(jsonKey);
                Integer param1 = Integer.valueOf(value.split("-")[0]);
                Integer param2 = Integer.valueOf(value.split("-")[1]);
                TableUtil.mergeTable(jsonKey, (XWPFDocument)document, param1, param2);
                TableUtil.mergeCell(jsonKey, (XWPFDocument)document, param1, param2);
            }
        }
        catch (XmlValueDisconnectedException xmlValueDisconnectedException) {
            FileOutputStream wordFileOutStream = new FileOutputStream(tempWordFileName);
            document.write((OutputStream)wordFileOutStream);
            wordFileOutStream.flush();
            wordFileOutStream.close();
            FileInputStream inputStream = new FileInputStream(tempWordFileName);
            document = new NiceXWPFDocument((InputStream)inputStream);
            ((InputStream)inputStream).close();
            return this.mergeTableAndCell(tempWordFileName, delTime + 1, outKey, document, bdcDysjPzDO);
        }
        catch (Exception e) {
            LOGGER.error("\u5408\u5e76\u8868\u683c\u5f02\u5e38 pdfpath: {}", (Object)bdcDysjPzDO.getPdfpath(), (Object)e);
        }
        return document;
    }

    private void deleteBlankParagraph(XWPFDocument document) {
        try {
            XWPFParagraph paragraph;
            List runs;
            IBodyElement element;
            List elements = document.getBodyElements();
            for (int i = 0; i < 1000 && (element = (IBodyElement)elements.get(elements.size() - 1)) instanceof XWPFParagraph && (runs = (paragraph = (XWPFParagraph)element).getRuns()).size() == 0; ++i) {
                document.removeBodyElement(document.getPosOfParagraph(paragraph));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u6587\u4ef6\u5c3e\u90e8\u7a7a\u767d\u6bb5\u843d\u5f02\u5e38", (Throwable)e);
        }
    }
}

