/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.common.service.impl;

import cn.gtmap.dysjy.common.domain.BdcDysjPzDO;
import cn.gtmap.dysjy.common.domain.BdcDysjZbPzDO;
import cn.gtmap.dysjy.common.dto.BdcDysjDTO;
import cn.gtmap.dysjy.common.enums.BdcDyBeanEnum;
import cn.gtmap.dysjy.common.service.BdcDypzService;
import cn.gtmap.dysjy.common.service.BdcDysjPzService;
import cn.gtmap.dysjy.common.service.BdcPrintService;
import cn.gtmap.dysjy.common.utils.AESutil;
import cn.gtmap.dysjy.common.utils.CoeRuntimeContext;
import cn.gtmap.dysjy.common.utils.ResultHandleUtils;
import cn.gtmap.dysjy.common.utils.StringToolUtils;
import cn.gtmap.dysjy.common.utils.groovy.XmlUtils;
import cn.gtmap.dysjy.common.utils.thread.DetailPrintThread;
import cn.gtmap.dysjy.common.utils.thread.DyThreadEngine;
import cn.gtmap.dysjy.common.utils.thread.PageStringThread;
import cn.gtmap.dysjy.common.vo.BdcDysjPzVO;
import cn.gtmap.dysjy.exceptions.DysjyException;
import cn.gtmap.dysjy.exceptions.MissingArgumentException;
import cn.gtmap.dysjy.mybatis.mapper.DyEntityMapper;
import cn.gtmap.dysjy.mybatis.mapper.Example;
import cn.gtmap.dysjy.server.utils.DyCacheUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import groovy.util.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.Asserts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class BdcPrintServiceImpl
implements BdcPrintService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BdcPrintServiceImpl.class);
    private static final Integer MAX_NUM = 50;
    private static final String REGEXP = "<|>";
    private static final Pattern PATTERN = Pattern.compile("<|>");
    @Autowired
    BdcDysjPzService bdcDysjPzService;
    @Autowired
    BdcDypzService bdcDypzService;
    @Autowired
    DyThreadEngine threadEngine;
    @Autowired
    AESutil aeSutil;
    @Autowired
    private DyEntityMapper dyEntityMapper;
    @Autowired
    private DyCacheUtils dyCacheUtils;
    @Value(value="${print.replaceNull.zbid:}")
    private String zbids;
    @Value(value="${print.replaceNull.symbol:}")
    private String symbol;

    @Override
    public String print(Map<String, List<Map>> paramMap) {
        if (MapUtils.isEmpty(paramMap)) {
            throw new MissingArgumentException("\u6253\u5370\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Date startTime = new Date();
        Integer[] valueSize = new Integer[]{0};
        StringBuilder xmlBulider = new StringBuilder();
        paramMap.forEach((key, value) -> {
            if (StringUtils.isEmpty((CharSequence)key)) {
                throw new MissingArgumentException("\u6253\u5370\u7c7b\u578b");
            }
            BdcDysjPzDO bdcDysjPzDO = new BdcDysjPzDO();
            bdcDysjPzDO.setDylx((String)key);
            List<BdcDysjPzDO> bdcDysjPzDOS = this.bdcDypzService.listBdcDysjPz(bdcDysjPzDO);
            if (CollectionUtils.isEmpty(bdcDysjPzDOS)) {
                throw new DysjyException("\u6253\u5370\u914d\u7f6e\u4e3b\u8868\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (Map param : value) {
                this.encodeParam(bdcDysjPzDOS.get(0), param);
            }
            BdcDysjZbPzDO bdcDysjZbPzDO = new BdcDysjZbPzDO();
            bdcDysjZbPzDO.setDylx((String)key);
            List<BdcDysjZbPzDO> bdcDysjZbPzDOS = this.bdcDypzService.listBdcDysjZbPz(bdcDysjZbPzDO);
            for (BdcDysjZbPzDO bdcDysjZbPz : bdcDysjZbPzDOS) {
                if (!StringUtils.isNotBlank((CharSequence)bdcDysjZbPz.getDyzbsx()) || null == bdcDysjZbPz.getDyzbid()) continue;
                String zbid = bdcDysjZbPz.getDyzbid() + bdcDysjZbPz.getDyzbsx();
                bdcDysjZbPz.setDyzbid(zbid);
            }
            BdcDysjPzVO bdcDysjPzVO = new BdcDysjPzVO();
            bdcDysjPzVO.setBdcDysjPzDO(bdcDysjPzDOS.get(0));
            bdcDysjPzVO.setBdcDysjZbPzDOList(bdcDysjZbPzDOS);
            List<Map<String, Object>> dycsMapList = value.stream().map(map -> {
                HashMap resultMap = new HashMap(map.size());
                if (!CollectionUtils.isEmpty((Map)map)) {
                    for (Object mapKey : map.keySet()) {
                        if (!Objects.nonNull(mapKey)) continue;
                        resultMap.put(String.valueOf(mapKey), map.get(mapKey));
                    }
                }
                return resultMap;
            }).collect(Collectors.toList());
            bdcDysjPzVO.setDycsMapList(dycsMapList);
            Map resultMap = (Map)this.jypzxx(bdcDysjPzVO);
            String xml = (String)resultMap.get("result");
            if (StringUtils.isBlank((CharSequence)xml)) {
                String dyzd = StringUtils.trimToEmpty((String)bdcDysjPzDOS.get(0).getDyzd());
                Node xmlNode = XmlUtils.getXmlNodeByString(dyzd);
                StringBuilder pageBulider = value.size() > MAX_NUM ? this.generatePageBuliderThread(bdcDysjPzDOS, bdcDysjZbPzDOS, xmlNode, (List<Map>)value) : this.generatePageBulider(bdcDysjPzDOS, bdcDysjZbPzDOS, xmlNode, (List<Map>)value, (String)key);
                valueSize[0] = valueSize[0] + value.size();
                xml = XmlUtils.processCharacterSet(XmlUtils.replacePageInXml(xmlNode, pageBulider.toString()));
            }
            xmlBulider.append(xml);
        });
        long time = System.currentTimeMillis() - startTime.getTime();
        LOGGER.info("\u6253\u5370\u603b\u5171\u6267\u884c\u7528\u65f6\uff1a{},\u6570\u636e\u91cf\uff1a{}", (Object)time, (Object)valueSize[0]);
        return xmlBulider.toString();
    }

    private StringBuilder generatePageBulider(List<BdcDysjPzDO> bdcDysjPzDOS, List<BdcDysjZbPzDO> bdcDysjZbPzDOS, Node xmlNode, List<Map> configParamList, String key) {
        StringBuilder pageBulider = new StringBuilder();
        configParamList.forEach(configParam -> {
            configParam.put("dylx", key);
            boolean sfdy = configParamList.size() > 1;
            String page = this.getPage(bdcDysjPzDOS, bdcDysjZbPzDOS, xmlNode, (Map)configParam, sfdy);
            pageBulider.append(page);
        });
        return pageBulider;
    }

    private StringBuilder generatePageBuliderThread(List<BdcDysjPzDO> bdcDysjPzDOS, List<BdcDysjZbPzDO> bdcDysjZbPzDOS, Node xmlNode, List<Map> configParamList) {
        StringBuilder pageBulider = new StringBuilder();
        ArrayList<PageStringThread> pageStringThreadList = new ArrayList<PageStringThread>();
        for (Map configParam : configParamList) {
            PageStringThread pageStringThread = new PageStringThread(this, bdcDysjPzDOS, bdcDysjZbPzDOS, xmlNode, configParam);
            pageStringThreadList.add(pageStringThread);
        }
        this.threadEngine.excuteThread(pageStringThreadList, true);
        for (PageStringThread pageStringThread : pageStringThreadList) {
            pageBulider.append(pageStringThread.getPageString());
        }
        return pageBulider;
    }

    @Override
    public String getPage(List<BdcDysjPzDO> bdcDysjPzDOS, List<BdcDysjZbPzDO> bdcDysjZbPzDOS, Node xmlNode, Map configParam, boolean sfdy) {
        Map dataMap = this.bdcDysjPzService.queryPrintDatasList(configParam, "bdcRegisterConfigMapper", bdcDysjPzDOS);
        this.decodeResult(bdcDysjPzDOS.get(0), dataMap);
        if (!CollectionUtils.isEmpty(dataMap.values())) {
            dataMap.forEach((key, value) -> {
                if (value != null) {
                    StringBuffer stringBuffer = this.replace(value.toString());
                    dataMap.replace(key, stringBuffer);
                }
            });
        }
        Multimap detailMap = this.bdcDysjPzService.queryPrintDetailList(configParam, "bdcRegisterConfigMapper", bdcDysjZbPzDOS);
        for (Map.Entry entry2 : detailMap.entries()) {
            for (Map map : (List)entry2.getValue()) {
                this.decodeResult(bdcDysjPzDOS.get(0), map);
            }
        }
        Map<String, String> detailXml = XmlUtils.converDetailXmlString(xmlNode);
        Map<String, String> detailRowXml = XmlUtils.converDetailRowXmlString(xmlNode);
        Map<String, List<String>> configKeys = XmlUtils.getDetailXmlKeys(xmlNode);
        HashMap detailXmlMap = Maps.newHashMap();
        detailMap.entries().forEach(entry -> {
            Date startTime = new Date();
            String key = (String)entry.getKey();
            boolean replaceSymbol = Lists.newArrayList((Object[])this.zbids.split(",")).contains(key);
            List value = (List)entry.getValue();
            String detailStr = value.size() > MAX_NUM ? this.processDetailXmlMultiThread(configKeys, detailXml, detailRowXml, key, value) : this.processDetailXml(configKeys, detailXml, detailRowXml, key, value, replaceSymbol);
            detailXmlMap.put(key, detailStr);
            long time = System.currentTimeMillis() - startTime.getTime();
            LOGGER.info("\u5b50\u8868{}\u6253\u5370\u603b\u5171\u6267\u884c\u7528\u65f6\uff1a{},\u6570\u636e\u91cf\uff1a{}", new Object[]{key, time, value.size()});
        });
        return sfdy ? this.processPrintXml(xmlNode, dataMap, detailXmlMap, bdcDysjPzDOS.get(0).getZdbqdyzd()) : this.processPrintXmlNoPage(xmlNode, dataMap, detailXmlMap, bdcDysjPzDOS.get(0).getZdbqdyzd());
    }

    private String processDetailXml(Map<String, List<String>> configKeys, Map<String, String> detailXml, Map<String, String> detailRowXml, String key, List<Map> detailList, boolean replaceSymbol) {
        StringBuilder rowBulider = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)key) || MapUtils.isEmpty(configKeys) || MapUtils.isEmpty(detailXml) || MapUtils.isEmpty(detailRowXml)) {
            return rowBulider.toString();
        }
        List<String> keys = configKeys.get(key);
        String rowXml = detailRowXml.get(key);
        if (CollectionUtils.isEmpty(keys) || StringUtils.isBlank((CharSequence)rowXml)) {
            return rowBulider.toString();
        }
        if (CollectionUtils.isEmpty(detailList)) {
            HashMap nullMap = Maps.newHashMap();
            detailList.add(nullMap);
        }
        for (Map detail : detailList) {
            Set keySet = detail.keySet();
            keys.forEach(column -> {
                boolean replace = true;
                for (Object mapKey : keySet) {
                    if (!String.valueOf(mapKey).equalsIgnoreCase((String)column)) continue;
                    replace = false;
                    break;
                }
                if (replace) {
                    detail.putIfAbsent(column, replaceSymbol ? this.symbol : "");
                }
            });
            String xml = rowXml;
            for (Map.Entry entry : detail.entrySet()) {
                xml = StringToolUtils.replaceXml((String)entry.getKey(), entry.getValue(), xml, detail);
            }
            rowBulider.append(xml);
        }
        return rowBulider.toString();
    }

    private String processDetailXmlMultiThread(Map<String, List<String>> configKeys, Map<String, String> detailXml, Map<String, String> detailRowXml, String key, List<Map> detailList) {
        StringBuilder rowBulider = new StringBuilder();
        if (CollectionUtils.isEmpty(detailList) || StringUtils.isBlank((CharSequence)key) || MapUtils.isEmpty(configKeys) || MapUtils.isEmpty(detailXml) || MapUtils.isEmpty(detailRowXml)) {
            return rowBulider.toString();
        }
        ArrayList<DetailPrintThread> detailPrintThreads = new ArrayList<DetailPrintThread>(detailList.size());
        for (Map detailData : detailList) {
            DetailPrintThread pageStringThread = new DetailPrintThread(configKeys.get(key), detailXml.get(key), detailRowXml.get(key), key, detailData);
            detailPrintThreads.add(pageStringThread);
        }
        this.threadEngine.excuteThread(detailPrintThreads, true);
        for (DetailPrintThread detailPrintThread : detailPrintThreads) {
            rowBulider.append(detailPrintThread.getDetailXmlString());
        }
        return rowBulider.toString();
    }

    @Override
    public String printDatas(List<BdcDysjDTO> bdcDysjDTOList) {
        if (CollectionUtils.isEmpty(bdcDysjDTOList)) {
            throw new DysjyException("\u914d\u7f6e\u7ed3\u679c\u96c6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StringBuilder xmlBulider = new StringBuilder();
        StringBuilder pageBulider = new StringBuilder();
        Node xmlNode = XmlUtils.getXmlNodeByString(bdcDysjDTOList.get(0).getDyzd());
        bdcDysjDTOList.forEach(bdcDysjDTO -> {
            String dyzd = bdcDysjDTO.getDyzd();
            if (StringUtils.isBlank((CharSequence)dyzd)) {
                throw new DysjyException("xml\u914d\u7f6e\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Map dataMap = (Map)JSON.parseObject((String)bdcDysjDTO.getDysj(), HashMap.class);
            Map detailMap = (Map)JSON.parseObject((String)bdcDysjDTO.getDyzbsj(), HashMap.class);
            String page = "";
            page = bdcDysjDTOList.size() > 1 ? this.processOtherDataSourcePrintXml(xmlNode, dataMap, detailMap, bdcDysjDTO.getZdbqdyzd()) : this.processOtherDataSourcePrintXmlNoPage(xmlNode, dataMap, detailMap, bdcDysjDTO.getZdbqdyzd());
            pageBulider.append(page);
        });
        String xml = XmlUtils.processCharacterSet(XmlUtils.replacePageInXml(xmlNode, pageBulider.toString()));
        xmlBulider.append(xml);
        return xmlBulider.toString();
    }

    private List<String> unCompletionKeyList(List<String> configKeys, Map<String, Object> dataMap) {
        if (MapUtils.isEmpty(dataMap)) {
            return new ArrayList<String>();
        }
        List<String> mapKeyList = dataMap.keySet().stream().map(key -> key.toLowerCase()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(configKeys)) {
            return mapKeyList;
        }
        configKeys = configKeys.stream().map(key -> key.toLowerCase()).collect(Collectors.toList());
        mapKeyList.removeAll(configKeys);
        return mapKeyList;
    }

    @Override
    public String parsePrintDatasXml(Node page, Map dataMap, Map detailDataMap, boolean zdbqdyzd) {
        List<String> unCompletionKeyList;
        StringBuilder builder = new StringBuilder();
        boolean emptyMap = MapUtils.isEmpty((Map)dataMap);
        if (emptyMap) {
            dataMap = Maps.newHashMap();
        }
        List<Object> configKeys = Lists.newArrayList();
        configKeys = XmlUtils.queryDataConfigKeys(page, configKeys);
        if (zdbqdyzd && !CollectionUtils.isEmpty(unCompletionKeyList = this.unCompletionKeyList((List<String>)configKeys, dataMap))) {
            unCompletionKeyList.forEach(key -> XmlUtils.addDataXml(page, key));
        }
        String xml = XmlUtils.queryDataXml(page, builder);
        String string = this.symbol = emptyMap ? this.symbol : "";
        if (!CollectionUtils.isEmpty((Collection)configKeys)) {
            for (String string2 : configKeys) {
                boolean replace = true;
                for (Object mapKey : dataMap.keySet()) {
                    if (!String.valueOf(mapKey).equalsIgnoreCase(string2)) continue;
                    replace = false;
                    break;
                }
                if (!replace) continue;
                dataMap.putIfAbsent(string2, this.symbol);
            }
        }
        Map targetDataMap = this.addDetailData(dataMap, detailDataMap);
        for (Map.Entry entry : dataMap.entrySet()) {
            xml = StringToolUtils.replaceXml((String)entry.getKey(), entry.getValue(), xml, targetDataMap);
        }
        return xml;
    }

    private Map addDetailData(Map dataMap, Map detailDataMap) {
        if (MapUtils.isEmpty((Map)dataMap) || MapUtils.isEmpty((Map)detailDataMap)) {
            return dataMap;
        }
        HashMap targetMap = new HashMap();
        targetMap.putAll(dataMap);
        detailDataMap.keySet().forEach(key -> {
            JSONArray dataArray = new JSONArray();
            JSONArray jsonArray = (JSONArray)detailDataMap.get(key);
            if (CollectionUtils.isEmpty((Collection)jsonArray)) {
                return;
            }
            jsonArray.forEach(innerObject -> {
                if (innerObject == null) {
                    return;
                }
                JSONArray innerArray = JSON.parseArray((String)JSON.toJSONString((Object)innerObject));
                if (CollectionUtils.isEmpty((Collection)innerArray)) {
                    return;
                }
                innerArray.forEach(jsonObject -> dataArray.add(jsonObject));
            });
            targetMap.putIfAbsent(key, dataArray);
        });
        return targetMap;
    }

    @Override
    public String processPageXml(Node page, Map dataMap, Map detailDataMap, boolean zdbqdyzd) {
        String datas = this.parsePrintDatasXml(page, dataMap, detailDataMap, zdbqdyzd);
        String detail = XmlUtils.parsePrintDetailXml(page, detailDataMap);
        StringBuilder pageStr = new StringBuilder();
        pageStr.append(datas);
        pageStr.append(detail);
        return pageStr.toString();
    }

    @Override
    public String processOtherDataSourcePageXml(Node page, Map dataMap, Map detailDataMap, boolean zdbqdyzd) {
        String datas = this.parsePrintDatasXml(page, dataMap, detailDataMap, zdbqdyzd);
        String detail = XmlUtils.parseOtherDataSourcePrintDetailXml(page, dataMap, detailDataMap, zdbqdyzd);
        StringBuilder pageStr = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)datas)) {
            datas = "<datas></datas>";
        }
        pageStr.append(datas);
        pageStr.append(detail);
        return pageStr.toString();
    }

    @Override
    public String processPrintXml(Node xml, Map dataMap, Map detailDataMap, boolean zdbqdyzd) {
        StringBuilder pages = new StringBuilder();
        if (xml == null) {
            return pages.toString();
        }
        xml.children().forEach(page -> {
            pages.append("<page>");
            String pageStr = this.processPageXml((Node)page, dataMap, detailDataMap, zdbqdyzd);
            pages.append(pageStr);
            pages.append("</page>");
        });
        return pages.toString();
    }

    @Override
    public String processPrintXmlNoPage(Node xml, Map dataMap, Map detailDataMap, boolean zdbqdyzd) {
        StringBuilder pages = new StringBuilder();
        if (xml == null) {
            return pages.toString();
        }
        xml.children().forEach(page -> {
            String pageStr = this.processPageXml((Node)page, dataMap, detailDataMap, zdbqdyzd);
            pages.append(pageStr);
        });
        return pages.toString();
    }

    @Override
    public String processOtherDataSourcePrintXml(Node xml, Map dataMap, Map detailDataMap, boolean zdbqdyzd) {
        StringBuilder pages = new StringBuilder();
        if (xml == null) {
            return pages.toString();
        }
        xml.children().forEach(page -> {
            pages.append("<page>");
            String pageStr = this.processOtherDataSourcePageXml((Node)page, dataMap, detailDataMap, zdbqdyzd);
            pages.append(pageStr);
            pages.append("</page>");
        });
        return pages.toString();
    }

    @Override
    public String processOtherDataSourcePrintXmlNoPage(Node xml, Map dataMap, Map detailDataMap, boolean zdbqdyzd) {
        StringBuilder pages = new StringBuilder();
        if (xml == null) {
            return pages.toString();
        }
        xml.children().forEach(page -> {
            String pageStr = this.processOtherDataSourcePageXml((Node)page, dataMap, detailDataMap, zdbqdyzd);
            pages.append(pageStr);
        });
        return pages.toString();
    }

    @Override
    public Object jypzxx(BdcDysjPzVO bdcDysjPzVO) {
        CoeRuntimeContext.setRuntimeData("BDC_DYSJ_METHOD_LIST", this.dyCacheUtils.getBdcDysjMethodList());
        if (null == bdcDysjPzVO) {
            throw new MissingArgumentException("\u83b7\u5f97\u5230\u7684\u6253\u5370\u914d\u7f6e\u9a8c\u8bc1\u5bf9\u8c61\u4e3anull\uff01");
        }
        List<Map<String, Object>> dycsMapList = bdcDysjPzVO.getDycsMapList();
        if (CollectionUtils.isEmpty(dycsMapList)) {
            throw new MissingArgumentException("\u6253\u5370\u6821\u9a8c\u53c2\u6570\u4e3anull\uff01");
        }
        BdcDysjPzDO bdcDysjPzDO = bdcDysjPzVO.getBdcDysjPzDO();
        if (null == bdcDysjPzDO || StringUtils.isBlank((CharSequence)bdcDysjPzDO.getDylx()) || StringUtils.isBlank((CharSequence)bdcDysjPzDO.getDyzd())) {
            throw new MissingArgumentException("\u8bf7\u68c0\u67e5\u4e3b\u8868\u914d\u7f6e\u4fe1\u606f\uff0c\u6253\u5370\u7c7b\u578b\u3001\u6253\u5370\u5b57\u6bb5xml\u6a21\u677f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        }
        String dylx = bdcDysjPzDO.getDylx();
        String dyzd = bdcDysjPzDO.getDyzd();
        bdcDysjPzDO.setDysjy(ResultHandleUtils.replaceParam(bdcDysjPzDO.getDysjy()));
        List<BdcDysjZbPzDO> bdcDysjZbPzDOList = bdcDysjPzVO.getBdcDysjZbPzDOList();
        for (BdcDysjZbPzDO bdcDysjZbPzDO : bdcDysjZbPzDOList) {
            if (StringUtils.isNotBlank((CharSequence)bdcDysjZbPzDO.getDyzbsx()) && null != bdcDysjZbPzDO.getDyzbid()) {
                String zbid = bdcDysjZbPzDO.getDyzbid() + bdcDysjZbPzDO.getDyzbsx();
                bdcDysjZbPzDO.setDyzbid(zbid);
            }
            bdcDysjZbPzDO.setDyzbsjy(ResultHandleUtils.replaceParam(bdcDysjZbPzDO.getDyzbsjy()));
        }
        ArrayList<BdcDysjPzDO> bdcDysjPzDOList = new ArrayList<BdcDysjPzDO>();
        bdcDysjPzDOList.add(bdcDysjPzDO);
        ArrayList<BdcDysjDTO> bdcDysjDTOList = new ArrayList<BdcDysjDTO>();
        for (Map<String, Object> dycsMap : dycsMapList) {
            Map datas = this.bdcDysjPzService.queryPrintDatasList(dycsMap, BdcDyBeanEnum.BdcDyConfigService.getBeanName(), bdcDysjPzDOList);
            this.decodeResult(bdcDysjPzVO.getBdcDysjPzDO(), datas);
            Multimap detail = this.bdcDysjPzService.queryPrintDetailList(dycsMap, BdcDyBeanEnum.BdcDyConfigService.getBeanName(), bdcDysjZbPzDOList);
            for (Map.Entry entry : detail.entries()) {
                for (Map map : (List)entry.getValue()) {
                    this.decodeResult(bdcDysjPzVO.getBdcDysjPzDO(), map);
                }
            }
            BdcDysjDTO bdcDysjDTO = new BdcDysjDTO();
            bdcDysjDTO.setDylx(dylx);
            bdcDysjDTO.setDyzd(dyzd);
            bdcDysjDTO.setDysj(JSONObject.toJSONString((Object)datas));
            bdcDysjDTO.setDyzbsj(JSONObject.toJSONString((Object)detail));
            bdcDysjDTO.setZdbqdyzd(bdcDysjPzDO.getZdbqdyzd());
            bdcDysjDTOList.add(bdcDysjDTO);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        resultMap.put("code", true);
        resultMap.put("result", this.printDatas(bdcDysjDTOList));
        CoeRuntimeContext.clearRuntimeData();
        return resultMap;
    }

    @Override
    public String getPrintXmlByDylx(String dylx, Map params) {
        HashMap<String, List<Map>> paramMap = new HashMap<String, List<Map>>();
        ArrayList<Map> list = new ArrayList<Map>();
        list.add(params);
        paramMap.put(dylx, list);
        return this.print(paramMap);
    }

    @Override
    public String getPrintXmlByTemplateName(String templateName, Map params) {
        Asserts.notBlank((CharSequence)templateName, (String)"\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Example example = new Example(BdcDysjPzDO.class);
        example.createCriteria().andEqualTo("pdfpath", templateName);
        List<BdcDysjPzDO> bdcDysjPzDOList = this.dyEntityMapper.selectByExampleNotNull(BdcDysjPzDO.class, example);
        Assert.notEmpty(bdcDysjPzDOList, (String)("\u672a\u67e5\u8be2\u5230\u6253\u5370XML\u914d\u7f6e templateName: " + templateName));
        return this.getPrintXmlByDylx(bdcDysjPzDOList.get(0).getDylx(), params);
    }

    public void encodeParam(BdcDysjPzDO bdcDysjPzDO, Map param) {
        String[] split;
        String jmcs = bdcDysjPzDO.getJmcs();
        if (StringUtils.isEmpty((CharSequence)jmcs)) {
            return;
        }
        for (String cs : split = jmcs.split(",")) {
            if (!param.containsKey(cs) || !Objects.nonNull(param.get(cs))) continue;
            String encrypt = AESutil.encrypt((String)param.get(cs));
            param.put(cs, encrypt);
        }
    }

    public void decodeResult(BdcDysjPzDO bdcDysjPzDO, Map data) {
        String[] split;
        String jmjg = bdcDysjPzDO.getJmjg();
        if (StringUtils.isEmpty((CharSequence)jmjg)) {
            return;
        }
        for (String jg : split = jmjg.split(",")) {
            if (!data.containsKey(jg) || !Objects.nonNull(data.get(jg))) continue;
            String decrypt = AESutil.decrypt((String)data.get(jg));
            data.put(jg, decrypt);
        }
    }

    public StringBuffer replace(String str) {
        HashMap replacements = new HashMap(2){
            {
                this.put("<", "<![CDATA[<]]>");
                this.put(">", "<![CDATA[>]]>");
            }
        };
        StringBuffer stringBuffer = new StringBuffer();
        Matcher m = PATTERN.matcher(str);
        while (m.find()) {
            m.appendReplacement(stringBuffer, (String)replacements.get(m.group()));
        }
        m.appendTail(stringBuffer);
        return stringBuffer;
    }
}

