/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.dysjy.common.service.impl;

import cn.gtmap.dysjy.common.domain.BdcDysjPzDO;
import cn.gtmap.dysjy.common.domain.BdcDysjZbPzDO;
import cn.gtmap.dysjy.common.enums.BdcDyBeanEnum;
import cn.gtmap.dysjy.common.enums.BdcDySjlyEnum;
import cn.gtmap.dysjy.common.mapper.BdcConfigMapper;
import cn.gtmap.dysjy.common.service.BdcDyConfigService;
import cn.gtmap.dysjy.common.service.BdcDyDataService;
import cn.gtmap.dysjy.common.service.BdcDysjPzService;
import cn.gtmap.dysjy.common.utils.BeansResolveUtils;
import cn.gtmap.dysjy.common.utils.DataParseUtils;
import cn.gtmap.dysjy.exceptions.DysjyException;
import cn.gtmap.dysjy.exceptions.MissingArgumentException;
import cn.gtmap.dysjy.server.utils.DyRestRpcUtils;
import cn.gtmap.pdf.exception.AppException;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BdcDysjPzServiceImpl
implements BdcDysjPzService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BdcDysjPzServiceImpl.class);
    private final Pattern pattern = Pattern.compile("\\$\\{[a-zA-Z]+\\}");
    @Autowired
    BeansResolveUtils beansResolveUtils;
    @Autowired
    DyRestRpcUtils restRpcUtils;
    @Autowired(required=false)
    private List<BdcDyDataService> bdcDyDataServiceList;

    @Override
    public Map queryPrintDatasList(Map configParam, String configBeanName, List<BdcDysjPzDO> bdcDysjPzDOList) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)configBeanName)) {
            throw new DysjyException("\u6267\u884c\u914d\u7f6esql\u7684bean\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(bdcDysjPzDOList)) {
            throw new DysjyException("\u6253\u5370\u4e3b\u8868\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList dataList = Lists.newArrayList();
        bdcDysjPzDOList.forEach(data -> {
            ArrayList csList = Lists.newArrayList((Object[])data.getCs().split(","));
            csList.forEach(cs -> {
                if (configParam.get(cs) == null) {
                    throw new MissingArgumentException("\u4ee3\u7801\u7f3a\u5931\u6253\u5370\u914d\u7f6e\u7684\u53c2\u6570:{}" + cs);
                }
            });
            if (BdcDySjlyEnum.JKSX.getCode().equals(data.getSjly())) {
                this.getResultByJksx((BdcDysjPzDO)data, configParam, dataList);
            } else if (BdcDySjlyEnum.FW.getCode().equals(data.getSjly())) {
                this.getResultByGetReuqest((BdcDysjPzDO)data, null, configParam, dataList);
            } else {
                List<String> sqlList = this.getSqlList(data.getDysjy());
                sqlList.forEach(sql -> {
                    List<Map> configList;
                    try {
                        Matcher matcher = this.pattern.matcher((CharSequence)sql);
                        String matchStr = null;
                        String condition = null;
                        Object value = null;
                        while (matcher.find()) {
                            matchStr = matcher.group();
                            condition = matchStr.substring(2, matchStr.length() - 1);
                            value = configParam.get(condition);
                            if (value == null) {
                                throw new MissingArgumentException(condition);
                            }
                            sql = sql.replaceAll("\\$\\{" + condition + "\\}", value.toString());
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("\u6253\u5370\u4e3b\u8868\u66ff\u6362${param}\u7c7b\u53c2\u6570\u65f6\u53d1\u8bc1\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7814\u53d1\uff01");
                    }
                    if (!sql.trim().startsWith("select") && !sql.trim().startsWith("SELECT")) {
                        throw new AppException("\u4e3b\u8868sql\u5fc5\u987b\u4e3aselect\u8bed\u53e5" + sql);
                    }
                    configParam.put("sql", sql);
                    if (BdcDyBeanEnum.BdcDyConfigService.getBeanName().equals(configBeanName)) {
                        BdcDyConfigService bdcDyConfigService = (BdcDyConfigService)this.beansResolveUtils.getBeanByName(configBeanName);
                        configList = bdcDyConfigService.executeConfigSql(configParam, data.getDbsource());
                    } else {
                        BdcConfigMapper bdcConfigMapper = (BdcConfigMapper)this.beansResolveUtils.getBeanByName(configBeanName);
                        configList = bdcConfigMapper.executeConfigSql(configParam);
                    }
                    configParam.remove("sql");
                    if (!CollectionUtils.isEmpty(configList)) {
                        dataList.addAll(configList);
                    }
                });
            }
        });
        HashMap map = Maps.newHashMap();
        dataList.forEach(data -> {
            if (null != data) {
                map.putAll(data);
            }
        });
        this.addParamToDataMap(map, configParam);
        return map;
    }

    private void getResultByJksx(BdcDysjPzDO bdcDysjPzDO, Map params, List<Map> resultDataList) {
        if (!CollectionUtils.isEmpty(this.bdcDyDataServiceList)) {
            for (BdcDyDataService bdcDyDataService : this.bdcDyDataServiceList) {
                String jksxResult = bdcDyDataService.getBdcDysjPzResult(bdcDysjPzDO, params);
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jksxResult)) continue;
                LOGGER.debug("\u7528\u6237\u63a5\u53e3\u8fd4\u56de\u6570\u636e bdcDysjPzDO: {}, params: {}, jksxResult: {}", new Object[]{JSON.toJSONString((Object)bdcDysjPzDO), JSON.toJSONString((Object)params), jksxResult});
                List result = (List)DataParseUtils.parseType(null, jksxResult);
                this.handleResult(result, resultDataList);
                return;
            }
        }
        try {
            LOGGER.error("\u7528\u6237\u672a\u5b9e\u73b0\u63a5\u53e3\u8fd4\u56de\u6570\u636e,\u4f7f\u7528\u9ed8\u8ba4\u903b\u8f91\u83b7\u53d6\u6570\u636e");
            Object paramResult = params.get(bdcDysjPzDO.getCs());
            String jksxResult = "";
            jksxResult = paramResult instanceof String ? (String)paramResult : JSON.toJSONString(paramResult);
            List result = (List)DataParseUtils.parseType(null, jksxResult);
            this.handleResult(result, resultDataList);
        }
        catch (Exception e) {
            LOGGER.error("\u63a5\u53e3\u5b9e\u73b0\u83b7\u53d6\u6570\u636e\u672a\u8fd4\u56de\u4efb\u52a1\u6570\u636e bdcDysjPzDO: {}, params: {}", (Object)JSON.toJSONString((Object)bdcDysjPzDO), (Object)JSON.toJSONString((Object)params));
            throw new DysjyException("\u8bf7\u5b9e\u73b0\u63a5\u53e3\u8fd4\u56de\u6570\u636e" + bdcDysjPzDO.getDylx());
        }
    }

    @Override
    public Multimap queryPrintDetailList(Map configParam, String configBeanName, List<BdcDysjZbPzDO> bdcDysjZbPzDOList) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)configBeanName)) {
            throw new MissingArgumentException("\u6267\u884c\u914d\u7f6esql\u7684bean\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(bdcDysjZbPzDOList)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u6253\u5370\u5b50\u8868\u914d\u7f6e\u4e3a\u7a7a");
            }
            return ArrayListMultimap.create();
        }
        ArrayListMultimap multimap = ArrayListMultimap.create();
        bdcDysjZbPzDOList.forEach(arg_0 -> this.lambda$queryPrintDetailList$5(configParam, configBeanName, (Multimap)multimap, arg_0));
        return multimap;
    }

    private void addParamToDataMap(Map dataMap, Map paramMap) {
        if (Objects.isNull(dataMap) || Objects.isNull(paramMap)) {
            return;
        }
        paramMap.keySet().forEach(key -> {
            if (Objects.isNull(dataMap.get(key))) {
                dataMap.put(key, paramMap.get(key));
            }
        });
    }

    private List<String> getSqlList(String sjySql) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sjySql)) {
            return new ArrayList<String>();
        }
        List<String> sqlList = Lists.newArrayList((Object[])sjySql.split(";")).stream().filter(sql -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)sql)).map(sql -> {
            for (int i = 0; i < 10 && sql.contains("--"); ++i) {
                int start = sql.indexOf("--");
                if (sql.substring(start).contains("\n")) {
                    int end = sql.substring(start).indexOf("\n");
                    sql = sql.substring(0, start) + sql.substring(start + end);
                    continue;
                }
                sql = sql.substring(0, start);
            }
            return sql;
        }).filter(sql -> !StringUtils.isEmpty((Object)sql.trim())).collect(Collectors.toList());
        return sqlList;
    }

    private void getDetailResultByJksx(BdcDysjZbPzDO bdcDysjZbPzDO, Map configParam, List<Map> sqlMapList) {
        if (!CollectionUtils.isEmpty(this.bdcDyDataServiceList)) {
            for (BdcDyDataService bdcDyDataService : this.bdcDyDataServiceList) {
                String jksxResult = bdcDyDataService.getBdcDysjZbPzResult(bdcDysjZbPzDO, configParam);
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jksxResult)) continue;
                LOGGER.debug("\u7528\u6237\u63a5\u53e3\u8fd4\u56de\u6570\u636e bdcDysjZbPzDO: {}, params: {}, jksxResult: {}", new Object[]{JSON.toJSONString((Object)bdcDysjZbPzDO), JSON.toJSONString((Object)configParam), jksxResult});
                List result = (List)DataParseUtils.parseType(bdcDysjZbPzDO.getDyzbid(), jksxResult);
                this.handleResult(result, sqlMapList);
                return;
            }
        }
        try {
            LOGGER.error("\u7528\u6237\u672a\u5b9e\u73b0\u63a5\u53e3\u8fd4\u56de\u6570\u636e,\u4f7f\u7528\u9ed8\u8ba4\u903b\u8f91\u83b7\u53d6\u6570\u636e");
            Object paramResult = configParam.get(bdcDysjZbPzDO.getCs());
            String jksxResult = "";
            jksxResult = paramResult instanceof String ? (String)paramResult : JSON.toJSONString(paramResult);
            List result = (List)DataParseUtils.parseType(bdcDysjZbPzDO.getDyzbid(), jksxResult);
            this.handleResult(result, sqlMapList);
        }
        catch (Exception e) {
            LOGGER.error("\u63a5\u53e3\u5b9e\u73b0\u83b7\u53d6\u6570\u636e\u672a\u8fd4\u56de\u4efb\u52a1\u6570\u636e bdcDysjZbPzDO: {}, params: {}", (Object)JSON.toJSONString((Object)bdcDysjZbPzDO), (Object)JSON.toJSONString((Object)configParam));
            throw new DysjyException("\u8bf7\u5b9e\u73b0\u63a5\u53e3\u8fd4\u56de\u6570\u636e" + bdcDysjZbPzDO.getDyzbid());
        }
    }

    private void getResultByGetReuqest(BdcDysjPzDO bdcDysjPzDO, BdcDysjZbPzDO bdcDysjZbPzDO, Map params, List<Map> resultDataList) {
        try {
            List result = (List)this.restRpcUtils.getRpcRequest(bdcDysjPzDO, bdcDysjZbPzDO, params);
            this.handleResult(result, resultDataList);
        }
        catch (Exception e) {
            LOGGER.error("\u6253\u5370-\u670d\u52a1\u65b9\u5f0f\u83b7\u53d6\u6570\u636e\u5185\u5bb9\u53d1\u751f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new DysjyException("\u6253\u5370-\u670d\u52a1\u65b9\u5f0f\u83b7\u53d6\u6570\u636e\u5185\u5bb9\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    private void handleResult(List<Map<String, Object>> result, List<Map> resultDataList) {
        if (!CollectionUtils.isEmpty(result)) {
            ArrayList newList = new ArrayList(result.size());
            result.stream().forEach(map -> {
                HashMap newMap = new HashMap(map.size());
                for (Map.Entry entry : map.entrySet()) {
                    newMap.put(((String)entry.getKey()).toUpperCase(), entry.getValue());
                }
                newList.add(newMap);
            });
            resultDataList.addAll(newList);
        }
    }

    private void getResultByGetReuqest(String dataId, String appName, String url, Map params, List<Map> resultDataList) {
        try {
            List result = (List)this.restRpcUtils.getRpcRequest(dataId, appName, url, params);
            if (!CollectionUtils.isEmpty((Collection)result)) {
                ArrayList newList = new ArrayList(result.size());
                result.stream().forEach(map -> {
                    HashMap newMap = new HashMap(map.size());
                    for (Map.Entry entry : map.entrySet()) {
                        newMap.put(((String)entry.getKey()).toUpperCase(), entry.getValue());
                    }
                    newList.add(newMap);
                });
                resultDataList.addAll(newList);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6253\u5370-\u670d\u52a1\u65b9\u5f0f\u83b7\u53d6\u6570\u636e\u5185\u5bb9\u53d1\u751f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new DysjyException("\u6253\u5370-\u670d\u52a1\u65b9\u5f0f\u83b7\u53d6\u6570\u636e\u5185\u5bb9\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    private /* synthetic */ void lambda$queryPrintDetailList$5(Map configParam, String configBeanName, Multimap multimap, BdcDysjZbPzDO detail) {
        ArrayList csList = Lists.newArrayList((Object[])detail.getCs().split(","));
        csList.forEach(cs -> {
            if (configParam.get(cs) == null) {
                throw new MissingArgumentException("\u6253\u5370\u914d\u7f6e\u53c2\u6570" + cs);
            }
        });
        ArrayList sqlMapList = Lists.newArrayList();
        if (BdcDySjlyEnum.JKSX.getCode().equals(detail.getSjly())) {
            this.getDetailResultByJksx(detail, configParam, sqlMapList);
        } else if (BdcDySjlyEnum.FW.getCode().equals(detail.getSjly())) {
            this.getResultByGetReuqest(null, detail, configParam, sqlMapList);
        } else {
            List<String> sqlList = this.getSqlList(detail.getDyzbsjy());
            int index = 1;
            HashMap sqlResult = Maps.newHashMap();
            for (String sql : sqlList) {
                List<Map> detailList;
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)org.apache.commons.lang3.StringUtils.trim((String)sql))) continue;
                Matcher matcher = this.pattern.matcher(sql);
                String matchStr = null;
                String condition = null;
                Object value = null;
                while (matcher.find()) {
                    matchStr = matcher.group();
                    condition = matchStr.substring(2, matchStr.length() - 1);
                    value = configParam.get(condition);
                    if (value == null) {
                        throw new MissingArgumentException(condition);
                    }
                    sql = sql.replaceAll("\\$\\{" + condition + "\\}", value.toString());
                }
                if (!sql.trim().startsWith("select") && !sql.trim().startsWith("SELECT")) {
                    throw new AppException("\u5b50\u8868sql\u5fc5\u987b\u4e3aselect\u8bed\u53e5" + sql);
                }
                configParam.put("sql", sql);
                if (BdcDyBeanEnum.BdcDyConfigService.getBeanName().equals(configBeanName)) {
                    BdcDyConfigService bdcDyConfigService = (BdcDyConfigService)this.beansResolveUtils.getBeanByName(configBeanName);
                    detailList = bdcDyConfigService.executeConfigSql(configParam, detail.getDbsource());
                } else {
                    BdcConfigMapper bdcConfigMapper = (BdcConfigMapper)this.beansResolveUtils.getBeanByName(configBeanName);
                    detailList = bdcConfigMapper.executeConfigSql(configParam);
                }
                configParam.remove("sql");
                if (sqlList.size() > 1) {
                    sqlResult.put("sql" + index, Queues.newArrayDeque(detailList));
                    ++index;
                    continue;
                }
                sqlMapList.addAll(detailList);
            }
            while (MapUtils.isNotEmpty((Map)sqlResult)) {
                Iterator iterator = sqlResult.entrySet().iterator();
                HashMap detailMap = Maps.newHashMap();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Queue queue = (Queue)entry.getValue();
                    Map map = (Map)queue.poll();
                    if (map == null) {
                        iterator.remove();
                        continue;
                    }
                    detailMap.putAll(map);
                }
                if (!MapUtils.isNotEmpty((Map)detailMap)) continue;
                sqlMapList.add(detailMap);
            }
        }
        String detailid = detail.getDyzbid();
        if (!CollectionUtils.isEmpty((Collection)sqlMapList)) {
            for (int i = 0; i < sqlMapList.size(); ++i) {
                ((Map)sqlMapList.get(i)).put("DYROWNUM", i + 1);
                this.addParamToDataMap((Map)sqlMapList.get(i), configParam);
            }
        }
        multimap.put((Object)detailid, (Object)sqlMapList);
    }
}

