/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ias.workflow.clients;

import cn.gtmap.ias.workflow.domain.dto.WorkflowDto;
import cn.gtmap.ias.workflow.domain.dto.page.LayPage;
import cn.gtmap.ias.workflow.domain.dto.page.LayPageable;
import java.io.IOException;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="${app.feign-client.workflow.name}")
@RequestMapping(value={"${app.feign-client.workflow.context-path}/resource/workflow"})
public interface WorkFlowClient {
    @GetMapping(value={"/test"})
    public String test();

    @PostMapping(value={"/process/{definitionId}"})
    public String startProcessInstance(@PathVariable(name="definitionId") String var1, @RequestParam(name="name", required=false) String var2);

    @PostMapping(value={"/assign/{instanceId}"})
    public void assign(@PathVariable(name="instanceId") String var1, @RequestBody(required=false) List<String> var2);

    @GetMapping(value={"/instances"})
    public List<WorkflowDto> getProcessInstances(@RequestBody(required=true) List<String> var1);

    @GetMapping(value={"/isBack/{instanceId}"})
    public String isBack(@PathVariable(name="instanceId") String var1);

    @GetMapping(value={"/task/{instanceId}"})
    public List<WorkflowDto> getCurrentTask(@PathVariable(name="instanceId") String var1);

    @PostMapping(value={"/end/{instanceId}"})
    public void end(@PathVariable(name="instanceId") String var1);

    @GetMapping(value={"/back/tasks/{instanceId}"})
    public List<WorkflowDto> allowSendBackTo(@PathVariable(name="instanceId") String var1);

    @PostMapping(value={"/back/{instanceId}"})
    public void sendBack(@PathVariable(name="instanceId") String var1, @RequestParam(name="targetTaskKey") String var2);

    @GetMapping(value={"/last/validation/{instanceId}"})
    public boolean validLast(@PathVariable(name="instanceId") String var1);

    @GetMapping(value={"/tasks"})
    public List<WorkflowDto> getTasks(@RequestParam(name="definitionId", required=false) String var1, @RequestParam(name="assignee", required=false) String var2);

    @GetMapping(value={"/tasks/page"})
    public LayPage<WorkflowDto> pageTasks(@RequestBody LayPageable var1, @RequestParam(name="definitionId", required=false) String var2, @RequestParam(name="assignee", required=false) String var3);

    @GetMapping(value={"/tasks/ended"})
    public List<WorkflowDto> getTasksEnded(@RequestParam(name="definitionId", required=false) String var1, @RequestParam(name="assignee", required=false) String var2);

    @GetMapping(value={"/tasks/ended/page"})
    public LayPage<WorkflowDto> pageTasksEnded(@RequestBody LayPageable var1, @RequestParam(name="definitionId", required=false) String var2, @RequestParam(name="assignee", required=false) String var3);

    @GetMapping(value={"/process/start"})
    public List<WorkflowDto> getAssigneeStartProcesses(@RequestParam(name="definitionId", required=false) String var1, @RequestParam(name="assignee") String var2);

    @GetMapping(value={"/process/start/page"})
    public LayPage<WorkflowDto> pageAssigneeStartProcesses(LayPageable var1, @RequestParam(name="definitionId", required=false) String var2, @RequestParam(name="assignee") String var3);

    @GetMapping(value={"/diagram/{instanceId}"})
    public void processDiagram(@PathVariable(name="instanceId") String var1) throws IOException;
}

