/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ias.cim.clients;

import cn.gtmap.ias.cim.domain.dto.AppCaseDto;
import cn.gtmap.ias.cim.domain.dto.ShortcutConfigDto;
import cn.gtmap.ias.cim.exception.GtmapDBException;
import cn.gtmap.ias.geo.twin.domain.dto.ResourceDto;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="${app.feign-client.cim.name}")
@RequestMapping(value={"${app.feign-client.cim.context-path}/rest/shortcut"})
public interface ShortcutClient {
    @GetMapping(value={"/all/app/case"})
    public List<AppCaseDto> getAllApps();

    @GetMapping(value={"/all/app/service"})
    public List<ResourceDto> getAllService();

    @GetMapping(value={"/all"})
    public List<ShortcutConfigDto> getAllShortcutConfigDto();

    @GetMapping(value={"/public/all/config"})
    public List<ShortcutConfigDto> getAllShortcutConfigByTypeAndUsed() throws GtmapDBException;

    @GetMapping(value={"/all/{type}"})
    public List<ShortcutConfigDto> getAllShortcutConfigByType(@PathVariable(name="type") String var1);

    @PatchMapping(value={"/update/app/{type}"})
    public ShortcutConfigDto updateAppCaseShortcutConfig(@PathVariable(name="type") String var1, @RequestParam(name="sort") String var2, @RequestParam(name="appId") String var3);

    @PatchMapping(value={"/update/icon/{type}"})
    public ShortcutConfigDto updateIconShortcutConfig(@PathVariable(name="type") String var1, @RequestParam(name="sort") String var2, @RequestParam(name="iconId") String var3);

    @PatchMapping(value={"/update/used/{type}"})
    public ShortcutConfigDto updateUsedShortcutConfig(@PathVariable(name="type") String var1, @RequestParam(name="sort") String var2, @RequestParam(name="used") String var3);
}

