/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ias.cim.clients;

import cn.gtmap.ias.basic.domain.dto.UserDto;
import cn.gtmap.ias.cim.domain.dto.AppCountDto;
import cn.gtmap.ias.cim.domain.dto.PageDataDto;
import cn.gtmap.ias.cim.domain.dto.page.LayPage;
import cn.gtmap.ias.cim.domain.dto.page.LayPageable;
import cn.gtmap.ias.cim.exception.GtmapDBException;
import cn.gtmap.ias.geo.twin.bean.ResourceAccessBean;
import cn.gtmap.ias.geo.twin.bean.ResourceBean;
import cn.gtmap.ias.geo.twin.domain.dto.ResourceAccessDto;
import cn.gtmap.ias.geo.twin.domain.dto.ResourceApplyDto;
import cn.gtmap.ias.geo.twin.domain.dto.ResourceDto;
import cn.gtmap.ias.geo.twin.domain.dto.ResourceQueryDto;
import cn.gtmap.ias.geo.twin.domain.dto.ServiceAuthorityDto;
import cn.gtmap.ias.geo.twin.domain.dto.ThemeDto;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@FeignClient(value="${app.feign-client.cim.name}")
@RequestMapping(value={"${app.feign-client.cim.context-path}/rest/resource"})
public interface ResourceDataClient {
    @GetMapping(value={"/themeGrid"})
    public String getThemeGrid(@RequestParam(name="page") String var1, @RequestParam(name="rows") String var2);

    @GetMapping(value={"/theme/page"})
    public LayPage<ThemeDto> themePage(LayPageable var1);

    @GetMapping(value={"/judge/repeat/theme/{themeName}"})
    public int judgeRepeatTheme(@PathVariable(name="themeName") String var1);

    @GetMapping(value={"/public/type/{typeStyle}"})
    public Object getTypeByStyle(@PathVariable(name="typeStyle") String var1);

    @GetMapping(value={"/public/themeList"})
    public Object getThemeForSelect();

    @PostMapping(value={"/resource"})
    public Object saveResource(ResourceDto var1, @RequestParam(value="file") MultipartFile var2);

    @GetMapping(value={"/public/allType"})
    public Object getAllTypes();

    @GetMapping(value={"/public/resources"})
    public PageDataDto getResourceListForPage(ResourceQueryDto var1);

    @GetMapping(value={"/authen/resources"})
    public PageDataDto getAuthenResourceListForPage(ResourceQueryDto var1);

    @GetMapping(value={"/all/resources/page"})
    public PageDataDto getAllResourcePage(ResourceQueryDto var1);

    @GetMapping(value={"/all/publish/resources/mine/page"})
    public PageDataDto getAllMyResourcePage(ResourceQueryDto var1);

    @GetMapping(value={"/all/apply/resources/page"})
    public PageDataDto getAllApplyResourcePage(ResourceQueryDto var1);

    @GetMapping(value={"/all/apply/resources/mine/page"})
    public PageDataDto getAllMyApplyResourcePage(ResourceQueryDto var1);

    @GetMapping(value={"/new/examine/page"})
    public PageDataDto newExaminePage(ResourceQueryDto var1);

    @GetMapping(value={"/examine/page"})
    public LayPage<ResourceApplyDto> getresourceApplyGrid(LayPageable var1);

    @PatchMapping(value={"/examine/{status}"})
    public Object updateResourceApplyStatus(@PathVariable(name="status") String var1, @RequestBody List<String> var2);

    @GetMapping(value={"/resource/{username}/{status}"})
    public LayPage<ResourceApplyDto> findResourceApplyForPage(LayPageable var1, @PathVariable(name="username") String var2, @PathVariable(name="status") String var3);

    @GetMapping(value={"/apply/resource"})
    public LayPage<ResourceApplyDto> findApplyForPage(LayPageable var1, @RequestParam(name="username") String var2, @RequestParam(name="instanceType") String var3, @RequestParam(name="typeId") String var4);

    @GetMapping(value={"/resource/all/{username}"})
    public LayPage<ResourceDto> findResourceForPage(LayPageable var1, @PathVariable(name="username") String var2);

    @GetMapping(value={"/resource/all"})
    public LayPage<ResourceDto> findResourceListForPage(LayPageable var1, @RequestParam(name="username") String var2, @RequestParam(name="instanceType") String var3, @RequestParam(name="typeId") String var4);

    @GetMapping(value={"/all/resource"})
    public LayPage<ResourceDto> allResource(LayPageable var1, @RequestParam(name="instanceType") String var2, @RequestParam(name="typeId") String var3);

    @PostMapping(value={"/theme"})
    public Object addTheme(@RequestBody ThemeDto var1);

    @PatchMapping(value={"/theme/{themeId}/{status}"})
    public Object updateThemeStatus(@PathVariable(name="themeId") String var1, @PathVariable(name="status") String var2);

    @PostMapping(value={"/apply"})
    public Object addResourceApply(@RequestParam(name="resourceId") String var1, @RequestParam(name="applyExplain") String var2);

    @GetMapping(value={"/applied/{username}"})
    public List<ResourceAccessBean> getAppliedCount(@PathVariable(name="username") String var1);

    @GetMapping(value={"/type/applied"})
    public List<ResourceAccessBean> getAppliedCountByResourceType(@RequestParam(name="username") String var1, @RequestParam(name="resourcetype") String var2);

    @GetMapping(value={"/count/{username}"})
    public List<ResourceBean> getResourceByName(@PathVariable(name="username") String var1);

    @GetMapping(value={"/all/resource/count"})
    public List<ResourceBean> getAllResourceCount();

    @GetMapping(value={"/visit/download/count"})
    public List<ResourceAccessBean> allVisitAndDownloadCount();

    @GetMapping(value={"/visit/download/count/date"})
    public List<ResourceAccessBean> getAllVisitAndDownloadCountByTime(@RequestParam(name="start") String var1, @RequestParam(name="end") String var2);

    @GetMapping(value={"/type/visit/download/count"})
    public List<ResourceAccessBean> visitAndDownloadCountByType(@RequestParam(name="resourceType") String var1);

    @GetMapping(value={"/down/visit/{username}"})
    public List<ResourceAccessBean> getVisitAndDownloadCountByUser(@PathVariable(name="username") String var1);

    @GetMapping(value={"/type/down/visit"})
    public List<ResourceAccessBean> getVisitAndDownloadCountByUserAndType(@RequestParam(name="username") String var1, @RequestParam(name="resourceType") String var2);

    @PostMapping(value={"/get/name"})
    public List<Map> getResourceAccessCountByDate(@RequestBody String[] var1);

    @GetMapping(value={"/resCount"})
    public Object getResCount();

    @GetMapping(value={"/resCountByUrl"})
    public int getResCountByUrl(@RequestParam(name="resUrl") String var1);

    @DeleteMapping(value={"/theme/delete/{id}"})
    public void deleteTheme(@PathVariable(name="id") String var1);

    @PutMapping(value={"/delete/{id}"})
    public void delete(@PathVariable(name="id") String var1);

    @PatchMapping(value={"/disabled"})
    public void updateResourceStatus(@RequestBody List<String> var1);

    @DeleteMapping
    public void delete(@RequestBody List<String> var1);

    @PutMapping(value={"/update/supermap/rest/{id}"})
    public ResourceDto updateSupermapRest(@PathVariable(name="id") String var1, @RequestBody ResourceDto var2);

    @GetMapping(value={"/resource/id/name"})
    public List<ResourceBean> resourceIdAndName();

    @GetMapping(value={"/type/resource/id/name/{type}"})
    public List<ResourceBean> resourceIdAndNameByResourceType(@PathVariable(name="type") String var1);

    @GetMapping(value={"/model/resource/id/name/{modelId}"})
    public List<ResourceBean> resourceIdAndNameByModelId(@PathVariable(name="modelId") String var1);

    @GetMapping(value={"/personal/resource/id/name/{username}"})
    public List<ResourceBean> resourceIdAndNameByUserName(@PathVariable(name="username") String var1);

    @GetMapping(value={"/personal/type/resource/id/name"})
    public List<ResourceBean> resourceIdAndNameByUserNameAndResourceType(@RequestParam(name="username") String var1, @RequestParam(name="resourceType") String var2);

    @GetMapping(value={"/personal/model/resource/id/name"})
    public List<ResourceBean> resourceIdAndNameByUserNameAndModelId(@RequestParam(name="username") String var1, @RequestParam(name="modelId") String var2);

    @GetMapping(value={"/resources/page"})
    public LayPage<ResourceAccessDto> getResourcesPage(@RequestParam(name="username") String var1, @RequestParam(name="type") String var2, @RequestParam(name="model") String var3, @RequestParam(name="resourceId") String var4, LayPageable var5);

    @GetMapping(value={"/access/count/date"})
    public List<ResourceAccessBean> getAllAccessCountByDate(@RequestParam(name="startDate") Date var1, @RequestParam(name="endDate") Date var2);

    @GetMapping(value={"/access/count/date/resourceType"})
    public List<ResourceAccessBean> getResourceAccessCountByTypeAndDate(@RequestParam(name="resourceType") String var1, @RequestParam(name="startDate") Date var2, @RequestParam(name="endDate") Date var3);

    @GetMapping(value={"/access/count/date/modelId"})
    public List<ResourceAccessBean> getResourceAccessCountByModelAndDate(@RequestParam(name="modelId") String var1, @RequestParam(name="startDate") Date var2, @RequestParam(name="endDate") Date var3);

    @GetMapping(value={"/date/access/count/resourceId"})
    public List<ResourceAccessBean> getResourceAccessCountByResourceIdAndDate(@RequestParam(name="resourceId") String var1, @RequestParam(name="startDate") Date var2, @RequestParam(name="endDate") Date var3);

    @GetMapping(value={"/type/and/model/{resourceId}"})
    public List<ResourceBean> getResourceTypeAndModelId(@PathVariable(value="resourceId") String var1);

    @GetMapping(value={"/resource/access/apply"})
    public LayPage<ResourceAccessBean> resourceAccessAndApply(@RequestParam(name="username", required=false) String var1, @RequestParam(name="resourceId", required=false) String var2, @RequestParam(name="modelId", required=false) String var3, @RequestParam(name="resourceType", required=false) String var4, LayPageable var5);

    @GetMapping(value={"/public/service"})
    public LayPage<ResourceDto> queryServices(@RequestParam(name="limit", required=true) int var1, @RequestParam(name="offset", required=true) int var2, @RequestParam(name="keyWord", required=false) String var3) throws GtmapDBException;

    @PostMapping(value={"/public/useAble"})
    public Integer useAble(@RequestBody UserDto var1, @RequestParam(name="id") String var2) throws GtmapDBException;

    @PostMapping(value={"/public/useAble1"})
    public Integer useAble1(@RequestParam(name="userName") String var1, @RequestBody UserDto var2) throws GtmapDBException;

    @GetMapping(value={"/authority/page"})
    public LayPage<ResourceDto> authorityPage(LayPageable var1, @RequestParam(name="orgId", required=false) String var2, @RequestParam(name="keyword", required=false) String var3) throws GtmapDBException;

    @PostMapping(value={"/authority/updateLevel"})
    public int updateLevel(@RequestParam(name="resourceId", required=true) String var1, @RequestParam(name="level", required=true) int var2);

    @PostMapping(value={"/authority/department/updateLevel"})
    public ServiceAuthorityDto updateDeparmentLevel(@RequestParam(name="resourceId", required=true) String var1, @RequestParam(name="orgId", required=true) String var2, @RequestParam(name="level", required=true) int var3);

    @PutMapping(value={"/authority/open"})
    public int open(@RequestParam(name="resourceId", required=true) String var1, @RequestParam(name="open", required=true) int var2);

    @GetMapping(value={"/department/page"})
    public LayPage<Map> departmentPage(LayPageable var1, @RequestParam(name="resourceId", required=true) String var2, @RequestParam(name="orgId", required=false) String var3);

    @GetMapping(value={"/queryTest/{user}"})
    public List<Map> queryTest(@PathVariable(name="user", required=true) String var1);

    @GetMapping(value={"/public/count"})
    public AppCountDto getResourceCout();

    @GetMapping(value={"/public/resource"})
    public Map getPreviewResource(@RequestParam String var1);

    @GetMapping(value={"/{id}"})
    public Map getResourceById(@PathVariable(value="id") String var1);

    @PostMapping(value={"/apply/batch"})
    public Object addBatchResourceApply(@RequestParam(name="resourceIds") String var1, @RequestParam(name="applyExplain") String var2);

    @GetMapping(value={"/apply/findByApplyId"})
    public ResourceApplyDto findApplyByApplyId(@RequestParam(name="id") String var1);
}

