/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ias.cim.clients;

import cn.gtmap.ias.basic.domain.dto.UserDto;
import cn.gtmap.ias.basic.domain.dto.page.LayPage;
import cn.gtmap.ias.basic.domain.dto.page.LayPageable;
import cn.gtmap.ias.cim.domain.dto.DataHomePage;
import cn.gtmap.ias.cim.domain.dto.DataSetAuthorityDto;
import cn.gtmap.ias.cim.domain.dto.DataStatistic;
import cn.gtmap.ias.cim.domain.dto.DownloadRecordDto;
import cn.gtmap.ias.cim.domain.dto.TableAbstract;
import cn.gtmap.ias.cim.domain.dto.Tables;
import cn.gtmap.ias.cim.domain.dto.TitleAndFiled;
import cn.gtmap.ias.cim.exception.GtmapDBException;
import cn.gtmap.ias.datagovern.domain.dto.DataMenu;
import com.alibaba.fastjson.JSONObject;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="${app.feign-client.cim.name}")
@RequestMapping(value={"${app.feign-client.cim.context-path}/data-center/rest/data"})
public interface DataServerClient {
    @GetMapping(value={"/tables"})
    public LayPage<TableAbstract> queryTables(@RequestParam(name="theme", required=false) String var1, @RequestParam(name="limit", required=true) int var2, @RequestParam(name="offset", required=true) int var3, @RequestParam(name="keyWord", required=false) String var4, @RequestParam(name="orgId", required=false) String var5, @RequestParam(name="startTime", required=false) String var6, @RequestParam(name="endTime", required=false) String var7, @RequestParam(name="order", required=false) String var8) throws GtmapDBException, GtmapDBException;

    @GetMapping(value={"/tableItems"})
    public LayPage<Map> queryTableItems(LayPageable var1, @RequestParam(name="tableName", required=true) String var2) throws GtmapDBException;

    @PostMapping(value={"/tableItemsByField"})
    public LayPage<Map> tableItemsByField(@RequestBody Map<String, String> var1) throws GtmapDBException;

    @GetMapping(value={"/disPlayFileds"})
    public List<TitleAndFiled> disPlayFileds(@RequestParam(name="tableName", required=true) String var1) throws GtmapDBException;

    @GetMapping(value={"/attachMenu"})
    public String attachMenu();

    @GetMapping(value={"/statistics"})
    public List<DataMenu> statistics(@RequestParam(name="simple", required=false) String var1, @RequestParam(name="type", required=false) int var2) throws GtmapDBException;

    @GetMapping(value={"/subjectStatistic"})
    public List<DataMenu> subjectStatistic(@RequestParam(name="theme") String var1) throws GtmapDBException;

    @GetMapping(value={"/departmentStatistic"})
    public List<DataMenu> departmentStatistic(@RequestParam(name="orgId") String var1) throws GtmapDBException;

    @GetMapping(value={"/departments"})
    public List<DataMenu> departments(@RequestParam(name="simple", required=false) String var1) throws GtmapDBException;

    @GetMapping(value={"/tableItemsByDepartment"})
    public LayPage<Map> queryTableByDepartment(LayPageable var1, @RequestParam(name="department", required=true) String var2) throws GtmapDBException;

    @GetMapping(value={"/excel"})
    public void excel(@RequestParam(name="tableName", required=true) String var1) throws Exception;

    @GetMapping(value={"/dataDirectory"})
    public List<Map> dataDirectory(LayPageable var1) throws GtmapDBException;

    @PostMapping(value={"/downloadRecord"})
    public DownloadRecordDto downloadRecord(@RequestParam(name="tableName", required=true) String var1);

    @PostMapping(value={"/authority/all"})
    public String authorityAll(@RequestParam(name="dataSet", required=true) String var1, @RequestParam(name="level") int var2);

    @GetMapping(value={"/authority/page"})
    public LayPage<Map> page(LayPageable var1, @RequestParam(name="orgId", required=false) String var2, @RequestParam(name="keyword", required=false) String var3) throws GtmapDBException;

    @PostMapping(value={"/authority/updateLevel"})
    public int updateLevel(@RequestParam(name="tableName", required=true) String var1, @RequestParam(name="level", required=true) int var2) throws SQLException, GtmapDBException;

    @PostMapping(value={"/authority/department/updateLevel"})
    public DataSetAuthorityDto updateDeparmentLevel(@RequestParam(name="tableName", required=true) String var1, @RequestParam(name="orgId", required=true) String var2, @RequestParam(name="level", required=true) int var3) throws SQLException, GtmapDBException;

    @GetMapping(value={"/public/downloadAble"})
    public int downloadAble(@RequestParam(name="userName") String var1, @RequestParam(name="tableName") String var2);

    @PutMapping(value={"/authority/open"})
    public int open(@RequestParam(name="tableName", required=true) String var1, @RequestParam(name="open", required=true) int var2) throws GtmapDBException, SQLException;

    @GetMapping(value={"/public/tableCount"})
    public long queryTableCount(@RequestParam(name="keyword") String var1) throws GtmapDBException;

    @GetMapping(value={"/public/statistic"})
    public DataStatistic statistic() throws GtmapDBException;

    @GetMapping(value={"/public/dataHomePage"})
    public DataHomePage DataHomePage() throws GtmapDBException;

    @GetMapping(value={"/public/data"})
    public Tables queryTableList(@RequestParam(name="theme", required=false) String var1, @RequestParam(name="limit", required=true) int var2, @RequestParam(name="offset", required=true) int var3, @RequestParam(name="keyWord", required=false) String var4, @RequestParam(name="department", required=false) String var5, @RequestParam(name="startTime", required=false) String var6, @RequestParam(name="endTime", required=false) String var7, @RequestParam(name="order", required=false) String var8) throws GtmapDBException;

    @GetMapping(value={"/public/query"})
    public Tables queryTableList(@RequestParam(name="sql", required=true) String var1) throws GtmapDBException;

    @GetMapping(value={"/public/statistics/distribution"})
    public LayPage<DataMenu> statisticsVisual(@RequestParam(name="simple", required=false) String var1, @RequestParam(name="type", required=false) int var2) throws GtmapDBException;

    @GetMapping(value={"/public/department/count"})
    public LayPage<DataStatistic> getDepartmentCount() throws GtmapDBException;

    @GetMapping(value={"/getUserByTableName"})
    public LayPage<UserDto> getUserByOrgId(@RequestParam(value="tableName") String var1);

    @GetMapping(value={"/public/getUserByTableName"})
    public LayPage<UserDto> getUserByTableName(@RequestParam(value="tableName") String var1);

    @GetMapping(value={"/public/dataSynchronization"})
    public boolean dataSynchronization();

    @PostMapping(value={"/point"})
    public boolean savePoint(@RequestBody Map<String, String> var1);

    @GetMapping(value={"/all/tables"})
    public List<Map> getAllTables();

    @GetMapping(value={"/synchronization/coordinate"})
    public JSONObject synchronizationCoordinate(@RequestParam(value="tables") String var1);

    @GetMapping(value={"/public/register/data"})
    public List<Map> getRegisterData();

    @GetMapping(value={"/public/index/data"})
    public List<Map> getIndexData();
}

