/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.helium.client.web;

import cn.gtmap.helium.client.config.PropertiesHeliumConfig;
import cn.gtmap.helium.client.core.HeliumBean;
import cn.gtmap.helium.client.core.HeliumConfig;
import cn.gtmap.helium.client.core.HeliumConfigContext;
import cn.gtmap.helium.client.exception.HeliumConfigException;
import cn.gtmap.helium.client.util.ObjectMapperUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Constructor;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

public class HeliumConfigContextListener
implements ServletContextListener {
    private static final String DEFAULT_HELIUM_CONFIG_LOCATION = "classpath:helium.json";
    public static final String HELIUM_CONFIG_IMPLEMENTATION = "helium.config.implementation";
    public static final String HELIUM_CONFIG_LOCATION = "helium.config.location";
    private static final Logger logger = LoggerFactory.getLogger(HeliumConfigContextListener.class);
    private HeliumConfig heliumConfig;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext sc = servletContextEvent.getServletContext();
        String configClass = sc.getInitParameter(HELIUM_CONFIG_IMPLEMENTATION);
        this.heliumConfig = this.createHeliumConfig(configClass, this.createHeliumBean(sc));
        logger.debug("\u521d\u59cb\u5316heliumConfig...");
        this.heliumConfig.init();
        HeliumConfigContext.setHeliumConfig(this.heliumConfig);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        if (this.heliumConfig != null) {
            logger.debug("\u9500\u6bc1 heliumConfig...");
            this.heliumConfig.destroy();
        }
    }

    private HeliumBean createHeliumBean(ServletContext sc) {
        String location = sc.getInitParameter(HELIUM_CONFIG_LOCATION);
        if (location == null || location.isEmpty()) {
            location = DEFAULT_HELIUM_CONFIG_LOCATION;
        }
        File file = null;
        try {
            file = ResourceUtils.getFile((String)location);
            return ObjectMapperUtils.readValue(file, HeliumBean.class);
        }
        catch (FileNotFoundException e) {
            throw new HeliumConfigException("\u672a\u627e\u5230\u6587\u4ef6 [" + location + "]", e);
        }
    }

    private HeliumConfig createHeliumConfig(String className, HeliumBean heliumBean) {
        try {
            Class<PropertiesHeliumConfig> clazz = className == null || className.isEmpty() ? PropertiesHeliumConfig.class : Class.forName(className);
            Constructor constructor = clazz.getConstructor(HeliumBean.class);
            return (HeliumConfig)constructor.newInstance(heliumBean);
        }
        catch (Exception e) {
            throw new HeliumConfigException(e);
        }
    }
}

