/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.helium.client.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

public final class EgovConfigHelper {
    public static final Logger logger = LoggerFactory.getLogger(EgovConfigHelper.class);
    public static final String EGOV_HOME_FOLDER = "egov-home";
    public static final String DEFAULT_ACTIVE_CONF = "default";
    public static final String PROPERTY_FILE_NAME = "egov.properties";

    public static File getEgovConfHome(String ... paths) {
        block11: {
            File root = EgovConfigHelper.determineRootDir(paths);
            if (root != null) {
                logger.info("Use egov-home dir:[" + root + "]");
                File activeFile = new File(root, "active.conf");
                String active = DEFAULT_ACTIVE_CONF;
                try {
                    active = FileUtils.readFileToString((File)activeFile);
                }
                catch (IOException e) {
                    logger.info("Read active profile from [" + activeFile.getAbsolutePath() + "] fail,use default");
                }
                File home = new File(root, active);
                if (!home.exists() && !(home = new File(root, DEFAULT_ACTIVE_CONF)).exists()) {
                    logger.error("Egov active conf [" + home.getAbsolutePath() + "] not exsit");
                }
                logger.info("Use Custom config home dir:[" + home + "]");
            } else {
                File home = new File("/opt/gtis/config/egov/default");
                if (home.exists()) {
                    logger.warn("Use compact config home dir:[" + home.getAbsolutePath() + "],please convert to new format");
                    return home;
                }
                URL url = null;
                try {
                    url = ResourceUtils.getURL((String)"/META-INF/conf/egov.properties");
                    if (url != null) {
                        try {
                            home = new File(url.toURI()).getParentFile().getParentFile();
                            logger.info("Custom config home not found,Use classpath config home dir [" + home.getAbsolutePath() + "]");
                            break block11;
                        }
                        catch (URISyntaxException ignored) {
                            return null;
                        }
                    }
                    logger.error("Load config error,config not found");
                    return null;
                }
                catch (FileNotFoundException e) {
                    logger.error("Load config error,config not found");
                    return null;
                }
            }
        }
        return null;
    }

    public static File determineRootDir(String ... paths) {
        File root;
        if (paths != null) {
            for (String path : paths) {
                root = new File(path);
                if (!root.exists()) continue;
                return root;
            }
        }
        for (String path : new String[]{System.getProperty("EGOV_HOME"), System.getenv("EGOV_HOME")}) {
            if (path == null || !(root = new File(path)).exists()) continue;
            return root;
        }
        for (String path : new String[]{System.getProperty("catalina.base"), System.getProperty("catalina.home"), System.getProperty("user.home")}) {
            if (path == null || !(root = new File(path, EGOV_HOME_FOLDER)).exists()) continue;
            return root;
        }
        return null;
    }
}

