/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.helium.client.core;

import cn.gtmap.helium.client.converter.BooleanValueConverter;
import cn.gtmap.helium.client.converter.DoubleValueConverter;
import cn.gtmap.helium.client.converter.FloatValueConverter;
import cn.gtmap.helium.client.converter.IntValueConverter;
import cn.gtmap.helium.client.converter.LongValueConverter;
import cn.gtmap.helium.client.core.ConfigProvider;
import cn.gtmap.helium.client.exception.ConfigNotFoundException;
import cn.gtmap.helium.client.exception.WrongAppConfigException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.Properties;
import org.springframework.util.PropertyPlaceholderHelper;

public class DefaultConfigProvider
implements ConfigProvider {
    private static final BooleanValueConverter BOOLEAN_VALUE_CONVERTER = new BooleanValueConverter();
    private static final IntValueConverter INT_VALUE_CONVERTER = new IntValueConverter();
    private static final LongValueConverter LONG_VALUE_CONVERTER = new LongValueConverter();
    private static final FloatValueConverter FLOAT_VALUE_CONVERTER = new FloatValueConverter();
    private static final DoubleValueConverter DOUBLE_VALUE_CONVERTER = new DoubleValueConverter();
    private final Properties properties;

    public DefaultConfigProvider(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties \u4e0d\u80fd\u4e3anull");
        }
        PropertyPlaceholderHelper placeholderHelper = new PropertyPlaceholderHelper("${", "}", ":", true);
        Properties replacedProperties = new Properties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            replacedProperties.setProperty(key, placeholderHelper.replacePlaceholders(value, properties));
        }
        this.properties = replacedProperties;
    }

    @Override
    public boolean containsKey(String key) {
        return this.getProperties().containsKey(key);
    }

    @Override
    public boolean getBoolean(String key) throws ConfigNotFoundException, WrongAppConfigException {
        return (Boolean)BOOLEAN_VALUE_CONVERTER.convert(key, this.getRequiredProperty(key));
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        return BOOLEAN_VALUE_CONVERTER.convert(key, this.getProperty(key), defaultValue);
    }

    @Override
    public int getInt(String key) throws ConfigNotFoundException, WrongAppConfigException {
        return (Integer)INT_VALUE_CONVERTER.convert(key, this.getRequiredProperty(key));
    }

    @Override
    public int getInt(String key, int defaultValue) {
        return INT_VALUE_CONVERTER.convert(key, this.getProperty(key), defaultValue);
    }

    @Override
    public long getLong(String key) throws ConfigNotFoundException, WrongAppConfigException {
        return (Long)LONG_VALUE_CONVERTER.convert(key, this.getRequiredProperty(key));
    }

    @Override
    public long getLong(String key, long defaultValue) {
        return LONG_VALUE_CONVERTER.convert(key, this.getProperty(key), defaultValue);
    }

    @Override
    public float getFloat(String key) throws ConfigNotFoundException, WrongAppConfigException {
        return ((Float)FLOAT_VALUE_CONVERTER.convert(key, this.getRequiredProperty(key))).floatValue();
    }

    @Override
    public float getFloat(String key, float defaultValue) {
        return FLOAT_VALUE_CONVERTER.convert(key, this.getProperty(key), Float.valueOf(defaultValue)).floatValue();
    }

    @Override
    public double getDouble(String key) throws ConfigNotFoundException, WrongAppConfigException {
        return (Double)DOUBLE_VALUE_CONVERTER.convert(key, this.getRequiredProperty(key));
    }

    @Override
    public double getDouble(String key, double defaultValue) {
        return DOUBLE_VALUE_CONVERTER.convert(key, this.getProperty(key), defaultValue);
    }

    @Override
    public String getString(String key) {
        return this.getString(key, null);
    }

    @Override
    public String getString(String key, String defaultValue) {
        String v = this.getProperty(key);
        if (v == null) {
            v = defaultValue;
        }
        return v;
    }

    @Override
    public BigDecimal getBigDecimal(String key) throws WrongAppConfigException {
        return this.getBigDecimal(key, null);
    }

    @Override
    public BigDecimal getBigDecimal(String key, String defaultValue) {
        try {
            String value = this.getString(key, defaultValue);
            if (value == null) {
                return null;
            }
            return new BigDecimal(value);
        }
        catch (Exception e) {
            throw new WrongAppConfigException(key, defaultValue, e);
        }
    }

    @Override
    public BigInteger getBigInteger(String key) throws WrongAppConfigException {
        return this.getBigInteger(key, null);
    }

    @Override
    public BigInteger getBigInteger(String key, String defaultValue) {
        try {
            String value = this.getString(key, defaultValue);
            if (value == null) {
                return null;
            }
            return new BigInteger(value);
        }
        catch (Exception e) {
            throw new WrongAppConfigException(key, defaultValue, e);
        }
    }

    @Override
    public Properties getProperties() {
        if (this.properties == null) {
            return new Properties();
        }
        return new Properties(this.properties);
    }

    protected String getRequiredProperty(String key) throws ConfigNotFoundException {
        String v = this.getProperty(key);
        if (v == null) {
            throw new ConfigNotFoundException(key);
        }
        return this.properties.getProperty(key);
    }

    protected String getProperty(String key) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("\u5c5e\u6027\u540d\u79f0 [propertyName] \u4e0d\u80fd\u4e3a null \u6216\u8005\u7a7a\u5b57\u7b26");
        }
        String v = this.getProperties().getProperty(key);
        if (v == null) {
            return v;
        }
        return this.properties.getProperty(key);
    }
}

