/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.resource.utils;

import cn.gtmap.gtc.resource.domain.resource.metadata.Dict;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;

public class Utils {
    private static final Map<String, String> wellKnownSimplePrefixes = new HashMap<String, String>(4);
    private static final Map<String, String> wellKnownSimpleRegexs = new HashMap<String, String>(4);
    static final Logger logger = LoggerFactory.getLogger((String)Utils.class.getName());
    static String regExOfchinese = "[\\u4e00-\\u9fa5]";
    static Pattern pattern = Pattern.compile(regExOfchinese);

    private Utils() {
    }

    public static double doubleRound(Double value, int precision) {
        switch (precision) {
            case 1: {
                return (double)Math.round(value * 100.0) / 100.0;
            }
            case 2: {
                return (double)Math.round(value * 100.0) / 100.0;
            }
            case 3: {
                return (double)Math.round(value * 100.0) / 100.0;
            }
        }
        return (double)Math.round(value * 100.0) / 100.0;
    }

    public static double round(double v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b = new BigDecimal(Double.toString(v));
        BigDecimal one = new BigDecimal("1");
        return b.divide(one, scale, 4).doubleValue();
    }

    public static String replaceHolder(String data, Map<String, Object> params) {
        String result = data;
        String[] values = data.split("\\$\\{+|\\}");
        for (int i = 0; i < values.length; ++i) {
            if (!params.containsKey(values[i])) continue;
            result = result.replaceAll("\\$\\{" + values[i] + "\\}", String.valueOf(params.get(values[i])));
        }
        return result;
    }

    public static String replaceHolder(String data, Object ... params) {
        String result = data;
        String[] values = data.split("\\$\\{+|\\}");
        for (int i = 0; i < values.length; ++i) {
            if (params[i] == null) continue;
            result = result.replaceAll("\\$\\{" + values[i] + "\\}", String.valueOf(params[i]));
        }
        return result;
    }

    public static String replaceHolder(String placeholderPrefix, String placeholderSuffix, String data, Map<String, Object> params) {
        String result = data;
        String simplePrefixForSuffix = wellKnownSimplePrefixes.get(placeholderSuffix);
        if (simplePrefixForSuffix != null && placeholderPrefix.endsWith(simplePrefixForSuffix)) {
            placeholderPrefix = simplePrefixForSuffix;
        }
        String[] values = data.split(wellKnownSimpleRegexs.get(placeholderPrefix) == null ? "\\$\\{+|\\}" : wellKnownSimpleRegexs.get(placeholderPrefix));
        for (int i = 0; i < values.length; ++i) {
            if (!params.containsKey(values[i])) continue;
            result = result.replaceAll("\\{" + values[i] + "\\}", String.valueOf(params.get(values[i])));
        }
        return result;
    }

    public static String urlReplaceHolder(String data, Map<String, Object> params) throws Exception {
        String result = data;
        String[] values = data.split("\\$\\{+|\\}");
        for (int i = 0; i < values.length; ++i) {
            if (!params.containsKey(values[i])) continue;
            result = result.replaceAll("\\$\\{" + values[i] + "\\}", URLEncoder.encode(MapUtils.getString(params, (Object)values[i]), "utf-8"));
        }
        return result;
    }

    public static Map updateMap(Object key, Object value, Map map) {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        result.put(key, value);
        if (map != null && !map.isEmpty()) {
            result.putAll(map);
        }
        return result;
    }

    public static boolean isContainChinese(String value) {
        Matcher matcher = pattern.matcher(value);
        boolean flg = false;
        if (matcher.find()) {
            flg = true;
        }
        return flg;
    }

    public static Object copyPropertyForSave(Object orig, Object dest) throws Exception {
        Field[] fieldArr = orig.getClass().getDeclaredFields();
        for (int i = 0; i < fieldArr.length; ++i) {
            Method method;
            Object value;
            Field field = fieldArr[i];
            String type = fieldArr[i].getGenericType().toString();
            String fieldName = field.getName();
            String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            String setMethodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            if (type.equals("class java.lang.String") && StringUtils.isNotBlank((String)(value = (String)(method = orig.getClass().getMethod(getMethodName, new Class[0])).invoke(orig, new Object[0])))) {
                method = dest.getClass().getMethod(setMethodName, String.class);
                method.invoke(dest, value);
            }
            if (!type.equals("class java.math.BigDecimal") || (value = (BigDecimal)(method = orig.getClass().getMethod(getMethodName, new Class[0])).invoke(orig, new Object[0])) == null) continue;
            method = dest.getClass().getMethod(setMethodName, BigDecimal.class);
            method.invoke(dest, value);
        }
        return dest;
    }

    public static String urlEncode(String url) {
        try {
            return URLEncoder.encode(url, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.toString());
            return url;
        }
    }

    public static boolean isNull(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return StringUtils.isBlank((String)((String)value));
        }
        return false;
    }

    public static boolean isNotNull(Object value) {
        return !Utils.isNull(value);
    }

    public static String substr(String originString, String charsetName, int byteLen) throws UnsupportedEncodingException {
        if (originString == null || originString.isEmpty() || byteLen <= 0) {
            return "";
        }
        char[] chars = originString.toCharArray();
        int length = 0;
        int index = chars.length;
        for (int i = 0; i < chars.length; ++i) {
            int len = String.valueOf(chars[i]).getBytes(charsetName).length + length;
            if (len > byteLen) {
                index = i;
                break;
            }
            length = len;
        }
        return String.valueOf(chars, 0, index);
    }

    public static String mappingUrl(String mappingUrl, List<Dict> dictList) {
        ArrayList<String> urlList = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(dictList)) {
            for (Dict dict : dictList) {
                urlList.add(dict.getValue());
            }
        }
        return Utils.urlMapping(mappingUrl, urlList);
    }

    public static String urlMapping(String repUrl, List<String> urlList) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(urlList)) {
            for (String url : urlList) {
                String[] urlArr = url.split("-");
                if (repUrl.indexOf(urlArr[0]) < 0) continue;
                repUrl = repUrl.replaceAll(urlArr[0], urlArr[1]);
                break;
            }
        }
        return repUrl;
    }

    public static boolean judgeRegionLevel(Integer index, String regionCode) {
        boolean res = false;
        if (Integer.parseInt(regionCode.substring(index, regionCode.length())) == 0) {
            res = true;
        }
        return res;
    }

    public static Map resMap(boolean result, String msg) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("message", msg);
        map.put("result", result);
        return map;
    }

    public static boolean isIEBrowser(String agent) {
        String[] IEBrowserSignals;
        agent = agent.toLowerCase();
        for (String signal : IEBrowserSignals = new String[]{"nsie", "trident", "edge"}) {
            if (!agent.contains(signal)) continue;
            return true;
        }
        return false;
    }

    public static Map parseRes(boolean res, String msg) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("res", res);
        map.put("msg", msg);
        return map;
    }

    public static Pageable layuiPage(Pageable pageable) {
        int page = pageable.getPageNumber();
        if (page > 0) {
            pageable = new PageRequest(page - 1, pageable.getPageSize(), pageable.getSort());
        }
        return pageable;
    }

    static {
        wellKnownSimplePrefixes.put("}", "{");
        wellKnownSimplePrefixes.put("]", "[");
        wellKnownSimplePrefixes.put(")", "(");
        wellKnownSimpleRegexs.put("${", "\\$\\{+|\\}");
        wellKnownSimpleRegexs.put("{", "\\{+|\\}");
    }
}

