/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.resource.utils;

import cn.gtmap.gtc.resource.domain.resource.metadata.Nodelist;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;

public class TreeBuilder {
    List<Nodelist> nodes = new ArrayList<Nodelist>();

    public String buildTree(List<Nodelist> nodes) {
        TreeBuilder treeBuilder = new TreeBuilder(nodes);
        return treeBuilder.buildJSONTree();
    }

    public TreeBuilder() {
    }

    public TreeBuilder(List<Nodelist> nodes) {
        this.nodes = nodes;
    }

    public String buildJSONTree() {
        List<Nodelist> nodeTree = this.buildTree();
        return JSON.toJSONString(nodeTree);
    }

    public List<Nodelist> buildTree() {
        ArrayList<Nodelist> treeNodes = new ArrayList<Nodelist>();
        List<Nodelist> rootNodes = this.getRootNodes();
        for (Nodelist rootNode : rootNodes) {
            this.buildChildNodes(rootNode);
            treeNodes.add(rootNode);
        }
        return treeNodes;
    }

    public void buildChildNodes(Nodelist Nodelist2) {
        List<Nodelist> children = this.getChildNodes(Nodelist2);
        if (!children.isEmpty()) {
            for (Nodelist child : children) {
                this.buildChildNodes(child);
            }
            Nodelist2.setChildren(children);
        }
    }

    public List<Nodelist> getChildNodes(Nodelist pnode) {
        ArrayList<Nodelist> childNodes = new ArrayList<Nodelist>();
        for (Nodelist n : this.nodes) {
            if (!pnode.getId().equals(n.getPid())) continue;
            childNodes.add(n);
        }
        return childNodes;
    }

    public boolean rootNode(Nodelist Nodelist2) {
        boolean isRootNode = true;
        for (Nodelist n : this.nodes) {
            if (!n.getId().equals(Nodelist2.getPid())) continue;
            isRootNode = false;
            break;
        }
        return isRootNode;
    }

    public List<Nodelist> getRootNodes() {
        ArrayList<Nodelist> rootNodes = new ArrayList<Nodelist>();
        for (Nodelist n : this.nodes) {
            if (!this.rootNode(n)) continue;
            rootNodes.add(n);
        }
        return rootNodes;
    }
}

