/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.resource.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeUtil {
    private static final Logger logger = LoggerFactory.getLogger(TimeUtil.class);

    public static Date getDateBefore(Date d, int day) {
        Calendar now = Calendar.getInstance();
        now.setTime(d);
        now.set(5, now.get(5) - day);
        return now.getTime();
    }

    public static Date getMonday(Date d) {
        Calendar cld = Calendar.getInstance();
        cld.setTime(d);
        cld.set(7, 2);
        return cld.getTime();
    }

    public static Date getMonthFirstDay(Date d) {
        Calendar cld = Calendar.getInstance();
        cld.setTime(d);
        cld.set(5, 1);
        return cld.getTime();
    }

    public static Long getDateBefore(Date date, String timeType) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        long start = 0L;
        if ("day".equals(timeType)) {
            c.add(5, -6);
            start = c.getTimeInMillis();
        } else if ("week".equals(timeType)) {
            c.add(2, -1);
            start = c.getTimeInMillis();
        } else if ("month".equals(timeType)) {
            c.add(1, -1);
            start = c.getTimeInMillis();
        }
        return start;
    }

    public static Long getDateBeforePro(Date date, String timeType) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        long start = 0L;
        if ("day".equals(timeType)) {
            c.add(10, -24);
            start = c.getTimeInMillis();
        } else if ("week".equals(timeType)) {
            c.add(5, -6);
            start = c.getTimeInMillis();
        } else if ("month".equals(timeType)) {
            c.add(2, -1);
            start = c.getTimeInMillis();
        }
        return start;
    }

    public static String getDateBeforeStr(Date date, String timeType) {
        Calendar c = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        c.setTime(date);
        String start = "";
        if ("day".equals(timeType)) {
            c.add(10, -24);
            start = sdf.format(c.getTime());
        } else if ("week".equals(timeType)) {
            c.add(5, -6);
            start = sdf.format(c.getTime());
        } else if ("month".equals(timeType)) {
            c.add(2, -1);
            start = sdf.format(c.getTime());
        } else if ("year".equals(timeType)) {
            c.add(1, -1);
            start = sdf.format(c.getTime());
        }
        return start;
    }

    public static Date getAfterMonth(Date date, int count) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, count);
        return c.getTime();
    }

    public static Date getBegin(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        return new Date(sdf.format(date) + " 00:00:00");
    }

    public static Date getEnd(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        return new Date(sdf.format(date) + " 23:59:59");
    }

    public static Date getDateAfter(Date d, int day) {
        Calendar now = Calendar.getInstance();
        now.setTime(d);
        now.set(5, now.get(5) + day);
        return now.getTime();
    }

    private int isYeaterday(Date oldTime, Date newTime) throws ParseException {
        String todayStr;
        SimpleDateFormat format;
        Date today;
        if (newTime == null) {
            newTime = new Date();
        }
        if ((today = (format = new SimpleDateFormat("yyyy-MM-dd")).parse(todayStr = format.format(newTime))).getTime() - oldTime.getTime() > 0L && today.getTime() - oldTime.getTime() <= 86400000L) {
            return 0;
        }
        if (today.getTime() - oldTime.getTime() <= 0L) {
            return -1;
        }
        return 1;
    }

    private boolean isToday(Date time) {
        try {
            Date nowTime = new Date();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            String todayStr = format.format(nowTime);
            Date today = format.parse(todayStr);
            long starttime = today.getTime();
            long endtime = today.getTime() + 86400000L;
            if (starttime <= time.getTime() && time.getTime() <= endtime) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error("\u65e5\u671f\u8f6c\u6362\u9519\u8bef", (Throwable)e);
        }
        return false;
    }
}

