/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.resource.utils;

import cn.gtmap.gtc.resource.domain.resource.dto.es.DataResourceIdxDTO;
import cn.gtmap.gtc.resource.domain.resource.dto.es.ResourceStatusCheckDTO;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceLogUtil {
    private static final Logger logger = LoggerFactory.getLogger(ResourceLogUtil.class);
    public static final FastDateFormat SDF = FastDateFormat.getInstance((String)"yyyy-MM");
    public static final String ALL_INDEX = "data-resource-*";
    public static final String ALL_CHECK_INDEX = "resource-check-*";
    public static final String ALL_CHANGE_INDEX = "resource-change-*";
    public static final String SERVICE_CHANGE = "services-change-*";
    private static final String INDEX = "data-resource";

    public static String getNowIndex() {
        String str = SDF.format(new Date());
        return INDEX.concat("-").concat(str);
    }

    public static Map<String, Object> getDatas(DataResourceIdxDTO dto) {
        Field[] fields;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : fields = dto.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                if (field.get(dto) == null) continue;
                map.put(field.getName(), field.get(dto));
            }
            catch (IllegalAccessException e) {
                logger.warn("getDatas", (Throwable)e);
            }
        }
        return map;
    }

    public static Map<String, Object> getDatas(ResourceStatusCheckDTO dto) {
        Field[] fields;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : fields = dto.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                if (field.get(dto) == null) continue;
                map.put(field.getName(), field.get(dto));
            }
            catch (IllegalAccessException e) {
                logger.warn("getDatas", (Throwable)e);
            }
        }
        return map;
    }
}

