/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.resource.utils;

import cn.gtmap.gtc.gis.support.Document;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.context.MessageSource;

public class ExcelComInitUtils {
    protected static final String RES = "result";
    public static MessageSource message;

    public static String getMessage(String key, Object ... param) {
        try {
            return message.getMessage(key, param, Locale.getDefault());
        }
        catch (Exception ex) {
            return key;
        }
    }

    public static Map<String, Object> result(Object value) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(RES, value);
        return result;
    }

    public static Document writeComAnalyExcel(List tableHead, Map<String, List> data, String tplName) {
        Document document = Document.getDocByName((String)tplName);
        XSSFWorkbook workbook = new XSSFWorkbook();
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            Font blackFont = workbook.createFont();
            blackFont.setFontName("\u5b8b\u4f53");
            CellStyle blackFontStyle = workbook.createCellStyle();
            blackFontStyle.setFont(blackFont);
            blackFontStyle.setVerticalAlignment((short)2);
            blackFontStyle.setAlignment((short)2);
            blackFont.setFontHeightInPoints((short)11);
            blackFont.setBoldweight((short)700);
            for (String sheetName : data.keySet()) {
                Sheet sheet = workbook.createSheet(sheetName);
                sheet.setDefaultColumnWidth(15);
                List values = data.get(sheetName);
                for (int rowIndex = 0; rowIndex < values.size() + 1; ++rowIndex) {
                    Row row = sheet.createRow(rowIndex);
                    if (rowIndex == 0) {
                        ExcelComInitUtils.addCols(row, tableHead, blackFontStyle);
                        continue;
                    }
                    List value = (List)values.get(rowIndex - 1);
                    ExcelComInitUtils.addCols(row, value, null);
                }
            }
            workbook.write((OutputStream)out);
            document.setContent(out.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(ExcelComInitUtils.getMessage("doc.out.stream.error", e.getLocalizedMessage()));
        }
        return document;
    }

    private static void addCols(Row row, List<String> valueList, CellStyle cellStyle) {
        for (int i = 0; i < valueList.size(); ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(valueList.get(i));
            if (cellStyle == null) continue;
            cell.setCellStyle(cellStyle);
        }
    }
}

